/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer;

import MITI.expression.analyzer.decoration.MIRDecorUtil;
import MITI.expression.analyzer.parser.MIRParserHelper;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRFeature;
import MITI.util.StringUtil;
import java.util.LinkedList;
import java.util.List;

public final class LookupOptions {
    private final MIRElementNode node;
    private final String name;
    private final String datatype;
    private final String description;
    private final int position;
    private final boolean positionBased;
    private final boolean isQuoted;
    private final boolean hasStar;
    private final boolean isAmbiguous;
    private final boolean isAlias;

    public LookupOptions(MIRElementNode mIRElementNode, String string, String string2, String string3, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.name = string;
        this.position = n;
        this.positionBased = bl;
        this.isQuoted = bl2;
        this.hasStar = bl3;
        this.datatype = string2;
        this.node = mIRElementNode;
        this.isAmbiguous = bl4;
        this.description = string3;
        this.isAlias = bl5;
    }

    public LookupOptions(MIRElementNode mIRElementNode, boolean bl) {
        this(mIRElementNode, bl, false, false);
    }

    public LookupOptions(MIRElementNode mIRElementNode, boolean bl, boolean bl2, boolean bl3) {
        MIRElementNamePart mIRElementNamePart;
        boolean bl4 = mIRElementNode.getNativeType().equals(MIRParserHelper.GET_POSITIONAL());
        if (bl4) {
            mIRElementNamePart = MIRDecorUtil.getFirstNotQualifiedPart(mIRElementNode);
            this.name = "";
            this.position = Integer.parseInt(mIRElementNamePart.getName().substring(1));
        } else {
            mIRElementNamePart = this.getLastPart(mIRElementNode);
            if (bl3 && mIRElementNode.getDestinationElementType() == 77) {
                LinkedList<String> linkedList = new LinkedList<String>();
                for (MIRElementNamePart mIRElementNamePart2 : mIRElementNode.getElementNamePartByPosition()) {
                    MIRElement mIRElement;
                    if (linkedList.isEmpty() && mIRElementNamePart2.getSourceElementType() != 77 && mIRElementNamePart2.getReferencedElementCount() != 0) continue;
                    if (mIRElementNamePart2.getReferencedElementCount() == 1 && (mIRElement = mIRElementNamePart2.getReferencedElementIterator().next()) instanceof MIRFeature) {
                        linkedList.add(mIRElement.getName());
                        continue;
                    }
                    linkedList.add(mIRElementNamePart2.getName());
                }
                this.name = StringUtil.join(linkedList, ".");
            } else {
                this.name = mIRElementNamePart.getName();
            }
            this.position = mIRElementNode.getPosition() + 1;
        }
        this.positionBased = bl || bl4;
        this.isQuoted = mIRElementNamePart.getQuoted();
        this.hasStar = "*".equals(mIRElementNamePart.getName());
        this.datatype = mIRElementNode.getDataType();
        this.description = mIRElementNode.getDescription();
        this.node = mIRElementNode;
        this.isAmbiguous = bl2;
        this.isAlias = false;
    }

    private MIRElementNamePart getLastPart(MIRElementNode mIRElementNode) {
        List<MIRElementNamePart> list = mIRElementNode.getElementNamePartByPosition();
        MIRElementNamePart mIRElementNamePart = null;
        for (MIRElementNamePart mIRElementNamePart2 : list) {
            if (mIRElementNamePart2.getSourceElementType() != mIRElementNode.getDestinationElementType()) continue;
            mIRElementNamePart = mIRElementNamePart2;
            break;
        }
        if (mIRElementNamePart == null) {
            mIRElementNamePart = list.get(list.size() - 1);
        }
        return mIRElementNamePart;
    }

    public String getName() {
        return this.name;
    }

    public String getDataType() {
        return this.datatype;
    }

    public String getDescription() {
        return this.description;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isPositionBased() {
        return this.positionBased;
    }

    public boolean isQuoted() {
        return this.isQuoted;
    }

    public boolean hasStar() {
        return this.hasStar;
    }

    public MIRElementNode getNode() {
        return this.node;
    }

    public boolean isAmbiguous() {
        return this.isAmbiguous;
    }

    public boolean isAlias() {
        return this.isAlias;
    }
}

