/*
 * Decompiled with CFR 0.152.
 */
package com.sas.security.omipermissions;

import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.security.omipermissions.PermissionConditionException;
import com.sas.services.security.login.OMIServerPrincipal;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.security.auth.Subject;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.StringHolder;

public abstract class OMIPermission
extends Permission {
    static final long serialVersionUID = 1596981828592803485L;
    private static final String METADATA_REOURCE_IDENTIFIER = "OMSOBJ";
    private static final int OMI_TEMPLATE = 4;
    private static final int OMI_INCLUDE_SUBTYPES = 16;
    private static final int OMI_XMLSELECT = 128;
    private static final int OMI_GET_METADATA = 256;
    protected static ResourceBundle bundle = ResourceBundle.getBundle("com.sas.security.omipermissions.JAASProvider");
    protected Set actionSet;

    public OMIPermission(String resource) {
        this(resource, null);
    }

    public OMIPermission(String resource, String actions) {
        super(resource);
        if (resource == null) {
            throw new IllegalArgumentException("Resource name is null");
        }
        if (actions == null) {
            this.actionSet = new TreeSet();
            return;
        }
        this.actionSet = new TreeSet();
        StringTokenizer tokenizer = new StringTokenizer(actions, ", ");
        while (tokenizer.hasMoreTokens()) {
            String action = tokenizer.nextToken();
            try {
                action = bundle.getString("Actions." + action.toLowerCase());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this.actionSet.add(action);
        }
    }

    @Override
    public String getActions() {
        if (this.actionSet.size() == 0) {
            return "";
        }
        StringBuffer actionListBuffer = new StringBuffer(this.actionSet.size());
        Iterator i = this.actionSet.iterator();
        while (i.hasNext()) {
            actionListBuffer.append(i.next());
            if (!i.hasNext()) continue;
            actionListBuffer.append(",");
        }
        return actionListBuffer.toString();
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof OMIPermission)) {
            return false;
        }
        OMIPermission inPermission = (OMIPermission)permission;
        OMIServerPrincipal principal = inPermission.getCurrentPrincipal();
        if (principal == null) {
            throw new AccessControlException("No subject/principal is associated", inPermission);
        }
        ISecurity isecurity = inPermission.getISecurity(principal);
        if (isecurity == null) {
            return false;
        }
        String search = inPermission.getAuthorizationURN(principal);
        StringHolder returnCondition = new StringHolder();
        BooleanHolder returnBoolean = new BooleanHolder();
        StringTokenizer tokenize = new StringTokenizer(inPermission.getActions(), ",");
        String permissionCondition = null;
        while (tokenize.hasMoreTokens()) {
            try {
                isecurity.IsAuthorized("", search, tokenize.nextToken(), returnCondition, returnBoolean);
                String string = permissionCondition = returnCondition.value.length() == 0 ? null : returnCondition.value;
                if (returnBoolean.value) continue;
                return false;
            }
            catch (Exception e) {
                throw new AccessControlException(e.getMessage());
            }
        }
        if (permissionCondition != null) {
            throw new PermissionConditionException(permissionCondition, permission);
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        OMIPermission that = (OMIPermission)object;
        return this.getName().equals(that.getName()) && this.actionSet.equals(that.actionSet);
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() + this.actionSet.hashCode();
    }

    protected abstract String getAuthorizationURN(OMIServerPrincipal var1);

    private OMIServerPrincipal getCurrentPrincipal() {
        try {
            final AccessControlContext acc = AccessController.getContext();
            Subject currentSubject = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Subject.getSubject(acc);
                }
            });
            if (currentSubject == null) {
                return null;
            }
            Set<Principal> principals = currentSubject.getPrincipals();
            for (Principal object : principals) {
                if (!(object instanceof OMIServerPrincipal)) continue;
                return (OMIServerPrincipal)object;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected String getRepositoryID() {
        OMIServerPrincipal principal = this.getCurrentPrincipal();
        return principal != null ? principal.getBase() : "";
    }

    protected IOMI getIOMI(final OMIServerPrincipal principal) {
        if (principal == null) {
            return null;
        }
        IOMI iomi = null;
        try {
            iomi = (IOMI)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return principal.getIOMI();
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
        }
        return iomi;
    }

    protected ISecurity getISecurity(final OMIServerPrincipal principal) {
        if (principal == null) {
            return null;
        }
        ISecurity iSecurity = null;
        try {
            iSecurity = (ISecurity)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return principal.getISecurity();
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
        }
        return iSecurity;
    }
}

