/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.identity.client;

import com.sas.svcs.identity.client.IdentityProperty;
import com.sas.svcs.identity.client.IdentityType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class IdentityProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CAPABILITY_VALUE_READ = "read";
    public static final String CAPABILITY_VALUE_ADD = "add";
    public static final String CAPABILITY_VALUE_DELETE = "delete";
    public static final String CAPABILITY_VALUE_UPDATE = "update";
    private String id;
    private String name;
    private String type;
    private boolean isDefault;
    private Set<IdentityType> supportedTypes;
    private Set<Capability> capabilities;
    private Set<IdentityProperty> properties;

    public IdentityProvider() {
    }

    public IdentityProvider(String id, String type, String name) {
        this.id = id;
        this.name = name;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public List<IdentityType> getSupportedTypes() {
        if (this.supportedTypes == null || this.supportedTypes.isEmpty()) {
            return Arrays.asList(IdentityType.values());
        }
        return new ArrayList<IdentityType>(this.supportedTypes);
    }

    public void setSupportedTypes(List<IdentityType> types) {
        this.supportedTypes = new LinkedHashSet<IdentityType>(types);
    }

    public boolean containsSupportedType(IdentityType type) {
        return this.supportedTypes != null && this.supportedTypes.contains((Object)type);
    }

    public List<Capability> getCapabilities() {
        return this.capabilities == null ? Collections.emptyList() : new ArrayList<Capability>(this.capabilities);
    }

    public void setCapabilities(List<Capability> capabilities) {
        if (capabilities != null) {
            this.capabilities = new LinkedHashSet<Capability>(capabilities);
        }
    }

    public boolean hasCapability(Capability capability) {
        return this.capabilities != null && this.capabilities.contains((Object)capability);
    }

    public void addProperty(IdentityProperty property) {
        if (this.properties == null) {
            this.properties = new HashSet<IdentityProperty>();
        }
        this.properties.add(property);
    }

    public void setProperties(List<IdentityProperty> propertyList) {
        if (this.properties == null) {
            this.properties = new HashSet<IdentityProperty>();
        }
        this.properties.addAll(propertyList);
    }

    public List<IdentityProperty> getProperties() {
        return this.properties == null ? Collections.emptyList() : new ArrayList<IdentityProperty>(this.properties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdentityProvider other = (IdentityProvider)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)other.getId()).append((Object)this.name, (Object)other.getName()).append((Object)this.type, (Object)other.getType()).append(this.isDefault, other.isDefault()).append(this.supportedTypes, other.getSupportedTypes()).append(this.capabilities, other.getCapabilities()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 7).append((Object)this.id).append((Object)this.name).append((Object)this.type).append(this.isDefault).append(this.supportedTypes).append(this.capabilities).toHashCode();
    }

    public static enum Capability {
        READ("read"),
        ADD("add"),
        DELETE("delete"),
        UPDATE("update");

        private String value;

        private Capability(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static Capability fromString(String value) {
            if (IdentityProvider.CAPABILITY_VALUE_READ.equals(value)) {
                return READ;
            }
            if (IdentityProvider.CAPABILITY_VALUE_ADD.equals(value)) {
                return ADD;
            }
            if (IdentityProvider.CAPABILITY_VALUE_DELETE.equals(value)) {
                return DELETE;
            }
            if (IdentityProvider.CAPABILITY_VALUE_UPDATE.equals(value)) {
                return UPDATE;
            }
            throw new IllegalArgumentException("Invalid capability: " + value);
        }
    }
}

