/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.identity.client;

import com.sas.nls.collator.SASCollatorFactory;
import com.sas.nls.collator.SASStringComparator;
import com.sas.svcs.identity.client.Group;
import com.sas.svcs.identity.client.GroupMember;
import com.sas.svcs.identity.client.GroupMembership;
import com.sas.svcs.identity.client.Identity;
import com.sas.svcs.identity.client.IdentityType;
import com.sas.svcs.identity.client.User;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

public class IdentityComparators {
    public static <T> Comparator<T> descending(final Comparator<T> comparator) {
        return new Comparator<T>(){

            @Override
            public int compare(T identity1, T identity2) {
                return comparator.compare(identity1, identity2) * -1;
            }
        };
    }

    public static class MemberComparator<T extends Identity>
    implements Comparator<GroupMember> {
        private Comparator<T> baseComparator;

        public MemberComparator(Comparator<T> baseComparator) {
            this.baseComparator = baseComparator;
        }

        @Override
        public int compare(GroupMember member1, GroupMember member2) {
            Identity identity1 = member1.getIdentity();
            Identity identity2 = member2.getIdentity();
            return this.baseComparator.compare(identity1, identity2);
        }
    }

    public static class MembershipComparator
    implements Comparator<GroupMembership> {
        private NameComparator<Group> comparator;

        public MembershipComparator(Locale locale) {
            this.comparator = new NameComparator(locale);
        }

        @Override
        public int compare(GroupMembership membership1, GroupMembership membership2) {
            Group group1 = membership1.getGroup();
            Group group2 = membership2.getGroup();
            return this.comparator.compare(group1, group2);
        }
    }

    public static class JobTitleComparator
    implements Comparator<User> {
        private SASStringComparator stringComparator;

        public JobTitleComparator(Locale locale) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            this.stringComparator = SASCollatorFactory.createCollator((Locale)locale);
        }

        @Override
        public int compare(User user1, User user2) {
            return this.stringComparator.compare(user1.getTitle(), user2.getTitle());
        }
    }

    public static class ModifiedComparator<T extends Identity>
    implements Comparator<T> {
        @Override
        public int compare(T identity1, T identity2) {
            Date d1 = ((Identity)identity1).getModifiedDate();
            Date d2 = ((Identity)identity2).getModifiedDate();
            if (d1 == null && d2 == null) {
                return 0;
            }
            if (d1 == null) {
                return -1;
            }
            if (d2 == null) {
                return 1;
            }
            return d1.compareTo(d2);
        }
    }

    public static class CreatedComparator<T extends Identity>
    implements Comparator<T> {
        @Override
        public int compare(T identity1, T identity2) {
            Date d1 = ((Identity)identity1).getCreatedDate();
            Date d2 = ((Identity)identity2).getCreatedDate();
            if (d1 == null && d2 == null) {
                return 0;
            }
            if (d1 == null) {
                return -1;
            }
            if (d2 == null) {
                return 1;
            }
            return d1.compareTo(d2);
        }
    }

    public static class DescriptionComparator<T extends Identity>
    implements Comparator<T> {
        private SASStringComparator stringComparator;

        public DescriptionComparator(Locale locale) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            this.stringComparator = SASCollatorFactory.createCollator((Locale)locale);
        }

        @Override
        public int compare(T identity1, T identity2) {
            return this.stringComparator.compare(((Identity)identity1).getDescription(), ((Identity)identity2).getDescription());
        }
    }

    public static class IdComparator<T extends Identity>
    implements Comparator<T> {
        private SASStringComparator stringComparator;

        public IdComparator(Locale locale) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            this.stringComparator = SASCollatorFactory.createCollator((Locale)locale);
        }

        @Override
        public int compare(T identity1, T identity2) {
            return this.stringComparator.compare(((Identity)identity1).getId(), ((Identity)identity2).getId());
        }
    }

    public static class NameComparator<T extends Identity>
    implements Comparator<T> {
        private SASStringComparator stringComparator;

        public NameComparator(Locale locale) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            this.stringComparator = SASCollatorFactory.createCollator((Locale)locale);
        }

        @Override
        public int compare(T identity1, T identity2) {
            return this.stringComparator.compare(((Identity)identity1).getDisplayName(), ((Identity)identity2).getDisplayName());
        }
    }

    public static class TypeComparator<T extends Identity>
    implements Comparator<T> {
        @Override
        public int compare(T identity1, T identity2) {
            IdentityType type1 = IdentityType.fromIdentity(identity1);
            IdentityType type2 = IdentityType.fromIdentity(identity2);
            return type1.value().compareToIgnoreCase(type2.value());
        }
    }
}

