/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web.providers;

import com.sas.svcs.config.client.UrlGeneratorInterface;
import com.sas.svcs.security.authentication.client.AuthenticationClient;
import com.sas.svcs.security.authentication.client.LogonFailureException;
import com.sas.svcs.security.authentication.web.RevokableCasAuthenticationToken;
import jakarta.servlet.http.HttpSession;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.UUID;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apereo.cas.client.session.SessionMappingStorage;
import org.apereo.cas.client.validation.Assertion;
import org.apereo.cas.client.validation.TicketValidationException;
import org.apereo.cas.client.validation.TicketValidator;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.cas.authentication.CasAssertionAuthenticationToken;
import org.springframework.security.cas.web.authentication.ServiceAuthenticationDetails;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsByNameServiceWrapper;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public abstract class AbstractAuthenticationClientProvider
implements AuthenticationProvider {
    private static final Logger logger = LogManager.getLogger(AbstractAuthenticationClientProvider.class);
    private TicketValidator ticketValidator;
    private UrlGeneratorInterface urlGenerator;
    protected String casUrl;
    protected String serviceUrl;
    private final UserDetailsChecker userDetailsChecker = new AccountStatusUserDetailsChecker();
    private AuthenticationUserDetailsService<CasAssertionAuthenticationToken> authenticationUserDetailsService;
    private String key = this.getClass().getName();
    private final Object casUrlLock = new Object();
    protected ClientHttpRequestFactory clientRequestFactory;
    private SessionMappingStorage sessionStorage;
    public static final String CAS_STATEFUL_IDENTIFIER = "_cas_stateful_";
    public static final String CAS_STATELESS_IDENTIFIER = "_cas_stateless_";

    public void setTicketValidator(TicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    @Autowired
    public void setUrlGenerator(UrlGeneratorInterface urlGenerator) {
        this.urlGenerator = urlGenerator;
    }

    public void setServiceUrl(String url) {
        this.serviceUrl = url;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.authenticationUserDetailsService = new UserDetailsByNameServiceWrapper(userDetailsService);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setClientRequestFactory(ClientHttpRequestFactory clientRequestFactory) {
        this.clientRequestFactory = clientRequestFactory;
    }

    protected ClientHttpRequestFactory getRequestFactory() {
        return this.clientRequestFactory;
    }

    @Autowired(required=false)
    public void setSessionMappingStorage(SessionMappingStorage sessionStorage) {
        this.sessionStorage = sessionStorage;
    }

    protected String getServiceUrl(Authentication authentication) {
        String url;
        if (authentication.getDetails() instanceof ServiceAuthenticationDetails) {
            url = ((ServiceAuthenticationDetails)authentication.getDetails()).getServiceUrl();
        } else {
            if (this.serviceUrl == null) {
                throw new IllegalStateException("serviceUrl cannot be null unless Authentication.getDetails() implements ServiceAuthenticationDetails.");
            }
            url = this.serviceUrl;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("serviceUrl = " + url);
        }
        try {
            url = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("Error encoding url to UTF-8: '" + url + "'");
        }
        return url;
    }

    protected abstract AuthenticationClient getAuthenticationClient(Authentication var1);

    protected void initialize(AuthenticationClient client) {
        ClientHttpRequestFactory requestFactory = this.getRequestFactory();
        if (null != requestFactory) {
            if (logger.isDebugEnabled()) {
                logger.debug("Using configured client request factory with class " + requestFactory.getClass().getName());
            }
            client.setRequestFactory(requestFactory);
        }
    }

    protected boolean canAuthenticate(Authentication authentication) {
        return !(authentication instanceof UsernamePasswordAuthenticationToken) || !CAS_STATEFUL_IDENTIFIER.equals(authentication.getPrincipal().toString()) && !CAS_STATELESS_IDENTIFIER.equals(authentication.getPrincipal().toString());
    }

    private static HttpSession createDummySession() {
        ProxyFactory proxyFactory = new ProxyFactory(HttpSession.class, (Interceptor)new HttpSessionIdInterceptor());
        proxyFactory.setFrozen(true);
        return (HttpSession)proxyFactory.getProxy();
    }

    protected Object getCredentialAfterAuthentication(Authentication originalAuthentication, String validTicket, Assertion assertion, UserDetails details) {
        if (logger.isDebugEnabled()) {
            logger.debug("Using the validated ticket as the credential for the security context");
        }
        return validTicket;
    }

    protected Authentication getCachedAuthentication(Authentication originalAuthentication) {
        if (logger.isDebugEnabled()) {
            logger.debug("No cached authentication implementation available in " + this.getClass().getName());
        }
        return null;
    }

    protected void cacheAuthentication(Authentication original, Authentication newAuthentication) {
        if (logger.isDebugEnabled()) {
            logger.debug("Will not cache authentication object for class " + this.getClass().getName());
        }
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.canAuthenticate(authentication)) {
            return null;
        }
        Authentication auth = this.getCachedAuthentication(authentication);
        if (null != auth) {
            if (logger.isDebugEnabled()) {
                logger.debug("Found cached credentials using original authentication");
            }
            return auth;
        }
        AuthenticationClient client = null;
        try {
            client = this.getAuthenticationClient(authentication);
        }
        catch (LogonFailureException e) {
            switch (e.getStatus()) {
                case NOT_FOUND: {
                    logger.error("Log-on destination could not be found", (Throwable)e);
                    throw new AuthenticationServiceException("Error logging on with the provided credentials. The log-on application could not be found.", (Throwable)e);
                }
                case SERVER_ERROR: {
                    logger.error("Log-on server error", (Throwable)e);
                    throw new AuthenticationServiceException("Error logging on with the provided credentials. The log-on application had an internal error.", (Throwable)e);
                }
                case BAD_REQUEST: {
                    logger.error("Bad credentials reported by log-on server", (Throwable)e);
                    throw new BadCredentialsException("Error logging on with the provided credentials. The credentials were invalid.", (Throwable)e);
                }
            }
            logger.error("Unknown log-on server error", (Throwable)e);
            throw new AuthenticationServiceException("Error logging on with the provided credentials. The log-on application had an unknown error.", (Throwable)e);
        }
        String url = this.getServiceUrl(authentication);
        if (null == url) {
            String message = "Could not find or dynamically generate service url for authentication request";
            logger.error(message);
            throw new AuthenticationServiceException(message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Got service url from authentication object '" + url + "'");
        }
        String myTicket = client.acquireTicket(url);
        if (logger.isDebugEnabled()) {
            logger.debug("Acquired service ticket '" + myTicket + "'");
        }
        SecurityContext before = SecurityContextHolder.getContext();
        try {
            SecurityContextImpl context = new SecurityContextImpl();
            Assertion assertion = this.ticketValidator.validate(myTicket, url);
            if (null != this.sessionStorage) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Storing dummy session in session storage for ticket '" + myTicket + "'");
                }
                this.sessionStorage.addSessionById(myTicket, AbstractAuthenticationClientProvider.createDummySession());
            }
            PreAuthenticatedAuthenticationToken preAuthentication = new PreAuthenticatedAuthenticationToken((Object)assertion.getPrincipal().getName(), null, new ArrayList());
            context.setAuthentication((Authentication)preAuthentication);
            SecurityContextHolder.setContext((SecurityContext)context);
            UserDetails userDetails = this.authenticationUserDetailsService.loadUserDetails((Authentication)new CasAssertionAuthenticationToken(assertion, myTicket));
            this.userDetailsChecker.check(userDetails);
            RevokableCasAuthenticationToken newAuthentication = new RevokableCasAuthenticationToken(this.key, userDetails, this.getCredentialAfterAuthentication(authentication, myTicket, assertion, userDetails), userDetails.getAuthorities(), userDetails, assertion, client);
            this.cacheAuthentication(auth, newAuthentication);
            RevokableCasAuthenticationToken revokableCasAuthenticationToken = newAuthentication;
            return revokableCasAuthenticationToken;
        }
        catch (TicketValidationException e) {
            logger.error("Error validating ticket '" + myTicket + "' for service '" + url + "'", (Throwable)e);
            throw new BadCredentialsException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (null == before) {
                SecurityContextHolder.clearContext();
            } else {
                SecurityContextHolder.setContext((SecurityContext)before);
            }
        }
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setCasUrl(String casUrl) {
        this.casUrl = casUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCasUrl() {
        if (null == this.casUrl) {
            Object object = this.casUrlLock;
            synchronized (object) {
                if (null == this.casUrl) {
                    this.casUrl = this.urlGenerator.generateInternalUrl("Logon Manager 9.4", "", "");
                }
            }
        }
        return this.casUrl;
    }

    private static class HttpSessionIdInterceptor
    implements MethodInterceptor {
        private final String id = UUID.randomUUID().toString();

        private HttpSessionIdInterceptor() {
        }

        public Object invoke(MethodInvocation mi) throws Throwable {
            if (mi.getMethod().getName().equals("getId")) {
                return this.id;
            }
            return null;
        }
    }
}

