/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web.logout;

import com.sas.svcs.config.client.ConfigurationServiceInterface;
import com.sas.svcs.config.client.UrlGeneratorInterface;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;

public class UrlLogoutSuccessHandler
implements LogoutSuccessHandler {
    SimpleUrlLogoutSuccessHandler handler;
    @Autowired
    UrlGeneratorInterface urlGenerator;
    @Autowired
    ConfigurationServiceInterface configService;

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        this.getHandler(request).onLogoutSuccess(request, response, authentication);
    }

    private synchronized LogoutSuccessHandler getHandler(HttpServletRequest request) {
        String logoutUrl = this.urlGenerator.generateExternalUrl("Logon Manager 9.4", "logout", this.addParameters(request));
        this.handler = new SimpleUrlLogoutSuccessHandler();
        this.handler.setDefaultTargetUrl(logoutUrl);
        return this.handler;
    }

    private String addParameters(HttpServletRequest request) {
        String locale;
        String publicDenied;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        StringBuffer params = new StringBuffer();
        ServletContext sc = request.getServletContext();
        String appName = sc.getInitParameter("application-name");
        if (null != appName) {
            paramMap.put("_sasapp", UrlLogoutSuccessHandler.encode(appName));
        }
        if (null != (publicDenied = request.getParameter("publicDenied"))) {
            paramMap.put("publicDenied", publicDenied);
        }
        if (null != (locale = request.getParameter("_locale"))) {
            paramMap.put("_locale", locale);
        }
        for (Map.Entry entry : paramMap.entrySet()) {
            if (params.length() > 0) {
                params.append("&");
            }
            params.append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
        return params.toString();
    }

    private static String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Received UnsupportedEncodingException for 'UTF-8' which is a required encoding per the java.nio.charset.CharSet class.", e);
        }
    }
}

