/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.apereo.cas.client.authentication.AttributePrincipal;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class TgtKeepAliveFilter
extends OncePerRequestFilter {
    private static final String LAST_PROXY_TICKET_TIME = "LAST_PROXY_TICKET_TIME";
    private static final String KEEP_ALIVE_REQUEST = "SESSION/KEEPALIVE";
    private static final String INVALIDATE_SESSION_REQUEST = "INVALIDATESESSION";
    private static final String TGT_KEEP_ALIVE_MINUTES = "sas.tgt.keep.alive.minutes";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authToken = securityContext.getAuthentication();
        if (authToken instanceof CasAuthenticationToken) {
            CasAuthenticationToken casToken = (CasAuthenticationToken)authToken;
            AttributePrincipal casPrincipal = casToken.getAssertion().getPrincipal();
            HttpSession session = request.getSession(false);
            if (null != session) {
                boolean isKeepAliveRequest = false;
                boolean isInvalidateSession = false;
                String requestURI = request.getRequestURI();
                if (requestURI.toUpperCase().endsWith(KEEP_ALIVE_REQUEST)) {
                    isKeepAliveRequest = true;
                } else if (requestURI.toUpperCase().endsWith(INVALIDATE_SESSION_REQUEST)) {
                    isInvalidateSession = true;
                }
                int tgtAliveInMinutes = 10;
                String specifiedTgtAliveInMinutes = System.getProperty(TGT_KEEP_ALIVE_MINUTES);
                if (null != specifiedTgtAliveInMinutes) {
                    try {
                        tgtAliveInMinutes = Integer.parseInt(specifiedTgtAliveInMinutes);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                long currentTime = System.currentTimeMillis();
                Long lastTouchedTimeObj = (Long)session.getAttribute(LAST_PROXY_TICKET_TIME);
                if (null == lastTouchedTimeObj) {
                    lastTouchedTimeObj = currentTime;
                    session.setAttribute(LAST_PROXY_TICKET_TIME, (Object)lastTouchedTimeObj);
                }
                long lastTouchedTime = lastTouchedTimeObj;
                long timeWithoutTouch = currentTime - lastTouchedTime;
                if (isKeepAliveRequest || timeWithoutTouch > (long)(tgtAliveInMinutes * 60 * 1000) && !isInvalidateSession) {
                    casPrincipal.getProxyTicketFor("http://tgt.keepali.ve");
                    session.setAttribute(LAST_PROXY_TICKET_TIME, (Object)currentTime);
                }
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

