/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web.filters;

import com.sas.framework.commons.holders.SessionHolder;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class SessionIdentifierFilter
extends OncePerRequestFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        try {
            SecurityContext securityContext = SecurityContextHolder.getContext();
            Authentication authToken = securityContext.getAuthentication();
            if (authToken instanceof CasAuthenticationToken) {
                CasAuthenticationToken casToken = (CasAuthenticationToken)authToken;
                String value = (String)casToken.getAssertion().getPrincipal().getAttributes().get("SAS_SESSION_IDENTIFIER");
                SessionHolder.set((String)value);
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            SessionHolder.clear();
        }
    }
}

