/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web.filters;

import com.sas.framework.commons.holders.ClientApplicationNameHolder;
import com.sas.svcs.config.client.ApplicationRegistration;
import com.sas.svcs.config.client.ConfigurationServiceInterface;
import com.sas.svcs.config.client.SiteConfiguration;
import com.sas.svcs.config.client.UrlGeneratorInterface;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class CsrfRefererCheckerFilter
extends OncePerRequestFilter {
    private static final String ALLOW_NULL = "sas.web.csrf.referers.allowNull";
    private static final String KNOWN_REFERERS = "sas.web.csrf.referers.knownHosts";
    private static final String BLACKLIST = "sas.web.csrf.referers.blacklist";
    private static final String PERFORM_CHECK = "sas.web.csrf.referers.performCheck";
    private static final String SKIP_HTTP_METHODS = "sas.web.csrf.referers.skipMethods";
    private static final Logger logger = LogManager.getLogger(CsrfRefererCheckerFilter.class);
    private static final List<MediaType> JSON_MEDIA_TYPES = Arrays.asList(MediaType.APPLICATION_JSON, MediaType.parseMediaType((String)"application/*+json"));
    private static final List<MediaType> XML_MEDIA_TYPES = Arrays.asList(MediaType.APPLICATION_XML, MediaType.parseMediaType((String)"application/*+xml"), MediaType.TEXT_XML);
    private static final List<MediaType> HTML_MEDIA_TYPES = Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_XHTML_XML);
    private static final String JSON_ERROR_MESSAGE = "'{\"errorCode\": 42, \"httpStatusCode\": 403, \"details\": [\"You attempted to access a SAS application with the URL '{0}' from an untrusted site. This may be a result of malicious attack and has been blocked.\"], \"links\": [], \"message\": \"Potential cross-site request forgery attack blocked\", \"remediation\": \"Contact your SAS Administrator if you think the referring page should be added to the cross-site request forgery whitelist. SAS Administrators should review the SAS Technical Support note on Cross Site Request Forgery.\", \"version\": 1}'";
    private static final String JSON_ERROR_MESSAGE2 = "'{\"errorCode\": 42, \"httpStatusCode\": 403, \"details\": [\"You attempted to access a SAS application with the URL '{0}' from an untrusted site. This may be a result of malicious attack and has been blocked.\"], \"links\": [], \"message\": \"Potential cross-site request forgery attack blocked\", \"remediation\": \"Contact your SAS Administrator if you think the referring page {1} should be added to the cross-site request forgery whitelist. SAS Administrators should review the SAS Technical Support note on Cross Site Request Forgery.\", \"version\": 1}'";
    private static final String XML_ERROR_MESSAGE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><error errorCode=42 httpStatusCode=403><details><detail>You attempted to access a SAS application with the URL {0} from an untrusted site. This may be a result of malicious attack and has been blocked.</detail></details><links/><message>Potential cross-site request forgery attack blocked</message><remediation>Contact your SAS Administrator if you think the referring page should be added to the cross-site request forgery whitelist. SAS Administrators should review the SAS Technical Support note on Cross Site Request Forgery.</remediation><version>1</version></error>";
    private static final String XML_ERROR_MESSAGE2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><error errorCode=42 httpStatusCode=403><details><detail>You attempted to access a SAS application with the URL {0} from an untrusted site. This may be a result of malicious attack and has been blocked.</detail></details><links/><message>Potential cross-site request forgery attack blocked</message><remediation>Contact your SAS Administrator if you think the referring page {1} should be added to the cross-site request forgery whitelist. SAS Administrators should review the SAS Technical Support note on Cross Site Request Forgery.</remediation><version>1</version></error>";
    private static final String TEXT_ERROR_MESSAGE = "You attempted to access a SAS application with the URL {0} from an untrusted site. This may be a result of malicious attack and has been blocked. Contact your SAS Administrator if you think the referring page should be added to the cross-site request forgery whitelist. SAS Administrators should review the SAS Technical Support note on Cross Site Request Forgery.";
    private ConfigurationServiceInterface configurationService;
    private UrlGeneratorInterface urlGenerator;
    private Boolean allowNullReferers;
    private Set<Pattern> allowedReferers = new LinkedHashSet<Pattern>();
    private Set<Pattern> disallowedRefers = new LinkedHashSet<Pattern>();
    private Boolean performCheck;
    private volatile boolean initialized = false;
    private final Object initLock = new Object();
    private String currentApplicationName;
    private Set<String> methodsToSkip;

    @Autowired(required=false)
    public void setConfigurationService(ConfigurationServiceInterface configurationService) {
        this.configurationService = configurationService;
    }

    @Autowired(required=false)
    public void setUrlGenerator(UrlGeneratorInterface urlGenerator) {
        this.urlGenerator = urlGenerator;
    }

    public void setApplicationName(String name) {
        this.currentApplicationName = name;
    }

    String getApplicationName() {
        return this.currentApplicationName;
    }

    public void setPerformCheck(boolean performCheck) {
        this.performCheck = performCheck;
    }

    Boolean getPerformCheck() {
        return this.performCheck;
    }

    public void setAllowedReferers(Set<String> allowedReferers) {
        for (String referer : allowedReferers) {
            this.addRefererPattern(referer);
        }
    }

    Set<Pattern> getAllowedRefererPatterns() {
        return this.allowedReferers;
    }

    public void setDisallowedReferers(Set<String> disallowedReferers) {
        for (String referer : disallowedReferers) {
            this.addDisallowedReferer(referer);
        }
    }

    Boolean getAllowNullReferers() {
        return this.allowNullReferers;
    }

    public void setAllowNullReferers(boolean allowNullReferers) {
        this.allowNullReferers = allowNullReferers;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    public void setSkipHttpMethods(Set<String> methodsToSkip) {
        this.methodsToSkip = methodsToSkip;
    }

    public CsrfRefererCheckerFilter() {
        String property = null;
        property = System.getProperty(ALLOW_NULL);
        if (null != property) {
            this.allowNullReferers = Boolean.parseBoolean(property);
            if (logger.isDebugEnabled()) {
                logger.debug("allowNullReferers = " + property);
            }
        }
        if (null != (property = System.getProperty(KNOWN_REFERERS))) {
            for (String referer : Arrays.asList(property.split(","))) {
                this.addRefererPattern(referer);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("allowedReferers = " + property);
            }
        }
        if (null != (property = System.getProperty(PERFORM_CHECK))) {
            this.performCheck = Boolean.parseBoolean(property);
            if (logger.isDebugEnabled()) {
                logger.debug("performCheck = " + property);
            }
        }
        if (null != (property = System.getProperty(SKIP_HTTP_METHODS))) {
            this.methodsToSkip = new HashSet<String>(Arrays.asList(property.toUpperCase().split(",")));
            if (logger.isDebugEnabled()) {
                logger.debug("methodsToCheck = " + property);
            }
        }
    }

    SiteConfiguration getCurrentConfiguration() {
        if (null == this.configurationService) {
            logger.warn("No configuration service configured. Cannot obtain site settings.");
            return new SiteConfiguration();
        }
        if (null == this.currentApplicationName) {
            this.currentApplicationName = ClientApplicationNameHolder.getBaseApplicationName();
        }
        SiteConfiguration configuration = null;
        if (null == this.currentApplicationName) {
            if (logger.isDebugEnabled()) {
                logger.debug("Could not determine current application name. Using site configuration.");
            }
            configuration = this.configurationService.getSiteConfiguration();
        } else {
            configuration = new SiteConfiguration();
            configuration.setConfiguration(this.configurationService.getSettings(this.currentApplicationName));
        }
        return configuration;
    }

    void initAppNameFromServletContext() {
        String applicationName = null;
        ServletContext servletContext = this.getServletContext();
        if (null != servletContext && null != (applicationName = servletContext.getInitParameter("application-name"))) {
            this.setApplicationName(applicationName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeLazy() {
        if (!this.initialized) {
            Object object = this.initLock;
            synchronized (object) {
                if (!this.initialized) {
                    if (null != this.performCheck && !this.performCheck.booleanValue()) {
                        this.initialized = true;
                        return;
                    }
                    this.initAppNameFromServletContext();
                    SiteConfiguration configuration = this.getCurrentConfiguration();
                    String property = null;
                    if (null == this.performCheck) {
                        if (null != configuration && null != (property = configuration.getConfigurationProperty(PERFORM_CHECK))) {
                            this.performCheck = Boolean.parseBoolean(property);
                            if (!this.performCheck.booleanValue()) {
                                logger.debug("Not performing check as configured in configuration service.");
                                this.initialized = true;
                                return;
                            }
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Not performing check by default since no sas.web.csrf.referers.performCheck setting was present in JVM args or configuration settings");
                            }
                            this.performCheck = false;
                            this.initialized = true;
                            return;
                        }
                    }
                    if (null == this.allowNullReferers) {
                        if (null != configuration && null != (property = configuration.getConfigurationProperty(ALLOW_NULL))) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Configuration service allowNullReferers=" + property);
                            }
                            this.allowNullReferers = Boolean.parseBoolean(property);
                        } else {
                            this.allowNullReferers = true;
                        }
                    }
                    if (null == this.methodsToSkip && null != configuration && null != (property = configuration.getConfigurationProperty(SKIP_HTTP_METHODS))) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Configuration service methodsToSkip='" + property + "'");
                        }
                        this.methodsToSkip = new HashSet<String>(Arrays.asList(property.toUpperCase().split(",")));
                    }
                    for (String referer : this.getConfiguredBlacklistedReferers(configuration)) {
                        this.addDisallowedReferer(referer);
                    }
                    for (String referer : this.getSystemReferers()) {
                        this.addRefererPattern(referer);
                    }
                    for (String referer : this.getConfiguredReferers(configuration)) {
                        this.addRefererPattern(referer);
                    }
                    this.initialized = true;
                }
            }
        }
    }

    static void addHostPattern(StringBuilder sb, String host) {
        sb.append("(?u:");
        sb.append(Pattern.quote(host));
        sb.append(")");
    }

    void addDisallowedReferer(String pattern) {
        if (logger.isDebugEnabled()) {
            logger.debug("Adding disallowed pattern: " + pattern);
        }
        if (!StringUtils.hasText((String)(pattern = pattern.trim()))) {
            return;
        }
        UriComponents uri = UriComponentsBuilder.fromUriString((String)pattern).build();
        StringBuilder sb = new StringBuilder("^");
        if (pattern.indexOf("://") == -1 || null == uri.getScheme()) {
            sb.append(".*?");
            uri = UriComponentsBuilder.fromUriString((String)("http://" + pattern)).build();
        } else {
            sb.append(uri.getScheme());
        }
        sb.append("://");
        String host = uri.getHost();
        String path = uri.getPath();
        if (null == host) {
            host = path;
            path = null;
        }
        if ((host = host.trim()).contains("*.")) {
            throw new IllegalArgumentException("Wildcards not allowed in blacklist: " + pattern);
        }
        CsrfRefererCheckerFilter.addHostPattern(sb, host);
        if (-1 == uri.getPort()) {
            sb.append("(:\\d{1,5}+)?");
        } else {
            sb.append(":");
            sb.append(uri.getPort());
        }
        if (null == path || null != path && "/".equals(path)) {
            sb.append("($|/$|/.*$)?");
        } else {
            sb.append(Pattern.quote(path));
            if (path.endsWith("/")) {
                sb.append(".*");
            }
            sb.append("$");
        }
        String regex = sb.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("Constructed CSRF blacklist regular expression " + regex);
        }
        this.disallowedRefers.add(Pattern.compile(regex));
    }

    void addRefererPattern(String pattern) {
        int wildcardPos;
        if (logger.isDebugEnabled()) {
            logger.debug("Adding allowed pattern: " + pattern);
        }
        if (!StringUtils.hasText((String)(pattern = pattern.trim()))) {
            return;
        }
        UriComponents uri = UriComponentsBuilder.fromUriString((String)pattern).build();
        StringBuilder sb = new StringBuilder("^");
        boolean eitherScheme = false;
        if (pattern.indexOf("://") == -1 || null == uri.getScheme()) {
            sb.append("https?");
            eitherScheme = true;
            uri = UriComponentsBuilder.fromUriString((String)("http://" + pattern)).build();
        } else {
            sb.append(uri.getScheme());
        }
        sb.append("://");
        String host = uri.getHost();
        String path = uri.getPath();
        if (null == host) {
            host = path;
            path = null;
        }
        if ((wildcardPos = (host = host.trim()).indexOf("*.")) > -1) {
            if (wildcardPos != 0) {
                throw new IllegalArgumentException("Invalid CSRF referer wildcard syntax. Wildcard must be located at beginning of host or nowhere at all.");
            }
            sb.append("([^/]*\\.)?");
            CsrfRefererCheckerFilter.addHostPattern(sb, host.substring(2));
        } else {
            CsrfRefererCheckerFilter.addHostPattern(sb, host);
        }
        if (-1 == uri.getPort()) {
            if (eitherScheme) {
                sb.append("(:80|:443)?");
            } else if ("http".equals(uri.getScheme())) {
                sb.append("(:80)?");
            } else if ("https".equals(uri.getScheme())) {
                sb.append("(:443)?");
            }
        } else {
            sb.append(":");
            sb.append(uri.getPort());
        }
        if (null == path || null != path && "/".equals(path)) {
            sb.append("($|/$|/.*$)?");
        } else {
            sb.append(Pattern.quote(path));
            if (path.endsWith("/")) {
                sb.append(".*");
            }
            sb.append("$");
        }
        String regex = sb.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("Constructed CSRF whitelist regular expression " + regex);
        }
        this.allowedReferers.add(Pattern.compile(regex));
    }

    Set<String> getReferers(String protocol, String host, int port) {
        HashSet<String> referers = new HashSet<String>(2);
        StringBuilder sb = new StringBuilder(protocol.toLowerCase(Locale.ENGLISH));
        sb.append("://");
        sb.append(host.toLowerCase(Locale.ENGLISH));
        String excludingPort = sb.toString();
        referers.add(excludingPort + ":" + port + "/");
        if (80 == port && "http".equals(protocol) || 443 == port && protocol.equals("https")) {
            referers.add(excludingPort + "/");
        }
        return referers;
    }

    Set<String> getReferers(ApplicationRegistration registration) {
        HashSet<String> referers = new HashSet<String>(2);
        referers.addAll(this.getReferers(registration.getExternalProtocol(), registration.getExternalHost(), registration.getExternalPort()));
        referers.addAll(this.getReferers(registration.getProtocol(), registration.getHost(), registration.getPort()));
        return referers;
    }

    Set<String> getSystemReferers() {
        List registrations = this.configurationService.getRegistrations();
        HashSet<String> referers = new HashSet<String>(registrations.size() * 2);
        for (ApplicationRegistration registration : registrations) {
            referers.addAll(this.getReferers(registration));
        }
        return referers;
    }

    Set<String> getConfiguredReferers(SiteConfiguration config) {
        String property = null;
        if (null != config && null != (property = config.getConfigurationProperty(KNOWN_REFERERS))) {
            return StringUtils.commaDelimitedListToSet((String)property);
        }
        return Collections.emptySet();
    }

    Set<String> getConfiguredBlacklistedReferers(SiteConfiguration config) {
        String property = null;
        if (null != config && null != (property = config.getConfigurationProperty(BLACKLIST))) {
            return StringUtils.commaDelimitedListToSet((String)property);
        }
        return Collections.emptySet();
    }

    boolean isWhitelisted(String referer) {
        for (Pattern pattern : this.allowedReferers) {
            if (!pattern.matcher(referer).matches()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Found whitelist match for referer " + referer + " using pattern " + pattern.toString());
            }
            return true;
        }
        return false;
    }

    boolean isBlacklisted(String referer) {
        for (Pattern pattern : this.disallowedRefers) {
            if (!pattern.matcher(referer).matches()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Found blacklisted match for referer " + referer + " using pattern " + pattern.toString());
            }
            return true;
        }
        return false;
    }

    boolean isRefererValid(String referer, String requestUri) {
        if (null == referer) {
            if (this.allowNullReferers.booleanValue()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Received null referer for request to '" + requestUri + "', but system is configured to allow null refereres so allowing call to proceed.");
                }
                return true;
            }
            logger.warn("Received null referer for request to '" + requestUri + "' and system not configured to allow null referers.");
            return false;
        }
        boolean blacklisted = this.isBlacklisted(referer);
        if (blacklisted) {
            logger.warn("Disallowing access to " + requestUri + " because referer " + referer + " was blacklisted");
            return false;
        }
        boolean whitelisted = this.isWhitelisted(referer);
        if (whitelisted && logger.isDebugEnabled()) {
            logger.debug("Allowing access to '" + requestUri + "' with referer '" + referer + "' because of whitelisted match");
        } else if (!whitelisted && logger.isDebugEnabled()) {
            logger.debug("Disallowing access to " + requestUri + " because no whitelisted match was found for referer " + referer);
        }
        return whitelisted;
    }

    boolean shouldProcessMethod(HttpServletRequest request) {
        if (null == this.methodsToSkip) {
            return true;
        }
        return !this.methodsToSkip.contains(request.getMethod().toUpperCase());
    }

    public void destroy() {
    }

    static boolean matchesMediaType(MediaType value, Collection<MediaType> mediaTypes) {
        for (MediaType mediaType : mediaTypes) {
            if (!mediaType.isCompatibleWith(value)) continue;
            return true;
        }
        return false;
    }

    static boolean matchesHtml(MediaType value) {
        return CsrfRefererCheckerFilter.matchesMediaType(value, HTML_MEDIA_TYPES);
    }

    static boolean matchesJson(MediaType value) {
        return CsrfRefererCheckerFilter.matchesMediaType(value, JSON_MEDIA_TYPES);
    }

    static void writeJsonResponse(HttpServletResponse response, String requestUrl) throws IOException {
        response.addHeader("Content-Type", "application/vnd.sas.error+json");
        response.getWriter().println(MessageFormat.format(JSON_ERROR_MESSAGE, requestUrl));
    }

    static void writeJsonResponse(HttpServletResponse response, Object ... objects) throws IOException {
        response.addHeader("Content-Type", "application/vnd.sas.error+json");
        response.getWriter().println(MessageFormat.format(JSON_ERROR_MESSAGE2, objects));
    }

    static boolean matchesXml(MediaType value) {
        return CsrfRefererCheckerFilter.matchesMediaType(value, XML_MEDIA_TYPES);
    }

    static ResponseType getPreferredMediaType(String acceptHeader) {
        List mediaTypes = MediaType.parseMediaTypes((String)acceptHeader);
        MediaType.sortBySpecificityAndQuality((List)mediaTypes);
        for (MediaType mediaType : mediaTypes) {
            if (CsrfRefererCheckerFilter.matchesHtml(mediaType)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Accept header '" + acceptHeader + "' matched for a variant of HTML, redirecting to error page");
                }
                return ResponseType.HTML;
            }
            if (CsrfRefererCheckerFilter.matchesJson(mediaType)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Accept header '" + acceptHeader + "' matched for JSON, sending 403 and JSON response to CSRF rejection");
                }
                return ResponseType.JSON;
            }
            if (!CsrfRefererCheckerFilter.matchesXml(mediaType)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Accept header '" + acceptHeader + "' matched for XML, sending 403 and XML response to CSRF rejection");
            }
            return ResponseType.XML;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Accept header '" + acceptHeader + "' did not match for HTML, XML, or JSON, writing generic 403 rejection");
        }
        return ResponseType.UNKNOWN;
    }

    static void writeXmlResponse(HttpServletResponse response, String requestUrl) throws IOException {
        response.addHeader("Content-Type", "application/vnd.sas.error+xml");
        response.getWriter().println(MessageFormat.format(XML_ERROR_MESSAGE, requestUrl));
    }

    static void writeXmlResponse(HttpServletResponse response, Object ... objects) throws IOException {
        response.addHeader("Content-Type", "application/vnd.sas.error+xml");
        response.getWriter().println(MessageFormat.format(XML_ERROR_MESSAGE2, objects));
    }

    void redirectToErrorPage(HttpServletResponse response, String requestUrl) throws IOException {
        UriComponentsBuilder builder = null;
        if (null == this.urlGenerator) {
            logger.warn("No URL generator available, so trying relative redirect to SASLogon");
            builder = UriComponentsBuilder.fromPath((String)"/SASLogon/csrf");
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Using URL generator to generate URL for SASLogon for CSRF rejection redirection");
            }
            String logonUrl = this.urlGenerator.generateExternalUrl("Logon Manager", "csrf", "");
            builder = UriComponentsBuilder.fromUriString((String)logonUrl);
        }
        String redirectLocation = builder.queryParam("target", new Object[]{requestUrl}).build(false).encode().toUriString();
        if (logger.isDebugEnabled()) {
            logger.debug("Redirecting to " + redirectLocation + " for CSRF rejection");
        }
        response.sendRedirect(redirectLocation);
    }

    static String getMergedAcceptHeader(HttpServletRequest request) {
        return StringUtils.arrayToCommaDelimitedString((Object[])CollectionUtils.toArray((Enumeration)request.getHeaders("Accept"), (Object[])new String[0]));
    }

    void writeResponse(HttpServletRequest request, HttpServletResponse response, String requestUrl) throws IOException {
        String acceptHeader = CsrfRefererCheckerFilter.getMergedAcceptHeader(request);
        switch (CsrfRefererCheckerFilter.getPreferredMediaType(acceptHeader).ordinal()) {
            case 2: {
                this.redirectToErrorPage(response, requestUrl);
                break;
            }
            case 0: {
                response.setStatus(403);
                CsrfRefererCheckerFilter.writeJsonResponse(response, requestUrl);
                break;
            }
            case 1: {
                response.setStatus(403);
                CsrfRefererCheckerFilter.writeXmlResponse(response, requestUrl);
                break;
            }
            default: {
                response.sendError(403, MessageFormat.format(TEXT_ERROR_MESSAGE, requestUrl));
            }
        }
    }

    String getOriginOrReferer(HttpServletRequest request) {
        String value = request.getHeader("origin");
        if (null == value || "null".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("No origin header found, using referer header");
            }
            value = request.getHeader("referer");
        }
        return value;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        this.initializeLazy();
        if (this.performCheck.booleanValue() && this.shouldProcessMethod(request)) {
            String referer = this.getOriginOrReferer(request);
            if (this.isRefererValid(referer, request.getRequestURI())) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                String requestUrl = request.getRequestURL().toString();
                logger.warn("Denying access to '" + requestUrl + "' because of referer header '" + referer + "'.");
                this.writeResponse(request, response, StringEscapeUtils.escapeHtml4((String)requestUrl));
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    static enum ResponseType {
        JSON,
        XML,
        HTML,
        UNKNOWN;

    }
}

