/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web.csrf;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.web.filter.OncePerRequestFilter;

public class CsrfTokenResponseHeaderBindingFilter
extends OncePerRequestFilter {
    protected static final String REQUEST_CSRF_ATTRIBUTE_NAME = "_csrf";
    public static final String RESPONSE_CSRF_TOKEN = "X-CSRF-TOKEN";
    public static final String RESPONSE_HEADER_NAME = "X-CSRF-HEADER";

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        this.doFilterInternal(request, response, filterChain);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        this.bindHeaders(request, response);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected void bindHeaders(HttpServletRequest request, HttpServletResponse response) {
        CsrfToken token = (CsrfToken)request.getAttribute(REQUEST_CSRF_ATTRIBUTE_NAME);
        CsrfToken csrfToken = token = Objects.isNull(token) ? (CsrfToken)CsrfToken.class.cast(request.getAttribute(CsrfToken.class.getName())) : token;
        if (token != null && request.getSession(false) != null) {
            response.setHeader(RESPONSE_HEADER_NAME, token.getHeaderName());
            response.setHeader(RESPONSE_CSRF_TOKEN, token.getToken());
        } else {
            String tokenPars = request.getParameter(REQUEST_CSRF_ATTRIBUTE_NAME);
            if (Objects.nonNull(tokenPars) && Objects.nonNull(request.getSession(false))) {
                response.setHeader(RESPONSE_HEADER_NAME, token.getHeaderName());
                response.setHeader(RESPONSE_CSRF_TOKEN, tokenPars);
            }
        }
    }
}

