/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web.csrf;

import com.sas.framework.commons.holders.ClientApplicationNameHolder;
import com.sas.svcs.config.client.ConfigurationServiceInterface;
import com.sas.svcs.config.client.SiteConfiguration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class CsrfRequestMatchers
implements RequestMatcher {
    private static final Logger logger = LogManager.getLogger(CsrfRequestMatchers.class);
    private static final String PERFORM_CHECK = "sas.web.csrf.token.performCheck";
    private static final String ALLOWED_PATHS = "sas.web.csrf.token.allowedPaths";
    private Set<String> allowedMethods = new HashSet<String>(Arrays.asList("GET", "HEAD", "TRACE", "OPTIONS"));
    private Set<String> allowedUriEndPoints = new HashSet<String>(Arrays.asList("/resources/"));
    private Boolean performCheck;
    private ConfigurationServiceInterface configurationService;
    private String currentApplicationName;
    private volatile boolean initialized = false;
    private final Object initLock = new Object();

    public CsrfRequestMatchers() {
        String property = null;
        property = System.getProperty(PERFORM_CHECK);
        if (null != property) {
            this.performCheck = Boolean.parseBoolean(property);
            if (logger.isDebugEnabled()) {
                logger.debug("performCheck = " + property);
            }
        }
    }

    @Autowired(required=false)
    public void setConfigurationService(ConfigurationServiceInterface configurationService) {
        this.configurationService = configurationService;
    }

    public void setApplicationName(String name) {
        this.currentApplicationName = name;
    }

    public boolean matches(HttpServletRequest request) {
        if (this.allowedMethods.contains(request.getMethod())) {
            return Boolean.FALSE;
        }
        if (request.getSession(false) == null) {
            return Boolean.FALSE;
        }
        this.initializeLazy(request.getServletContext());
        return this.allowedUriEndPoints.stream().anyMatch(eachVal -> request.getRequestURI().startsWith((String)eachVal)) ? Boolean.FALSE : this.performCheck;
    }

    SiteConfiguration getCurrentConfiguration() {
        if (null == this.configurationService) {
            logger.warn("No configuration service configured. Cannot obtain site settings.");
            return new SiteConfiguration();
        }
        if (null == this.currentApplicationName) {
            this.currentApplicationName = ClientApplicationNameHolder.getBaseApplicationName();
        }
        SiteConfiguration configuration = null;
        if (null == this.currentApplicationName) {
            if (logger.isDebugEnabled()) {
                logger.debug("Could not determine current application name. Using site configuration.");
            }
            configuration = this.configurationService.getSiteConfiguration();
        } else {
            configuration = new SiteConfiguration();
            configuration.setConfiguration(this.configurationService.getSettings(this.currentApplicationName));
        }
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeLazy(ServletContext servletContext) {
        if (!this.initialized) {
            Object object = this.initLock;
            synchronized (object) {
                if (!this.initialized) {
                    String allowedUris;
                    if (null != this.performCheck && !this.performCheck.booleanValue()) {
                        this.initialized = true;
                        return;
                    }
                    this.initAppNameFromServletContext(servletContext);
                    SiteConfiguration configuration = this.getCurrentConfiguration();
                    String property = null;
                    if (null == this.performCheck) {
                        if (null != configuration && null != (property = configuration.getConfigurationProperty(PERFORM_CHECK))) {
                            this.performCheck = Boolean.parseBoolean(property);
                            if (!this.performCheck.booleanValue()) {
                                logger.debug("Not performing check as configured in configuration service.");
                                this.initialized = true;
                                return;
                            }
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Not performing check by default since no sas.web.csrf.token.performCheck setting was present in JVM args or configuration settings");
                            }
                            this.performCheck = false;
                            this.initialized = true;
                            return;
                        }
                    }
                    if (this.allowedUriEndPoints.size() <= 1 && Objects.nonNull(allowedUris = configuration.getConfigurationProperty(ALLOWED_PATHS))) {
                        Arrays.stream(allowedUris.split("[,]")).filter(eachVal -> Objects.nonNull(eachVal) && !eachVal.isEmpty()).forEach(this.allowedUriEndPoints::add);
                    }
                    this.initialized = true;
                }
            }
        }
    }

    void initAppNameFromServletContext(ServletContext servletContext) {
        String applicationName = null;
        if (null != servletContext && null != (applicationName = servletContext.getInitParameter("application-name"))) {
            this.setApplicationName(applicationName);
        }
    }
}

