/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;

public class FilterDelegatingAccessDeniedHandler
extends AccessDeniedHandlerImpl
implements AccessDeniedHandler,
FilterChain {
    private static final Logger logger = LogManager.getLogger(FilterDelegatingAccessDeniedHandler.class);
    private Filter filter;

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        if (!response.isCommitted()) {
            request.setAttribute("SPRING_SECURITY_403_EXCEPTION", (Object)accessDeniedException);
            this.filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)this);
        } else {
            logger.debug("Skipping filtering access denied exception since the response is already committed");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (!response.isCommitted()) {
            super.handle((HttpServletRequest)request, (HttpServletResponse)response, (AccessDeniedException)request.getAttribute("SPRING_SECURITY_403_EXCEPTION"));
        } else {
            logger.debug("Skipping handling access denied exception since the response is already committed");
        }
    }
}

