/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web;

import com.sas.svcs.config.client.UrlGeneratorInterface;
import com.sas.svcs.security.authentication.DevelopmentUtility;
import com.sas.svcs.security.authentication.web.LogonHandler;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.web.CasAuthenticationEntryPoint;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.context.ServletContextAware;

public class AuthenticationEntryPoint
implements org.springframework.security.web.AuthenticationEntryPoint,
ServletContextAware {
    CasAuthenticationEntryPoint entryPoint;
    String applicationName;
    UrlGeneratorInterface urlGenerator;
    List<LogonHandler> handlers = new ArrayList<LogonHandler>();

    public void setLogonHandlers(List<LogonHandler> handlers) {
        this.handlers = handlers;
    }

    @Autowired
    public void setUrlGenerator(UrlGeneratorInterface urlGenerator) {
        this.urlGenerator = urlGenerator;
    }

    public void setServletContext(ServletContext servletContext) {
        this.applicationName = servletContext.getInitParameter("application-name");
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        this.initialize();
        for (LogonHandler handler : this.handlers) {
            if (!handler.supports(request)) continue;
            response = handler.generateLogonResponse(request, response);
            break;
        }
        this.entryPoint.commence(request, response, authException);
    }

    private synchronized void initialize() {
        if (null == this.entryPoint) {
            String service = DevelopmentUtility.getServiceUrl(this.urlGenerator, this.applicationName, "login/cas");
            String login = this.urlGenerator.generateExternalUrl("Logon Manager 9.4", "login", "");
            ServiceProperties serviceProperties = new ServiceProperties();
            serviceProperties.setService(service);
            this.entryPoint = new CasAuthenticationEntryPoint();
            this.entryPoint.setServiceProperties(serviceProperties);
            this.entryPoint.setLoginUrl(login);
            this.entryPoint.setEncodeServiceUrlWithSessionId(false);
            for (LogonHandler handler : this.handlers) {
                handler.setService(this.entryPoint.getServiceProperties().getService());
            }
        }
    }
}

