/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.validation.jasig;

import com.sas.svcs.security.authentication.validation.jasig.ResponseRetriever;
import com.sas.text.Message;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apereo.cas.client.ssl.HttpURLConnectionFactory;
import org.apereo.cas.client.util.CommonUtils;
import org.springframework.util.StringUtils;

public class HttpClientResponseRetriever
implements ResponseRetriever {
    private static final Logger LOGGER = LogManager.getLogger(HttpClientResponseRetriever.class);
    private CredentialsProvider credentialsProvider;
    private ProxySelector proxySelector = ProxySelector.getDefault();
    protected ConcurrentMap<Proxy, HttpHost> proxyToHostConfigMap = new ConcurrentHashMap<Proxy, HttpHost>(2);

    public HttpClientResponseRetriever() {
        if (StringUtils.hasText((String)System.getProperty("http.proxyHost")) || StringUtils.hasText((String)System.getProperty("https.proxyHost"))) {
            String proxyUser = System.getProperty("http.proxyUser");
            String proxyPass = System.getProperty("http.proxyPassword");
            String proxyRealm = System.getProperty("http.proxyRealm");
            String proxyScheme = System.getProperty("http.proxyScheme");
            if (proxyUser == null) {
                proxyUser = System.getProperty("https.proxyUser");
                if (proxyPass != null) {
                    proxyPass = System.getProperty("https.proxyPassword");
                }
            }
            if (StringUtils.hasText((String)proxyUser)) {
                AuthScope authscope = new AuthScope(null, -1, proxyRealm, proxyScheme);
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUser, proxyPass);
                this.credentialsProvider = new BasicCredentialsProvider();
                this.credentialsProvider.setCredentials(authscope, (Credentials)credentials);
            }
        }
    }

    private HttpHost getHttpHost(URL url) {
        List<Proxy> proxies;
        try {
            proxies = this.proxySelector.select(url.toURI());
        }
        catch (URISyntaxException e) {
            LOGGER.error("", (Throwable)e);
            throw new RuntimeException("Invalid uri context: " + url, e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Proxy selector returned " + proxies.size() + " potential proxies for " + url);
        }
        HttpHost httpHost = null;
        for (Proxy proxy : proxies) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing potential proxy " + proxy.toString() + " for " + url);
            }
            if (!Proxy.Type.HTTP.equals((Object)proxy.type()) || !(proxy.address() instanceof InetSocketAddress)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found proxy match for " + url);
            }
            if (null != (httpHost = (HttpHost)this.proxyToHostConfigMap.get(proxy))) continue;
            String proxyHost = ((InetSocketAddress)proxy.address()).getHostName();
            int proxyPort = ((InetSocketAddress)proxy.address()).getPort();
            httpHost = new HttpHost(proxyHost, proxyPort, proxy.type().name());
            this.proxyToHostConfigMap.putIfAbsent(proxy, httpHost);
            if (!LOGGER.isDebugEnabled()) break;
            LOGGER.debug("Constructed new http host with proxy address " + proxyHost + " and port " + proxyPort);
            break;
        }
        return httpHost;
    }

    @Override
    public String getResponseFromServer(URL url) {
        HttpGet httpGet = new HttpGet(url.toString());
        try {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            HttpHost proxyHost = this.getHttpHost(url);
            if (null != proxyHost) {
                httpClientBuilder.setProxy(proxyHost);
            }
            if (null != this.credentialsProvider) {
                httpClientBuilder.setDefaultCredentialsProvider(this.credentialsProvider);
            }
            CloseableHttpClient httpClient = httpClientBuilder.build();
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            return new BasicResponseHandler().handleResponse(httpResponse);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getResponseFromServer(URL constructedUrl, HttpURLConnectionFactory factory, String encoding) {
        String string;
        HttpURLConnection conn = null;
        InputStreamReader in = null;
        try {
            int byteRead;
            conn = factory.buildHttpURLConnection(constructedUrl.openConnection());
            String cs = encoding;
            in = CommonUtils.isEmpty((CharSequence)cs) ? new InputStreamReader(conn.getInputStream()) : new InputStreamReader(conn.getInputStream(), encoding);
            StringBuilder builder = new StringBuilder(255);
            while ((byteRead = in.read()) != -1) {
                builder.append((char)byteRead);
            }
            string = builder.toString();
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (SSLException e2) {
                    LOGGER.error(Message.format((String)"SSL error getting response from host: {0} : Error Message: {1}", (Object)constructedUrl.getHost(), (Object)e2.getMessage()), (Throwable)e2);
                    throw new RuntimeException(e2);
                }
                catch (IOException e3) {
                    LOGGER.error(Message.format((String)"Error getting response from host: [{0}] with path: [{1}] and protocol: [{2}] Error Message: {3}", (Object)constructedUrl.getHost(), (Object)constructedUrl.getPath(), (Object)constructedUrl.getProtocol(), (Object)e3.getMessage()), (Throwable)e3);
                    throw new RuntimeException(e3);
                }
            }
            catch (Throwable throwable) {
                this.closeQuietly(in);
                if (conn != null) {
                    conn.disconnect();
                }
                throw throwable;
            }
        }
        this.closeQuietly(in);
        if (conn != null) {
            conn.disconnect();
        }
        return string;
    }

    public void closeQuietly(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

