/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.validation.jasig;

import com.sas.svcs.security.authentication.validation.jasig.Cas20ServiceTicketValidator;
import java.util.Arrays;
import java.util.List;
import org.apereo.cas.client.util.XmlUtils;
import org.apereo.cas.client.validation.Assertion;
import org.apereo.cas.client.validation.InvalidProxyChainTicketValidationException;
import org.apereo.cas.client.validation.ProxyList;
import org.apereo.cas.client.validation.TicketValidationException;

public class Cas20ProxyTicketValidator
extends Cas20ServiceTicketValidator {
    private boolean acceptAnyProxy;
    private ProxyList allowedProxyChains = new ProxyList();
    private boolean allowEmptyProxyChain = true;

    public Cas20ProxyTicketValidator(String casServerUrlPrefix) {
        super(casServerUrlPrefix);
    }

    protected final ProxyList getAllowedProxyChains() {
        return this.allowedProxyChains;
    }

    @Override
    protected String getUrlSuffix() {
        return "proxyValidate";
    }

    @Override
    protected void customParseResponse(String response, Assertion assertion) throws TicketValidationException {
        List<String> proxies = this.parseProxiesFromResponse(response);
        if (proxies == null) {
            throw new InvalidProxyChainTicketValidationException("Invalid proxy chain: No proxy could be retrieved from response. This indicates a problem with CAS validation. Review logs/configuration to find the root cause.");
        }
        if (this.allowEmptyProxyChain && proxies.isEmpty()) {
            this.logger.debug("Found an empty proxy chain, permitted by client configuration");
            return;
        }
        if (this.acceptAnyProxy) {
            this.logger.debug("Client configuration accepts any proxy. It is generally dangerous to use a non-proxied CAS filter specially for protecting resources that require proxy access.");
            return;
        }
        Object[] proxiedList = proxies.toArray(new String[proxies.size()]);
        if (this.allowedProxyChains.contains((String[])proxiedList)) {
            return;
        }
        this.logger.warn("Proxies received from the CAS validation response are {}. However, none are allowed by allowed proxy chain of the client which is {}", (Object)Arrays.toString(proxiedList), (Object)this.allowedProxyChains);
        throw new InvalidProxyChainTicketValidationException("Invalid proxy chain: " + proxies.toString());
    }

    protected List<String> parseProxiesFromResponse(String response) {
        return XmlUtils.getTextForElements((String)response, (String)"proxy");
    }

    public final void setAcceptAnyProxy(boolean acceptAnyProxy) {
        this.acceptAnyProxy = acceptAnyProxy;
    }

    public final void setAllowedProxyChains(ProxyList allowedProxyChains) {
        this.allowedProxyChains = allowedProxyChains;
    }

    protected final boolean isAcceptAnyProxy() {
        return this.acceptAnyProxy;
    }

    protected final boolean isAllowEmptyProxyChain() {
        return this.allowEmptyProxyChain;
    }

    public final void setAllowEmptyProxyChain(boolean allowEmptyProxyChain) {
        this.allowEmptyProxyChain = allowEmptyProxyChain;
    }
}

