/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.validation;

import com.sas.svcs.config.client.Application;
import com.sas.svcs.config.client.ApplicationRegistration;
import com.sas.svcs.config.client.ConfigurationServiceInterface;
import com.sas.svcs.config.client.UrlGeneratorInterface;
import com.sas.svcs.security.authentication.resolver.ServiceResolver;
import com.sas.svcs.security.authentication.validation.jasig.Cas20ProxyTicketValidator;
import com.sas.svcs.security.authentication.validation.jasig.HttpClientResponseRetriever;
import jakarta.servlet.ServletContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apereo.cas.client.proxy.ProxyGrantingTicketStorage;
import org.apereo.cas.client.validation.Assertion;
import org.apereo.cas.client.validation.TicketValidationException;
import org.apereo.cas.client.validation.TicketValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.ServletContextAware;

public class ServiceTicketValidator
implements TicketValidator,
ServletContextAware {
    Cas20ProxyTicketValidator validator;
    String applicationName;
    ServiceResolver serviceResolver;
    String proxyCallbackSuffix = "login/cas/proxyreceptor";
    ConcurrentHashMap<String, String> urlMap = new ConcurrentHashMap();
    @Autowired
    UrlGeneratorInterface urlGenerator;
    @Autowired
    ConfigurationServiceInterface configService;
    @Autowired
    ProxyGrantingTicketStorage proxyGrantingTicketStorage;

    public void setServletContext(ServletContext servletContext) {
        this.applicationName = servletContext.getInitParameter("application-name");
    }

    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }

    public void setProxyCallback(String proxyCallback) {
        this.proxyCallbackSuffix = proxyCallback;
    }

    public Assertion validate(String ticket, String service) throws TicketValidationException {
        Assertion assertion;
        try {
            assertion = this.getValidator().validate(ticket, service);
        }
        catch (TicketValidationException e) {
            if (Boolean.getBoolean("sas.retry.internal.url")) {
                this.initializeUrlMap();
                for (Map.Entry<String, String> urls : this.urlMap.entrySet()) {
                    String externalUrl = urls.getKey();
                    if (!service.startsWith(externalUrl)) continue;
                    service = service.replace(externalUrl, urls.getValue());
                    break;
                }
                return this.getValidator().validate(ticket, service);
            }
            throw e;
        }
        return assertion;
    }

    private synchronized TicketValidator getValidator() {
        if (null == this.validator) {
            String logonUrl = this.urlGenerator.generateInternalUrl("Logon Manager 9.4", "", "");
            String proxyCallback = this.serviceResolver.getService(this.proxyCallbackSuffix, false);
            this.validator = new Cas20ProxyTicketValidator(logonUrl);
            this.validator.setAcceptAnyProxy(true);
            this.validator.setProxyGrantingTicketStorage(this.proxyGrantingTicketStorage);
            this.validator.setProxyCallbackUrl(proxyCallback);
            this.validator.setResponseRetriever(new HttpClientResponseRetriever());
        }
        return this.validator;
    }

    private synchronized void initializeUrlMap() {
        if (this.urlMap.isEmpty()) {
            List applications = this.configService.getApplications();
            for (Application application : applications) {
                ApplicationRegistration registration = application.getRegistration();
                if (null == registration) continue;
                this.urlMap.put(registration.getExternalUrl(), registration.getUrl());
            }
        }
    }
}

