/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.ticket.cache;

import com.sas.svcs.data.caches.gemfire.ApplicationContextProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.Region;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.cas.authentication.StatelessTicketCache;

public class GemFireBasedTicketCache
implements StatelessTicketCache {
    private static final String STATELESS_TICKET_REGION = "stateless_ticket_region";
    private static final Logger logger = LogManager.getLogger(GemFireBasedTicketCache.class);
    private volatile Region<Object, Object> region = null;
    private final Object regionLock = new Object();
    private int ticketTimeout = 1800;

    public CasAuthenticationToken getByTicketId(String serviceTicket) {
        CasAuthenticationToken token = null;
        boolean isDebugEnabled = logger.isDebugEnabled();
        Object object = this.getRegion().get((Object)serviceTicket);
        if (object != null) {
            if (isDebugEnabled) {
                ClassLoader objectClassLoader = object.getClass().getClassLoader();
                ClassLoader tokenClassLoader = CasAuthenticationToken.class.getClassLoader();
                logger.debug("Gemfire object ClassLoader for " + serviceTicket + " \n" + objectClassLoader);
                logger.debug("CasAuthenticationToken ClassLoader for " + serviceTicket + " \n" + tokenClassLoader);
            }
            try {
                token = (CasAuthenticationToken)object;
                if (isDebugEnabled) {
                    logger.debug("Getting ticket from cache with id: " + serviceTicket + " value: " + token);
                }
            }
            catch (ClassCastException e1) {
                logger.trace("Attemt to cast object results in ClassCastException: \n", (Throwable)e1);
                logger.debug("Attempting to re-cast object by serializaing ad deserializing with WebApp ClassLoader");
                try {
                    token = (CasAuthenticationToken)this.castObject(object);
                }
                catch (Exception e2) {
                    logger.debug("Apptempt to re-cast failed");
                    logger.trace("\n", (Throwable)e2);
                }
            }
        } else if (isDebugEnabled) {
            logger.debug("Retrieved ticket from cache with id: " + serviceTicket + " value: null");
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T castObject(Object object) throws IOException, ClassNotFoundException {
        if (object != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(object);
            }
            finally {
                try {
                    oos.close();
                }
                catch (Exception exception) {}
            }
            byte[] bb = baos.toByteArray();
            if (bb != null && bb.length > 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(bb);
                ObjectInputStream ois = new ObjectInputStream(bais);
                Object res = ois.readObject();
                return (T)res;
            }
        }
        return null;
    }

    public void putTicketInCache(CasAuthenticationToken token) {
        if (logger.isDebugEnabled()) {
            logger.debug("Putting ticket in cache with id: " + token.getCredentials().toString());
        }
        this.getRegion().put((Object)token.getCredentials().toString(), (Object)token);
    }

    public void removeTicketFromCache(CasAuthenticationToken token) {
        this.removeTicketFromCache(token.getCredentials().toString());
    }

    public void removeTicketFromCache(String serviceTicket) {
        if (logger.isDebugEnabled()) {
            logger.debug("Removing ticket from cache with id: " + serviceTicket);
        }
        this.getRegion().remove((Object)serviceTicket);
    }

    public void setTicketTimeout(int ticketTimeout) {
        this.ticketTimeout = ticketTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region<Object, Object> getRegion() {
        Region result = this.region;
        if (null == result) {
            Object object = this.regionLock;
            synchronized (object) {
                result = this.region;
                if (null == result) {
                    ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
                    if (null != applicationContext) {
                        String gemfireRegionName = ApplicationContextProvider.getGemfireRegionName();
                        Region parentRegion = (Region)applicationContext.getBean(gemfireRegionName);
                        this.region = result = parentRegion.getSubregion(STATELESS_TICKET_REGION);
                        if (null == this.region) {
                            AttributesFactory subregionAttributesFactory = new AttributesFactory(parentRegion.getAttributes());
                            subregionAttributesFactory.setEntryTimeToLive(new ExpirationAttributes(this.ticketTimeout, ExpirationAction.DESTROY));
                            this.region = result = parentRegion.createSubregion(STATELESS_TICKET_REGION, subregionAttributesFactory.create());
                        }
                    }
                    if (null == result) {
                        throw new IllegalStateException("Could not find gemfire region");
                    }
                }
            }
        }
        return result;
    }
}

