/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.springframework.config;

import com.sas.framework.webapp.servlet.ApplicationNameFilter;
import com.sas.framework.webapp.servlet.SecurityFilter;
import com.sas.svcs.authentication.helper.PublicUserHelper;
import com.sas.svcs.remoting.client.CommonsClientHttpRequestFactory;
import com.sas.svcs.security.authentication.provider.AuthenticationProvider;
import com.sas.svcs.security.authentication.provider.ServiceResolverAuthenticationDetailsSource;
import com.sas.svcs.security.authentication.resolver.ConfigBasedServiceResolver;
import com.sas.svcs.security.authentication.resolver.PublishedServiceResolver;
import com.sas.svcs.security.authentication.session.DistributedSessionMappingStorage;
import com.sas.svcs.security.authentication.session.jasig.SingleSignOutFilter;
import com.sas.svcs.security.authentication.session.jasig.SingleSignOutHandler;
import com.sas.svcs.security.authentication.ticket.cache.GemFireBasedPGTCache;
import com.sas.svcs.security.authentication.ticket.cache.GemFireBasedTicketCache;
import com.sas.svcs.security.authentication.validation.ServiceTicketValidator;
import com.sas.svcs.security.authentication.web.AuthenticationEntryPoint;
import com.sas.svcs.security.authentication.web.AuthenticationFailureHandler;
import com.sas.svcs.security.authentication.web.GuestLogonHandler;
import com.sas.svcs.security.authentication.web.NoninteractiveAuthenticationEntryPoint;
import com.sas.svcs.security.authentication.web.RequestParameterLogonHandler;
import com.sas.svcs.security.authentication.web.context.HttpSessionSecurityContextRepository;
import com.sas.svcs.security.authentication.web.csrf.CsrfRequestMatchers;
import com.sas.svcs.security.authentication.web.csrf.CsrfTokenResponseHeaderBindingFilter;
import com.sas.svcs.security.authentication.web.filters.BasicAuthSessionTimeoutFilter;
import com.sas.svcs.security.authentication.web.filters.CsrfRefererCheckerFilter;
import com.sas.svcs.security.authentication.web.filters.RevokableTokenLogoutFilter;
import com.sas.svcs.security.authentication.web.filters.SessionIdentifierFilter;
import com.sas.svcs.security.authentication.web.filters.TgtKeepAliveFilter;
import com.sas.svcs.security.authentication.web.logout.UrlLogoutSuccessHandler;
import com.sas.svcs.security.authentication.web.providers.CasTgtAuthenticationProvider;
import com.sas.svcs.security.authentication.web.providers.UsernamePasswordCasAuthenticationProvider;
import com.sas.svcs.security.authentication.web.session.SessionFixationSupportListener;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apereo.cas.client.proxy.ProxyGrantingTicketStorageImpl;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.authentication.EhCacheBasedTicketCache;
import org.springframework.security.cas.web.CasAuthenticationFilter;
import org.springframework.security.cas.web.authentication.ServiceAuthenticationDetailsSource;
import org.springframework.security.config.authentication.AuthenticationManagerBeanDefinitionParser;
import org.springframework.security.config.http.HttpSecurityBeanDefinitionParser;
import org.springframework.security.web.authentication.DelegatingAuthenticationEntryPoint;
import org.springframework.security.web.authentication.ExceptionMappingAuthenticationFailureHandler;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HttpBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final Logger logger = LogManager.getLogger(HttpBeanDefinitionParser.class);
    private static final String SESSION_FIXATION_STRATEGY_ID = "sas.svcs.fixationProtectionStrategy";
    private static final String TGT_KEEP_ALIVE_FILTER = "sas.svcs.tgtKeepAliveFilter";
    private static final String DEFAULT_TICKET_VALIDATOR_ID = "sas.svcs.ticketValidator";
    private static final String DEFAULT_AUTH_PROVIDER_ID = "sas.svcs.authProvider";
    private static final String DIRECT_AUTH_PROVIDER_ID = "sas.svcs.direct.authProvider";
    private static final String CAS_TGT_PROVIDER_ID = "sas.svcs.tgt.authProvider";
    private static final String DEFAULT_LOGOUT_FILTER_ID = "sas.svcs.logoutFilter";
    private static final String REVOKABLE_LOGOUT_FILTER_ID = "sas.svcs.revokableLogoutFilter";
    private static final String DEFAULT_CONTEXT_LOGOUT_HANDLER_ID = "sas.svcs.contextLogoutHandler";
    private static final String DEFAULT_URL_LOGOUT_HANDLER_ID = "sas.svcs.logoutSuccessHandler";
    private static final String DEFAULT_SESSION_MAPPING_STORAGE_ID = "sas.svcs.ssoSessionMappingStorage";
    private static final String DEFAULT_SINGLE_SIGNOUT_FILTER_ID = "sas.svcs.ssoFilter";
    private static final String CSRF_HEADER_CHECKER_FILTER_ID = "sas.svcs.csrf.headerFilter";
    private static final String CSRF_TOKEN_RESPONSE_HEADER_BINDING_FILTER = "csrfTokenResponseHeaderBindingFilter";
    private static final String CSRF_REQUEST_MATCHERS = "csrfRequestMatchers";
    private static final String SESSION_FIXATION_SUPPORT_LISTENER_ID = "sas.svcs.sessionFixationSupportListener";
    private static final String DEFAULT_SESSION_IDENTIFIER_FILTER_ID = "sas.svcs.sessionIdentifierFilter";
    private static final String DEFAULT_FILTER_ID = "sas.svcs.casFilter";
    private static final String SINGLE_SIGNOUT_HANDLER = "sas.svcs.singleSignOutHandler";
    private static final String DEFAULT_SUCCESS_HANDLER_ID = "sas.svcs.authSuccessHandler";
    private static final String DEFAULT_FAILURE_HANDLER_ID = "sas.svcs.authFailureHandler";
    private static final String CAS_ENTRY_POINT_ID = "sas.svcs.casAuthEntryPoint";
    private static final String INTERACTIVE_SWITCHING_ENTRY_POINT_ID = "sas.svcs.interactiveSwitchEntryPoint";
    private static final String INTERACTIVE_DELEGATING_ENTRY_POINT_ID = "sas.svcs.interactiveDelegatingEntryPoint";
    private static final String NON_BROWSER_ENTRY_POINT_ID = "sas.svcs.nonBrowserEntryPoint";
    private static final String NONINTERACTIVE_ENTRY_POINT_ID = "sas.svcs.noninteractiveEntryPoint";
    private static final String DEFAULT_PROXY_GRANTING_TICKET_STORAGE_ID = "sas.svcs.casProxyGrantingTicketStorage";
    private static final String APPLICATION_NAME_FILTER_ID = "sas.svcs.applicationNameFilter";
    private static final String AUTHENTICATION_DETAILS_SOURCE_ID = "sas.svcs.authenticationDetailsSource";
    private static final String BASIC_AUTH_XML = "<http-basic authentication-details-source-ref=\"sas.svcs.authenticationDetailsSource\" />";
    private static final String SERVICE_RESOLVER_BEAN_ID = "sas.svcs.authentication.serviceResolver";
    private static final String CSRF_FILTER_ID = "CSRF_FILTER";
    private static final String CSRF_TOKEN_REP_SESSION_ID = "httpSessionCsrfTokenRepository";
    private static final String BASIC_AUTH_SESSION_TIMEOUT_FILTER = "sas.svcs.basicAuthSessionTimeoutFilter";
    private static final String BASIC_AUTH_SESSION_TIMEOUT_SYS_PROP = "sas.svcs.http.basic.sessionTimeout";
    private static final String CLIENT_HTTP_REQUEST_FACTORY = "sas.svcs.http.requestFactory";
    private static final String TICKET_CACHE = "sas.svcs.statelessTicketCache";
    private static final String SETINIT_FILTER = "sas.svcs.setinitFilter";
    private static final String EHCACHE_CLASSNAME = "net.sf.ehcache.Cache";
    private static final String PROXY_AUTHENTICATION_FAILURE_HANDLER_ID = "sas.svcs.proxyAuthenticationFailureHandler";
    private static final String SESSION_FIXATION_SUPPORT_CLASS = "com.sas.vfabrictcsvr.session.SessionFixationSupport";
    HttpSecurityBeanDefinitionParser securityParser = new HttpSecurityBeanDefinitionParser();
    AuthenticationManagerBeanDefinitionParser authManagerParser = new AuthenticationManagerBeanDefinitionParser();

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
        String matcherType;
        String matcherRef;
        String pattern;
        Element serviceResolver;
        Element allowGuestElement;
        boolean stateless;
        BeanDefinitionRegistry registry = context.getRegistry();
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader(registry);
        xmlReader.loadBeanDefinitions("classpath*:META-INF/wip-cache-client-config.xml");
        String pgtStorageId = element.getAttribute("pgt-storage-ref");
        if (!StringUtils.hasText((String)pgtStorageId)) {
            BeanDefinitionBuilder proxyGrantingTicketStorage = null;
            if (HttpBeanDefinitionParser.isGemfireAvailable(context)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Gemfire locators profile is active, using " + GemFireBasedPGTCache.class.getName() + " as pgt ticket storage");
                }
                proxyGrantingTicketStorage = BeanDefinitionBuilder.rootBeanDefinition(GemFireBasedPGTCache.class);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Gemfire locators profile is not active, using " + ProxyGrantingTicketStorageImpl.class.getName() + " as pgt ticket storage");
                }
                proxyGrantingTicketStorage = BeanDefinitionBuilder.rootBeanDefinition(ProxyGrantingTicketStorageImpl.class);
            }
            registry.registerBeanDefinition(DEFAULT_PROXY_GRANTING_TICKET_STORAGE_ID, (BeanDefinition)proxyGrantingTicketStorage.getBeanDefinition());
            pgtStorageId = DEFAULT_PROXY_GRANTING_TICKET_STORAGE_ID;
        }
        if (stateless = Boolean.parseBoolean(element.getAttribute("stateless"))) {
            BeanDefinitionBuilder http403EntryPoint = BeanDefinitionBuilder.rootBeanDefinition(Http403ForbiddenEntryPoint.class);
            registry.registerBeanDefinition("sas.svcs.403ForbiddenEntryPoint", (BeanDefinition)http403EntryPoint.getBeanDefinition());
            if (HttpBeanDefinitionParser.isGemfireAvailable(context)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Using gemfire based stateless ticket cache.");
                }
                BeanDefinitionBuilder gemfireCacheBasedTicketCache = BeanDefinitionBuilder.rootBeanDefinition(GemFireBasedTicketCache.class);
                gemfireCacheBasedTicketCache.addPropertyValue("ticketTimeout", (Object)"@{sas.stateless.ticket.timeout:1800}");
                registry.registerBeanDefinition(TICKET_CACHE, (BeanDefinition)gemfireCacheBasedTicketCache.getBeanDefinition());
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Using EHCache based stateless ticket cache because gemfire was not available or active.");
                }
                BeanDefinitionBuilder ehCache = BeanDefinitionBuilder.rootBeanDefinition((String)EHCACHE_CLASSNAME);
                ehCache.addConstructorArgValue((Object)"casTickets");
                ehCache.addConstructorArgValue((Object)50);
                ehCache.addConstructorArgValue((Object)true);
                ehCache.addConstructorArgValue((Object)false);
                ehCache.addConstructorArgValue((Object)3600);
                ehCache.addConstructorArgValue((Object)900);
                ehCache.setInitMethodName("initialise");
                ehCache.setDestroyMethodName("dispose");
                registry.registerBeanDefinition("sas.svcs.ehCache", (BeanDefinition)ehCache.getBeanDefinition());
                BeanDefinitionBuilder ehCacheBasedTicketCache = BeanDefinitionBuilder.rootBeanDefinition(EhCacheBasedTicketCache.class);
                ehCacheBasedTicketCache.addPropertyReference("cache", "sas.svcs.ehCache");
                registry.registerBeanDefinition(TICKET_CACHE, (BeanDefinition)ehCacheBasedTicketCache.getBeanDefinition());
            }
        }
        ManagedList handlers = new ManagedList();
        Element acceptCredentialsElement = DomUtils.getChildElementByTagName((Element)element, (String)"accept-direct-credentials");
        String securityContextRepositoryRef = "";
        if (null != acceptCredentialsElement) {
            BeanDefinitionBuilder requestParameterHandler = BeanDefinitionBuilder.rootBeanDefinition(RequestParameterLogonHandler.class);
            String useridField = acceptCredentialsElement.getAttribute("userid-field");
            String passwordField = acceptCredentialsElement.getAttribute("password-field");
            requestParameterHandler.addPropertyValue("useridField", (Object)useridField);
            requestParameterHandler.addPropertyValue("passwordField", (Object)passwordField);
            requestParameterHandler.addPropertyValue("path", (Object)acceptCredentialsElement.getAttribute("path"));
            AbstractBeanDefinition requestHandlerBeanDefinition = requestParameterHandler.getBeanDefinition();
            handlers.add((Object)requestHandlerBeanDefinition);
            BeanDefinitionBuilder securityContextRepository = BeanDefinitionBuilder.rootBeanDefinition(HttpSessionSecurityContextRepository.class);
            securityContextRepository.addPropertyValue("useridField", (Object)useridField);
            securityContextRepository.addPropertyValue("passwordField", (Object)passwordField);
            registry.registerBeanDefinition("sas.svcs.securityContextRepository", (BeanDefinition)securityContextRepository.getBeanDefinition());
            securityContextRepositoryRef = " security-context-repository-ref=\"sas.svcs.securityContextRepository\" ";
        }
        if (null != (allowGuestElement = DomUtils.getChildElementByTagName((Element)element, (String)"allow-guest"))) {
            BeanDefinitionBuilder guestLogonHandler = BeanDefinitionBuilder.rootBeanDefinition(GuestLogonHandler.class);
            guestLogonHandler.addPropertyValue("defaultUserid", (Object)allowGuestElement.getAttribute("userid"));
            guestLogonHandler.addPropertyValue("defaultPassword", (Object)allowGuestElement.getAttribute("password"));
            guestLogonHandler.addPropertyValue("path", (Object)allowGuestElement.getAttribute("path"));
            AbstractBeanDefinition guestHandlerBeanDefinition = guestLogonHandler.getBeanDefinition();
            handlers.add((Object)guestHandlerBeanDefinition);
        }
        BeanDefinitionBuilder sasCasAuthEntryPoint = BeanDefinitionBuilder.rootBeanDefinition(AuthenticationEntryPoint.class);
        sasCasAuthEntryPoint.addPropertyValue("logonHandlers", (Object)handlers);
        registry.registerBeanDefinition(CAS_ENTRY_POINT_ID, (BeanDefinition)sasCasAuthEntryPoint.getBeanDefinition());
        String entryPointId = CAS_ENTRY_POINT_ID;
        String basicAuthSpringXml = "";
        String customAttrForBasicAuthPattern = "";
        Element basicAuth = HttpBeanDefinitionParser.getFirstOfManyChildElementsByTagName(element, "http-basic");
        String basicAuthPattern = null;
        if (null != basicAuth) {
            BeanDefinitionBuilder nonBrowserEntryPoint = BeanDefinitionBuilder.rootBeanDefinition(BasicAuthenticationEntryPoint.class);
            String realmName = basicAuth.getAttribute("realm-name");
            nonBrowserEntryPoint.addPropertyValue("realmName", (Object)realmName);
            customAttrForBasicAuthPattern = " realm=\"" + realmName + "\" ";
            registry.registerBeanDefinition(NON_BROWSER_ENTRY_POINT_ID, (BeanDefinition)nonBrowserEntryPoint.getBeanDefinition());
            BeanDefinitionBuilder delegatingEntryPoint = BeanDefinitionBuilder.rootBeanDefinition(DelegatingAuthenticationEntryPoint.class);
            ManagedMap delegatingEntryPointMap = new ManagedMap();
            String disableHttpBasicRule = basicAuth.getAttribute("interactive-if");
            delegatingEntryPointMap.put((Object)disableHttpBasicRule, (Object)new RuntimeBeanReference(CAS_ENTRY_POINT_ID));
            delegatingEntryPoint.addConstructorArgValue((Object)delegatingEntryPointMap);
            delegatingEntryPoint.addPropertyReference("defaultEntryPoint", NON_BROWSER_ENTRY_POINT_ID);
            registry.registerBeanDefinition(INTERACTIVE_SWITCHING_ENTRY_POINT_ID, (BeanDefinition)delegatingEntryPoint.getBeanDefinition());
            String pattern2 = basicAuth.getAttribute("pattern");
            if (!HttpBeanDefinitionParser.isTopLevelWildcardPattern(pattern2)) {
                basicAuthPattern = pattern2;
            } else {
                basicAuthSpringXml = BASIC_AUTH_XML;
                entryPointId = INTERACTIVE_SWITCHING_ENTRY_POINT_ID;
            }
        }
        Element noninteractive = null;
        String noninteractivePattern = null;
        if (INTERACTIVE_SWITCHING_ENTRY_POINT_ID != entryPointId) {
            noninteractive = HttpBeanDefinitionParser.getFirstOfManyChildElementsByTagName(element, "noninteractive");
        } else if (logger.isDebugEnabled()) {
            logger.debug("ignoring noninteractive elements (if any) because http-basic pattern is a top level wildcard");
        }
        if (null != noninteractive) {
            BeanDefinitionBuilder noninteractiveEntryPoint = BeanDefinitionBuilder.rootBeanDefinition(NoninteractiveAuthenticationEntryPoint.class);
            registry.registerBeanDefinition(NONINTERACTIVE_ENTRY_POINT_ID, (BeanDefinition)noninteractiveEntryPoint.getBeanDefinition());
            BeanDefinitionBuilder delegatingEntryPoint = BeanDefinitionBuilder.rootBeanDefinition(DelegatingAuthenticationEntryPoint.class);
            ManagedMap delegatingEntryPointMap = new ManagedMap();
            String interactiveIfBasicRule = noninteractive.getAttribute("interactive-if");
            delegatingEntryPointMap.put((Object)interactiveIfBasicRule, (Object)new RuntimeBeanReference(CAS_ENTRY_POINT_ID));
            delegatingEntryPoint.addConstructorArgValue((Object)delegatingEntryPointMap);
            delegatingEntryPoint.addPropertyReference("defaultEntryPoint", NONINTERACTIVE_ENTRY_POINT_ID);
            registry.registerBeanDefinition(INTERACTIVE_DELEGATING_ENTRY_POINT_ID, (BeanDefinition)delegatingEntryPoint.getBeanDefinition());
            String htmlTypes = noninteractive.getAttribute("html-types");
            List<String> htmlTypeLst = Arrays.asList(StringUtils.tokenizeToStringArray((String)htmlTypes, (String)","));
            noninteractiveEntryPoint.addPropertyValue("htmlTypes", htmlTypeLst);
            String pattern3 = noninteractive.getAttribute("pattern");
            if (!HttpBeanDefinitionParser.isTopLevelWildcardPattern(pattern3)) {
                noninteractivePattern = pattern3;
            } else {
                entryPointId = NONINTERACTIVE_ENTRY_POINT_ID;
            }
        }
        BeanDefinitionBuilder authSuccessHandler = BeanDefinitionBuilder.rootBeanDefinition(SavedRequestAwareAuthenticationSuccessHandler.class);
        authSuccessHandler.addPropertyValue("alwaysUseDefaultTargetUrl", (Object)element.getAttribute("force-target-url"));
        authSuccessHandler.addPropertyValue("defaultTargetUrl", (Object)element.getAttribute("logon-target-url"));
        registry.registerBeanDefinition(DEFAULT_SUCCESS_HANDLER_ID, (BeanDefinition)authSuccessHandler.getBeanDefinition());
        BeanDefinitionBuilder authFailureHandler = BeanDefinitionBuilder.rootBeanDefinition(ExceptionMappingAuthenticationFailureHandler.class);
        HashMap<String, String> failureUrlMap = new HashMap<String, String>();
        failureUrlMap.put("org.springframework.security.authentication.InsufficientAuthenticationException", element.getAttribute("logoff-processing-url") + "?publicDenied=true");
        authFailureHandler.addPropertyValue("exceptionMappings", failureUrlMap);
        registry.registerBeanDefinition(DEFAULT_FAILURE_HANDLER_ID, (BeanDefinition)authFailureHandler.getBeanDefinition());
        boolean systemValidation = Boolean.parseBoolean(element.getAttribute("system-validation"));
        String setinitStr = "";
        if (systemValidation) {
            BeanDefinitionBuilder setinitFilterBuilder = BeanDefinitionBuilder.rootBeanDefinition(SecurityFilter.class);
            registry.registerBeanDefinition(SETINIT_FILTER, (BeanDefinition)setinitFilterBuilder.getBeanDefinition());
            setinitStr = "<custom-filter ref=\"sas.svcs.setinitFilter\" before=\"FILTER_SECURITY_INTERCEPTOR\" />";
        }
        if (stateless) {
            BeanDefinitionBuilder serviceProperties = BeanDefinitionBuilder.rootBeanDefinition(ServiceProperties.class);
            serviceProperties.addPropertyValue("authenticateAllArtifacts", (Object)"true");
            serviceProperties.addPropertyValue("service", (Object)(System.getProperty("sas.scs.cas.scheme") + "://" + System.getProperty("sas.scs.cas.host") + ":" + System.getProperty("sas.scs.cas.port") + "/SASLogon/services/j_acegi_cas_security_check"));
            registry.registerBeanDefinition("sas.svcs.casFilterServiceProperties", (BeanDefinition)serviceProperties.getBeanDefinition());
        }
        if (stateless || null != basicAuth) {
            BeanDefinitionBuilder serviceAuthenticationDetailsSource = BeanDefinitionBuilder.rootBeanDefinition(ServiceAuthenticationDetailsSource.class);
            serviceAuthenticationDetailsSource.addConstructorArgReference("sas.svcs.casFilterServiceProperties");
            registry.registerBeanDefinition(AUTHENTICATION_DETAILS_SOURCE_ID, (BeanDefinition)serviceAuthenticationDetailsSource.getBeanDefinition());
        }
        BeanDefinitionBuilder casFilter = BeanDefinitionBuilder.rootBeanDefinition(CasAuthenticationFilter.class);
        casFilter.addPropertyReference("authenticationManager", "authManager");
        if (stateless) {
            casFilter.addPropertyReference("serviceProperties", "sas.svcs.casFilterServiceProperties");
            casFilter.addPropertyReference("authenticationDetailsSource", AUTHENTICATION_DETAILS_SOURCE_ID);
        }
        casFilter.addPropertyReference("authenticationSuccessHandler", DEFAULT_SUCCESS_HANDLER_ID);
        casFilter.addPropertyReference("authenticationFailureHandler", DEFAULT_FAILURE_HANDLER_ID);
        casFilter.addPropertyReference("proxyGrantingTicketStorage", pgtStorageId);
        casFilter.addPropertyValue("proxyReceptorUrl", (Object)"/login/cas/proxyreceptor");
        casFilter.addPropertyReference("proxyAuthenticationFailureHandler", this.registerProxyAuthenticationFailureHandler(registry));
        String sessionFixationProtection = element.getAttribute("session-fixation-protection");
        if (!StringUtils.hasText((String)sessionFixationProtection)) {
            sessionFixationProtection = System.getProperty("sas.session.fixation", "none");
        }
        if (StringUtils.hasText((String)sessionFixationProtection)) {
            if ("migrateSession".equals(sessionFixationProtection)) {
                boolean sharedSessionCookies = false;
                Class<SessionFixationProtectionStrategy> sessionFixationProtectionStrategy = SessionFixationProtectionStrategy.class;
                try {
                    Class.forName(SESSION_FIXATION_SUPPORT_CLASS);
                    sessionFixationProtectionStrategy = com.sas.svcs.security.authentication.web.session.SessionFixationProtectionStrategy.class;
                    sharedSessionCookies = Boolean.parseBoolean(element.getAttribute("shared-session-cookies"));
                    if (sharedSessionCookies) {
                        BeanDefinitionBuilder sharedSessionListenerBean = BeanDefinitionBuilder.rootBeanDefinition(SessionFixationSupportListener.class);
                        registry.registerBeanDefinition(SESSION_FIXATION_SUPPORT_LISTENER_ID, (BeanDefinition)sharedSessionListenerBean.getBeanDefinition());
                    }
                }
                catch (ClassNotFoundException e) {
                    logger.warn(e.getMessage() + "; sas.vfabrictcsvr.jar in the server lib directory is out of date; session fixation protection will be limited.");
                }
                BeanDefinitionBuilder fixationStrategy = BeanDefinitionBuilder.rootBeanDefinition(sessionFixationProtectionStrategy);
                if (sharedSessionCookies) {
                    fixationStrategy.addPropertyValue("sharedSessionCookies", (Object)sharedSessionCookies);
                    logger.debug("Using shared session cookies with session fixation");
                }
                registry.registerBeanDefinition(SESSION_FIXATION_STRATEGY_ID, (BeanDefinition)fixationStrategy.getBeanDefinition());
                casFilter.addPropertyReference("sessionAuthenticationStrategy", SESSION_FIXATION_STRATEGY_ID);
            } else if (!"none".equals(sessionFixationProtection)) {
                logger.error("Invalid value for session-fixation-protection, " + sessionFixationProtection + ". Only 'none' or 'migrateSession' are supported.");
            }
        }
        BeanDefinitionBuilder distributedSessionMappingStorage = BeanDefinitionBuilder.rootBeanDefinition(DistributedSessionMappingStorage.class);
        registry.registerBeanDefinition(DEFAULT_SESSION_MAPPING_STORAGE_ID, (BeanDefinition)distributedSessionMappingStorage.getBeanDefinition());
        BeanDefinitionBuilder singleSignOutHandler = BeanDefinitionBuilder.rootBeanDefinition(SingleSignOutHandler.class);
        singleSignOutHandler.addPropertyReference("sessionMappingStorage", DEFAULT_SESSION_MAPPING_STORAGE_ID);
        singleSignOutHandler.addPropertyValue("artifactParameterName", (Object)"ticket");
        singleSignOutHandler.addPropertyValue("logoutParameterName", (Object)"logoutRequest");
        singleSignOutHandler.addPropertyValue("sessionMigrationEnabled", (Object)"migrateSession".equals(sessionFixationProtection));
        singleSignOutHandler.setInitMethodName("init");
        registry.registerBeanDefinition(SINGLE_SIGNOUT_HANDLER, (BeanDefinition)singleSignOutHandler.getBeanDefinition());
        BeanDefinitionBuilder singleSignOutFilter = BeanDefinitionBuilder.rootBeanDefinition(SingleSignOutFilter.class);
        singleSignOutFilter.addPropertyReference("handler", SINGLE_SIGNOUT_HANDLER);
        registry.registerBeanDefinition(DEFAULT_SINGLE_SIGNOUT_FILTER_ID, (BeanDefinition)singleSignOutFilter.getBeanDefinition());
        BeanDefinitionBuilder sessionIdentifierFilter = BeanDefinitionBuilder.rootBeanDefinition(SessionIdentifierFilter.class);
        registry.registerBeanDefinition(DEFAULT_SESSION_IDENTIFIER_FILTER_ID, (BeanDefinition)sessionIdentifierFilter.getBeanDefinition());
        BeanDefinitionBuilder logoutSuccessHandler = BeanDefinitionBuilder.rootBeanDefinition(UrlLogoutSuccessHandler.class);
        registry.registerBeanDefinition(DEFAULT_URL_LOGOUT_HANDLER_ID, (BeanDefinition)logoutSuccessHandler.getBeanDefinition());
        BeanDefinitionBuilder contextLogoutHandler = BeanDefinitionBuilder.rootBeanDefinition(SecurityContextLogoutHandler.class);
        registry.registerBeanDefinition(DEFAULT_CONTEXT_LOGOUT_HANDLER_ID, (BeanDefinition)contextLogoutHandler.getBeanDefinition());
        BeanDefinitionBuilder logoutFilter = BeanDefinitionBuilder.rootBeanDefinition(LogoutFilter.class);
        logoutFilter.addConstructorArgReference(DEFAULT_URL_LOGOUT_HANDLER_ID);
        logoutFilter.addConstructorArgReference(DEFAULT_CONTEXT_LOGOUT_HANDLER_ID);
        logoutFilter.addPropertyValue("filterProcessesUrl", (Object)element.getAttribute("logoff-processing-url"));
        registry.registerBeanDefinition(DEFAULT_LOGOUT_FILTER_ID, (BeanDefinition)logoutFilter.getBeanDefinition());
        BeanDefinitionBuilder casTicketValidator = BeanDefinitionBuilder.rootBeanDefinition(ServiceTicketValidator.class);
        BeanDefinitionBuilder casAuthenticationProvider = BeanDefinitionBuilder.rootBeanDefinition(AuthenticationProvider.class);
        String userDetailsServiceId = element.getAttribute("user-details-service");
        casAuthenticationProvider.addPropertyReference("userDetailsService", userDetailsServiceId);
        if (stateless) {
            casAuthenticationProvider.addPropertyReference("statelessTicketCache", TICKET_CACHE);
        }
        if (null != (serviceResolver = DomUtils.getChildElementByTagName((Element)element, (String)"service-resolver"))) {
            casAuthenticationProvider.addPropertyReference("serviceResolver", serviceResolver.getAttribute("ref"));
            casTicketValidator.addPropertyReference("serviceResolver", serviceResolver.getAttribute("ref"));
        } else {
            serviceResolver = DomUtils.getChildElementByTagName((Element)element, (String)"auto-discovery-resolver");
            BeanDefinitionBuilder resolverBuilder = null;
            if (null != serviceResolver) {
                resolverBuilder = BeanDefinitionBuilder.rootBeanDefinition(PublishedServiceResolver.class);
                BeanDefinitionBuilder detailsSourceBuilder = BeanDefinitionBuilder.rootBeanDefinition(ServiceResolverAuthenticationDetailsSource.class);
                detailsSourceBuilder.addPropertyReference("serviceResolver", SERVICE_RESOLVER_BEAN_ID);
                casFilter.addPropertyValue("authenticationDetailsSource", (Object)detailsSourceBuilder.getBeanDefinition());
            } else {
                resolverBuilder = BeanDefinitionBuilder.rootBeanDefinition(ConfigBasedServiceResolver.class);
            }
            registry.registerBeanDefinition(SERVICE_RESOLVER_BEAN_ID, (BeanDefinition)resolverBuilder.getBeanDefinition());
            casAuthenticationProvider.addPropertyReference("serviceResolver", SERVICE_RESOLVER_BEAN_ID);
            casTicketValidator.addPropertyReference("serviceResolver", SERVICE_RESOLVER_BEAN_ID);
        }
        registry.registerBeanDefinition(DEFAULT_FILTER_ID, (BeanDefinition)casFilter.getBeanDefinition());
        registry.registerBeanDefinition(DEFAULT_AUTH_PROVIDER_ID, (BeanDefinition)casAuthenticationProvider.getBeanDefinition());
        registry.registerBeanDefinition(DEFAULT_TICKET_VALIDATOR_ID, (BeanDefinition)casTicketValidator.getBeanDefinition());
        BeanDefinitionBuilder applicationNameFilter = BeanDefinitionBuilder.rootBeanDefinition(ApplicationNameFilter.class);
        registry.registerBeanDefinition(APPLICATION_NAME_FILTER_ID, (BeanDefinition)applicationNameFilter.getBeanDefinition());
        BeanDefinitionBuilder tgtKeepAliveFilter = BeanDefinitionBuilder.rootBeanDefinition(TgtKeepAliveFilter.class);
        registry.registerBeanDefinition(TGT_KEEP_ALIVE_FILTER, (BeanDefinition)tgtKeepAliveFilter.getBeanDefinition());
        boolean foundTopLevelWildcard = false;
        StringBuilder interceptUrls = new StringBuilder();
        List interceptElements = DomUtils.getChildElementsByTagName((Element)element, (String)"intercept-url");
        try {
            for (Element elt : interceptElements) {
                String pattern4 = elt.getAttribute("pattern");
                if (HttpBeanDefinitionParser.isTopLevelWildcardPattern(pattern4)) {
                    foundTopLevelWildcard = true;
                }
                interceptUrls.append("<").append(elt.getLocalName()).append(" ");
                NamedNodeMap attributes = elt.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node item = attributes.item(i);
                    interceptUrls.append(item.getNodeName()).append("=\"").append(item.getNodeValue()).append("\" ");
                }
                interceptUrls.append("/>");
            }
        }
        catch (Exception e) {
            System.out.println("Unable to parse intercept-url elements.");
            e.printStackTrace();
        }
        if (!foundTopLevelWildcard) {
            interceptUrls.append("<intercept-url pattern=\"/**\" access=\"isAuthenticated()\" />");
        }
        String customXml = "";
        if (StringUtils.hasText((String)element.getAttribute("last-custom-filter"))) {
            customXml = "<custom-filter position=\"LAST\" ref=\"" + element.getAttribute("last-custom-filter") + "\" />";
        }
        String authManagerXml = "<authentication-manager alias=\"authManager\"> <authentication-provider ref=\"sas.svcs.authProvider\" /> ";
        BeanDefinitionBuilder clientRequestFactory = BeanDefinitionBuilder.rootBeanDefinition(CommonsClientHttpRequestFactory.class);
        registry.registerBeanDefinition(CLIENT_HTTP_REQUEST_FACTORY, (BeanDefinition)clientRequestFactory.getBeanDefinition());
        BeanDefinitionBuilder usernamePasswordDirectProvider = BeanDefinitionBuilder.rootBeanDefinition(UsernamePasswordCasAuthenticationProvider.class);
        usernamePasswordDirectProvider.addPropertyReference("userDetailsService", userDetailsServiceId);
        usernamePasswordDirectProvider.addPropertyReference("ticketValidator", DEFAULT_TICKET_VALIDATOR_ID);
        usernamePasswordDirectProvider.addPropertyReference("clientRequestFactory", CLIENT_HTTP_REQUEST_FACTORY);
        usernamePasswordDirectProvider.addPropertyReference("sessionMappingStorage", DEFAULT_SESSION_MAPPING_STORAGE_ID);
        registry.registerBeanDefinition(DIRECT_AUTH_PROVIDER_ID, (BeanDefinition)usernamePasswordDirectProvider.getBeanDefinition());
        authManagerXml = authManagerXml + "<authentication-provider ref=\"sas.svcs.direct.authProvider\" />";
        if (null != acceptCredentialsElement || null != basicAuth) {
            BeanDefinitionBuilder casTgtProvider = BeanDefinitionBuilder.rootBeanDefinition(CasTgtAuthenticationProvider.class);
            casTgtProvider.addPropertyReference("userDetailsService", userDetailsServiceId);
            casTgtProvider.addPropertyReference("ticketValidator", DEFAULT_TICKET_VALIDATOR_ID);
            casTgtProvider.addPropertyReference("clientRequestFactory", CLIENT_HTTP_REQUEST_FACTORY);
            casTgtProvider.addPropertyReference("sessionMappingStorage", DEFAULT_SESSION_MAPPING_STORAGE_ID);
            if (stateless) {
                casTgtProvider.addPropertyReference("ticketCache", TICKET_CACHE);
            }
            registry.registerBeanDefinition(CAS_TGT_PROVIDER_ID, (BeanDefinition)casTgtProvider.getBeanDefinition());
            authManagerXml = authManagerXml + "<authentication-provider ref=\"sas.svcs.tgt.authProvider\" />";
        }
        BeanDefinitionBuilder revokableFilterBuilder = BeanDefinitionBuilder.rootBeanDefinition(RevokableTokenLogoutFilter.class);
        registry.registerBeanDefinition(REVOKABLE_LOGOUT_FILTER_ID, (BeanDefinition)revokableFilterBuilder.getBeanDefinition());
        customXml = customXml + "<custom-filter after=\"LOGOUT_FILTER\" ref=\"sas.svcs.revokableLogoutFilter\" />";
        authManagerXml = authManagerXml + "</authentication-manager>";
        customXml = customXml + HttpBeanDefinitionParser.getAccessDeniedHandlerXml(element);
        String customAttributes = "";
        if (!registry.containsBeanDefinition("publicUserHelper")) {
            AbstractBeanDefinition publicUserDef = BeanDefinitionBuilder.rootBeanDefinition(PublicUserHelper.class).getBeanDefinition();
            registry.registerBeanDefinition("publicUserHelper", (BeanDefinition)publicUserDef);
        }
        String customXmlForBasicAuthPattern = "";
        if (StringUtils.hasText((String)sessionFixationProtection)) {
            if (!"none".equals(sessionFixationProtection)) {
                customAttributes = customAttributes + "create-session=\"always\"";
            }
            customXml = "migrateSession".equals(sessionFixationProtection) ? customXml + "<session-management session-authentication-strategy-ref=\"sas.svcs.fixationProtectionStrategy\" />" : customXml + "<session-management session-fixation-protection=\"" + sessionFixationProtection + "\" />";
            if (null != basicAuth) {
                logger.debug("Stateless ticket cache in use with HTTP basic auth, adding basic auth timeout filter");
                BeanDefinitionBuilder basicAuthTimeoutFilter = BeanDefinitionBuilder.rootBeanDefinition(BasicAuthSessionTimeoutFilter.class);
                String basicAuthSessionTimeout = System.getProperty(BASIC_AUTH_SESSION_TIMEOUT_SYS_PROP);
                if (StringUtils.hasText((String)basicAuthSessionTimeout)) {
                    basicAuthTimeoutFilter.addPropertyValue("inactiveTimeout", (Object)basicAuthSessionTimeout);
                }
                registry.registerBeanDefinition(BASIC_AUTH_SESSION_TIMEOUT_FILTER, (BeanDefinition)basicAuthTimeoutFilter.getBeanDefinition());
                customXmlForBasicAuthPattern = customXmlForBasicAuthPattern + "<custom-filter before=\"BASIC_AUTH_FILTER\" ref=\"sas.svcs.basicAuthSessionTimeoutFilter\" />";
            }
        }
        ArrayList<String> httpElements = new ArrayList<String>(2);
        if (null != basicAuthPattern) {
            pattern = "pattern=\"" + basicAuthPattern + "\" ";
            matcherRef = basicAuth.getAttribute("request-matcher-ref");
            if (StringUtils.hasText((String)matcherRef)) {
                pattern = pattern + "request-matcher-ref=\"" + matcherRef + "\" ";
            } else {
                matcherType = basicAuth.getAttribute("request-matcher");
                if (StringUtils.hasText((String)matcherType)) {
                    pattern = pattern + "request-matcher=\"" + matcherType + "\" ";
                }
            }
            httpElements.add(HttpBeanDefinitionParser.buildHttpXml(pattern, INTERACTIVE_SWITCHING_ENTRY_POINT_ID, securityContextRepositoryRef, interceptUrls.toString(), customAttributes + customAttrForBasicAuthPattern, customXml + customXmlForBasicAuthPattern + BASIC_AUTH_XML, setinitStr));
        } else {
            customXml = customXml + customXmlForBasicAuthPattern;
            customAttributes = customAttributes + customAttrForBasicAuthPattern;
        }
        if (null != noninteractivePattern) {
            pattern = "pattern=\"" + noninteractivePattern + "\" ";
            matcherRef = noninteractive.getAttribute("request-matcher-ref");
            if (StringUtils.hasText((String)matcherRef)) {
                pattern = pattern + "request-matcher-ref=\"" + matcherRef + "\" ";
            } else {
                matcherType = noninteractive.getAttribute("request-matcher");
                if (StringUtils.hasText((String)matcherType)) {
                    pattern = pattern + "request-matcher=\"" + matcherType + "\" ";
                }
            }
            httpElements.add(HttpBeanDefinitionParser.buildHttpXml(pattern, INTERACTIVE_DELEGATING_ENTRY_POINT_ID, securityContextRepositoryRef, interceptUrls.toString(), customAttributes, customXml, setinitStr));
        }
        httpElements.add(HttpBeanDefinitionParser.buildHttpXml("", entryPointId, securityContextRepositoryRef, interceptUrls.toString(), customAttributes, customXml + basicAuthSpringXml, setinitStr));
        BeanDefinitionBuilder csrfFilter = BeanDefinitionBuilder.rootBeanDefinition(CsrfFilter.class);
        csrfFilter.addConstructorArgReference(CSRF_TOKEN_REP_SESSION_ID);
        registry.registerBeanDefinition(CSRF_FILTER_ID, (BeanDefinition)csrfFilter.getBeanDefinition());
        BeanDefinitionBuilder httpSessionCsrfTokenRepository = BeanDefinitionBuilder.rootBeanDefinition(HttpSessionCsrfTokenRepository.class);
        registry.registerBeanDefinition(CSRF_TOKEN_REP_SESSION_ID, (BeanDefinition)httpSessionCsrfTokenRepository.getBeanDefinition());
        BeanDefinitionBuilder csrfHeaderFilterBean = BeanDefinitionBuilder.rootBeanDefinition(CsrfRefererCheckerFilter.class);
        registry.registerBeanDefinition(CSRF_HEADER_CHECKER_FILTER_ID, (BeanDefinition)csrfHeaderFilterBean.getBeanDefinition());
        BeanDefinitionBuilder csrfTokenResponseHeaderBindingFilter = BeanDefinitionBuilder.rootBeanDefinition(CsrfTokenResponseHeaderBindingFilter.class);
        registry.registerBeanDefinition(CSRF_TOKEN_RESPONSE_HEADER_BINDING_FILTER, (BeanDefinition)csrfTokenResponseHeaderBindingFilter.getBeanDefinition());
        BeanDefinitionBuilder csrfRequestMatchers = BeanDefinitionBuilder.rootBeanDefinition(CsrfRequestMatchers.class);
        registry.registerBeanDefinition(CSRF_REQUEST_MATCHERS, (BeanDefinition)csrfRequestMatchers.getBeanDefinition());
        BeanDefinitionBuilder httpSessionRequestCache = BeanDefinitionBuilder.rootBeanDefinition(HttpSessionRequestCache.class);
        registry.registerBeanDefinition("httpSessionRequestCacheSupportPost", (BeanDefinition)httpSessionRequestCache.getBeanDefinition());
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        for (String httpXml : httpElements) {
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document httpDocument = db.parse(new ByteArrayInputStream(httpXml.getBytes()));
                Element httpElement = httpDocument.getDocumentElement();
                this.securityParser.parse(httpElement, context);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to parse...", e);
            }
        }
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document authDocument = db.parse(new ByteArrayInputStream(authManagerXml.getBytes()));
            Element authElement = authDocument.getDocumentElement();
            this.authManagerParser.parse(authElement, context);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to parse...", e);
        }
        return null;
    }

    private static String buildHttpXml(String pattern, String entryPointId, String securityContextRepositoryRef, String interceptUrls, String customAttributes, String customXml, String setinitStr) {
        String requestMethod = System.getProperty("sas.springsecurity.requestcache.supportedmethod");
        String result = "<http " + pattern + "entry-point-ref=\"" + entryPointId + "\" " + securityContextRepositoryRef + customAttributes + " use-expressions=\"true\"> " + interceptUrls + "<custom-filter position=\"CAS_FILTER\" ref=\"" + DEFAULT_FILTER_ID + "\" /> <custom-filter ref=\"" + DEFAULT_LOGOUT_FILTER_ID + "\" before=\"LOGOUT_FILTER\"/><custom-filter ref=\"" + DEFAULT_SINGLE_SIGNOUT_FILTER_ID + "\" before=\"CAS_FILTER\"/> <custom-filter ref=\"" + CSRF_HEADER_CHECKER_FILTER_ID + "\" before=\"SECURITY_CONTEXT_FILTER\"/> <custom-filter ref=\"" + DEFAULT_SESSION_IDENTIFIER_FILTER_ID + "\" after=\"CAS_FILTER\" /><custom-filter ref=\"" + TGT_KEEP_ALIVE_FILTER + "\" after=\"EXCEPTION_TRANSLATION_FILTER\" /><custom-filter ref=\"" + CSRF_TOKEN_RESPONSE_HEADER_BINDING_FILTER + "\" after=\"CSRF_FILTER\" />" + setinitStr + "<custom-filter position=\"FIRST\" ref=\"" + APPLICATION_NAME_FILTER_ID + "\" />" + customXml + "<csrf request-matcher-ref=\"" + CSRF_REQUEST_MATCHERS + "\"/><csrf disabled=\"false\"/>";
        if (null != requestMethod && requestMethod.equalsIgnoreCase("any")) {
            result = result + "<request-cache ref=\"httpSessionRequestCacheSupportPost\"/>";
        }
        result = result + "</http>";
        if (logger.isDebugEnabled()) {
            logger.debug("Creating Spring Security XML:\n\t" + result);
        }
        return result;
    }

    private static boolean isGemfireAvailable(ParserContext context) {
        return context.getReaderContext().getReader().getEnvironment().acceptsProfiles(new String[]{"locators"});
    }

    private static String getAccessDeniedHandlerXml(Element parent) {
        Element accessDeniedHandlerEl = DomUtils.getChildElementByTagName((Element)parent, (String)"access-denied-handler");
        if (null != accessDeniedHandlerEl) {
            String xml = "<access-denied-handler ";
            String ref = accessDeniedHandlerEl.getAttribute("ref");
            String page = accessDeniedHandlerEl.getAttribute("error-page");
            if (StringUtils.hasText((String)ref)) {
                xml = xml + "ref=\"" + ref + "\"";
            } else if (StringUtils.hasText((String)page)) {
                xml = xml + "error-page=\"" + page + "\"";
            } else {
                logger.warn("No error-page or ref attribute found for access-denied-handler");
                return "";
            }
            xml = xml + " />";
            return xml;
        }
        return "";
    }

    private static boolean isTopLevelWildcardPattern(String pattern) {
        return "/**".equals(pattern);
    }

    private static Element getFirstOfManyChildElementsByTagName(Element parent, String tagName) {
        int childLstL;
        List childLst = DomUtils.getChildElementsByTagName((Element)parent, (String)tagName);
        int n = childLstL = childLst != null ? childLst.size() : 0;
        if (childLstL > 1) {
            logger.warn("ignoring all but the first " + tagName + " element");
        }
        return childLstL > 0 ? (Element)childLst.get(0) : null;
    }

    private String registerProxyAuthenticationFailureHandler(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(PROXY_AUTHENTICATION_FAILURE_HANDLER_ID)) {
            BeanDefinitionBuilder failureHandler = BeanDefinitionBuilder.rootBeanDefinition(AuthenticationFailureHandler.class);
            registry.registerBeanDefinition(PROXY_AUTHENTICATION_FAILURE_HANDLER_ID, (BeanDefinition)failureHandler.getBeanDefinition());
        }
        return PROXY_AUTHENTICATION_FAILURE_HANDLER_ID;
    }
}

