/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.session.jasig;

import com.sas.svcs.security.authentication.session.jasig.SingleSignOutHandler;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.filter.OncePerRequestFilter;

public final class SingleSignOutFilter
extends OncePerRequestFilter {
    private static Logger log = LogManager.getLogger(SingleSignOutFilter.class);
    private SingleSignOutHandler handler;

    public void setHandler(SingleSignOutHandler handler) {
        this.handler = handler;
    }

    public SingleSignOutHandler getHandler() {
        return this.handler;
    }

    protected void doFilterInternal(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        HttpServletRequest request = servletRequest;
        if (this.handler.isLogoutRequest(request)) {
            if (log.isDebugEnabled()) {
                log.debug("Logout Request: " + request.getRequestURI());
            }
            this.handler.destroySession(request);
            return;
        }
        if (this.handler.isTokenRequest(request)) {
            HttpSession session = request.getSession(true);
            if (log.isDebugEnabled()) {
                log.debug("Token Request: " + request.getRequestURI() + ", sessionId=" + session.getId());
            }
            this.handler.recordSession(request);
        } else if (log.isDebugEnabled()) {
            log.debug("Ignoring URI " + request.getRequestURI());
        }
        filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
    }
}

