/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.session;

import com.sas.svcs.commons.util.EventingMap;
import com.sas.svcs.commons.util.EventingMapEvent;
import com.sas.svcs.commons.util.EventingMapListener;
import com.sas.svcs.commons.util.EventingMapListenerAdapter;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apereo.cas.client.session.SessionMappingStorage;
import org.apereo.cas.client.session.SingleSignOutHttpSessionListener;
import org.springframework.web.context.ServletContextAware;

public class DistributedSessionMappingStorage
implements SessionMappingStorage,
ServletContextAware {
    private static Logger log = LogManager.getLogger(DistributedSessionMappingStorage.class);
    Map<String, HttpSession> localMap = new ConcurrentHashMap<String, HttpSession>();
    Map<String, Set<String>> sessionIdLocalMap = new ConcurrentHashMap<String, Set<String>>();
    EventingMap<Object, Object> distributedMap;

    @Resource(name="sas.svcs.serviceTicketMap")
    public void setDistributedMap(EventingMap<Object, Object> distributedMap) {
        this.distributedMap = distributedMap;
        this.distributedMap.addListener((EventingMapListener)new MapListener());
    }

    public HttpSession removeSessionByMappingId(String mappingId) {
        String sessionId = (String)this.distributedMap.remove((Object)mappingId);
        if (log.isDebugEnabled()) {
            log.debug("removeSessionByMappingId: mappingId=" + mappingId + ", sessionId=" + sessionId);
        }
        HttpSession session = this.localMap.get(mappingId);
        if (null != sessionId) {
            this.removeBySessionById(sessionId);
        }
        return session;
    }

    public void removeBySessionById(String sessionId) {
        if (log.isDebugEnabled()) {
            log.debug("removeBySessionId: sessionId=" + sessionId);
        }
        Set<String> mappingIds = this.sessionIdLocalMap.remove(sessionId);
        if (log.isDebugEnabled()) {
            log.debug("mappingIds=" + mappingIds);
        }
        if (mappingIds != null) {
            for (String mappingId : mappingIds) {
                if (null == mappingId) continue;
                this.distributedMap.remove((Object)mappingId);
                this.localMap.remove(mappingId);
            }
        }
    }

    public void addSessionById(String mappingId, HttpSession session) {
        if (log.isDebugEnabled()) {
            log.debug("addSessionById: mappingId=" + mappingId + ", sessionId=" + session.getId());
        }
        if (this.localMap.containsKey(mappingId)) {
            if (log.isDebugEnabled()) {
                log.debug("localMap contains mappingId, returning.");
            }
            return;
        }
        this.localMap.put(mappingId, session);
        Set<String> mappingIds = this.sessionIdLocalMap.get(session.getId());
        if (null == mappingIds) {
            mappingIds = Collections.newSetFromMap(new ConcurrentHashMap());
            this.sessionIdLocalMap.put(session.getId(), mappingIds);
        }
        mappingIds.add(mappingId);
        this.distributedMap.put((Object)mappingId, (Object)session.getId());
    }

    public void setServletContext(ServletContext servletContext) {
        servletContext.addListener(SingleSignOutHttpSessionListener.class);
    }

    private class MapListener
    extends EventingMapListenerAdapter<Object, Object> {
        private MapListener() {
        }

        public void entryRemoved(EventingMapEvent<Object, Object> event) {
            String mappingId = (String)event.getKey();
            String sessionId = (String)event.getValue();
            if (log.isDebugEnabled()) {
                log.debug("entryRemoved: mappingId=" + mappingId + ", sessionId=" + sessionId);
            }
            HttpSession session = DistributedSessionMappingStorage.this.localMap.get(mappingId);
            if (sessionId != null) {
                DistributedSessionMappingStorage.this.removeBySessionById(sessionId);
            }
            if (session != null) {
                if (session.getId().equals(sessionId)) {
                    try {
                        log.debug("Invalidating HTTPSession");
                        session.invalidate();
                    }
                    catch (IllegalStateException e) {
                        log.debug("Error invalidating session.", (Throwable)e);
                    }
                } else {
                    log.debug("mappingId " + mappingId + " is now associated to new sessionId: " + session.getId());
                }
            }
        }
    }
}

