/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.resolver;

import com.sas.svcs.security.authentication.resolver.ServiceResolver;
import jakarta.servlet.ServletContext;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;

public class PublishedServiceResolver
implements ServiceResolver,
InitializingBean,
ServletContextAware {
    private static final Logger logger = LogManager.getLogger(PublishedServiceResolver.class);
    private String host;
    private Integer port;
    private String protocol;
    private String contextPath;

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public String getService(String suffix, boolean createExternalUrl) {
        URL url;
        if (null == suffix) {
            suffix = "/";
        } else if (!suffix.startsWith("/")) {
            suffix = "/" + suffix;
        }
        try {
            url = new URL(this.protocol, this.host, this.port, this.contextPath + suffix);
        }
        catch (MalformedURLException e) {
            logger.error("Error creating URL with protocol: '" + this.protocol + "', host: '" + this.host + "', port: '" + this.port + ", applicationName: '" + this.contextPath + "', suffix: '" + suffix + "'");
            throw new RuntimeException("Error creating service url", e);
        }
        return url.toString();
    }

    public void afterPropertiesSet() throws Exception {
        String strPort;
        InetAddress address;
        if (!StringUtils.hasText((String)this.host)) {
            this.host = System.getProperty("sas.auto.publish.host");
        }
        if (!StringUtils.hasText((String)this.host)) {
            logger.debug("Host value was not found. Using the local IP address. If you want a specific value, set the localIpAddress property or use the sas.auto.publish.host system property");
            this.host = InetAddress.getLocalHost().getHostAddress();
        }
        if ((address = InetAddress.getByName(this.host)) instanceof Inet6Address && this.host.indexOf(58) >= 0) {
            if (!this.host.startsWith("[")) {
                this.host = "[" + this.host;
            }
            if (!this.host.endsWith("]")) {
                this.host = this.host + "]";
            }
        }
        if (null == this.port && null != (strPort = System.getProperty("sas.auto.publish.port"))) {
            this.port = Integer.parseInt(strPort);
        }
        if (null == this.port) {
            throw new IllegalStateException("No port available. Please explicitly set the port property or use the sas.auto.publish.port system property setting.");
        }
        if (!StringUtils.hasText((String)this.protocol)) {
            this.protocol = System.getProperty("sas.auto.publish.protocol");
        }
        if (!StringUtils.hasText((String)this.protocol)) {
            logger.debug("Protocol value was not found; using 'http' default. If you want a specific value, set the localProtocol property or use the sas.auto.publish.protocol system property.");
            this.protocol = "http";
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.contextPath = servletContext.getContextPath();
    }
}

