/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication;

import com.sas.svcs.config.client.UrlGeneratorInterface;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.util.UriComponentsBuilder;

public class DevelopmentUtility {
    private static final Logger logger = LogManager.getLogger(DevelopmentUtility.class);

    private DevelopmentUtility() {
    }

    public static String getServiceUrl(UrlGeneratorInterface urlGenerator, String applicationName, String path) {
        return DevelopmentUtility.getExternalServiceUrl(urlGenerator, applicationName, path);
    }

    public static String getExternalServiceUrl(UrlGeneratorInterface urlGenerator, String applicationName, String path) {
        String service = urlGenerator.generateExternalUrl(applicationName, path, "");
        return DevelopmentUtility.getServiceUrl(service);
    }

    public static String getInternalServiceUrl(UrlGeneratorInterface urlGenerator, String applicationName, String path) {
        String service = urlGenerator.generateInternalUrl(applicationName, path, "");
        return DevelopmentUtility.getServiceUrl(service);
    }

    private static String getServiceUrl(String service) {
        return System.getProperty("sas.development.mode") != null ? DevelopmentUtility.getDevelopmentServiceUrl(service) : service;
    }

    private static String getDevelopmentServiceUrl(String service) {
        try {
            URL serviceUrl = URI.create(service).toURL();
            String localHostName = System.getProperty("sas.development.service.url", InetAddress.getLocalHost().getCanonicalHostName());
            int port = Integer.parseInt(System.getProperty("sas.auto.publish.port", "8080"));
            return UriComponentsBuilder.newInstance().scheme(serviceUrl.getProtocol()).host(localHostName).port(port).path(serviceUrl.getPath()).query(serviceUrl.getQuery()).build().toUriString();
        }
        catch (MalformedURLException | UnknownHostException e) {
            logger.warn("Unable to process development mode URL, falling back to default application information...", (Throwable)e);
            return service;
        }
    }
}

