/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.profilingxml.common.csv;

import MITI.MIRException;
import MITI.bridges.profilingxml.common.csv.CsvGenerator;
import MITI.bridges.profilingxml.common.csv.EntityGenerator;
import MITI.bridges.profilingxml.common.csv.LineageLinkGenerator;
import MITI.bridges.profilingxml.common.csv.ModelInfoGenerator;
import MITI.bridges.profilingxml.common.csv.ProfileLinkGenerator;
import MITI.bridges.profilingxml.common.csv.ProfiledCsvFileWriter;
import MITI.bridges.profilingxml.common.csv.ReferenceLinkGenerator;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRModel;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.Profiler;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;

public class ProfiledCsvFileManager {
    private static final String MODEL_INFO = "ModelInfo";
    private static final String PROFILE_LINKS = "ProfileLinks";
    private static final String REFERENCE_LINKS = "ReferenceLinks";
    private static final String LINEAGE_LINKS = "LineageLinks";
    private static final String SUMMARY_LINEAGE_LINKS = "LineageSummaryLinks";
    private static final int MAX_FILE_WRITERS = 50;
    private File outputDir;
    private LinkedList<ProfiledCsvFileWriter> writers = new LinkedList();

    public ProfiledCsvFileManager(File file) {
        this.outputDir = file;
    }

    public ProfiledCsvFileWriter getModelInfoWriter(Profiler profiler) throws MIRException {
        int n = -1;
        String string = MODEL_INFO;
        ProfiledCsvFileWriter profiledCsvFileWriter = this.lookupWriter(n, string);
        if (profiledCsvFileWriter == null) {
            ModelInfoGenerator modelInfoGenerator = new ModelInfoGenerator(profiler);
            profiledCsvFileWriter = this.createWriter(n, string, modelInfoGenerator);
        }
        return profiledCsvFileWriter;
    }

    public ProfiledCsvFileWriter getEntityWriter(Profiler profiler, int n, MIRProfileEntity mIRProfileEntity, MIRModel mIRModel) throws MIRException {
        String string = mIRProfileEntity.getName();
        ProfiledCsvFileWriter profiledCsvFileWriter = this.lookupWriter(n, string);
        if (profiledCsvFileWriter == null) {
            EntityGenerator entityGenerator = new EntityGenerator(profiler, mIRProfileEntity, mIRModel);
            profiledCsvFileWriter = this.createWriter(n, string, entityGenerator);
        }
        return profiledCsvFileWriter;
    }

    public ProfiledCsvFileWriter getReferenceLinkWriter(int n, String string) throws MIRException {
        String string2 = "ReferenceLinks_" + string;
        ProfiledCsvFileWriter profiledCsvFileWriter = this.lookupWriter(n, string2);
        if (profiledCsvFileWriter == null) {
            ReferenceLinkGenerator referenceLinkGenerator = new ReferenceLinkGenerator();
            profiledCsvFileWriter = this.createWriter(n, string2, referenceLinkGenerator);
        }
        return profiledCsvFileWriter;
    }

    public ProfiledCsvFileWriter getLineageLinkWriter(int n, boolean bl) throws MIRException {
        String string = bl ? SUMMARY_LINEAGE_LINKS : LINEAGE_LINKS;
        ProfiledCsvFileWriter profiledCsvFileWriter = this.lookupWriter(n, string);
        if (profiledCsvFileWriter == null) {
            LineageLinkGenerator lineageLinkGenerator = new LineageLinkGenerator(bl);
            profiledCsvFileWriter = this.createWriter(n, string, lineageLinkGenerator);
        }
        return profiledCsvFileWriter;
    }

    private ProfiledCsvFileWriter lookupWriter(int n, String string) {
        ProfiledCsvFileWriter profiledCsvFileWriter = null;
        for (ProfiledCsvFileWriter profiledCsvFileWriter2 : this.writers) {
            if (!profiledCsvFileWriter2.matches(n, string)) continue;
            profiledCsvFileWriter = profiledCsvFileWriter2;
            break;
        }
        return profiledCsvFileWriter;
    }

    private void insertWriter(ProfiledCsvFileWriter profiledCsvFileWriter) {
        if (this.writers.contains(profiledCsvFileWriter)) {
            this.writers.remove(profiledCsvFileWriter);
        }
        this.writers.addFirst(profiledCsvFileWriter);
        if (this.writers.size() > 50) {
            ProfiledCsvFileWriter profiledCsvFileWriter2 = this.writers.removeLast();
            this.close(profiledCsvFileWriter2);
        }
    }

    private ProfiledCsvFileWriter createWriter(int n, String string, CsvGenerator<?> csvGenerator) throws MIRException {
        ProfiledCsvFileWriter profiledCsvFileWriter;
        File file = null;
        file = n == -1 ? this.outputDir : new File(this.outputDir, String.valueOf(n));
        file.mkdirs();
        File file2 = new File(file, string + ".csv");
        boolean bl = file2.exists();
        try {
            profiledCsvFileWriter = new ProfiledCsvFileWriter(file2, n, string);
            profiledCsvFileWriter.setGenerator(csvGenerator);
            this.insertWriter(profiledCsvFileWriter);
            if (!bl) {
                Collection<String> collection = csvGenerator.generateHeader();
                profiledCsvFileWriter.setColumnCount(collection.size());
                profiledCsvFileWriter.printLine(collection);
            }
        }
        catch (IOException iOException) {
            throw new MIRException(iOException.getMessage(), iOException);
        }
        return profiledCsvFileWriter;
    }

    public void close(ProfiledCsvFileWriter profiledCsvFileWriter) {
        try {
            profiledCsvFileWriter.close();
        }
        catch (IOException iOException) {
            BLIB.DBG_DEBUG.log(iOException, "Error closing writer '" + profiledCsvFileWriter.toString() + "'");
        }
    }

    public void close() {
        for (ProfiledCsvFileWriter profiledCsvFileWriter : this.writers) {
            this.close(profiledCsvFileWriter);
        }
        this.writers.clear();
    }

    public ProfiledCsvFileWriter getProfileLinkWriter() throws MIRException {
        String string = PROFILE_LINKS;
        ProfiledCsvFileWriter profiledCsvFileWriter = this.lookupWriter(-1, string);
        if (profiledCsvFileWriter == null) {
            ProfileLinkGenerator profileLinkGenerator = new ProfileLinkGenerator();
            profiledCsvFileWriter = this.createWriter(-1, string, profileLinkGenerator);
        }
        return profiledCsvFileWriter;
    }
}

