/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.profilingxml.common.csv;

import MITI.MIRException;
import MITI.bridges.profilingxml.common.csv.CsvGenerator;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRStoreType;
import MITI.sdk.profiles.AggregationProfileLink;
import MITI.sdk.profiles.MIRProfile;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.Profiler;
import java.util.ArrayList;
import java.util.Collection;

public class ModelInfoGenerator
implements CsvGenerator<AggregationProfileLink> {
    private static final String MODEL_ID = "ModelId";
    private static final String PROFILE_ID = "ProfileId";
    private static final String CHECKSUM = "Checksum";
    private static final String IS_CONNECTION = "IsConnection";
    private static final String STORE_TYPE = "StoreType";
    private static final String SYSTEM_TYPE = "SystemType";
    private Profiler profiler;

    public ModelInfoGenerator(Profiler profiler) {
        this.profiler = profiler;
    }

    @Override
    public Collection<String> generateHeader() throws MIRException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(MODEL_ID);
        arrayList.add(PROFILE_ID);
        arrayList.add(CHECKSUM);
        arrayList.add(IS_CONNECTION);
        arrayList.add(STORE_TYPE);
        arrayList.add(SYSTEM_TYPE);
        return arrayList;
    }

    @Override
    public String[] generateData(AggregationProfileLink aggregationProfileLink) throws MIRException {
        MIRObject mIRObject;
        ProfiledObject profiledObject = aggregationProfileLink.getSourceNode();
        ProfiledObject profiledObject2 = aggregationProfileLink.getDestinationNode();
        MIRProfileEntity mIRProfileEntity = this.profiler.getProfileEntity(profiledObject2);
        MIRProfile mIRProfile = mIRProfileEntity.getProfile();
        MIRModel mIRModel = (MIRModel)this.profiler.getMIRObject(profiledObject2.getObjectDefinition());
        boolean bl = false;
        MIRObject mIRObject2 = mIRObject = profiledObject != null ? this.profiler.getMIRObject(profiledObject.getObjectDefinition()) : null;
        if (mIRObject instanceof MIRStoreContent && ((MIRStoreContent)mIRObject).getConnectionOfDirectoryStructureModel() != null) {
            bl = true;
        }
        String string = "";
        String string2 = "";
        if (mIRModel instanceof MIRStoreModel) {
            string = MIRStoreType.toCppString(((MIRStoreModel)mIRModel).getStoreType());
        }
        if (mIRModel != null) {
            string2 = mIRModel.getSystemType();
        }
        String[] stringArray = new String[]{String.valueOf(profiledObject2.getObjectDefinition().getModelId()), String.valueOf(mIRProfile.getProfileId()), this.profiler.getChecksum(profiledObject2), Boolean.toString(bl), string, string2};
        return stringArray;
    }
}

