/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.profilingxml.common.csv;

import MITI.MIRException;
import MITI.bridges.profilingxml.common.csv.CsvGenerator;
import MITI.sdk.profiles.LineageProfileLink;
import MITI.sdk.profiles.ProfileLink;
import MITI.sdk.profiles.ProfiledObject;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class LineageLinkGenerator
implements CsvGenerator<LineageProfileLink> {
    private static final String SRC_MODEL_ID = "SourceModelId";
    private static final String SRC_OBJECT_ID = "SourceObjectId";
    private static final String DST_MODEL_ID = "DestinationModelId";
    private static final String DST_OBJECT_ID = "DestinationObjectId";
    private static final String TYPE = "Type";
    private static final String TR_OBJECT_ID = "QueryId";
    private boolean forSummary;
    private Map<String, Integer> header = new LinkedHashMap<String, Integer>();

    public LineageLinkGenerator(boolean bl) {
        this.forSummary = bl;
        this.addHeader(SRC_MODEL_ID);
        this.addHeader(SRC_OBJECT_ID);
        this.addHeader(DST_MODEL_ID);
        this.addHeader(DST_OBJECT_ID);
        this.addHeader(TYPE);
        if (!bl) {
            this.addHeader(TR_OBJECT_ID);
        }
    }

    private void addHeader(String string) {
        this.header.putIfAbsent(string, this.header.size());
    }

    private void addData(String[] stringArray, String string, String string2) {
        Integer n = this.header.get(string);
        if (n != null) {
            stringArray[n.intValue()] = string2;
        }
    }

    @Override
    public Collection<String> generateHeader() throws MIRException {
        return this.header.keySet();
    }

    @Override
    public String[] generateData(LineageProfileLink lineageProfileLink) {
        ProfiledObject profiledObject = lineageProfileLink.getSourceNode();
        ProfiledObject profiledObject2 = lineageProfileLink.getDestinationNode();
        ProfiledObject profiledObject3 = lineageProfileLink.getTransformation();
        String[] stringArray = new String[this.forSummary ? 5 : 6];
        this.addObjectData(stringArray, profiledObject, SRC_MODEL_ID, SRC_OBJECT_ID);
        this.addObjectData(stringArray, profiledObject2, DST_MODEL_ID, DST_OBJECT_ID);
        this.addData(stringArray, TYPE, this.getShortType(lineageProfileLink.getLinkType()));
        if (!this.forSummary) {
            this.addData(stringArray, TR_OBJECT_ID, profiledObject3 != null ? String.valueOf(profiledObject3.getObjectDefinition().getObjectId()) : "");
        }
        return stringArray;
    }

    private String getShortType(ProfileLink.LINK_TYPE lINK_TYPE) {
        String string;
        switch (lINK_TYPE) {
            case DATA_LINEAGE: 
            case SUMMARY_LINEAGE: {
                string = "d";
                break;
            }
            case CONTROL_LINEAGE: 
            case SUMMARY_CONTROL_LINEAGE: {
                string = "c";
                break;
            }
            case STITCHING: {
                string = "s";
                break;
            }
            case SEMANTIC_LINK: {
                string = "e";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    private void addObjectData(String[] stringArray, ProfiledObject profiledObject, String string, String string2) {
        this.addData(stringArray, string, profiledObject != null ? String.valueOf(profiledObject.getObjectDefinition().getModelId()) : "");
        this.addData(stringArray, string2, profiledObject != null ? String.valueOf(profiledObject.getObjectDefinition().getObjectId()) : "");
    }
}

