/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.profilingxml.common.csv;

import MITI.MIRException;
import MITI.bridges.profilingxml.common.csv.CsvProfileLink;
import MITI.bridges.profilingxml.common.csv.ProfileLinkGenerator;
import MITI.bridges.profilingxml.common.csv.ProfiledCsvFileWriter;
import MITI.sdk.profiles.MIRProfile;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.MIRProfileGroup;
import MITI.sdk.profiles.MIRProfileLink;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CsvProfileLinks {
    private static final Set<Integer> profileCache = new HashSet<Integer>();
    private static final Map<String, Integer> linksCache = new HashMap<String, Integer>();
    private static int counter = 1;

    public void printProfileLinks(MIRProfile mIRProfile, ProfiledCsvFileWriter profiledCsvFileWriter) throws MIRException {
        int n = mIRProfile.getProfileId();
        if (!profileCache.contains(n)) {
            profileCache.add(n);
            MIRProfileEntity[] mIRProfileEntityArray = mIRProfile.getProfileEntities();
            if (mIRProfileEntityArray != null) {
                for (MIRProfileEntity mIRProfileEntity : mIRProfileEntityArray) {
                    this.printProfileLinks(mIRProfileEntity, profiledCsvFileWriter);
                }
            }
        }
    }

    private void printProfileLinks(MIRProfileEntity mIRProfileEntity, ProfiledCsvFileWriter profiledCsvFileWriter) throws MIRException {
        Object[] objectArray;
        MIRProfileGroup[] mIRProfileGroupArray = mIRProfileEntity.getProfileGroups();
        if (mIRProfileGroupArray != null) {
            objectArray = mIRProfileGroupArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                MIRProfileLink[] object2 = ((MIRProfileGroup)object).getProfileLinks();
                if (object2 == null) continue;
                for (MIRProfileLink mIRProfileLink : object2) {
                    this.printProfileLink(mIRProfileLink, profiledCsvFileWriter);
                }
            }
        }
        if ((objectArray = mIRProfileEntity.getProfileLinks()) != null) {
            for (Object object : objectArray) {
                this.printProfileLink((MIRProfileLink)object, profiledCsvFileWriter);
            }
        }
    }

    private void printProfileLink(MIRProfileLink mIRProfileLink, ProfiledCsvFileWriter profiledCsvFileWriter) throws MIRException {
        CsvProfileLink csvProfileLink = new CsvProfileLink(mIRProfileLink);
        List<String> list = csvProfileLink.getData();
        String string = list.toString();
        int n = counter++;
        linksCache.put(string, n);
        ProfileLinkGenerator profileLinkGenerator = (ProfileLinkGenerator)profiledCsvFileWriter.getGenerator();
        profileLinkGenerator.setLinkId(n);
        String[] stringArray = profileLinkGenerator.generateData(csvProfileLink);
        try {
            profiledCsvFileWriter.printLine(stringArray);
        }
        catch (IOException iOException) {
            throw new MIRException(iOException.getMessage(), iOException);
        }
    }

    public static Integer get(MIRProfileLink mIRProfileLink) {
        if (mIRProfileLink != null) {
            CsvProfileLink csvProfileLink = new CsvProfileLink(mIRProfileLink);
            List<String> list = csvProfileLink.getData();
            String string = list.toString();
            Integer n = linksCache.get(string);
            return n;
        }
        return null;
    }
}

