/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.profilingxml.common;

import MITI.MIRException;
import MITI.sdk.profiles.ProfileLink;
import MITI.sdk.profiles.ProfileLinkProcessor;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.Profiler;
import MITI.server.services.common.mir.ProfiledObjectDefinition;

public class BrowseResultProcessor
implements ProfileLinkProcessor {
    private Profiler profiler;
    private ProfiledObject rootObj;
    private int rootModelId;

    public BrowseResultProcessor(Profiler profiler, ProfiledObject profiledObject) {
        this.profiler = profiler;
        this.rootObj = profiledObject;
        this.rootModelId = profiledObject.getObjectDefinition().getModelId();
    }

    @Override
    public void process(ProfileLink profileLink) throws MIRException {
        ProfiledObject profiledObject = profileLink.getSourceNode();
        ProfiledObject profiledObject2 = profileLink.getDestinationNode();
        if (profileLink.getLinkType() == ProfileLink.LINK_TYPE.AGGREGATION && profiledObject != null && profiledObject2 != null && profiledObject.getObjectDefinition().getModelId() == this.rootModelId && profiledObject2.getObjectDefinition().getModelId() == this.rootModelId) {
            ProfiledObject[] profiledObjectArray = this.profiler.getObjectPath(profiledObject2, this.rootObj);
            this.processBrowseResult(profiledObject2, profiledObjectArray);
        }
    }

    public void processBrowseResult(ProfiledObject profiledObject, ProfiledObject[] profiledObjectArray) throws MIRException {
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject.getObjectDefinition();
        String string = profiledObject.getEntityName();
        String string2 = profiledObjectDefinition.getObjectName();
        String string3 = this.profiler.getNativeId(profiledObject);
        StringBuffer stringBuffer = new StringBuffer();
        if (profiledObjectArray != null) {
            for (ProfiledObject profiledObject2 : profiledObjectArray) {
                ProfiledObjectDefinition profiledObjectDefinition2 = profiledObject2.getObjectDefinition();
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("/");
                }
                stringBuffer.append(profiledObjectDefinition2.serialize());
            }
        }
        System.out.println(string + "," + profiledObjectDefinition.serialize() + ",'" + string2 + "','" + string3 + "'," + stringBuffer.toString());
    }
}

