/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.profilingxml.common;

import MITI.MIRException;
import MITI.bridges.mimb.BridgeLibrary;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.bridges.profiles.BridgeProfileIds;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;

public class BridgeProfiles
extends BridgeProfileIds {
    public static int getRootProfileIDFromBridgeID(String string, boolean bl) {
        Integer n = null;
        if (bl) {
            n = BridgeProfiles.getSummaryProfileId(string);
            if (n == null) {
                n = BridgeProfiles.getRootProfileId(string);
            }
        } else {
            n = BridgeProfiles.getRootProfileId(string);
        }
        if (n == null) {
            throw new IllegalArgumentException("Bridge '" + string + "' has no default profile.");
        }
        return n;
    }

    private static void validate(File file) throws MIRException {
        MIRModelBridges mIRModelBridges = MIRModelBridges.load(file);
        HashSet<String> hashSet = new HashSet<String>();
        Collection<BridgeLibrary> collection = mIRModelBridges.getBridges(false);
        for (BridgeLibrary object : collection) {
            hashSet.add(object.getBridgeId());
        }
        for (String string : hashSet) {
            BridgeProfiles.getRootProfileIDFromBridgeID(string, false);
        }
        for (String string : BridgeProfiles.getDefinedBridges()) {
            if (hashSet.contains(string)) continue;
            throw new MIRException("Bridge identifier '" + string + "' is not current");
        }
    }

    public static void main(String[] stringArray) throws MIRException {
        String string = "";
        if (stringArray.length >= 1) {
            string = stringArray[0];
        }
        File file = new File(string);
        if (string.isEmpty() || !file.isDirectory()) {
            throw new IllegalArgumentException("Specify MIMB Home directory as first argument.");
        }
        BridgeProfiles.validate(file);
        System.out.println("validated successfully.");
    }
}

