/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public final class VersionSpec
implements Comparable,
Serializable {
    private static final long serialVersionUID = 3260743344940754450L;
    public static final VersionSpec ANY = new VersionSpec(0, 0, 0, "", true);
    private static final VersionSpec ZERO = new VersionSpec(0, 0, 0, "", false);
    private final int m_major;
    private final int m_minor;
    private final int m_micro;
    private final String m_qualifier;
    private final byte m_type;
    private static final byte TYPE_BIT_RANGE = 1;
    private static final byte TYPE_BIT_OPEN_RANGE = 2;
    private static final byte TYPE_BIT_INCLUDE_START = 4;
    private static final byte TYPE_BIT_INCLUDE_END = 8;
    private final int m_endMajor;
    private final int m_endMinor;
    private final int m_endMicro;
    private final String m_endQualifier;

    public static VersionSpec parseVersion(String s) {
        if (s == null || s.length() <= 0) {
            return null;
        }
        int[] mmm = new int[3];
        String qual = VersionSpec.parseVersion(s, mmm);
        if (qual == null) {
            return null;
        }
        if (mmm[0] == 0 && mmm[1] == 0 && mmm[2] == 0 && qual.length() <= 0) {
            return ZERO;
        }
        return new VersionSpec(mmm[0], mmm[1], mmm[2], qual, false);
    }

    private static String parseVersion(String string, int[] mmm) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n < 1) {
            return null;
        }
        mmm[0] = 0;
        int ipos = 0;
        int summax = 0xCCCCCCC;
        boolean startOfPiece = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                if (startOfPiece) {
                    return null;
                }
                if (++ipos >= 3) {
                    int j = i + 1;
                    if (j >= n) {
                        return null;
                    }
                    while (j < n) {
                        c = string.charAt(j);
                        if (!(c == '-' || c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9')) {
                            return null;
                        }
                        ++j;
                    }
                    return string.substring(i + 1);
                }
                startOfPiece = true;
                mmm[ipos] = 0;
                continue;
            }
            if (c < '0' || c > '9') {
                return null;
            }
            startOfPiece = false;
            int old = mmm[ipos];
            if (old >= summax) {
                long temp = 10L * (long)old + (long)(c - 48);
                if (temp > Integer.MAX_VALUE) {
                    return null;
                }
                mmm[ipos] = (int)temp;
                continue;
            }
            mmm[ipos] = 10 * old + (c - 48);
        }
        if (startOfPiece) {
            return null;
        }
        while (++ipos < 3) {
            mmm[ipos] = 0;
        }
        return "";
    }

    public static VersionSpec parseRange(String s) {
        boolean includeEnd;
        boolean includeStart;
        if (s == null || s.length() <= 0) {
            return null;
        }
        char c = s.charAt(0);
        if (c >= '0' && c <= '9') {
            int[] mmm = new int[3];
            String qual = VersionSpec.parseVersion(s, mmm);
            if (qual == null) {
                return null;
            }
            if (mmm[0] == 0 && mmm[1] == 0 && mmm[2] == 0 && qual.length() <= 0) {
                return ANY;
            }
            return new VersionSpec(mmm[0], mmm[1], mmm[2], qual, true);
        }
        int nStart = 1;
        int nEnd = s.length();
        if (c == '\"') {
            if (--nEnd < 6 || s.charAt(nEnd) != '\"') {
                return null;
            }
            c = s.charAt(nStart++);
        } else if (nEnd < 5) {
            return null;
        }
        if (c == '[') {
            includeStart = true;
        } else if (c == '(') {
            includeStart = false;
        } else {
            return null;
        }
        c = s.charAt(--nEnd);
        if (c == ']') {
            includeEnd = true;
        } else if (c == ')') {
            includeEnd = false;
        } else {
            return null;
        }
        int comma = s.indexOf(44, nStart);
        if (comma <= nStart || comma >= nEnd) {
            return null;
        }
        int[] mmm = new int[3];
        String qual = VersionSpec.parseVersion(s.substring(nStart, comma), mmm);
        if (qual == null) {
            return null;
        }
        int[] emmm = new int[3];
        String equal = VersionSpec.parseVersion(s.substring(comma + 1, nEnd), emmm);
        if (equal == null) {
            return null;
        }
        int comp = 0;
        for (int i = 0; i < 3; ++i) {
            comp = emmm[i] - mmm[i];
            if (comp < 0) {
                return null;
            }
            if (comp > 0) break;
        }
        if (comp == 0) {
            comp = qual.compareTo(equal);
            if (comp > 0) {
                return null;
            }
            if (comp == 0) {
                if (!includeStart || !includeEnd) {
                    return null;
                }
                if (mmm[0] == 0 && mmm[1] == 0 && mmm[2] == 0 && qual.length() <= 0) {
                    return ZERO;
                }
                return new VersionSpec(mmm[0], mmm[1], mmm[2], qual, false);
            }
        }
        return new VersionSpec(mmm[0], mmm[1], mmm[2], qual, emmm[0], emmm[1], emmm[2], equal, includeStart, includeEnd);
    }

    private static int compareVersions(int aMajor, int aMinor, int aMicro, String aQual, int bMajor, int bMinor, int bMicro, String bQual) {
        int rc = aMajor - bMajor;
        if (rc != 0) {
            return rc;
        }
        rc = aMinor - bMinor;
        if (rc != 0) {
            return rc;
        }
        rc = aMicro - bMicro;
        if (rc != 0) {
            return rc;
        }
        return aQual.compareTo(bQual);
    }

    static int compareVersionStarts(VersionSpec v1, VersionSpec v2) {
        int rc = VersionSpec.compareVersions(v1.m_major, v1.m_minor, v1.m_micro, v1.m_qualifier, v2.m_major, v2.m_minor, v2.m_micro, v2.m_qualifier);
        if (rc != 0) {
            return rc;
        }
        boolean s1 = v1.isIncludeStart();
        if (s1 == v2.isIncludeStart()) {
            return 0;
        }
        return s1 ? -1 : 1;
    }

    private static int compareVersionEnds(VersionSpec v1, VersionSpec v2) {
        boolean b = v2.isOpenEnded();
        if (v1.isOpenEnded()) {
            return b ? 0 : 1;
        }
        if (b) {
            return -1;
        }
        int rc = VersionSpec.compareVersions(v1.m_endMajor, v1.m_endMinor, v1.m_endMicro, v1.m_endQualifier, v2.m_endMajor, v2.m_endMinor, v2.m_endMicro, v2.m_endQualifier);
        if (rc != 0) {
            return rc;
        }
        boolean s1 = v1.isIncludeEnd();
        if (s1 == v2.isIncludeEnd()) {
            return 0;
        }
        return s1 ? 1 : -1;
    }

    static VersionSpec readFrom(DataInput s) throws IOException {
        byte rangeBits;
        byte type = s.readByte();
        int major = s.readInt();
        if (major < 0) {
            throw VersionSpec.illegalNegIO("major", major);
        }
        int minor = s.readInt();
        if (minor < 0) {
            throw VersionSpec.illegalNegIO("minor", minor);
        }
        int micro = s.readInt();
        if (micro < 0) {
            throw VersionSpec.illegalNegIO("micro", micro);
        }
        String qual = s.readUTF();
        if (qual.length() <= 0) {
            qual = "";
        }
        if ((rangeBits = (byte)(type & 3)) != 1) {
            return new VersionSpec(major, minor, micro, qual, rangeBits != 0);
        }
        int endMajor = s.readInt();
        if (endMajor < 0) {
            throw VersionSpec.illegalNegIO("endMajor", endMajor);
        }
        int endMinor = s.readInt();
        if (endMinor < 0) {
            throw VersionSpec.illegalNegIO("endMinor", endMinor);
        }
        int endMicro = s.readInt();
        if (endMicro < 0) {
            throw VersionSpec.illegalNegIO("endMicro", endMicro);
        }
        String endQual = s.readUTF();
        if (endQual.length() <= 0) {
            endQual = "";
        }
        return new VersionSpec(major, minor, micro, qual, endMajor, endMinor, endMicro, endQual, (type & 4) != 0, (type & 8) != 0);
    }

    private static IOException illegalNegIO(String varName, int value) {
        if (value >= 0) {
            throw Util.illegalArgument("value", new Integer(value));
        }
        IllegalArgumentException iarg = Util.illegalNegative(varName, value);
        IOException rc = new IOException(iarg.getMessage());
        rc.initCause(iarg);
        return rc;
    }

    private VersionSpec(int major, int minor, int micro, String qual, boolean openEndedRange) {
        if (qual == null) {
            qual = "";
        }
        this.m_major = major;
        this.m_minor = minor;
        this.m_micro = micro;
        this.m_qualifier = qual;
        this.m_endMajor = major;
        this.m_endMinor = minor;
        this.m_endMicro = micro;
        this.m_endQualifier = qual;
        this.m_type = (byte)(openEndedRange ? 15 : 12);
    }

    private VersionSpec(int major, int minor, int micro, String qual, int endMajor, int endMinor, int endMicro, String endQual, boolean includeStart, boolean includeEnd) {
        this.m_major = major;
        this.m_minor = minor;
        this.m_micro = micro;
        this.m_qualifier = qual == null ? "" : qual;
        this.m_endMajor = endMajor;
        this.m_endMinor = endMinor;
        this.m_endMicro = endMicro;
        this.m_endQualifier = endQual == null ? "" : endQual;
        int type = 1;
        if (includeStart) {
            type = (byte)(type | 4);
        }
        if (includeEnd) {
            type = (byte)(type | 8);
        }
        this.m_type = (byte)type;
    }

    public boolean isRange() {
        return (this.m_type & 1) != 0;
    }

    public boolean isOpenEnded() {
        int i = 3;
        return (this.m_type & 3) == 3;
    }

    public int getMajor() {
        return this.m_major;
    }

    public int getMinor() {
        return this.m_minor;
    }

    public int getMicro() {
        return this.m_micro;
    }

    public String getQualifier() {
        return this.m_qualifier;
    }

    public boolean isIncludeStart() {
        return (this.m_type & 4) != 0;
    }

    public boolean isIncludeEnd() {
        return (this.m_type & 8) != 0;
    }

    public int getEndMajor() throws IllegalStateException {
        if (this.isOpenEnded()) {
            throw new IllegalStateException();
        }
        return this.m_endMajor;
    }

    public int getEndMinor() throws IllegalStateException {
        if (this.isOpenEnded()) {
            throw new IllegalStateException();
        }
        return this.m_endMinor;
    }

    public int getEndMicro() throws IllegalStateException {
        if (this.isOpenEnded()) {
            throw new IllegalStateException();
        }
        return this.m_endMicro;
    }

    public String getEndQualifier() throws IllegalStateException {
        if (this.isOpenEnded()) {
            throw new IllegalStateException();
        }
        return this.m_endQualifier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof VersionSpec)) {
            return false;
        }
        VersionSpec v = (VersionSpec)o;
        if (this.m_type != v.m_type || this.m_major != v.m_major || this.m_minor != v.m_minor || this.m_micro != v.m_micro || this.m_qualifier != v.m_qualifier && !this.m_qualifier.equals(v.m_qualifier)) {
            return false;
        }
        if (!this.isRange() || this.isOpenEnded()) {
            return true;
        }
        return this.m_endMajor == v.m_endMajor && this.m_endMinor == v.m_endMinor && this.m_endMicro == v.m_endMicro && (this.m_endQualifier == v.m_endQualifier || this.m_endQualifier.equals(v.m_endQualifier));
    }

    public int hashCode() {
        int a = (this.m_major << 24) + (this.m_minor << 16) + (this.m_micro << 8) + this.m_qualifier.hashCode() + this.m_type;
        if (!this.isRange() || this.isOpenEnded()) {
            return a;
        }
        return (this.m_endMajor << 24) + (this.m_endMinor << 16) + (this.m_endMicro << 8) + this.m_endQualifier.hashCode() + a;
    }

    public boolean includes(VersionSpec v) throws IllegalArgumentException {
        if (this == v || this == ANY) {
            return true;
        }
        if (v == null) {
            throw Util.illegalNull("v");
        }
        return VersionSpec.compareVersionStarts(this, v) <= 0 && VersionSpec.compareVersionEnds(this, v) >= 0;
    }

    public VersionSpec intersect(VersionSpec r) throws IllegalArgumentException {
        VersionSpec later;
        VersionSpec earlier;
        if (r == null) {
            throw Util.illegalNull("r");
        }
        if (r == ANY) {
            return this;
        }
        if (this == ANY) {
            return r;
        }
        if (VersionSpec.compareVersionStarts(this, r) < 0) {
            earlier = this;
            later = r;
        } else {
            earlier = r;
            later = this;
        }
        if (VersionSpec.compareVersionEnds(earlier, later) >= 0) {
            return later;
        }
        int e = earlier.m_endMajor;
        int f = earlier.m_endMinor;
        int g = earlier.m_endMicro;
        String h = earlier.m_endQualifier;
        int a = later.m_major;
        int b = later.m_minor;
        int c = later.m_micro;
        String d = later.m_qualifier;
        int i = VersionSpec.compareVersions(e, f, g, h, a, b, c, d);
        if (i < 0) {
            return null;
        }
        boolean iStart = later.isIncludeStart();
        boolean iEnd = earlier.isIncludeEnd();
        if (i == 0) {
            return iStart && iEnd ? new VersionSpec(a, b, c, d, false) : null;
        }
        return new VersionSpec(a, b, c, d, e, f, g, h, iStart, iEnd);
    }

    VersionSpec union(VersionSpec r) throws IllegalArgumentException {
        VersionSpec later;
        VersionSpec earlier;
        if (r == null) {
            throw Util.illegalNull("r");
        }
        if (r == ANY || this == ANY) {
            return ANY;
        }
        if (VersionSpec.compareVersionStarts(this, r) <= 0) {
            earlier = this;
            later = r;
        } else {
            earlier = r;
            later = this;
        }
        if (VersionSpec.compareVersionEnds(earlier, later) >= 0) {
            return earlier;
        }
        int c = VersionSpec.compareVersions(earlier.m_endMajor, earlier.m_endMinor, earlier.m_endMicro, earlier.m_endQualifier, later.m_major, later.m_minor, later.m_micro, later.m_qualifier);
        if (c < 0 || c == 0 && !earlier.isIncludeEnd() && !later.isIncludeStart()) {
            return null;
        }
        if (later.isOpenEnded()) {
            if (!earlier.isIncludeStart()) {
                return null;
            }
            return new VersionSpec(earlier.m_major, earlier.m_minor, earlier.m_micro, earlier.m_qualifier, true);
        }
        return new VersionSpec(earlier.m_major, earlier.m_minor, earlier.m_micro, earlier.m_qualifier, later.m_endMajor, later.m_endMinor, later.m_endMicro, later.m_endQualifier, earlier.isIncludeStart(), later.isIncludeEnd());
    }

    public String toVersionString() {
        if (this.isRange()) {
            throw new IllegalStateException();
        }
        StringBuffer b = new StringBuffer().append(this.m_major).append('.').append(this.m_minor).append('.').append(this.m_micro);
        if (this.m_qualifier.length() > 0) {
            b.append('.').append(this.m_qualifier);
        }
        return b.toString();
    }

    public String toRangeString(boolean quoteRanges) {
        StringBuffer b = new StringBuffer();
        if (this.isOpenEnded()) {
            b.append(this.m_major).append('.').append(this.m_minor).append('.').append(this.m_micro);
            if (this.m_qualifier.length() > 0) {
                b.append('.').append(this.m_qualifier);
            }
        } else {
            if (quoteRanges) {
                b.append('\"');
            }
            b.append(this.isIncludeStart() ? (char)'[' : '(');
            b.append(this.m_major).append('.').append(this.m_minor).append('.').append(this.m_micro);
            if (this.m_qualifier.length() > 0) {
                b.append('.').append(this.m_qualifier);
            }
            b.append(',');
            b.append(this.m_endMajor).append('.').append(this.m_endMinor).append('.').append(this.m_endMicro);
            if (this.m_endQualifier.length() > 0) {
                b.append('.').append(this.m_endQualifier);
            }
            b.append(this.isIncludeEnd() ? (char)']' : ')');
            if (quoteRanges) {
                b.append('\"');
            }
        }
        return b.toString();
    }

    public String toString() {
        return this.toRangeString(true);
    }

    void writeTo(DataOutput s) throws IOException {
        s.writeByte(this.m_type);
        s.writeInt(this.m_major);
        s.writeInt(this.m_minor);
        s.writeInt(this.m_micro);
        s.writeUTF(this.m_qualifier);
        if (!this.isRange() || this.isOpenEnded()) {
            return;
        }
        s.writeInt(this.m_endMajor);
        s.writeInt(this.m_endMinor);
        s.writeInt(this.m_endMicro);
        s.writeUTF(this.m_endQualifier);
    }

    public int compareTo(Object o) throws ClassCastException, IllegalArgumentException {
        if (o == this) {
            return 0;
        }
        if (o == null) {
            throw Util.illegalNull("o");
        }
        return this.compareTo((VersionSpec)o);
    }

    public int compareTo(VersionSpec v) throws ClassCastException {
        if (v == this) {
            return 0;
        }
        if (v == null) {
            throw Util.illegalNull("v");
        }
        int rc = VersionSpec.compareVersionStarts(this, v);
        return rc != 0 ? rc : VersionSpec.compareVersionEnds(this, v);
    }
}

