/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.GetSystemPropertyAction;
import com.sas.app.Util;
import com.sas.app.VersionSpec;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

final class SplashController
implements Runnable,
AWTEventListener {
    public static final String PROP_SPLASH_PATH = "sas.app.splash.path";
    private static boolean s_wet = false;
    private static SplashController s_instance;
    private byte[] m_imageBytes;
    private JWindow m_window;
    private Toolkit m_toolkitListened;
    private DeathKnell m_knell;

    private static synchronized boolean wet() {
        boolean rc = s_wet;
        if (!rc) {
            s_wet = true;
        }
        return rc;
    }

    private static synchronized boolean isWet() {
        return s_wet;
    }

    public static JWindow getSplashWindow() {
        SplashController instance = SplashController.getInstance();
        return instance == null ? null : instance.getWindow();
    }

    public static void closeSplash() {
        SplashController instance = SplashController.getInstance();
        if (instance != null) {
            instance.close();
        }
    }

    static synchronized SplashController getInstance() {
        return s_instance;
    }

    private static synchronized void setInstance(SplashController instance) {
        s_instance = instance;
    }

    static void doSplash() {
        if (SplashController.isWet()) {
            return;
        }
        String v = (String)AccessController.doPrivileged(new GetSystemPropertyAction(PROP_SPLASH_PATH));
        if (v == null) {
            return;
        }
        SplashController.doSplash(v);
    }

    static void doSplash(String propValue) {
        byte[] imageBytes;
        if (propValue == null) {
            return;
        }
        if (SplashController.wet()) {
            return;
        }
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        String javaSpecVersion = (String)AccessController.doPrivileged(new GetSystemPropertyAction("java.specification.version"));
        if (javaSpecVersion != null) {
            VersionSpec spec = VersionSpec.parseVersion(javaSpecVersion);
            VersionSpec ONE_SIX = VersionSpec.parseVersion("1.6");
            assert (ONE_SIX != null);
            if (spec != null && spec.compareTo(ONE_SIX) >= 0) {
                Object rc;
                Class<?> classJavaAwtSplashScreen = null;
                try {
                    classJavaAwtSplashScreen = SplashController.class.getClassLoader().loadClass("java.awt.SplashScreen");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    // empty catch block
                }
                if (classJavaAwtSplashScreen != null && (rc = Util.invoke(classJavaAwtSplashScreen, "getSplashScreen", new Class[0], new Object[0], classJavaAwtSplashScreen, null)) != null) {
                    return;
                }
            }
        }
        try {
            imageBytes = SplashController.getImageBytes(propValue);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SplashController splashController = new SplashController(imageBytes);
        splashController.createSplash();
        SplashController.setInstance(splashController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getImageBytes(String propValue) throws IOException, ArrayIndexOutOfBoundsException, SecurityException {
        byte[] byArray;
        File f = new File(propValue);
        InputStream s = null;
        try {
            s = new FileInputStream(f);
            long len = f.length();
            if (len > Integer.MAX_VALUE) {
                throw new ArrayIndexOutOfBoundsException(Long.toString(len));
            }
            byte[] bytes = new byte[(int)len];
            new DataInputStream(s).readFully(bytes);
            byArray = bytes;
        }
        catch (FileNotFoundException fnf) {
            byte[] byArray2;
            try {
                int n;
                if (s != null) {
                    assert (false);
                    Util.close(s);
                    s = null;
                }
                if ((s = SplashController.class.getClassLoader().getResourceAsStream(propValue)) == null) {
                    throw fnf;
                }
                byte[] buffer = new byte[8192];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((n = s.read(buffer)) > 0) {
                    baos.write(buffer, 0, n);
                }
                byArray2 = baos.toByteArray();
            }
            catch (Throwable throwable) {
                Util.close(s);
                throw throwable;
            }
            Util.close(s);
            return byArray2;
        }
        Util.close(s);
        return byArray;
    }

    private SplashController(byte[] imageBytes) {
        if (imageBytes == null) {
            throw Util.illegalNull("imageBytes");
        }
        this.m_imageBytes = imageBytes;
        this.m_knell = new DeathKnell(Thread.currentThread());
    }

    public synchronized JWindow getWindow() {
        return this.m_window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JWindow w;
        assert (EventQueue.isDispatchThread());
        SplashController splashController = this;
        synchronized (splashController) {
            w = this.m_window;
            this.m_window = null;
        }
        if (w != null) {
            w.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSplash() {
        JWindow window;
        byte[] imageBytes;
        SplashController splashController = this;
        synchronized (splashController) {
            Toolkit toolkit;
            if (this.m_imageBytes == null) {
                this.close();
                return;
            }
            imageBytes = this.m_imageBytes;
            this.m_imageBytes = null;
            this.m_window = window = new JWindow();
            this.m_toolkitListened = toolkit = Toolkit.getDefaultToolkit();
            toolkit.addAWTEventListener(this, 64L);
        }
        Container p = window.getContentPane();
        p.setLayout(new BorderLayout());
        p.add((Component)new JLabel(new ImageIcon(imageBytes)), "Center");
        GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point center = genv.getCenterPoint();
        window.pack();
        window.setLocation(center.x - window.getWidth() / 2, center.y - window.getHeight() / 2);
        window.setVisible(true);
    }

    @Override
    public void eventDispatched(AWTEvent e) {
        Window w;
        JWindow ourSplash = this.getWindow();
        if (ourSplash == null) {
            return;
        }
        int id = e.getID();
        if (id == 200) {
            Window w2 = ((WindowEvent)e).getWindow();
            if (w2 != ourSplash) {
                this.close();
            }
        } else if (id == 202 && (w = ((WindowEvent)e).getWindow()) == ourSplash) {
            this.close();
        }
    }

    synchronized void close() {
        SplashController.setInstance(null);
        this.m_imageBytes = null;
        if (this.m_toolkitListened != null) {
            this.m_toolkitListened.removeAWTEventListener(this);
            this.m_toolkitListened = null;
        }
        if (this.m_knell != null) {
            this.m_knell.cancel();
            this.m_knell = null;
        }
        if (this.m_window != null) {
            if (EventQueue.isDispatchThread()) {
                this.m_window.dispose();
                this.m_window = null;
            } else {
                SwingUtilities.invokeLater(this);
            }
        }
    }

    synchronized boolean isClosed() {
        return this.m_imageBytes == null && this.m_window == null;
    }

    private class DeathKnell
    implements Runnable {
        private WeakReference m_refWatchedThread;
        private boolean m_cancel;
        private WeakReference m_refWatchdogThread;

        DeathKnell(Thread thread) {
            if (thread == null) {
                throw Util.illegalNull("mainThread");
            }
            if (!thread.isAlive()) {
                SplashController.this.close();
            }
            this.m_refWatchedThread = new WeakReference<Thread>(thread);
            Thread t = new Thread((Runnable)this, "mainWatcher");
            try {
                t.setDaemon(true);
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            t.start();
        }

        public synchronized void cancel() {
            this.m_cancel = true;
            WeakReference refWatchdogThread = this.m_refWatchdogThread;
            if (refWatchdogThread == null) {
                return;
            }
            Thread watchdogThread = (Thread)refWatchdogThread.get();
            if (watchdogThread == null || !watchdogThread.isAlive()) {
                this.m_refWatchdogThread = null;
                return;
            }
            try {
                watchdogThread.interrupt();
                this.m_refWatchdogThread = null;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            DeathKnell deathKnell = this;
            // MONITORENTER : deathKnell
            WeakReference refWatchedThread = this.m_refWatchedThread;
            this.m_refWatchedThread = null;
            if (refWatchedThread == null) {
                // MONITOREXIT : deathKnell
                return;
            }
            Thread mainThread = (Thread)refWatchedThread.get();
            if (mainThread == null) {
                // MONITOREXIT : deathKnell
                return;
            }
            if (this.m_cancel) {
                // MONITOREXIT : deathKnell
                return;
            }
            if (this.m_refWatchdogThread == null) {
                this.m_refWatchdogThread = new WeakReference<Thread>(Thread.currentThread());
            } else assert (false);
            // MONITOREXIT : deathKnell
            try {
                while (true) {
                    deathKnell = this;
                    // MONITORENTER : deathKnell
                    if (this.m_cancel) {
                        // MONITOREXIT : deathKnell
                        return;
                    }
                    // MONITOREXIT : deathKnell
                    if (SplashController.this.isClosed()) {
                        return;
                    }
                    try {
                        mainThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                DeathKnell deathKnell2 = this;
            }
            SplashController.this.close();
        }
    }
}

