/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.SDSDestTraversalPath;
import com.sas.app.SDSImageServerConnection;
import com.sas.app.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;

class SDSFileTraversalPath
implements SDSDestTraversalPath {
    private final List m_parents = new ArrayList();
    private File m_current;

    SDSFileTraversalPath(File f) {
        if (f == null) {
            throw Util.illegalNull("f");
        }
        this.m_current = f.getAbsoluteFile();
    }

    @Override
    public void push(String name) {
        SDSImageServerConnection.validateSimpleName(name);
        this.m_parents.add(this.m_current);
        this.m_current = new File(this.m_current, name);
    }

    @Override
    public void pop() throws EmptyStackException {
        int n = this.m_parents.size();
        if (n <= 0) {
            throw new EmptyStackException();
        }
        this.m_current = (File)this.m_parents.remove(n - 1);
    }

    @Override
    public int relativeDepth() {
        return this.m_parents.size();
    }

    @Override
    public String getPath() {
        return this.m_current.getPath();
    }

    File getPathFile() {
        return this.m_current;
    }

    @Override
    public String getRelPath() {
        int n = this.m_parents.size();
        if (n <= 0) {
            return "/";
        }
        StringBuffer rc = new StringBuffer();
        for (int i = 1; i < n; ++i) {
            if (rc.length() > 0) {
                rc.append('/');
            }
            rc.append(((File)this.m_parents.get(i)).getName());
        }
        if (rc.length() > 0) {
            rc.append('/');
        }
        rc.append(this.m_current.getName());
        return rc.toString();
    }

    @Override
    public void close() {
    }

    @Override
    public String[] list() {
        return this.m_current.list();
    }

    @Override
    public boolean mkdirs() {
        return this.m_current.mkdirs();
    }

    @Override
    public boolean isDirectory() {
        return this.m_current.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.m_current.isFile();
    }

    @Override
    public boolean exists() {
        return this.m_current.exists();
    }

    @Override
    public long lastModified() {
        return this.m_current.lastModified();
    }

    @Override
    public long length() {
        return this.m_current.length();
    }

    @Override
    public InputStream openSource() throws IOException {
        return new FileInputStream(this.m_current);
    }

    @Override
    public OutputStream openDest() throws IOException {
        return new FileOutputStream(this.m_current);
    }

    @Override
    public void setLastModified(long millis) {
        this.m_current.setLastModified(millis);
    }

    @Override
    public boolean delete() {
        if (!this.m_current.exists()) {
            return true;
        }
        try {
            this.m_current.delete();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (!this.m_current.exists()) {
            return true;
        }
        if (!this.m_current.isDirectory()) {
            return false;
        }
        ArrayList<File> path = new ArrayList<File>();
        ArrayList unprocessedNames = new ArrayList();
        path.add(this.m_current);
        while (!path.isEmpty()) {
            ArrayList<File> unprocessed;
            int n = path.size();
            File dir = (File)path.get(n - 1);
            if (unprocessedNames.size() < n) {
                File[] files = dir.listFiles();
                unprocessed = new ArrayList<File>();
                unprocessedNames.add(unprocessed);
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        File f = files[i];
                        if (f.isDirectory()) {
                            unprocessed.add(f);
                            continue;
                        }
                        try {
                            f.delete();
                            continue;
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                }
            } else {
                unprocessed = (ArrayList<File>)unprocessedNames.get(n - 1);
            }
            if (unprocessedNames.size() != n) {
                assert (false);
                throw new IllegalStateException("path size " + n + ", but unprocessedNames.size() " + unprocessedNames.size());
            }
            if (unprocessed.isEmpty()) {
                try {
                    dir.delete();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                path.remove(n - 1);
                unprocessed.remove(n - 1);
            }
            path.add((File)unprocessed.remove(n - 1));
        }
        return !this.m_current.exists();
    }
}

