/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.util.layout;

public class Point {
    private double x;
    private double y;

    public Point() {
        this(0.0, 0.0);
    }

    public Point(double x, double y) {
        this.setValue(x, y);
    }

    public Point(Point p) {
        this.setValue(p);
    }

    public void setValue(Point p) {
        if (p != null) {
            this.setValue(p.x, p.y);
        } else {
            this.setValue(0.0, 0.0);
        }
    }

    public void setValue(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public Point add(Point p) {
        return this.add(p, null);
    }

    public Point add(Point p, Point result) {
        if (result == null) {
            result = new Point();
        }
        if (p != null) {
            result.x = this.x + p.x;
            result.y = this.y + p.y;
        } else {
            result.x = this.x;
            result.y = this.y;
        }
        return result;
    }

    public Point subtract(Point p) {
        return this.subtract(p, null);
    }

    public Point subtract(Point p, Point result) {
        if (result == null) {
            result = new Point();
        }
        if (p != null) {
            result.x = this.x - p.x;
            result.y = this.y - p.y;
        } else {
            result.x = this.x;
            result.y = this.y;
        }
        return result;
    }

    public Point divide(double constant, Point result) {
        if (result == null) {
            result = new Point();
        }
        result.x = this.x / constant;
        result.y = this.y / constant;
        return result;
    }

    public Point multiply(double constant, Point result) {
        if (result == null) {
            result = new Point();
        }
        result.x = this.x * constant;
        result.y = this.y * constant;
        return result;
    }

    public double scalarProduct(Point p) {
        if (p == null) {
            return Double.NaN;
        }
        double result = this.x * p.x + this.y * p.y;
        return result;
    }

    public double distanceSq(Point p) {
        if (p != null) {
            return this.distanceSq(p.x, p.y);
        }
        return this.distanceSq(0.0, 0.0);
    }

    public double distanceSq(double x, double y) {
        double dx = x - this.getX();
        double dy = y - this.getY();
        return dx * dx + dy * dy;
    }

    public double distance(Point p) {
        if (p != null) {
            return this.distance(p.x, p.y);
        }
        return this.distance(0.0, 0.0);
    }

    public double distance(double x, double y) {
        return Math.sqrt(this.distanceSq(x, y));
    }

    public int compareX(Point p) {
        if (p == null) {
            return 1;
        }
        return this.compareX(p.x);
    }

    private int compareX(double x) {
        if (this.x > x) {
            return 1;
        }
        if (this.x < x) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "Point [x=" + this.x + ", y=" + this.y + "]\n";
    }
}

