/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.util.layout;

import com.sas.graphics.components.pfd.PFDPathDiagramCurvedLink;
import com.sas.graphics.components.pfd.PFDPathDiagramModel;
import com.sas.graphics.components.pfd.PFDPathDiagramNode;
import com.sas.graphics.components.pfd.PFDPathDiagramSelfLink;
import com.sas.graphics.components.util.layout.LayeredLayoutStrategy;
import com.sas.graphics.components.util.layout.NodeInfo;
import com.sas.graphics.components.util.layout.NodeInfoExtension;
import com.sas.graphics.components.util.layout.SubdiagramNodeInfo;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.graphics.interfaces.NodeLinkDiagramLayoutInterface;
import com.sas.graphics.interfaces.PathDiagramLinkLayoutInterface;
import com.sas.graphics.interfaces.PathDiagramNodeLayoutInterface;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;

public class PathDiagramNeuralNetworkLayout
extends LayeredLayoutStrategy {
    private Vector<PathDiagramLinkLayoutInterface> subsetLinks = null;
    private Vector<NodeLayoutInterface> subsetNodes = null;
    private PFDPathDiagramModel subsetModel = null;
    private Vector<PathDiagramLinkLayoutInterface> curvedLinks = null;
    private Vector<PathDiagramLinkLayoutInterface> selfLinks = null;
    private Vector<PathDiagramLinkLayoutInterface> p1p3Links = null;
    private Vector<PathDiagramLinkLayoutInterface> p2p3Links = null;
    private Vector<PathDiagramLinkLayoutInterface> nonP1Links = null;
    private Vector<PathDiagramNodeLayoutInterface> p3DirectNodes = null;
    private Vector<PathDiagramNodeLayoutInterface> p3Nodes = null;
    private static final int ERROR_LINK_LENGTH = 30;
    private double gridScaleFactor = 1.0;
    private boolean keepNodeOrder = true;
    private boolean keepAspectRatio = true;
    private Dimension graphSize;
    private double horzGridPadding = 0.0;
    private double vertGridPadding = 0.0;
    private boolean initializing = true;
    NodeLinkDiagramLayoutInterface rawModel;

    public void setGridScaleFactor(double fac) {
        this.gridScaleFactor = fac;
    }

    public void setKeepNodeOrder(boolean b) {
        this.keepNodeOrder = b;
    }

    public boolean isKeepNodeOrder() {
        return this.keepNodeOrder;
    }

    public void setKeepAspectRatio(boolean fit) {
        this.keepAspectRatio = fit;
    }

    public boolean isKeepAspectRatio() {
        return this.keepAspectRatio;
    }

    public void setGraphSize(int width, int height) {
        this.graphSize = new Dimension(width, height);
    }

    @Override
    public boolean arrange() {
        int i;
        Point fromCenter;
        PFDPathDiagramNode tn;
        PathDiagramNodeLayoutInterface toNode;
        PathDiagramNodeLayoutInterface fromNode;
        PathDiagramLinkLayoutInterface link;
        int i2;
        if (this.model == null) {
            return false;
        }
        super.arrange();
        for (i2 = 0; i2 < this.p2p3Links.size(); ++i2) {
            link = this.p2p3Links.elementAt(i2);
            fromNode = (PathDiagramNodeLayoutInterface)link.getFromNode();
            toNode = (PathDiagramNodeLayoutInterface)link.getToNode();
            tn = (PFDPathDiagramNode)toNode;
            Point toRight = tn.getDrawable().getSpotLocation(4, null);
            fromCenter = new Point(toRight.x + (int)(30.0 * this.gridScaleFactor) + fromNode.getWidth() / 2, toRight.y);
            fromNode.setCenterLocation(fromCenter);
        }
        for (i2 = 0; i2 < this.p1p3Links.size(); ++i2) {
            link = this.p1p3Links.elementAt(i2);
            fromNode = (PathDiagramNodeLayoutInterface)link.getFromNode();
            toNode = (PathDiagramNodeLayoutInterface)link.getToNode();
            tn = (PFDPathDiagramNode)toNode;
            Point toCenter = tn.getDrawable().getSpotLocation(6, null);
            fromCenter = new Point(toCenter.x, toCenter.y + (int)(30.0 * this.gridScaleFactor) + fromNode.getHeight() / 2);
            fromNode.setCenterLocation(fromCenter);
        }
        for (i2 = 0; i2 < this.selfLinks.size(); ++i2) {
            PFDPathDiagramSelfLink pdsl = (PFDPathDiagramSelfLink)this.selfLinks.elementAt(i2);
            fromNode = (PathDiagramNodeLayoutInterface)pdsl.getFromNode();
            int loc = 2;
            if (this.p3DirectNodes.contains(fromNode)) {
                loc = 6;
            }
            pdsl.setRelativeLocation(loc, true);
        }
        Vector allNodes = this.rawModel.getAllNodes();
        double minX = Double.MAX_VALUE;
        for (i = 0; i < allNodes.size(); ++i) {
            PFDPathDiagramNode node = (PFDPathDiagramNode)allNodes.elementAt(i);
            minX = Math.min(minX, node.getCenterLocation().getX());
        }
        for (i = 0; i < this.curvedLinks.size(); ++i) {
            PathDiagramLinkLayoutInterface link2 = this.curvedLinks.elementAt(i);
            PathDiagramNodeLayoutInterface fromNode2 = (PathDiagramNodeLayoutInterface)link2.getFromNode();
            PathDiagramNodeLayoutInterface toNode2 = (PathDiagramNodeLayoutInterface)link2.getToNode();
            PFDPathDiagramCurvedLink pdcl = null;
            if (link2 instanceof PFDPathDiagramCurvedLink) {
                pdcl = (PFDPathDiagramCurvedLink)link2;
            }
            if (pdcl == null) continue;
            Point fp = fromNode2.getCenterLocation();
            Point tp = toNode2.getCenterLocation();
            if (fp.x == tp.x && (double)fp.x == minX) {
                double multiplier = (double)Math.abs(fp.y - tp.y) / (double)(2 * fromNode2.getWidth());
                int offset = (int)((double)fromNode2.getWidth() * multiplier);
                pdcl.setControlPoint(new Point(fp.x - offset, (fp.y + tp.y) / 2));
                continue;
            }
            PathDiagramNeuralNetworkLayout.computeLinkControlPoint(pdcl, fromNode2, toNode2);
        }
        return true;
    }

    @Override
    public void setModel(NodeLinkDiagramLayoutInterface m) {
        super.setModel(m);
        this.doSetupModel();
        this.initializing = false;
        this.rawModel = m;
    }

    @Override
    void doSetupModel() {
        super.doSetupModel();
        if (!this.initializing) {
            return;
        }
        this.subsetLinks = new Vector();
        this.subsetNodes = new Vector();
        this.p3DirectNodes = new Vector();
        this.p3Nodes = new Vector();
        this.curvedLinks = new Vector();
        this.selfLinks = new Vector();
        this.p1p3Links = new Vector();
        this.p2p3Links = new Vector();
        this.nonP1Links = new Vector();
        Vector allLinks = this.model.getAllLinks();
        for (int i = 0; i < allLinks.size(); ++i) {
            PathDiagramLinkLayoutInterface pdli = (PathDiagramLinkLayoutInterface)allLinks.get(i);
            PathDiagramNodeLayoutInterface toNode = (PathDiagramNodeLayoutInterface)pdli.getToNode();
            PathDiagramNodeLayoutInterface fromNode = (PathDiagramNodeLayoutInterface)pdli.getFromNode();
            if (pdli.getLinkPriority() != 1 && pdli.getLinkPriority() != 2) {
                this.model.removeLink(pdli);
                continue;
            }
            if (fromNode == toNode) {
                this.selfLinks.add(pdli);
                ((PFDPathDiagramSelfLink)pdli).setGridScaleFactor(this.gridScaleFactor);
                continue;
            }
            if (pdli.getLinkDirection() == 3 || pdli.getLinkPriority() != 1) {
                this.curvedLinks.add(pdli);
                continue;
            }
            if (fromNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_3) {
                if (toNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_1) {
                    this.p3DirectNodes.add(fromNode);
                    this.p1p3Links.add(pdli);
                    continue;
                }
                this.p3Nodes.add(fromNode);
                this.p2p3Links.add(pdli);
                continue;
            }
            this.subsetLinks.add(pdli);
        }
        Vector allNodes = this.model.getAllNodes();
        for (int i = 0; i < allNodes.size(); ++i) {
            PFDPathDiagramNode node = (PFDPathDiagramNode)allNodes.elementAt(i);
            if (this.p3Nodes.contains(node) || this.p3DirectNodes.contains(node)) continue;
            this.subsetNodes.add(node);
        }
        this.subsetModel = new PFDPathDiagramModel(this.subsetNodes, this.subsetLinks);
        super.setModel(this.subsetModel);
        this.setGridHeight((int)Math.ceil((double)this.getGridHeight() * this.gridScaleFactor));
        this.setGridWidth((int)Math.ceil((double)this.getGridWidth() * this.gridScaleFactor));
    }

    public static void computeLinkControlPoint(PFDPathDiagramCurvedLink pdcl, PathDiagramNodeLayoutInterface fromNode, PathDiagramNodeLayoutInterface toNode) {
        Point fp = fromNode.getCenterLocation();
        Point tp = toNode.getCenterLocation();
        Point cp = new Point();
        if (fp.y == tp.y) {
            cp.setLocation((double)((fp.x + tp.x) / 2), (double)fp.y - 1.5 * (double)fromNode.getWidth());
        } else if (fp.x == tp.x) {
            double multiplier = (double)Math.abs(fp.y - tp.y) / (double)(2 * fromNode.getWidth());
            int offset = (int)((double)fromNode.getWidth() * multiplier);
            cp.setLocation(fp.x + offset, (fp.y + tp.y) / 2);
        } else {
            cp.x = (int)((double)((fp.x + tp.x) / 2) - 0.7 * (double)fromNode.getHeight());
            cp.y = fp.y < tp.y ? (int)((double)((fp.y + tp.y) / 2) - 0.7 * (double)fromNode.getHeight()) : (int)((double)((fp.y + tp.y) / 2) + 0.7 * (double)fromNode.getHeight());
        }
        pdcl.setControlPoint(cp);
    }

    @Override
    void reduceUniformCrossings() {
        int i;
        NodeInfo ni;
        if (this.keepNodeOrder) {
            for (int i2 = 0; i2 < this.pos.length; ++i2) {
                this.pos[i2] = this.sortColumnByNodeOrder(this.pos[i2]);
            }
        }
        this.prevcross = Integer.MAX_VALUE;
        int dx = 1;
        int min = 0;
        int max = min + dx * this.layerWidth[0];
        this.leavesAssigned = false;
        this.wideTreeAlgo = false;
        int start = 0;
        while (this.layerWidth[start] == 0) {
            ++start;
        }
        if (this.revtree && this.newLayout) {
            int index = this.numLayers - 1;
            while (this.pos[index].size() == 0) {
                --index;
            }
            ni = (NodeInfo)this.pos[index].elementAt(0);
            ni.col = 0;
            while (ni.inEdges.size() != 0) {
                ni = (NodeInfo)ni.inEdges.elementAt(0);
                this.pos[ni.layer].remove(ni);
                this.pos[ni.layer].insertElementAt(ni, 0);
                ni.col = 0;
            }
        }
        int last = this.numLayers - 1;
        while (this.layerWidth[last] == 0) {
            --last;
        }
        start = 0;
        while (this.layerWidth[start] == 0) {
            ++start;
        }
        this.maxLayerWidth = this.pos[start].size();
        this.maxLayerWidthIndex = start;
        if (!this.leavesAssigned) {
            this.assignLeafLoc();
        }
        int maxColumn = 0;
        for (i = 0; i < this.numLayers; ++i) {
            maxColumn = Math.max(maxColumn, this.pos[i].size());
        }
        for (i = start; i < this.numLayers; ++i) {
            int size = this.pos[i].size();
            if (size == 0) continue;
            this.NNLayoutColumn(i, maxColumn);
            min = Math.min(min, ((NodeInfo)this.pos[i].elementAt((int)0)).col);
            max = Math.max(max, ((NodeInfo)this.pos[i].elementAt((int)(size - 1))).col);
            if (size <= this.maxLayerWidth) continue;
            this.maxLayerWidth = size;
            this.maxLayerWidthIndex = i;
        }
        this.minrow = ((NodeInfo)this.pos[start].elementAt((int)0)).col;
        for (i = start + 1; i < last; ++i) {
            if (this.layerWidth[i] == 0) continue;
            ni = (NodeInfo)this.pos[i].elementAt(0);
            this.minrow = Math.min(ni.col, this.minrow);
        }
        int ninfoSize = this.ninfo.size();
        if (this.minrow < 0) {
            for (int i3 = 0; i3 < ninfoSize; ++i3) {
                ni = (NodeInfo)this.ninfo.elementAt(i3);
                if (ni == null) continue;
                ni.col -= this.minrow;
            }
        }
        this.computeGridPadding();
    }

    private void NNLayoutColumn(int layer, int maxCols) {
        int j;
        boolean even;
        int size = this.pos[layer].size();
        int inc = (int)((double)maxCols / (double)size);
        int middleCol1 = (int)((double)maxCols / 2.0);
        int middleCol2 = (int)((double)maxCols / 2.0);
        int colsize = ((NodeInfo)this.pos[layer].elementAt((int)0)).colsize;
        int numRealNode = size / colsize;
        int middlePoint1 = 0;
        int middlePoint2 = 0;
        int count = 0;
        boolean bl = even = numRealNode % 2 == 0;
        if (even) {
            for (j = 0; j < size; ++j) {
                if (this.pos[layer].elementAt(j) instanceof NodeInfoExtension || ++count != numRealNode / 2) continue;
                middlePoint1 = j;
                middlePoint2 = j + colsize;
                middleCol2 = (middleCol1 -= (inc * colsize + 1) / 2) + inc * colsize;
                break;
            }
        } else {
            for (j = 0; j < size; ++j) {
                if (this.pos[layer].elementAt(j) instanceof NodeInfoExtension || ++count != (numRealNode + 1) / 2) continue;
                middlePoint1 = j;
                break;
            }
        }
        for (int j2 = 0; j2 < size; ++j2) {
            NodeInfo To = (NodeInfo)this.pos[layer].elementAt(j2);
            boolean isExtension = To instanceof NodeInfoExtension;
            if (isExtension) {
                NodeInfoExtension nie = (NodeInfoExtension)To;
                To.col = nie.parent.col + nie.colOffset;
                continue;
            }
            if (even) {
                if (j2 == middlePoint1) {
                    To.col = middleCol1;
                    continue;
                }
                if (j2 == middlePoint2) {
                    To.col = middleCol2;
                    continue;
                }
                if (j2 < middlePoint1) {
                    To.col = middleCol1 - inc * (middlePoint1 - j2);
                    continue;
                }
                To.col = middleCol2 + inc * (j2 - middlePoint2);
                continue;
            }
            To.col = j2 == middlePoint1 ? middleCol1 : (j2 < middlePoint1 ? middleCol1 - inc * (middlePoint1 - j2) : middleCol1 + inc * (j2 - middlePoint1));
        }
    }

    @Override
    protected void assignHorzFlowCoords(boolean right) {
        int offset;
        int factor;
        int hspace = this.gridWidth;
        int vspace = this.gridHeight;
        if (this.keepAspectRatio) {
            hspace += (int)this.horzGridPadding;
            vspace += (int)this.vertGridPadding;
        }
        if (right) {
            factor = 1;
            offset = 0;
        } else {
            factor = -1;
            offset = this.numLayers - 1;
        }
        int xo = this.gridWidth * this.xGridBorder;
        int yo = this.gridHeight * this.yGridBorder - this.minrow * vspace;
        if (!this.newLayout) {
            NodeInfo ni;
            int i;
            int[] nl = new int[2 * this.totalNodes];
            int xoffset = 0;
            int yoffset = 0;
            for (i = 0; i < this.totalNodes; ++i) {
                ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null) continue;
                if (right) {
                    nl[2 * i] = xo + hspace * ni.layer;
                    nl[2 * i + 1] = yo + vspace * ni.col;
                    continue;
                }
                nl[2 * i] = xo + hspace * (offset - (ni.layer + ni.layersize - 1));
                nl[2 * i + 1] = yo + vspace * ni.col;
            }
            if (this.prevOrientation == this.orientation) {
                if (this.columnOffsetNode != null) {
                    yoffset = Math.max(0, this.columnOffset % vspace);
                }
                if (this.layerOffsetNode != null) {
                    xoffset = Math.max(0, this.layerOffset % hspace);
                }
            }
            for (i = 0; i < this.totalNodes; ++i) {
                ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null || ni instanceof NodeInfoExtension || ni instanceof SubdiagramNodeInfo || this.assignNewOnly && ni.node.isNodePlaced()) continue;
                Point p = new Point(nl[2 * i] + xoffset, nl[2 * i + 1] + yoffset);
                ni.node.setLayoutLocation(1, p);
                ni.node.setNodePlaced(true);
            }
        } else {
            for (int i = 0; i < this.totalNodes; ++i) {
                NodeInfo ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null || ni instanceof NodeInfoExtension || ni instanceof SubdiagramNodeInfo || this.assignNewOnly && ni.node.isNodePlaced()) continue;
                Point p = right ? new Point(xo + hspace * ni.layer, yo + vspace * ni.col) : new Point(xo + hspace * (offset - (ni.layer + ni.layersize - 1)), yo + vspace * ni.col);
                ni.node.setLayoutLocation(1, p);
                ni.node.setNodePlaced(true);
            }
        }
    }

    private void computeGridPadding() {
        if (this.graphSize == null || this.graphSize.width == 0 || this.graphSize.height == 0) {
            return;
        }
        int maxLayer = -1;
        int maxCol = -1;
        for (int i = 0; i < this.totalNodes; ++i) {
            NodeInfo ni = (NodeInfo)this.allinfo.elementAt(i);
            maxLayer = Math.max(maxLayer, ni.layer);
            maxCol = Math.max(maxCol, ni.col);
        }
        double graphRatio = (double)this.graphSize.width / (double)this.graphSize.height;
        double dataWidth = maxLayer * this.gridWidth;
        double dataHeight = maxCol * this.gridHeight;
        double dataRatio = dataWidth / dataHeight;
        if (graphRatio > dataRatio) {
            double ideaWidth = dataHeight * graphRatio;
            this.horzGridPadding = ideaWidth / (double)maxLayer - (double)this.gridWidth;
            this.horzGridPadding = Math.max(0.0, this.horzGridPadding);
        } else {
            double ideaHeight = dataWidth / graphRatio;
            this.vertGridPadding = ideaHeight / (double)maxCol - (double)this.gridHeight;
            this.vertGridPadding = Math.max(0.0, this.vertGridPadding);
        }
    }

    private Vector sortColumnByNodeOrder(Vector list) {
        PFDPathDiagramNode n;
        NodeInfo ni;
        int size = list.size();
        if (size <= 1) {
            return list;
        }
        ArrayList<Integer> idxList = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            ni = (NodeInfo)list.elementAt(i);
            if (!(ni.node instanceof PFDPathDiagramNode)) {
                return list;
            }
            n = (PFDPathDiagramNode)ni.node;
            idxList.add(new Integer(n.getIndex()));
        }
        Collections.sort(idxList);
        Vector<NodeInfo> sortedList = new Vector<NodeInfo>();
        sortedList.setSize(size);
        int lastIdx = -1;
        int offset = -1;
        for (int i = 0; i < size; ++i) {
            ni = (NodeInfo)list.elementAt(i);
            n = (PFDPathDiagramNode)ni.node;
            int idx = n.getIndex();
            int sortIdx = idxList.indexOf(new Integer(idx));
            if (sortIdx != lastIdx) {
                offset = 0;
                lastIdx = sortIdx;
            } else {
                ++offset;
            }
            sortedList.setElementAt(ni, sortIdx + offset);
        }
        return sortedList;
    }

    @Override
    protected void createDummyNodes() {
    }
}

