/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.util.layout;

import com.sas.graphics.components.pfd.PFDPathDiagramCurvedLink;
import com.sas.graphics.components.pfd.PFDPathDiagramModel;
import com.sas.graphics.components.pfd.PFDPathDiagramSelfLink;
import com.sas.graphics.components.util.layout.GRIPLayout;
import com.sas.graphics.interfaces.NodeLinkDiagramLayoutInterface;
import com.sas.graphics.interfaces.PathDiagramLinkLayoutInterface;
import com.sas.graphics.interfaces.PathDiagramNodeLayoutInterface;
import java.awt.Point;
import java.util.Vector;

public class PathDiagramGRIPLayout
extends GRIPLayout {
    private PFDPathDiagramModel subsetModel = null;
    private Vector subsetLinks = new Vector();
    private Vector curvedLinks = new Vector();
    private Vector selfLinks = new Vector();
    private Vector reciprocalLinks = new Vector();
    private Vector errorLinks = new Vector();
    private double gridScaleFactor = 1.0;
    private double graphScale = 1.0;
    private boolean nodeScaled = false;

    public PathDiagramGRIPLayout(int width, int height) {
        super(width, height);
    }

    @Override
    public void setModel(NodeLinkDiagramLayoutInterface m) {
        NodeLinkDiagramLayoutInterface newModel = this.preProcessModel(m);
        super.setModel(newModel);
    }

    public void setGridScaleFactor(double fac) {
        this.gridScaleFactor = fac;
    }

    public void setGraphScale(double s) {
        this.graphScale = s;
    }

    public double getGraphScale() {
        return this.graphScale;
    }

    private NodeLinkDiagramLayoutInterface preProcessModel(NodeLinkDiagramLayoutInterface model) {
        Vector allLinks = model.getAllLinks();
        for (int i = 0; i < allLinks.size(); ++i) {
            PathDiagramLinkLayoutInterface pdli = (PathDiagramLinkLayoutInterface)allLinks.get(i);
            PathDiagramNodeLayoutInterface toNode = (PathDiagramNodeLayoutInterface)pdli.getToNode();
            PathDiagramNodeLayoutInterface fromNode = (PathDiagramNodeLayoutInterface)pdli.getFromNode();
            if (fromNode == toNode) {
                this.selfLinks.add(pdli);
                ((PFDPathDiagramSelfLink)pdli).setGridScaleFactor(this.gridScaleFactor);
                ((PFDPathDiagramSelfLink)pdli).setGraphScale(this.graphScale);
                continue;
            }
            if (pdli.getLinkPriority() == 1) {
                this.subsetLinks.add(pdli);
                if (pdli.getLinkDirection() == 3 && pdli instanceof PFDPathDiagramCurvedLink) {
                    this.curvedLinks.add(pdli);
                    continue;
                }
                if (!(pdli instanceof PFDPathDiagramCurvedLink) || !((PFDPathDiagramCurvedLink)pdli).isReciprocalLink()) continue;
                this.reciprocalLinks.add(pdli);
                continue;
            }
            if (pdli.getLinkPriority() == 2) {
                this.errorLinks.add(pdli);
                continue;
            }
            if (pdli.getLinkPriority() == -1) {
                model.removeLink(pdli);
                continue;
            }
            model.removeLink(pdli);
        }
        this.subsetModel = new PFDPathDiagramModel(model.getAllNodes(), this.subsetLinks);
        return this.subsetModel;
    }

    @Override
    public boolean arrange() {
        if (this.nodeScaled) {
            PFDPathDiagramModel.resetNodeSize(this.model.getAllNodes());
        }
        return super.arrange();
    }

    @Override
    protected void postProcessModel() {
        PFDPathDiagramCurvedLink link;
        int i;
        PathDiagramNodeLayoutInterface fromNode;
        int i2;
        if (this.graphScale != 1.0) {
            PFDPathDiagramModel.scaleNodeSize(this.model.getAllNodes(), this.graphScale);
            this.nodeScaled = true;
        }
        for (i2 = 0; i2 < this.curvedLinks.size(); ++i2) {
            PFDPathDiagramCurvedLink link2 = (PFDPathDiagramCurvedLink)this.curvedLinks.elementAt(i2);
            fromNode = (PathDiagramNodeLayoutInterface)link2.getFromNode();
            PathDiagramNodeLayoutInterface toNode = (PathDiagramNodeLayoutInterface)link2.getToNode();
            PathDiagramGRIPLayout.computeLinkControlPoint(link2, fromNode, toNode);
        }
        for (i2 = 0; i2 < this.selfLinks.size(); ++i2) {
            PFDPathDiagramSelfLink pdsl = (PFDPathDiagramSelfLink)this.selfLinks.elementAt(i2);
            fromNode = (PathDiagramNodeLayoutInterface)pdsl.getFromNode();
            int loc = fromNode.getCenterLocation().y < 0 ? 2 : 6;
            pdsl.setRelativeLocation(loc, true);
        }
        boolean[] controlPointUpdated = new boolean[this.reciprocalLinks.size()];
        for (i = 0; i < this.reciprocalLinks.size(); ++i) {
            if (controlPointUpdated[i]) continue;
            controlPointUpdated[i] = true;
            link = (PFDPathDiagramCurvedLink)this.reciprocalLinks.elementAt(i);
            PFDPathDiagramCurvedLink otherLink = this.getReciprocalLink(link, controlPointUpdated);
            PathDiagramNodeLayoutInterface fromNode2 = (PathDiagramNodeLayoutInterface)link.getFromNode();
            PathDiagramNodeLayoutInterface toNode = (PathDiagramNodeLayoutInterface)link.getToNode();
            this.computeReciprocalLinkControlPoint(link, fromNode2, toNode, otherLink);
        }
        for (i = 0; i < this.errorLinks.size(); ++i) {
            link = (PFDPathDiagramCurvedLink)this.errorLinks.elementAt(i);
            PathDiagramNodeLayoutInterface fromNode3 = (PathDiagramNodeLayoutInterface)link.getFromNode();
            PathDiagramNodeLayoutInterface toNode = (PathDiagramNodeLayoutInterface)link.getToNode();
            PathDiagramGRIPLayout.computeLinkControlPoint(link, fromNode3, toNode);
        }
    }

    private PFDPathDiagramCurvedLink getReciprocalLink(PFDPathDiagramCurvedLink theLink, boolean[] controlPointUpdated) {
        for (int i = 0; i < this.reciprocalLinks.size(); ++i) {
            PFDPathDiagramCurvedLink link = (PFDPathDiagramCurvedLink)this.reciprocalLinks.elementAt(i);
            if (!link.isReciprocalOfLink(theLink)) continue;
            controlPointUpdated[i] = true;
            return link;
        }
        return null;
    }

    private void computeReciprocalLinkControlPoint(PFDPathDiagramCurvedLink link, PathDiagramNodeLayoutInterface fromNode, PathDiagramNodeLayoutInterface toNode, PFDPathDiagramCurvedLink otherLink) {
        if (link == null || otherLink == null) {
            return;
        }
        Point fp = fromNode.getCenterLocation();
        Point tp = toNode.getCenterLocation();
        Point cp = new Point();
        Point cp2 = new Point();
        if (fp.y == tp.y) {
            cp.setLocation((double)(fp.x + tp.x) / 2.0, (double)fp.y - 0.5 * (double)fromNode.getHeight());
            cp2.setLocation((double)(fp.x + tp.x) / 2.0, (double)fp.y + 0.5 * (double)fromNode.getHeight());
        } else if (fp.x == tp.x) {
            cp.setLocation((double)fp.x - 0.5 * (double)fromNode.getWidth(), (double)(fp.y + tp.y) / 2.0);
            cp2.setLocation((double)fp.x + 0.5 * (double)fromNode.getWidth(), (double)(fp.y + tp.y) / 2.0);
        } else {
            int fw2 = (int)((double)fromNode.getWidth() * 0.5);
            int fh2 = (int)((double)fromNode.getHeight() * 0.5);
            int tw2 = (int)((double)toNode.getWidth() * 0.5);
            int th2 = (int)((double)toNode.getHeight() * 0.5);
            int dx = Math.abs(fp.x - tp.x) - fw2 - tw2;
            int dy = Math.abs(fp.y - tp.y) - fh2 - th2;
            if (dy > fromNode.getHeight() || (double)dx > 0.5 * (double)fromNode.getWidth()) {
                cp.x = (int)((double)(fp.x + tp.x) / 2.0 - 0.25 * (double)fromNode.getWidth());
                cp.y = (int)((double)(fp.y + tp.y) / 2.0 - 0.5 * (double)fromNode.getHeight());
                cp2.x = (int)((double)(fp.x + tp.x) / 2.0 + 0.25 * (double)fromNode.getWidth());
                cp2.y = (int)((double)(fp.y + tp.y) / 2.0 + 0.5 * (double)fromNode.getHeight());
            } else if (dy > 0) {
                cp.y = (int)((double)((fp.y + tp.y) / 2) + 0.25 * (double)dy);
                cp2.y = (int)((double)((fp.y + tp.y) / 2) - 0.25 * (double)dy);
                cp.x = (int)((double)((fp.x + tp.x) / 2) - 0.5 * (double)fw2);
                cp2.x = (int)((double)((fp.x + tp.x) / 2) + 0.5 * (double)fw2);
            } else if (dx > 0) {
                cp.x = (int)((double)((fp.x + tp.x) / 2) - 0.25 * (double)dx);
                cp2.x = (int)((double)((fp.x + tp.x) / 2) + 0.25 * (double)dx);
                cp.y = (int)((double)((fp.y + tp.y) / 2) + 0.5 * (double)fh2);
                cp2.y = (int)((double)((fp.y + tp.y) / 2) - 0.5 * (double)fh2);
            } else {
                if (fp.x < tp.x) {
                    cp.x = fp.x - fromNode.getWidth();
                    cp2.x = tp.x + toNode.getWidth();
                } else {
                    cp.x = tp.x - toNode.getWidth();
                    cp2.x = fp.x + fromNode.getWidth();
                }
                cp.y = (fp.y + tp.y) / 2 + fh2;
                cp2.y = (fp.y + tp.y) / 2 - fh2;
            }
        }
        link.setControlPoint(cp);
        otherLink.setControlPoint(cp2);
    }

    public static void computeLinkControlPoint(PFDPathDiagramCurvedLink pdcl, PathDiagramNodeLayoutInterface fromNode, PathDiagramNodeLayoutInterface toNode) {
        Point fp = fromNode.getCenterLocation();
        Point tp = toNode.getCenterLocation();
        Point cp = new Point();
        if (fp.y == tp.y) {
            cp.setLocation((double)((fp.x + tp.x) / 2), (double)fp.y - 1.5 * (double)fromNode.getWidth());
        } else if (fp.x == tp.x) {
            double multiplier = (double)Math.abs(fp.y - tp.y) / (double)(2 * fromNode.getWidth());
            int offset = (int)((double)fromNode.getWidth() * multiplier);
            cp.setLocation(fp.x + offset, (fp.y + tp.y) / 2);
        } else {
            int fw2 = (int)((double)fromNode.getWidth() * 0.5);
            int fh2 = (int)((double)fromNode.getHeight() * 0.5);
            int tw2 = (int)((double)toNode.getWidth() * 0.5);
            int th2 = (int)((double)toNode.getHeight() * 0.5);
            int dx = Math.abs(fp.x - tp.x) - fw2 - tw2;
            int dy = Math.abs(fp.y - tp.y) - fh2 - th2;
            if (dy > 0) {
                int signY;
                double fac;
                double d = fac = dy > 2 * fromNode.getHeight() ? 1.0 : 0.75;
                if (fp.x < tp.x) {
                    if (dx > 0) {
                        cp.x = (int)((double)fp.x + (double)fw2 * 0.75);
                        signY = tp.y > fp.y ? 1 : -1;
                    } else if (fp.x < 0) {
                        cp.x = (int)((double)fp.x - fac * (double)fromNode.getWidth());
                        signY = tp.y > fp.y ? 1 : -1;
                    } else {
                        cp.x = (int)((double)tp.x + fac * (double)toNode.getWidth());
                        signY = tp.y < fp.y ? 1 : -1;
                    }
                } else if (dx > 0) {
                    cp.x = (int)((double)tp.x + (double)tw2 * 0.75);
                    signY = fp.y > tp.y ? 1 : -1;
                } else if (tp.x < 0) {
                    cp.x = (int)((double)tp.x - fac * (double)toNode.getWidth());
                    signY = fp.y > tp.y ? 1 : -1;
                } else {
                    cp.x = (int)((double)fp.x + fac * (double)fromNode.getWidth());
                    signY = fp.y < tp.y ? 1 : -1;
                }
                cp.y = (int)((double)((fp.y + tp.y) / 2) + (double)(signY * dy) * 0.25);
            } else if (dx > 0) {
                cp.x = (fp.x + tp.x) / 2;
                cp.y = (fp.y + tp.y) / 2;
                cp.y = cp.y > 0 ? (cp.y += fh2) : (cp.y -= fh2);
            } else if (fp.x < tp.x) {
                cp.x = (int)((double)fp.x - (double)fromNode.getWidth() * 0.75);
                cp.y = tp.y > fp.y ? (int)((double)tp.y + (double)toNode.getHeight() * 0.25) : (int)((double)tp.y - (double)toNode.getHeight() * 0.25);
            } else {
                cp.x = (int)((double)tp.x - (double)toNode.getWidth() * 0.75);
                cp.y = fp.y > tp.y ? (int)((double)fp.y + (double)fromNode.getHeight() * 0.25) : (int)((double)fp.y - (double)fromNode.getHeight() * 0.25);
            }
        }
        pdcl.setControlPoint(cp);
    }
}

