/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.util.layout;

import com.sas.graphics.components.util.layout.NodeInfoExtension;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import java.util.ArrayList;
import java.util.Vector;

class NodeInfo {
    NodeLayoutInterface node;
    public static final int UNASSIGNED = -1;
    int id;
    int col = -1;
    int depth = -1;
    int layer = -1;
    int label = -1;
    int layersize = 1;
    int colsize = 1;
    int diagramId = -1;
    Vector inEdges = null;
    double[] inports = null;
    Vector outEdges = null;
    double[] outports = null;
    boolean ignore = false;
    boolean dummy = false;
    boolean revDummy = false;
    boolean shuffled = false;
    NodeInfo attachedTo = null;
    int leafAt = -1;
    boolean countCrossings = true;
    ArrayList children = null;

    protected NodeInfo(NodeLayoutInterface n) {
        this.node = n;
    }

    public NodeInfo(NodeLayoutInterface n, int aid) {
        this.node = n;
        this.id = aid;
        this.inEdges = new Vector();
        this.outEdges = new Vector();
    }

    public void setLayer(int newLayer) {
        this.layer = newLayer;
        this.setChildrenLayer();
    }

    public void setColumn(int newColumn) {
        this.col = newColumn;
        this.setChildrenColumn();
    }

    public void setLeafAt(int newLeafAt) {
        if (this.leafAt != newLeafAt) {
            this.leafAt = newLeafAt;
            if (this.children != null) {
                for (int i = 0; i < this.children.size(); ++i) {
                    NodeInfoExtension ni = (NodeInfoExtension)this.children.get(i);
                    ni.leafAt = this.leafAt;
                }
            }
        }
    }

    private void setChildrenLayer() {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                NodeInfoExtension ni = (NodeInfoExtension)this.children.get(i);
                ni.layer = this.layer + ni.layerOffset;
            }
        }
    }

    private void setChildrenColumn() {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                NodeInfoExtension ni = (NodeInfoExtension)this.children.get(i);
                ni.col = this.col + ni.colOffset;
            }
        }
    }

    public NodeInfo getChild(int lo, int co) {
        if (lo == 0 && co == 0) {
            return this;
        }
        if (lo < 0 || lo >= this.layersize) {
            return null;
        }
        if (co < 0 || co >= this.colsize) {
            return null;
        }
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                NodeInfoExtension nie = (NodeInfoExtension)this.children.get(i);
                if (nie.layerOffset != lo || nie.colOffset != co) continue;
                return nie;
            }
        }
        return null;
    }
}

