/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.util.layout;

import com.sas.graphics.components.util.layout.Node;

class List {
    int size = 0;
    Node first = null;
    Node last = null;

    List() {
    }

    void insertFirst(Node n) {
        ++this.size;
        if (this.size == 1) {
            this.first = this.last = n;
        } else {
            Node temp = this.first;
            this.first = n;
            this.first.next = temp;
        }
    }

    void insert(Node n) {
        ++this.size;
        if (this.size == 1) {
            this.first = this.last = n;
        } else {
            this.last.next = n;
            this.last = n;
        }
    }

    void insertAscending(Node n) {
        ++this.size;
        if (this.size == 1) {
            this.first = this.last = n;
        } else if (this.first.val > n.val) {
            n.next = this.first;
            this.first = n;
        } else {
            Node n1 = this.first;
            Node n2 = this.first.next;
            while (n2 != null && n.val > n2.val) {
                n1 = n2;
                n2 = n1.next;
            }
            n1.next = n;
            n.next = n2;
            if (n2 == null) {
                this.last = n;
            }
        }
    }

    void insertByLocation(Node n) {
        ++this.size;
        if (this.size == 1) {
            this.first = this.last = n;
        } else if (this.first.location > n.location) {
            n.next = this.first;
            this.first = n;
        } else {
            Node n1 = this.first;
            Node n2 = this.first.next;
            while (n2 != null && n.location >= n2.location) {
                n1 = n2;
                n2 = n1.next;
            }
            n1.next = n;
            n.next = n2;
            if (n2 == null) {
                this.last = n;
            }
        }
    }

    Node remove(Node n) {
        Node curr = this.first.next;
        if (n == this.first) {
            this.first = curr;
            --this.size;
            return n;
        }
        Node prev = this.first;
        while (curr != null) {
            if (curr == n) {
                prev.next = curr.next;
                --this.size;
                break;
            }
            prev = curr;
            curr = prev.next;
        }
        return curr;
    }

    void removeValue(int aval) {
        if (this.size == 0) {
            return;
        }
        Node curr = this.first;
        while (this.size != 0 && curr.val == aval) {
            curr = curr.next;
            --this.size;
        }
        this.first = curr;
        if (this.size == 0) {
            return;
        }
        Node prev = this.first;
        curr = this.first.next;
        while (curr != null) {
            if (curr.val == aval) {
                prev.next = curr = curr.next;
                --this.size;
                continue;
            }
            prev = curr;
            curr = prev.next;
        }
    }

    Node remove(int n) {
        Node curr = this.first.next;
        Node prev = this.first;
        if (n == this.first.val) {
            this.first = curr;
            --this.size;
            return prev;
        }
        while (curr != null) {
            if (curr.val == n) {
                prev.next = curr.next;
                --this.size;
                break;
            }
            prev = curr;
            curr = prev.next;
        }
        return curr;
    }

    void removeAll() {
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{");
        Node curr = this.first;
        int i = 0;
        while (curr != null) {
            sb.append(curr.val + ", ");
            curr = curr.next;
            ++i;
        }
        sb.append("}");
        return new String(sb);
    }
}

