/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.util.layout;

import com.sas.graphics.components.pfd.PFDPathDiagramGroupNode;
import com.sas.graphics.components.util.layout.DummyLink;
import com.sas.graphics.components.util.layout.LayoutStrategy;
import com.sas.graphics.components.util.layout.List;
import com.sas.graphics.components.util.layout.Node;
import com.sas.graphics.components.util.layout.NodeInfo;
import com.sas.graphics.components.util.layout.NodeInfoExtension;
import com.sas.graphics.components.util.layout.PlaceHolder;
import com.sas.graphics.components.util.layout.Sort;
import com.sas.graphics.components.util.layout.SubdiagramNodeInfo;
import com.sas.graphics.interfaces.LayeredLayoutStrategyInterface;
import com.sas.graphics.interfaces.LinkLayoutInterface;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.graphics.interfaces.NodeLinkDiagramLayoutInterface;
import com.sas.graphics.interfaces.SubdiagramNodeLayoutInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Stack;
import java.util.Vector;

public class LayeredLayoutStrategy
extends LayoutStrategy
implements LayeredLayoutStrategyInterface,
PropertyInterface {
    private static final int UP = 0;
    private static final int DOWN = 1;
    private static final int LEFT = 2;
    private static final int RIGHT = 3;
    private static final int RUP = 5;
    private static final int RDOWN = 6;
    private static final int RLEFT = 7;
    private static final int RRIGHT = 8;
    private static final int IN = 0;
    private static final int OUT = 1;
    private static final int ALL = 2;
    private static final int OPTIMAL = 2;
    private static final int GREEDY = 1;
    private static final int SOURCE = 0;
    private static final int SINK = 1;
    protected int layerSize = -1;
    protected int maxLayerWidth;
    protected int maxLayerWidthIndex;
    protected int userLayers = -1;
    protected int initAlgo = 2;
    protected int crAlgo = 2;
    protected int layerOption = 2;
    private static final boolean DEBUG_PRINT = false;
    private static final int LEAVES_OUTSIDE = 0;
    private static final int LEAVES_INSIDE = 1;
    private static final int LEAVES_ALGO_NONE = 2;
    private static final int NUM_ALGO = 3;
    private static final int FORWARD_ASCENDING = 0;
    private static final int FORWARD_DESCENDING = 1;
    private static final int BACKWARD_ASCENDING = 2;
    private static final int BACKWARD_DESCENDING = 3;
    private static final int FIRST_STATE = 0;
    private static final int FIRST_BACKWARD = 2;
    private static final int LAST_STATE = 3;
    private static final int NUM_STATES = 4;
    protected int orientation = 3;
    protected int prevOrientation = 3;
    protected int gridWidth = 33;
    protected int gridHeight = 33;
    protected double colGridSpace = 1.0;
    protected double layerGridSpace = 2.0;
    protected int xGridBorder = 2;
    protected int yGridBorder = 2;
    protected boolean layeringDone = false;
    protected int totalNodes;
    protected boolean varsize = false;
    protected boolean varcols = false;
    protected boolean varlayers = false;
    protected Vector dummyLinks = new Vector();
    protected Vector selfLinks = new Vector();
    protected Vector islands = new Vector();
    protected boolean islandsOnly = false;
    protected int moveLeavesAlgo = 0;
    protected boolean wideTreeAlgo = false;
    protected boolean hasMultiPorts = false;
    protected Vector subdiagrams = new Vector();
    protected Vector subdiagramInfo = new Vector();
    protected Hashtable subdiagramDummyLinkMap;
    protected PropertyList pending = null;
    protected boolean firstTime = true;
    protected Hashtable revlinks = new Hashtable();
    protected Hashtable cycleNodes = new Hashtable();
    protected List allroots;
    protected Vector droots;
    protected List roots;
    protected boolean revtree;
    private Hashtable lookup = new Hashtable();
    protected Vector allinfo;
    Vector diagrams;
    protected Vector ninfo;
    int maxcolsize;
    int maxlayersize;
    int numDiagrams;
    protected boolean reuse = false;
    protected boolean assignNewOnly = false;
    int columnOffset;
    int layerOffset;
    NodeInfo columnOffsetNode;
    NodeInfo layerOffsetNode;
    protected int numLayers;
    protected int maxDummyWidth;
    boolean leavesAssigned = false;
    private int[] dummyWidth;
    int maxSize = 0;
    protected int minrow = 0;
    protected int maxrow = 0;
    protected int crossings;
    protected int prevcross;
    protected Vector[] pos;
    protected int[] layerWidth;
    protected Vector[][] allPos;
    protected int[][] allLayerWidth;
    boolean newLayout = true;
    int minimumX;
    int minimumY;
    boolean forceNewLayout = false;

    public LayeredLayoutStrategy() {
        this.numIterations = 10;
        this.pending = new PropertyList();
    }

    @Override
    public String getFlowDirection() {
        String rv = null;
        switch (this.orientation) {
            case 0: {
                rv = "Up";
                break;
            }
            case 1: {
                rv = "Down";
                break;
            }
            default: {
                rv = "Left";
                break;
            }
            case 3: {
                rv = "Right";
            }
        }
        return rv;
    }

    @Override
    public void setFlowDirection(String x) {
        this.orientation = x.equalsIgnoreCase("Left") ? 2 : (x.equalsIgnoreCase("Up") ? 0 : (x.equalsIgnoreCase("Down") ? 1 : 3));
        if (this.assignNewOnly && this.prevOrientation == -1) {
            this.prevOrientation = this.orientation;
        }
    }

    @Override
    public void setBetweenLayerSpace(int pixels) {
    }

    @Override
    public int getBetweenLayerSpace() {
        return 0;
    }

    @Override
    public void setWithinLayerSpace(int pixels) {
    }

    @Override
    public int getWithinLayerSpace() {
        return 0;
    }

    @Override
    public void setLayerSize(int num) {
        this.userLayers = num;
    }

    @Override
    public int getLayerSize() {
        return this.userLayers;
    }

    @Override
    public void setReferenceNodeSize(int x, int y) {
    }

    public int getReferenceNodeWidth() {
        return 0;
    }

    public int getReferenceNodeHeight() {
        return 0;
    }

    @Override
    public void setInitializationAlgorithm(String name) {
        this.initAlgo = name.equalsIgnoreCase("DepthFirstInward") ? 0 : (name.equalsIgnoreCase("DepthFirstOutward") ? 1 : 2);
    }

    @Override
    public String getInitializationAlgorithm() {
        String name = "";
        switch (this.initAlgo) {
            case 0: {
                name = "DepthFirstInward";
                break;
            }
            case 1: {
                name = "DepthFirstOutward";
                break;
            }
            default: {
                name = "Optimal";
            }
        }
        return name;
    }

    @Override
    public void setCycleRemovalAlgorithm(String name) {
        this.crAlgo = name.equalsIgnoreCase("Greedy") ? 1 : 2;
    }

    @Override
    public String getCycleRemovalAlgorithm() {
        String name;
        switch (this.crAlgo) {
            case 1: {
                name = "Greedy";
                break;
            }
            default: {
                name = "Optimal";
            }
        }
        return name;
    }

    @Override
    public void setLayeringOption(String name) {
        this.layerOption = name.equalsIgnoreCase("Source") ? 0 : (name.equalsIgnoreCase("Sink") ? 1 : 2);
    }

    @Override
    public String getLayeringOption() {
        String name;
        switch (this.layerOption) {
            case 0: {
                name = "Source";
                break;
            }
            case 1: {
                name = "Sink";
                break;
            }
            default: {
                name = "Optimal";
            }
        }
        return name;
    }

    @Override
    public void setModel(NodeLinkDiagramLayoutInterface m) {
        super.setModel(m);
        this.layeringDone = false;
    }

    @Override
    public void arrange(boolean update) {
        if (update || !this.layeringDone || this.varcols || this.varlayers) {
            this.arrange();
        } else {
            if (this.nodes == null || this.nodes.isEmpty()) {
                return;
            }
            switch (this.orientation) {
                default: {
                    this.model.setFlowDirection("Right");
                    break;
                }
                case 2: {
                    this.model.setFlowDirection("Left");
                    break;
                }
                case 0: {
                    this.model.setFlowDirection("Up");
                    break;
                }
                case 1: {
                    this.model.setFlowDirection("Down");
                }
            }
            this.assignCoords();
        }
    }

    private void checkNodeOrtho(boolean flag) {
        int size = this.links.size();
        for (int i = 0; i < size; ++i) {
            LinkLayoutInterface arc = (LinkLayoutInterface)this.links.elementAt(i);
            arc.setOrthogonal(flag);
        }
    }

    @Override
    public boolean arrange() {
        if (this.model == null) {
            return false;
        }
        if (this.assignNewOnly && this.prevOrientation == -1) {
            this.prevOrientation = this.orientation;
        }
        boolean redo = true;
        this.firstTime = true;
        while (redo) {
            int num;
            NodeInfo ni;
            redo = false;
            this.doSetupModel();
            if (this.nodes == null || this.nodes.isEmpty()) {
                return false;
            }
            this.totalNodes = this.numNodes;
            switch (this.orientation) {
                default: {
                    this.model.setFlowDirection("Right");
                    break;
                }
                case 2: {
                    this.model.setFlowDirection("Left");
                    break;
                }
                case 0: {
                    this.model.setFlowDirection("Up");
                    break;
                }
                case 1: {
                    this.model.setFlowDirection("Down");
                }
            }
            this.setData();
            this.layoutSubdiagrams();
            this.breakBigNodes();
            int tempmax = 0;
            int maxLayer = -1;
            if (!this.islandsOnly) {
                this.removeCycles();
                this.assignLayers();
                this.optimizeLayers();
                this.createDummyNodes();
                this.allPos = new Vector[this.numDiagrams][this.numLayers];
                this.allLayerWidth = new int[this.numDiagrams][this.numLayers];
                for (int i = 0; i < this.numDiagrams; ++i) {
                    for (int j = 0; j < this.numLayers; ++j) {
                        this.allLayerWidth[i][j] = 0;
                        this.allPos[i][j] = new Vector();
                    }
                }
                int offset = 0;
                this.minrow = 0;
                this.maxrow = 0;
                int prevmax = -1;
                int numNonIslandDiagrams = this.numDiagrams - this.islands.size();
                for (int i = 0; i < numNonIslandDiagrams; ++i) {
                    this.ninfo = (Vector)this.diagrams.elementAt(i);
                    this.roots = (List)this.droots.elementAt(i);
                    this.layerWidth = this.allLayerWidth[i];
                    this.pos = this.allPos[i];
                    this.assignUniformRows();
                    if (!this.assignNewOnly && !this.newLayout && this.crossings != 0) {
                        this.forceNewLayout = true;
                        return this.arrange();
                    }
                    if (this.firstTime && this.numDiagrams > 1) {
                        redo |= this.maxrow - this.minrow >= this.maxSize;
                    }
                    offset -= this.minrow;
                    this.maxrow = 0;
                    for (int j = 0; j < this.ninfo.size(); ++j) {
                        ni = (NodeInfo)this.ninfo.elementAt(j);
                        if (ni == null) continue;
                        ni.col += offset;
                        this.maxrow = Math.max(this.maxrow, ni.col);
                        maxLayer = Math.max(maxLayer, ni.layer);
                    }
                    offset = this.maxrow + 1;
                    prevmax = tempmax = Math.max(tempmax, offset);
                }
            } else {
                maxLayer = this.userLayers == -1 ? 32 : this.userLayers;
                int tempNumLayers = Math.max(this.maxlayersize, maxLayer + 1);
                this.allPos = new Vector[this.numDiagrams][tempNumLayers];
                this.allLayerWidth = new int[this.numDiagrams][tempNumLayers];
                for (int i = 0; i < this.numDiagrams; ++i) {
                    for (int j = 0; j < tempNumLayers; ++j) {
                        this.allLayerWidth[i][j] = 0;
                        this.allPos[i][j] = new Vector();
                    }
                }
            }
            if ((num = this.islands.size()) > 0) {
                int colSize = 1;
                int curLayer = 0;
                int curCol = tempmax;
                for (int i = 0; i < num; ++i) {
                    ni = (NodeInfo)this.islands.elementAt(i);
                    if (!this.assignNewOnly || !ni.node.isNodePlaced()) {
                        if (curLayer + ni.layersize - 1 > maxLayer) {
                            curLayer = 0;
                            curCol += colSize;
                            colSize = 1;
                        }
                        ni.setColumn(curCol);
                        ni.setLayer(curLayer);
                        curLayer += ni.layersize;
                    }
                    colSize = Math.max(colSize, ni.colsize);
                    this.numLayers = Math.max(this.numLayers, ni.layer + ni.layersize);
                    for (int j = 0; j < ni.layersize; ++j) {
                        Vector v = this.allPos[ni.diagramId][ni.layer + j];
                        for (int k = 0; k < ni.colsize; ++k) {
                            NodeInfo nk = ni.getChild(j, k);
                            v.addElement(nk);
                        }
                        this.allLayerWidth[ni.diagramId][ni.layer + j] = v.size();
                    }
                }
                tempmax = curCol + colSize;
                this.totalNodes = this.allinfo.size();
            }
            this.minrow = 0;
            this.maxrow = tempmax;
            this.assignCoords();
            this.firstTime = false;
        }
        this.layeringDone = true;
        this.forceNewLayout = false;
        return true;
    }

    protected void setData() {
        int width;
        Vector v;
        NodeInfo To;
        LinkLayoutInterface arc;
        int i;
        NodeInfo From;
        NodeLayoutInterface n1;
        int k;
        this.lookup.clear();
        this.dummyLinks.removeAllElements();
        this.selfLinks.removeAllElements();
        this.islands.removeAllElements();
        this.islandsOnly = false;
        int[] sortedList = new int[this.numNodes];
        this.allinfo = new Vector();
        this.allinfo.setSize(this.numNodes);
        this.subdiagramInfo.clear();
        int count = Math.min(10, this.numNodes);
        int segLength = 0;
        for (k = 0; k < count; ++k) {
            n1 = (NodeLayoutInterface)this.nodes.elementAt(k);
            if (!n1.isVisible()) continue;
            segLength = Math.max(segLength, n1.getOutputEndSegmentLength());
            segLength = Math.max(segLength, n1.getInputEndSegmentLength());
        }
        segLength *= 2;
        for (k = 0; k < this.numNodes; ++k) {
            n1 = (NodeLayoutInterface)this.nodes.elementAt(k);
            if (!n1.isVisible()) continue;
            if (n1 instanceof SubdiagramNodeLayoutInterface) {
                From = new SubdiagramNodeInfo((SubdiagramNodeLayoutInterface)n1, k, this);
                this.subdiagramInfo.add(From);
            } else {
                From = new NodeInfo(n1, k);
            }
            this.allinfo.setElementAt(From, k);
        }
        Vector<LinkLayoutInterface> dups = new Vector<LinkLayoutInterface>();
        for (i = 0; i < this.numLinks; ++i) {
            arc = (LinkLayoutInterface)this.links.elementAt(i);
            if (!arc.isVisible()) continue;
            n1 = arc.getTopFromNode();
            NodeLayoutInterface n2 = arc.getTopToNode();
            if (!n1.isVisible() || !n2.isVisible()) continue;
            int from = this.nodes.indexOf(n1);
            int to = this.nodes.indexOf(n2);
            From = (NodeInfo)this.allinfo.elementAt(from);
            To = (NodeInfo)this.allinfo.elementAt(to);
            if (n1 == n2) {
                Vector<Object> self = new Vector<Object>();
                self.addElement(arc);
                self.addElement(From);
                this.selfLinks.addElement(self);
                continue;
            }
            if (this.assignNewOnly && arc.isCustomBreakPointsUsed()) {
                NodeInfo dummy;
                NodeLayoutInterface node;
                if (this.lookup.get(from + "," + to) != null) {
                    LinkLayoutInterface duparc = (LinkLayoutInterface)this.lookup.get(from + "," + to);
                    if (duparc.isCustomBreakPointsUsed() || !arc.isCustomBreakPointsUsed()) {
                        dups.add(arc);
                        continue;
                    }
                    dups.add(duparc);
                    this.lookup.put(from + "," + to, arc);
                } else {
                    this.lookup.put(from + "," + to, arc);
                }
                Point[] points = arc.getBreakPoints();
                NodeInfo fi = From;
                Point pp = From.node.getCenterLocation();
                boolean horzlayout = this.prevOrientation == 3 || this.prevOrientation == 2;
                int lext = horzlayout ? this.gridWidth : this.gridHeight;
                for (int j = 0; j < points.length; ++j) {
                    if (horzlayout) {
                        if (Math.abs(points[j].x - pp.x) > lext) {
                            int factor = points[j].x > pp.x ? 1 : -1;
                            int y = points[j].y;
                            while (factor * (points[j].x - pp.x) > lext) {
                                pp = new Point(pp.x + factor * lext, y);
                                node = this.model.createDummyNode(this.gridWidth, this.gridHeight);
                                this.nodes.addElement(node);
                                node.setCenterLocation(pp);
                                node.setNodePlaced(true);
                                dummy = new NodeInfo(node, this.allinfo.size());
                                dummy.dummy = true;
                                fi.outEdges.add(dummy);
                                dummy.inEdges.add(fi);
                                this.allinfo.add(dummy);
                                fi = dummy;
                            }
                        }
                    } else if (Math.abs(points[j].y - pp.y) > lext) {
                        int factor = points[j].y > pp.y ? 1 : -1;
                        int x = points[j].x;
                        while (factor * (points[j].y - pp.y) > lext) {
                            pp = new Point(x, pp.y + factor * lext);
                            node = this.model.createDummyNode(this.gridWidth, this.gridHeight);
                            this.nodes.addElement(node);
                            node.setCenterLocation(pp);
                            node.setNodePlaced(true);
                            dummy = new NodeInfo(node, this.allinfo.size());
                            dummy.dummy = true;
                            fi.outEdges.add(dummy);
                            dummy.inEdges.add(fi);
                            this.allinfo.add(dummy);
                            fi = dummy;
                        }
                    }
                    NodeLayoutInterface node2 = this.model.createDummyNode(this.gridWidth, this.gridHeight);
                    this.nodes.addElement(node2);
                    node2.setCenterLocation(points[j]);
                    node2.setNodePlaced(true);
                    NodeInfo dummy2 = new NodeInfo(node2, this.allinfo.size());
                    dummy2.dummy = true;
                    fi.outEdges.add(dummy2);
                    dummy2.inEdges.add(fi);
                    this.allinfo.add(dummy2);
                    fi = dummy2;
                    pp = points[j];
                }
                Point tpnt = To.node.getCenterLocation();
                if (horzlayout) {
                    if (Math.abs(tpnt.x - pp.x) > lext) {
                        int factor = tpnt.x > pp.x ? 1 : -1;
                        int y = pp.y;
                        while (factor * (tpnt.x - pp.x) > lext) {
                            pp = new Point(pp.x + factor * lext, y);
                            node = this.model.createDummyNode(this.gridWidth, this.gridHeight);
                            this.nodes.addElement(node);
                            node.setCenterLocation(pp);
                            node.setNodePlaced(true);
                            dummy = new NodeInfo(node, this.allinfo.size());
                            dummy.dummy = true;
                            fi.outEdges.add(dummy);
                            dummy.inEdges.add(fi);
                            this.allinfo.add(dummy);
                            fi = dummy;
                        }
                    }
                } else if (Math.abs(tpnt.y - pp.y) > lext) {
                    int factor = tpnt.y > pp.y ? 1 : -1;
                    int x = tpnt.x;
                    while (factor * (tpnt.y - pp.y) > lext) {
                        pp = new Point(x, pp.y + factor * lext);
                        node = this.model.createDummyNode(this.gridWidth, this.gridHeight);
                        this.nodes.addElement(node);
                        node.setCenterLocation(pp);
                        node.setNodePlaced(true);
                        dummy = new NodeInfo(node, this.allinfo.size());
                        dummy.dummy = true;
                        fi.outEdges.add(dummy);
                        dummy.inEdges.add(fi);
                        this.allinfo.add(dummy);
                        fi = dummy;
                    }
                }
                To.inEdges.add(fi);
                fi.outEdges.add(To);
                continue;
            }
            if (this.lookup.get(from + "," + to) != null) {
                dups.add(arc);
                continue;
            }
            v = From.outEdges;
            v.addElement(To);
            v = To.inEdges;
            v.addElement(From);
            this.lookup.put(from + "," + to, arc);
        }
        if (dups.size() > 0) {
            for (int ii = 0; ii < dups.size(); ++ii) {
                arc = (LinkLayoutInterface)dups.get(ii);
                this.links.remove(arc);
            }
            this.numLinks = this.links.size();
        }
        boolean horz = this.orientation == 3 || this.orientation == 2;
        this.hasMultiPorts = false;
        for (int k2 = 0; k2 < this.numNodes; ++k2) {
            int l;
            int l2;
            Point anchor;
            Point[] array;
            double min;
            double max;
            n1 = (NodeLayoutInterface)this.nodes.elementAt(k2);
            if (!n1.isVisible()) continue;
            NodeInfo n = (NodeInfo)this.allinfo.get(k2);
            if (n.inEdges.size() > 1) {
                max = 0.0;
                min = 2.147483647E9;
                int insize = n.inEdges.size();
                array = new Point[insize];
                double[] inports = new double[insize];
                anchor = new Point(0, 0);
                for (l2 = 0; l2 < insize; ++l2) {
                    From = (NodeInfo)n.inEdges.elementAt(l2);
                    arc = (LinkLayoutInterface)this.lookup.get(this.allinfo.indexOf(From) + "," + k2);
                    array[l2] = new Point();
                    arc.getToLinkPoint(anchor, array[l2]);
                    inports[l2] = horz ? (double)array[l2].y : (double)array[l2].x;
                    max = Math.max(max, inports[l2]);
                    min = Math.min(min, inports[l2]);
                }
                if (min != max) {
                    double factor = 0.1 / (max - min);
                    for (l = 0; l < insize; ++l) {
                        inports[l] = (inports[l] - min) * factor;
                    }
                    n.inports = inports;
                    this.hasMultiPorts = true;
                }
            }
            if (n.outEdges.size() <= 1) continue;
            max = 0.0;
            min = 2.147483647E9;
            int outsize = n.outEdges.size();
            array = new Point[outsize];
            double[] outports = new double[outsize];
            anchor = new Point(0, 0);
            for (l2 = 0; l2 < outsize; ++l2) {
                To = (NodeInfo)n.outEdges.elementAt(l2);
                arc = (LinkLayoutInterface)this.lookup.get(k2 + "," + this.allinfo.indexOf(To));
                array[l2] = new Point();
                arc.getFromLinkPoint(anchor, array[l2]);
                outports[l2] = horz ? (double)array[l2].y : (double)array[l2].x;
                max = Math.max(max, outports[l2]);
                min = Math.min(min, outports[l2]);
            }
            if (min == max) continue;
            double factor = 0.1 / (max - min);
            for (l = 0; l < outsize; ++l) {
                outports[l] = (outports[l] - min) * factor;
            }
            n.outports = outports;
            this.hasMultiPorts = true;
        }
        this.varsize = false;
        this.maxlayersize = 1;
        this.maxcolsize = 1;
        this.varlayers = false;
        this.varcols = false;
        this.varsize = false;
        if (this.orientation == 0 || this.orientation == 1) {
            for (i = 0; i < this.numNodes; ++i) {
                int height;
                From = (NodeInfo)this.allinfo.elementAt(i);
                if (From == null || From instanceof SubdiagramNodeInfo) continue;
                width = From.node.getLayoutWidth() + (int)((double)this.gridWidth * this.colGridSpace);
                if (width > this.gridWidth) {
                    From.colsize = (int)Math.ceil((double)width / (double)this.gridWidth);
                    this.maxcolsize = Math.max(From.colsize, this.maxcolsize);
                }
                if ((height = From.node.getLayoutHeight() + (int)((double)this.gridHeight * this.layerGridSpace)) > this.gridHeight) {
                    From.layersize = (int)Math.ceil((double)height / (double)this.gridHeight);
                    this.maxlayersize = Math.max(From.layersize, this.maxlayersize);
                }
                if (this.varsize) continue;
                this.varsize = From.colsize > 1 && From.layersize > 1;
            }
        } else {
            for (i = 0; i < this.numNodes; ++i) {
                int height;
                From = (NodeInfo)this.allinfo.elementAt(i);
                if (From == null || From instanceof SubdiagramNodeInfo) continue;
                width = From.node.getLayoutWidth() + (int)((double)this.gridWidth * this.layerGridSpace);
                if (width > this.gridWidth) {
                    From.layersize = (int)Math.ceil((double)width / (double)this.gridWidth);
                    this.maxlayersize = Math.max(From.layersize, this.maxlayersize);
                }
                if ((height = From.node.getLayoutHeight() + (int)((double)this.gridHeight * this.colGridSpace)) > this.gridHeight) {
                    From.colsize = (int)Math.ceil((double)height / (double)this.gridHeight);
                    this.maxcolsize = Math.max(From.colsize, this.maxcolsize);
                }
                if (this.varsize) continue;
                this.varsize = From.colsize > 1 && From.layersize > 1;
            }
        }
        this.varcols = this.maxcolsize > 1;
        this.varlayers = this.maxlayersize > 1;
        this.allroots = new List();
        List leaves = new List();
        for (i = 0; i < this.numNodes; ++i) {
            Node n;
            NodeInfo ni = (NodeInfo)this.allinfo.elementAt(i);
            if (ni == null) continue;
            if (ni.inEdges.size() + ni.outEdges.size() == 0) {
                this.islands.addElement(ni);
                continue;
            }
            if (ni.inEdges.size() == 0) {
                n = new Node(i);
                if (this.reuse && !this.forceNewLayout) {
                    n.location = this.getColumnIndex(ni);
                    this.allroots.insertByLocation(n);
                    continue;
                }
                this.allroots.insert(n);
                continue;
            }
            if (ni.outEdges.size() != 0) continue;
            n = new Node(i);
            leaves.insert(n);
        }
        if (this.islands.size() == this.numNodes) {
            this.islandsOnly = true;
            this.numDiagrams = 0;
            this.diagrams = new Vector();
            this.assignIslandDiagrams();
            return;
        }
        this.newLayout = true;
        if (this.assignNewOnly) {
            this.getAssignedLayersAndColumns();
        } else if (this.reuse && !this.forceNewLayout) {
            this.getPreviousColumns();
        }
        if (this.newLayout) {
            this.revtree = this.allroots.size == 1 || leaves.size == 0 || this.hasMultiPorts ? false : this.layerOption == 1 || this.layerOption == 2 && this.allroots.size > leaves.size;
        } else if (this.assignNewOnly) {
            this.revtree = false;
        }
        if (this.initAlgo == 0) {
            this.revtree = !this.revtree;
        }
        if (this.revtree) {
            for (i = 0; i < this.numNodes; ++i) {
                NodeInfo ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null) continue;
                v = ni.inEdges;
                ni.inEdges = ni.outEdges;
                ni.outEdges = v;
            }
            this.allroots = leaves;
        }
        if (this.allroots.size == 0) {
            Node n;
            if (!this.newLayout) {
                n = new Node(this.getRootIndex());
            } else {
                int rootIndex = 0;
                NodeInfo ni = (NodeInfo)this.allinfo.elementAt(0);
                int maxDiff = ni.outEdges.size() - ni.inEdges.size();
                for (i = 1; i < this.numNodes; ++i) {
                    int delta;
                    ni = (NodeInfo)this.allinfo.elementAt(i);
                    if (ni == null || (delta = ni.outEdges.size() - ni.inEdges.size()) <= maxDiff) continue;
                    maxDiff = delta;
                    rootIndex = i;
                }
                n = new Node(rootIndex);
            }
            this.allroots.insert(n);
        }
        this.assignDepthFromRoot(this.allroots.first);
        for (i = 0; i < this.numNodes; ++i) {
            int j;
            NodeInfo ni = (NodeInfo)this.allinfo.elementAt(i);
            if (ni == null || ni.depth > -1 || this.islands.contains(ni)) continue;
            v = ni.inEdges;
            boolean found = false;
            for (j = 0; j < v.size(); ++j) {
                From = (NodeInfo)v.elementAt(j);
                if (From.depth <= -1) continue;
                found = true;
                break;
            }
            v = ni.outEdges;
            for (j = 0; j < v.size() && !found; ++j) {
                From = (NodeInfo)v.elementAt(j);
                if (From.depth <= -1) continue;
                found = true;
                break;
            }
            if (found) continue;
            Node n = new Node(i);
            this.allroots.insert(n);
            this.assignDepthFromRoot(n);
        }
        this.revlinks.clear();
        this.cycleNodes.clear();
        for (i = 0; i < this.numNodes; ++i) {
            int j;
            NodeInfo ni = (NodeInfo)this.allinfo.elementAt(i);
            if (ni == null || ni.depth > -1) continue;
            v = ni.inEdges;
            Vector v1 = ni.outEdges;
            boolean noreverse = true;
            if (this.revtree) {
                for (j = 0; j < v.size(); ++j) {
                    From = (NodeInfo)v.elementAt(j);
                    arc = (LinkLayoutInterface)this.lookup.get(ni.id + "," + From.id);
                    if (arc != null) continue;
                    noreverse = false;
                    break;
                }
            } else {
                for (j = 0; j < v.size(); ++j) {
                    From = (NodeInfo)v.elementAt(j);
                    arc = (LinkLayoutInterface)this.lookup.get(From.id + "," + ni.id);
                    if (arc != null) continue;
                    noreverse = false;
                    break;
                }
            }
            if (!noreverse) continue;
            for (j = 0; j < v.size(); ++j) {
                From = (NodeInfo)v.elementAt(j);
                if (this.revtree) {
                    arc = (LinkLayoutInterface)this.lookup.get(ni.id + "," + From.id);
                    this.revlinks.put(ni.id + "," + From.id, arc);
                } else {
                    arc = (LinkLayoutInterface)this.lookup.get(From.id + "," + ni.id);
                    this.revlinks.put(From.id + "," + ni.id, arc);
                }
                v1.addElement(From);
                Vector v2 = From.outEdges;
                v2.remove(ni);
                v2 = From.inEdges;
                v2.addElement(ni);
            }
            v.removeAllElements();
        }
        this.assignDiagrams();
        this.assignIslandDiagrams();
    }

    private void getPreviousColumns() {
        int xmin;
        int num = this.allinfo.size();
        Point[] points = new Point[num];
        int ymin = xmin = Integer.MAX_VALUE;
        NodeInfo xnode = null;
        NodeInfo ynode = null;
        for (int i = 0; i < num; ++i) {
            NodeInfo ni = (NodeInfo)this.allinfo.elementAt(i);
            if (ni == null || !ni.node.isNodePlaced()) continue;
            this.newLayout = false;
            points[i] = ni.node.getCenterLocation();
            if (points[i].x < xmin) {
                xmin = points[i].x;
                xnode = ni;
            }
            if (points[i].y >= ymin) continue;
            ymin = points[i].y;
            ynode = ni;
        }
        if (this.newLayout) {
            return;
        }
        if (this.prevOrientation < 2) {
            int hspace = this.gridWidth;
            int vspace = this.gridHeight;
            if (ymin == Integer.MAX_VALUE) {
                this.layerOffset = 0;
                this.layerOffsetNode = null;
            } else {
                if (this.prevOrientation == this.orientation) {
                    ymin %= vspace;
                }
                this.layerOffset = ymin - vspace / 2;
                this.layerOffsetNode = ynode;
            }
            if (xmin == Integer.MAX_VALUE) {
                this.columnOffset = 0;
                this.columnOffsetNode = null;
            } else {
                if (this.prevOrientation == this.orientation) {
                    xmin %= hspace;
                }
                this.columnOffset = xmin - hspace / 2;
                this.columnOffsetNode = xnode;
            }
            for (int i = 0; i < num; ++i) {
                NodeInfo ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null || points[i] == null) continue;
                ni.col = (points[i].x - xmin) / hspace;
            }
        } else {
            int vspace = this.gridHeight;
            int hspace = this.gridWidth;
            if (ymin == Integer.MAX_VALUE) {
                this.columnOffset = 0;
                this.columnOffsetNode = null;
            } else {
                if (this.prevOrientation == this.orientation) {
                    ymin %= vspace;
                }
                this.columnOffset = ymin - vspace / 2;
                this.columnOffsetNode = ynode;
            }
            if (xmin == Integer.MAX_VALUE) {
                this.layerOffset = 0;
                this.layerOffsetNode = null;
            } else {
                if (this.prevOrientation == this.orientation) {
                    xmin %= hspace;
                }
                this.layerOffset = xmin - hspace / 2;
                this.layerOffsetNode = xnode;
            }
            for (int i = 0; i < num; ++i) {
                NodeInfo ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null || points[i] == null) continue;
                ni.col = (points[i].y - ymin) / vspace;
            }
        }
    }

    private int getRootIndex() {
        int index = 0;
        if (this.prevOrientation == 0) {
            int max = Integer.MIN_VALUE;
            for (int i = 0; i < this.numNodes; ++i) {
                NodeInfo ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null || !ni.node.isNodePlaced()) continue;
                Point p = ni.node.getCenterLocation();
                if (p.y <= max) continue;
                index = i;
                max = p.y;
            }
        } else if (this.prevOrientation == 1) {
            int min = Integer.MAX_VALUE;
            for (int i = 0; i < this.numNodes; ++i) {
                NodeInfo ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null || !ni.node.isNodePlaced()) continue;
                Point p = ni.node.getCenterLocation();
                if (p.y >= min) continue;
                index = i;
                min = p.y;
            }
        } else if (this.prevOrientation == 2) {
            int max = Integer.MIN_VALUE;
            for (int i = 0; i < this.numNodes; ++i) {
                NodeInfo ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null || !ni.node.isNodePlaced()) continue;
                Point p = ni.node.getCenterLocation();
                if (p.x <= max) continue;
                index = i;
                max = p.x;
            }
        } else {
            int min = Integer.MAX_VALUE;
            for (int i = 0; i < this.numNodes; ++i) {
                NodeInfo ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null || !ni.node.isNodePlaced()) continue;
                Point p = ni.node.getCenterLocation();
                if (p.x >= min) continue;
                index = i;
                min = p.x;
            }
        }
        return index;
    }

    private int getColumnIndex(NodeInfo n) {
        boolean index = false;
        Stack<NodeInfo> offsprings = new Stack<NodeInfo>();
        offsprings.push(n);
        HashSet<NodeInfo> map = new HashSet<NodeInfo>();
        map.add(n);
        if (this.prevOrientation == 0 || this.prevOrientation == 1) {
            while (!offsprings.isEmpty()) {
                NodeInfo ni = (NodeInfo)offsprings.pop();
                if (ni.node.isNodePlaced()) {
                    Point p = ni.node.getCenterLocation();
                    return p.x;
                }
                Vector v = ni.outEdges;
                for (int i = 0; i < v.size(); ++i) {
                    NodeInfo c = (NodeInfo)v.elementAt(i);
                    if (map.contains(c)) continue;
                    map.add(c);
                    offsprings.push(c);
                }
            }
            return Integer.MAX_VALUE;
        }
        while (!offsprings.isEmpty()) {
            NodeInfo ni = (NodeInfo)offsprings.pop();
            if (ni.node.isNodePlaced()) {
                Point p = ni.node.getCenterLocation();
                return p.y;
            }
            Vector v = ni.outEdges;
            for (int i = 0; i < v.size(); ++i) {
                NodeInfo c = (NodeInfo)v.elementAt(i);
                if (map.contains(c)) continue;
                map.add(c);
                offsprings.push(c);
            }
        }
        return Integer.MAX_VALUE;
    }

    private void assignDepthFromRoot(Node n) {
        List nset = new List();
        int curDepth = 0;
        while (n != null) {
            Node nx;
            NodeInfo ni = (NodeInfo)this.allinfo.elementAt(n.val);
            if (ni == null) {
                return;
            }
            ni.depth = curDepth;
            Vector v = ni.outEdges;
            if (v != null) {
                for (int i = 0; i < v.size(); ++i) {
                    NodeInfo To = (NodeInfo)v.elementAt(i);
                    if (To.depth != -1) continue;
                    nset.insert(new Node(To.id));
                }
            }
            if ((nx = n.next) == null) {
                List cset = nset;
                ++curDepth;
                nset = new List();
                n = cset.first;
                continue;
            }
            n = nx;
        }
    }

    protected void removeCycles() {
        NodeInfo To;
        NodeInfo From;
        NodeInfo ni;
        int i;
        int[] left = new int[this.numNodes];
        int[] right = new int[this.numNodes];
        int[] ids = new int[this.numNodes];
        int[] sortedList = new int[this.numNodes];
        int next = 0;
        int nr = 0;
        int nl = 0;
        Stack<NodeInfo> ancestors = new Stack<NodeInfo>();
        for (i = 0; i < this.numNodes; ++i) {
            ni = (NodeInfo)this.allinfo.elementAt(i);
            if (ni == null) continue;
            if (ni.outEdges.size() == 0) {
                right[nr] = i;
                ++nr;
                continue;
            }
            if (ni.inEdges.size() == 0) {
                left[nl] = i;
                ++nl;
                continue;
            }
            ids[next] = i;
            sortedList[i] = ni.outEdges.size() - ni.inEdges.size();
            ++next;
        }
        Sort.indexSortDescending(sortedList, ids, next);
        i = 0;
        while (i < next) {
            left[nl] = ids[i];
            ids[i] = -1;
            ++i;
            ++nl;
        }
        while (i < nl) {
            ids[i] = -1;
            ++i;
        }
        i = 0;
        while (nl < this.numNodes) {
            left[nl] = right[i];
            ids[nl] = -1;
            ++i;
            ++nl;
        }
        boolean cycleSize = false;
        int numCycles = 0;
        Vector<NodeInfo[]> cyclePairs = new Vector<NodeInfo[]>();
        for (i = 0; i < this.numNodes; ++i) {
            int l = left[i];
            ni = (NodeInfo)this.allinfo.elementAt(l);
            if (ni == null) continue;
            Vector v1 = ni.inEdges;
            int jmax = v1.size();
            for (int j = 0; j < jmax; ++j) {
                int k;
                From = (NodeInfo)v1.elementAt(j);
                if (From.dummy || (k = ids[From.id]) != -1) continue;
                boolean cycle = false;
                To = ni;
                if (this.crAlgo == 1) {
                    cycle = true;
                    continue;
                }
                ancestors.removeAllElements();
                ancestors.addElement(From);
                ancestors.addElement(ni);
                k = From.id;
                if (this.isCycle(From, ni, ancestors)) {
                    int curSize;
                    if (this.assignNewOnly) {
                        boolean hasNodePlaced = false;
                        curSize = ancestors.size() - 1;
                        for (k = 0; k <= curSize; ++k) {
                            From = (NodeInfo)ancestors.elementAt(k);
                            if (!From.node.isNodePlaced()) continue;
                            hasNodePlaced = true;
                            break;
                        }
                        if (hasNodePlaced) continue;
                    }
                    ++numCycles;
                    curSize = ancestors.size() - 1;
                    From = (NodeInfo)ancestors.elementAt(curSize);
                    To = (NodeInfo)ancestors.elementAt(0);
                    int depthmin = To.depth;
                    for (k = 1; k <= curSize; ++k) {
                        NodeInfo Aindex = (NodeInfo)ancestors.elementAt(k);
                        if (Aindex.depth >= depthmin) continue;
                        To = Aindex;
                        From = (NodeInfo)ancestors.elementAt(k - 1);
                        depthmin = To.depth;
                    }
                    cycle = true;
                }
                if (!cycle) continue;
                To.inEdges.remove(From);
                From.outEdges.remove(To);
                To.outEdges.add(From);
                From.inEdges.add(To);
                NodeInfo[] pair = new NodeInfo[]{From, To};
                cyclePairs.add(pair);
                jmax = v1.size();
                --j;
            }
            ids[l] = 0;
        }
        for (i = 0; i < numCycles; ++i) {
            NodeInfo[] pair = (NodeInfo[])cyclePairs.elementAt(i);
            From = pair[0];
            To = pair[1];
            To.outEdges.remove(From);
            From.inEdges.remove(To);
            To.inEdges.add(From);
            From.outEdges.add(To);
        }
        for (i = 0; i < numCycles; ++i) {
            NodeInfo nn;
            LinkLayoutInterface arc;
            LinkLayoutInterface link;
            NodeInfo[] pair = (NodeInfo[])cyclePairs.elementAt(i);
            From = pair[0];
            To = pair[1];
            LinkLayoutInterface linkLayoutInterface = link = this.revtree ? (LinkLayoutInterface)this.lookup.get(From.id + "," + To.id) : (LinkLayoutInterface)this.lookup.get(To.id + "," + From.id);
            if (this.revtree) {
                arc = (LinkLayoutInterface)this.lookup.get(To.id + "," + From.id);
                this.revlinks.put(To.id + "," + From.id, arc);
            } else {
                arc = (LinkLayoutInterface)this.lookup.get(From.id + "," + To.id);
                this.revlinks.put(From.id + "," + To.id, arc);
            }
            NodeLayoutInterface node = this.model.createDummyNode(this.gridWidth, this.gridHeight);
            this.nodes.addElement(node);
            NodeInfo dummy = new NodeInfo(node, this.allinfo.size());
            dummy.dummy = true;
            dummy.diagramId = To.diagramId;
            dummy.attachedTo = To;
            this.allinfo.addElement(dummy);
            ((Vector)this.diagrams.elementAt(dummy.diagramId)).addElement(dummy);
            dummy.layersize = To.layersize;
            this.breakNode(dummy);
            dummy.setLayer(0);
            node = this.model.createDummyNode(this.gridWidth, this.gridHeight);
            this.nodes.addElement(node);
            NodeInfo dummy2 = new NodeInfo(node, this.allinfo.size());
            dummy2.dummy = true;
            dummy2.diagramId = From.diagramId;
            dummy2.attachedTo = From;
            this.allinfo.addElement(dummy2);
            ((Vector)this.diagrams.elementAt(dummy2.diagramId)).addElement(dummy2);
            dummy2.layersize = From.layersize;
            this.breakNode(dummy2);
            dummy2.setLayer(0);
            To.inEdges.remove(From);
            From.outEdges.remove(To);
            dummy.outEdges.addElement(dummy2);
            dummy2.inEdges.addElement(dummy);
            if (To.inEdges.size() > 0) {
                nn = (NodeInfo)To.inEdges.elementAt(0);
                nn.outEdges.addElement(dummy);
                dummy.inEdges.addElement(nn);
            } else if (From.outEdges.size() > 0) {
                nn = (NodeInfo)From.outEdges.elementAt(0);
                nn.inEdges.addElement(dummy2);
                dummy2.outEdges.addElement(nn);
            }
            Vector<NodeInfo> rr = new Vector<NodeInfo>();
            rr.addElement(dummy);
            rr.addElement(To);
            rr.addElement(From);
            rr.addElement(dummy2);
            this.cycleNodes.put(String.valueOf(arc.hashCode()), rr);
            if (To.inEdges.size() == 0) {
                Node n = new Node(To.id);
                this.allroots.insert(n);
                n = new Node(To.id);
                ((List)this.droots.elementAt(To.diagramId)).insert(n);
                n = new Node(dummy.id);
                this.allroots.insert(n);
                n = new Node(dummy.id);
                ((List)this.droots.elementAt(To.diagramId)).insert(n);
            }
            if (From.inEdges.size() != 1) continue;
            this.allroots.remove(From.id);
            ((List)this.droots.elementAt(From.diagramId)).remove(From.id);
        }
        this.totalNodes = this.allinfo.size();
    }

    private boolean isCycle(NodeInfo ni, NodeInfo nj, Vector ances) {
        Vector v1 = ni.inEdges;
        if (v1.size() == 0) {
            return false;
        }
        for (int i1 = 0; i1 < v1.size(); ++i1) {
            NodeInfo From = (NodeInfo)v1.elementAt(i1);
            if (From.equals(nj)) {
                return true;
            }
            boolean dup = false;
            for (int i2 = ances.size() - 1; i2 >= 0; --i2) {
                NodeInfo n1 = (NodeInfo)ances.elementAt(i2);
                if (!From.equals(n1)) continue;
                dup = true;
                break;
            }
            if (dup) continue;
            ances.insertElementAt(From, 0);
            if (this.isCycle(From, nj, ances)) {
                return true;
            }
            ances.removeElementAt(0);
        }
        return false;
    }

    private void assignParentNodes(HashSet parentNodes) {
        boolean reiterate = true;
        while (reiterate) {
            reiterate = false;
            HashSet copy = (HashSet)parentNodes.clone();
            for (NodeInfo ni : copy) {
                int j;
                if (ni.layer != -1) {
                    parentNodes.remove(ni);
                    continue;
                }
                boolean assign = true;
                int player = Integer.MAX_VALUE;
                for (j = 0; j < ni.outEdges.size(); ++j) {
                    int alayer = ((NodeInfo)ni.outEdges.get((int)j)).layer;
                    if (alayer == -1) {
                        assign = false;
                        break;
                    }
                    player = Math.min(player, alayer);
                }
                if (!assign) continue;
                parentNodes.remove(ni);
                if (player == 0) {
                    ni.setLayer(0);
                } else {
                    ni.setLayer(player - 1);
                }
                for (j = 0; j < ni.inEdges.size(); ++j) {
                    parentNodes.add(ni.inEdges.get(j));
                }
                reiterate = true;
            }
        }
    }

    private void getAssignedLayersAndColumns() {
        int j;
        Point pos;
        NodeInfo ni;
        int i;
        int yo;
        int xo;
        int vspace;
        int hspace;
        HashSet parentNodes = new HashSet();
        int maxLayer = 0;
        this.totalNodes = this.allinfo.size();
        if (this.prevOrientation == 3 || this.prevOrientation == 2) {
            hspace = this.gridWidth;
            vspace = this.gridHeight;
            xo = this.bbox.x + hspace / 2;
            yo = this.bbox.y - this.minrow * vspace + vspace / 2;
            for (i = 0; i < this.totalNodes; ++i) {
                ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null || !ni.node.isNodePlaced()) continue;
                this.newLayout = false;
                pos = ni.node.getCenterLocation();
                if (ni.layersize == 1) {
                    ni.setLayer((pos.x - xo) / hspace);
                } else {
                    ni.setLayer((int)(((double)(pos.x - xo) - 0.5 * (double)(ni.layersize - 1) * (double)hspace) / (double)hspace));
                }
                ni.col = ni.colsize == 1 ? (pos.y - yo) / vspace : (int)(((double)(pos.y - yo) - 0.5 * (double)(ni.colsize - 1) * (double)vspace) / (double)vspace);
                if (maxLayer < ni.layer + ni.layersize - 1) {
                    maxLayer = ni.layer + ni.layersize - 1;
                }
                if (parentNodes.contains(ni)) {
                    parentNodes.remove(ni);
                }
                for (j = 0; j < ni.inEdges.size(); ++j) {
                    parentNodes.add(ni.inEdges.get(j));
                }
            }
            this.assignParentNodes(parentNodes);
            if (this.prevOrientation == 2) {
                for (i = 0; i < this.numNodes; ++i) {
                    ni = (NodeInfo)this.allinfo.elementAt(i);
                    if (ni == null || ni.layer == -1) continue;
                    ni.setLayer(maxLayer - (int)((double)ni.layer + 0.5 * (double)ni.layersize));
                }
            }
        } else {
            hspace = this.gridWidth;
            vspace = this.gridHeight;
            xo = this.bbox.x - this.minrow * hspace + hspace / 2;
            yo = this.bbox.y + vspace / 2;
            for (i = 0; i < this.totalNodes; ++i) {
                ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null || !ni.node.isNodePlaced()) continue;
                this.newLayout = false;
                pos = ni.node.getCenterLocation();
                ni.setLayer((int)((double)((pos.y - yo) / vspace) - 0.5 * (double)(ni.layersize - 1)));
                ni.col = (int)((double)((pos.x - xo) / hspace) - 0.5 * (double)(ni.colsize - 1));
                if (maxLayer < ni.layer + ni.layersize - 1) {
                    maxLayer = ni.layer + ni.layersize - 1;
                }
                for (j = 0; j < ni.inEdges.size(); ++j) {
                    parentNodes.add(ni.inEdges.get(j));
                }
            }
            this.assignParentNodes(parentNodes);
            if (this.prevOrientation == 0) {
                for (i = 0; i < this.totalNodes; ++i) {
                    ni = (NodeInfo)this.allinfo.elementAt(i);
                    if (ni == null || !ni.node.isNodePlaced()) continue;
                    ni.setLayer(maxLayer - (int)((double)ni.layer + 0.5 * (double)ni.layersize));
                }
            }
        }
        for (int i2 = 0; i2 < this.numNodes; ++i2) {
            NodeInfo ni2 = (NodeInfo)this.allinfo.elementAt(i2);
            if (ni2 == null || ni2.layer != 0) continue;
            this.allroots.insert(new Node(ni2.id));
        }
        this.numLayers = maxLayer + 1;
    }

    protected void assignLayers() {
        Vector v1;
        NodeInfo ni;
        int i;
        List cset = this.allroots;
        List nset = new List();
        Node n = cset.first;
        int curLayer = 0;
        int num = 0;
        int maxwidth = 0;
        int layersize = 0;
        HashSet<NodeInfo> assignedNodes = new HashSet<NodeInfo>();
        if (this.assignNewOnly) {
            for (i = 0; i < this.numNodes; ++i) {
                ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null || ni.layer == -1) continue;
                assignedNodes.add(ni);
            }
            boolean bl = this.newLayout = assignedNodes.size() == 0;
            if (assignedNodes.size() == this.numNodes) {
                return;
            }
        }
        while (n != null) {
            Node n1;
            NodeInfo To;
            Vector v2;
            int imax;
            ni = (NodeInfo)this.allinfo.elementAt(n.val);
            if (ni == null) {
                return;
            }
            if (ni.layer == -1) {
                boolean okay = true;
                v1 = ni.inEdges;
                imax = v1.size();
                for (i = 0; i < imax; ++i) {
                    NodeInfo From = (NodeInfo)v1.elementAt(i);
                    int nextValidLayer = From.layer + From.layersize;
                    if (From.layer != -1 && nextValidLayer <= curLayer) continue;
                    if (From.layer != -1) {
                        if (nextValidLayer - 1 == curLayer) {
                            nset.insertFirst(new Node(n.val));
                        } else {
                            nset.insert(new Node(n.val));
                        }
                    }
                    okay = false;
                    break;
                }
                if (okay) {
                    ni.setLayer(curLayer);
                    layersize = Math.max(layersize, ni.layersize);
                    ++num;
                    v2 = ni.outEdges;
                    imax = v2.size();
                    for (i = 0; i < imax; ++i) {
                        To = (NodeInfo)v2.elementAt(i);
                        if (To.layer != -1) continue;
                        nset.insert(new Node(To.id));
                    }
                }
            } else if (assignedNodes.contains(ni)) {
                if (ni.layer > curLayer) {
                    nset.insert(new Node(ni.id));
                } else {
                    assignedNodes.remove(ni);
                    layersize = Math.max(layersize, ni.layersize);
                    ++num;
                    v2 = ni.outEdges;
                    imax = v2.size();
                    for (i = 0; i < imax; ++i) {
                        To = (NodeInfo)v2.elementAt(i);
                        if (To.layer != -1 && To.layer <= curLayer) continue;
                        nset.insert(new Node(To.id));
                    }
                }
            }
            if ((n1 = n.next) == null) {
                cset = nset;
                ++curLayer;
                --layersize;
                num = 0;
                nset = new List();
                n = n1 = cset.first;
                continue;
            }
            n = n1;
            if (num == this.userLayers) {
                ++curLayer;
                --layersize;
                num = 0;
                continue;
            }
            maxwidth = Math.max(num, maxwidth);
        }
        this.numLayers = curLayer;
        if (layersize > 0) {
            this.numLayers += layersize;
        }
        if (num != 0) {
            ++this.numLayers;
        }
        this.layerSize = this.userLayers == -1 ? maxwidth : this.userLayers;
        Enumeration enums = this.cycleNodes.elements();
        while (enums.hasMoreElements()) {
            v1 = (Vector)enums.nextElement();
            this.updateCycleNodes(v1);
        }
        this.totalNodes = this.allinfo.size();
        this.updateNumLayersForIslands();
    }

    protected void updateNumLayersForIslands() {
        if (this.islands == null) {
            return;
        }
        NodeInfo ni = null;
        for (int i = 0; i < this.islands.size(); ++i) {
            ni = (NodeInfo)this.islands.get(i);
            this.numLayers = Math.max(this.numLayers, ni.layersize);
        }
    }

    private void updateCycleNodes(Vector nodeList) {
        if (nodeList.size() < 4) {
            return;
        }
        NodeInfo to = (NodeInfo)nodeList.get(2);
        NodeInfo from = (NodeInfo)nodeList.get(1);
        NodeInfo toDummy = (NodeInfo)nodeList.get(3);
        NodeInfo fromDummy = (NodeInfo)nodeList.get(0);
        toDummy.setLayer(to.layer);
        fromDummy.setLayer(from.layer);
        int numDummies = toDummy.layer - fromDummy.layer - fromDummy.layersize;
        if (numDummies > 0) {
            NodeInfo ni;
            int i;
            fromDummy.outEdges.remove(toDummy);
            toDummy.inEdges.remove(fromDummy);
            for (i = 0; i < fromDummy.inEdges.size(); ++i) {
                ni = (NodeInfo)fromDummy.inEdges.get(i);
                ni.outEdges.remove(fromDummy);
            }
            fromDummy.inEdges.clear();
            for (i = 0; i < toDummy.outEdges.size(); ++i) {
                ni = (NodeInfo)toDummy.outEdges.get(i);
                ni.inEdges.remove(toDummy);
            }
            toDummy.outEdges.clear();
            NodeInfo previous = fromDummy;
            NodeInfo[] dummies = new NodeInfo[numDummies];
            for (int i2 = 0; i2 < numDummies; ++i2) {
                NodeLayoutInterface node = this.model.createDummyNode(this.gridWidth, this.gridHeight);
                this.nodes.addElement(node);
                dummies[i2] = new NodeInfo(node, this.allinfo.size());
                dummies[i2].diagramId = previous.diagramId;
                dummies[i2].dummy = true;
                dummies[i2].setLayer(previous.layer + previous.layersize);
                this.allinfo.addElement(dummies[i2]);
                ((Vector)this.diagrams.elementAt(dummies[i2].diagramId)).addElement(dummies[i2]);
                previous.outEdges.add(dummies[i2]);
                dummies[i2].inEdges.add(previous);
                previous = dummies[i2];
            }
            dummies[numDummies - 1].outEdges.add(toDummy);
            toDummy.inEdges.add(dummies[numDummies - 1]);
            from.outEdges.add(dummies[0]);
            dummies[0].inEdges.add(from);
            dummies[numDummies - 1].outEdges.add(to);
            to.inEdges.add(dummies[numDummies - 1]);
            nodeList.add(dummies);
        }
    }

    private void assignDiagrams() {
        this.numDiagrams = 0;
        this.diagrams = new Vector();
        int curDiagram = 0;
        Node n = this.allroots.first;
        NodeInfo ni = (NodeInfo)this.allinfo.elementAt(n.val);
        if (ni == null) {
            return;
        }
        Vector nodes = new Vector();
        this.setDiagramIds(ni, 0, nodes);
        this.diagrams.addElement(nodes);
        this.droots = new Vector();
        List list = new List();
        Node nl = new Node(n.val);
        list.insert(nl);
        this.droots.addElement(list);
        n = n.next;
        while (n != null) {
            ni = (NodeInfo)this.allinfo.elementAt(n.val);
            if (ni == null) {
                return;
            }
            int id = this.getDiagramId(ni);
            if (id == -1) {
                nodes = new Vector();
                this.setDiagramIds(ni, ++curDiagram, nodes);
                this.diagrams.addElement(nodes);
                list = new List();
                nl = new Node(n.val);
                list.insert(nl);
                this.droots.addElement(list);
            } else {
                ((List)this.droots.elementAt(ni.diagramId)).insert(new Node(n.val));
            }
            n = n.next;
        }
        this.numDiagrams = curDiagram + 1;
    }

    private void assignIslandDiagrams() {
        int curDiagram = this.numDiagrams;
        for (int i = 0; i < this.islands.size(); ++i) {
            NodeInfo ni = (NodeInfo)this.islands.elementAt(i);
            ni.diagramId = curDiagram++;
            Vector<NodeInfo> v = new Vector<NodeInfo>();
            v.addElement(ni);
            this.diagrams.addElement(v);
        }
        this.numDiagrams = curDiagram;
    }

    private void setDiagramIds(NodeInfo ni, int id, Vector nodes) {
        int i;
        if (ni.diagramId != -1) {
            return;
        }
        ni.diagramId = id;
        nodes.addElement(ni);
        int size = ni.inEdges.size();
        for (i = 0; i < size; ++i) {
            this.setDiagramIds((NodeInfo)ni.inEdges.elementAt(i), id, nodes);
        }
        size = ni.outEdges.size();
        for (i = 0; i < size; ++i) {
            this.setDiagramIds((NodeInfo)ni.outEdges.elementAt(i), id, nodes);
        }
    }

    private int getDiagramId(NodeInfo n) {
        NodeInfo ni;
        int i;
        if (n.diagramId != -1) {
            return n.diagramId;
        }
        int size = n.inEdges.size();
        for (i = 0; i < size; ++i) {
            ni = (NodeInfo)n.inEdges.elementAt(i);
            if (ni.diagramId == -1) continue;
            return ni.diagramId;
        }
        size = n.outEdges.size();
        for (i = 0; i < size; ++i) {
            ni = (NodeInfo)n.outEdges.elementAt(i);
            if (ni.diagramId == -1) continue;
            return ni.diagramId;
        }
        return -1;
    }

    protected void optimizeLayers() {
        boolean redo = false;
        int diflen = 0;
        int savedif = Integer.MAX_VALUE;
        for (int i = 0; i < this.numNodes; ++i) {
            int newlev;
            int newi;
            int outlen;
            int inlen;
            NodeInfo ni;
            block20: {
                int newout;
                int newin;
                boolean flag;
                NodeInfo From;
                int l;
                NodeInfo To;
                int j;
                ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null || ni instanceof NodeInfoExtension || this.assignNewOnly && ni.node.isNodePlaced()) continue;
                Vector v1 = ni.outEdges;
                Vector v2 = ni.inEdges;
                int jmax = v1.size();
                int lmax = v2.size();
                inlen = 0;
                outlen = 0;
                newi = i;
                for (j = 0; j < jmax; ++j) {
                    To = (NodeInfo)v1.elementAt(j);
                    outlen += To.layer - (ni.layer + ni.layersize);
                    newi = Math.min(newi, To.id - 1);
                }
                for (l = 0; l < lmax; ++l) {
                    From = (NodeInfo)v2.elementAt(l);
                    inlen += ni.layer - (From.layer + From.layersize);
                    newi = Math.min(newi, From.id - 1);
                }
                if (outlen == inlen) {
                    if (i != this.numNodes - 1 || !redo || savedif <= diflen) continue;
                    redo = false;
                    savedif = diflen;
                    i = 0;
                    diflen = 0;
                    continue;
                }
                newlev = ni.layer;
                int ls = ni.layersize;
                if (inlen > outlen) {
                    flag = false;
                    while (true) {
                        --newlev;
                        newin = 0;
                        newout = 0;
                        for (j = 0; j < jmax; ++j) {
                            To = (NodeInfo)v1.elementAt(j);
                            if (newlev + ni.layersize > To.layer) {
                                flag = true;
                                break;
                            }
                            newout += To.layer - (newlev + ni.layersize);
                        }
                        if (!flag) {
                            for (l = 0; l < lmax; ++l) {
                                From = (NodeInfo)v2.elementAt(l);
                                if (From.layer + From.layersize > newlev) {
                                    flag = true;
                                    break;
                                }
                                newin += newlev - (From.layer + From.layersize);
                            }
                        }
                        if (flag || newin + newout > inlen + outlen) {
                            ++newlev;
                            break block20;
                        }
                        inlen = newin;
                        outlen = newout;
                    }
                }
                flag = false;
                while (true) {
                    ++newlev;
                    newin = 0;
                    newout = 0;
                    for (j = 0; j < jmax; ++j) {
                        To = (NodeInfo)v1.elementAt(j);
                        if (newlev + ni.layersize > To.layer) {
                            flag = true;
                            break;
                        }
                        newout += To.layer - (newlev + ni.layersize);
                    }
                    if (!flag) {
                        for (l = 0; l < lmax; ++l) {
                            From = (NodeInfo)v2.elementAt(l);
                            if (From.layer + From.layersize > newlev) {
                                flag = true;
                                break;
                            }
                            newin += newlev - (From.layer + From.layersize);
                        }
                    }
                    if (flag || newin + newout > inlen + outlen) {
                        --newlev;
                        break;
                    }
                    inlen = newin;
                    outlen = newout;
                }
            }
            diflen += Math.abs(outlen - inlen);
            if (newlev != ni.layer) {
                redo |= i != newi;
                ni.setLayer(newlev);
            }
            if (i != this.numNodes - 1 || !redo || savedif <= diflen) continue;
            redo = false;
            savedif = diflen;
            i = 0;
            diflen = 0;
        }
    }

    protected void assignLeafLoc() {
        for (int i = 0; i < this.pos.length; ++i) {
            for (int j = 0; j < this.pos[i].size(); ++j) {
                NodeInfo nij = (NodeInfo)this.pos[i].elementAt(j);
                if (nij.outEdges.size() != 0) continue;
                this.setLeafId(nij, nij.layer);
            }
        }
        this.leavesAssigned = true;
    }

    private void assignRevLeafLoc() {
        for (int i = this.pos.length - 1; i >= 0; --i) {
            for (int j = 0; j < this.pos[i].size(); ++j) {
                NodeInfo nij = (NodeInfo)this.pos[i].elementAt(j);
                if (nij.inEdges.size() != 0) continue;
                this.setRevLeafId(nij, nij.layer);
            }
        }
        this.leavesAssigned = true;
    }

    private void setLeafId(NodeInfo ni, int leafId) {
        if (ni.leafAt == -1) {
            ni.setLeafAt(leafId);
            for (int j = 0; j < ni.inEdges.size(); ++j) {
                NodeInfo nj = (NodeInfo)ni.inEdges.elementAt(j);
                this.setLeafId(nj, leafId);
            }
        }
    }

    private void setRevLeafId(NodeInfo ni, int leafId) {
        if (ni.leafAt == -1) {
            ni.setLeafAt(leafId);
            for (int i = 0; i < ni.outEdges.size(); ++i) {
                this.setRevLeafId((NodeInfo)ni.outEdges.elementAt(i), leafId);
            }
        }
    }

    protected void createDummyNodes() {
        NodeInfo ni;
        NodeLayoutInterface n2;
        int k;
        NodeLayoutInterface n1;
        NodeInfo K;
        Vector v2;
        LinkLayoutInterface arc;
        Object obj;
        String key;
        int lmax;
        NodeInfo To;
        int j;
        boolean nodePlaced;
        int jmax;
        Vector v1;
        NodeInfo From;
        int i;
        this.dummyWidth = new int[this.numLayers];
        for (i = 0; i < this.numLayers; ++i) {
            this.dummyWidth[i] = 0;
        }
        int numDummy = 0;
        int totnodes = this.allinfo.size();
        for (i = 0; i < this.numNodes; ++i) {
            From = (NodeInfo)this.allinfo.elementAt(i);
            if (From == null) continue;
            v1 = From.outEdges;
            jmax = v1.size();
            nodePlaced = this.assignNewOnly && From.node.isNodePlaced();
            for (j = 0; j < jmax; ++j) {
                To = (NodeInfo)v1.elementAt(j);
                if (nodePlaced && To.node.isNodePlaced()) continue;
                numDummy += To.layer - (From.layer + From.layersize);
            }
        }
        this.maxDummyWidth = 0;
        if (numDummy == 0 || this.assignNewOnly && numDummy < 0) {
            return;
        }
        for (i = 0; i < this.numNodes; ++i) {
            From = (NodeInfo)this.allinfo.elementAt(i);
            if (From == null) continue;
            nodePlaced = this.assignNewOnly && From.node.isNodePlaced();
            v1 = From.outEdges;
            jmax = v1.size();
            for (j = 0; j < jmax; ++j) {
                boolean flip;
                To = (NodeInfo)v1.elementAt(j);
                if (nodePlaced && To.node.isNodePlaced() || (lmax = To.layer - (From.layer + From.layersize)) <= 0) continue;
                key = this.revtree ? From.id + "," + To.id : To.id + "," + From.id;
                obj = this.revlinks.get(key);
                if (obj != null) {
                    this.revlinks.remove(obj);
                    flip = true;
                    arc = (LinkLayoutInterface)obj;
                } else {
                    flip = false;
                    key = this.revtree ? To.id + "," + From.id : From.id + "," + To.id;
                    arc = (LinkLayoutInterface)this.lookup.get(key);
                }
                if (arc == null) {
                    System.out.println("_DEBUG_:Something went wrong");
                    continue;
                }
                Vector<Object> dummy = new Vector<Object>();
                dummy.addElement(arc);
                dummy.addElement(From);
                this.dummyLinks.addElement(dummy);
                v2 = From.outEdges;
                v2.remove(To);
                K = From;
                n1 = From.node;
                k = From.layer + From.layersize;
                while (k < To.layer) {
                    n2 = this.model.createDummyNode(this.gridWidth, this.gridHeight);
                    ni = new NodeInfo(n2, this.allinfo.size());
                    ni.dummy = true;
                    ni.diagramId = From.diagramId;
                    if (flip ^ this.revtree) {
                        dummy.insertElementAt(ni, 1);
                    } else {
                        dummy.addElement(ni);
                    }
                    if (this.ortho) {
                        arc.setOrthogonal(true);
                    }
                    this.nodes.addElement(n2);
                    this.allinfo.addElement(ni);
                    ((Vector)this.diagrams.elementAt(ni.diagramId)).addElement(ni);
                    ni.setLayer(k);
                    v2 = ni.inEdges;
                    v2.addElement(K);
                    v2 = K.outEdges;
                    v2.addElement(ni);
                    K = ni;
                    int n = k++;
                    this.dummyWidth[n] = this.dummyWidth[n] + 1;
                    n1 = n2;
                }
                if (this.ortho) {
                    arc.setOrthogonal(true);
                }
                v2 = K.outEdges;
                v2.addElement(To);
                v2 = To.inEdges;
                v2.remove(From);
                v2.addElement(K);
                if (flip) {
                    Vector<NodeInfo> rr = new Vector<NodeInfo>();
                    if (this.revtree) {
                        dummy.addElement(To);
                        ni = (NodeInfo)dummy.elementAt(2);
                        rr.addElement(ni);
                        rr.addElement(From);
                        rr.addElement(To);
                    } else {
                        dummy.insertElementAt(To, 1);
                        ni = (NodeInfo)dummy.elementAt(dummy.size() - 2);
                        rr.addElement(ni);
                        rr.addElement(To);
                        rr.addElement(From);
                    }
                    this.cycleNodes.put(String.valueOf(arc.hashCode()), rr);
                    ni.revDummy = true;
                } else if (this.revtree) {
                    dummy.insertElementAt(To, 1);
                } else {
                    dummy.addElement(To);
                }
                --j;
                --jmax;
            }
        }
        int oldNumNodes = this.totalNodes;
        this.totalNodes = this.allinfo.size();
        for (i = oldNumNodes; i < totnodes; ++i) {
            From = (NodeInfo)this.allinfo.elementAt(i);
            if (this.assignNewOnly && From.node.isNodePlaced()) continue;
            v1 = From.outEdges;
            jmax = v1.size();
            for (j = 0; j < jmax; ++j) {
                NodeInfo nk;
                To = (NodeInfo)v1.elementAt(j);
                lmax = To.layer - (From.layer + From.layersize);
                if (lmax <= 0) continue;
                NodeInfo actFrom = From;
                NodeInfo actTo = To;
                while (actFrom.dummy && actFrom.inEdges.size() > 0) {
                    nk = (NodeInfo)actFrom.inEdges.elementAt(0);
                    for (k = 1; k < actFrom.inEdges.size() && nk.dummy; ++k) {
                        nk = (NodeInfo)actFrom.inEdges.elementAt(k);
                    }
                    actFrom = nk;
                }
                while (actTo.dummy && actTo.outEdges.size() > 0) {
                    nk = (NodeInfo)actTo.outEdges.elementAt(0);
                    for (k = 1; k < actTo.outEdges.size() && nk.dummy; ++k) {
                        nk = (NodeInfo)actTo.outEdges.elementAt(k);
                    }
                    actTo = nk;
                }
                key = this.revtree ? actFrom.id + "," + actTo.id : actTo.id + "," + actFrom.id;
                obj = this.revlinks.get(key);
                arc = (LinkLayoutInterface)obj;
                Vector rr = null;
                int fromIndex = -1;
                int toIndex = -1;
                if (arc != null) {
                    rr = (Vector)this.cycleNodes.get(String.valueOf(arc.hashCode()));
                    fromIndex = rr.indexOf(From);
                    toIndex = rr.indexOf(To);
                }
                v2 = From.outEdges;
                v2.remove(To);
                K = From;
                n1 = From.node;
                k = From.layer + 1;
                while (k < To.layer) {
                    n2 = this.model.createDummyNode(this.gridWidth, this.gridHeight);
                    ni = new NodeInfo(n2, this.allinfo.size());
                    ni.dummy = true;
                    ni.diagramId = From.diagramId;
                    if (rr != null) {
                        if (this.revtree) {
                            rr.insertElementAt(ni, fromIndex);
                        } else {
                            rr.insertElementAt(ni, toIndex);
                        }
                    }
                    this.nodes.addElement(n2);
                    this.allinfo.addElement(ni);
                    ((Vector)this.diagrams.elementAt(ni.diagramId)).addElement(ni);
                    ni.setLayer(k);
                    v2 = ni.inEdges;
                    v2.addElement(K);
                    v2 = K.outEdges;
                    v2.addElement(ni);
                    K = ni;
                    int n = k++;
                    this.dummyWidth[n] = this.dummyWidth[n] + 1;
                    n1 = n2;
                }
                if (this.ortho) {
                    arc.setOrthogonal(true);
                }
                v2 = K.outEdges;
                v2.addElement(To);
                v2 = To.inEdges;
                v2.remove(From);
                v2.addElement(K);
            }
        }
        for (i = 0; i < this.numLayers; ++i) {
            if (this.maxDummyWidth >= this.dummyWidth[i]) continue;
            this.maxDummyWidth = this.dummyWidth[i];
        }
        this.totalNodes = this.allinfo.size();
    }

    protected void assignUniformRows() {
        int num = this.ninfo.size();
        this.maxSize = 0;
        if (!this.newLayout) {
            if (this.assignNewOnly) {
                this.assignPosByColumns2();
                this.checkReverseLinks();
            } else {
                this.assignPosByColumns();
                this.fixDuplicateCols();
            }
            if (this.assignNewOnly || !this.hasCrossings()) {
                int start = 0;
                while (this.layerWidth[start] == 0) {
                    ++start;
                }
                int last = this.numLayers - 1;
                while (this.layerWidth[last] == 0) {
                    --last;
                }
                this.maxrow = ((NodeInfo)this.pos[start].lastElement()).col;
                this.minrow = ((NodeInfo)this.pos[start].elementAt((int)0)).col;
                this.maxLayerWidth = this.layerWidth[0];
                this.maxLayerWidthIndex = 0;
                for (int i = start + 1; i <= last; ++i) {
                    if (this.layerWidth[i] == 0) continue;
                    if (this.maxLayerWidth < this.layerWidth[i]) {
                        this.maxLayerWidth = this.layerWidth[i];
                        this.maxLayerWidthIndex = i;
                    }
                    this.maxrow = Math.max(this.maxrow, ((NodeInfo)this.pos[i].lastElement()).col);
                    this.minrow = Math.min(this.minrow, ((NodeInfo)this.pos[i].elementAt((int)0)).col);
                }
                this.alignFromMaxWidthLayer();
                return;
            }
        } else {
            this.assignPositionByLocation();
        }
        this.shiftLayers();
        this.reduceUniformCrossings();
    }

    private boolean hasCrossings() {
        for (int i = 0; i < this.numLayers; ++i) {
            if (this.pos[i] == null || !this.isCrossingsPresent(this.pos[i])) continue;
            return true;
        }
        return false;
    }

    private boolean fixDuplicateCols() {
        for (int i = 0; i < this.numLayers; ++i) {
            if (this.pos[i] == null) continue;
            int prevcol = -1;
            for (int j = 0; j < this.layerWidth[i]; ++j) {
                NodeInfo nij = (NodeInfo)this.pos[i].elementAt(j);
                if (nij.col > prevcol) {
                    prevcol = nij.col;
                    continue;
                }
                nij.col = ++prevcol;
            }
        }
        return false;
    }

    private void shiftLayers() {
        if (this.revtree) {
            int offset = 0;
            for (int i = this.numLayers - 1; i >= 0; --i) {
                NodeInfo nj;
                int j;
                int actsize;
                int psize = actsize = this.pos[i].size();
                for (j = 0; j < actsize; ++j) {
                    nj = (NodeInfo)this.pos[i].elementAt(j);
                    if (!nj.dummy) break;
                    --psize;
                }
                if (psize == 0) {
                    ++offset;
                    for (j = 0; j < actsize; ++j) {
                        nj = (NodeInfo)this.pos[i].elementAt(j);
                        nj.ignore = true;
                    }
                    continue;
                }
                if (offset <= 0) continue;
                this.layerWidth[i + offset] = this.layerWidth[i];
                for (j = 0; j < this.layerWidth[i]; ++j) {
                    nj = (NodeInfo)this.pos[i].elementAt(j);
                    nj.layer += offset;
                }
                this.pos[i + offset] = this.pos[i];
            }
            while (offset > 0) {
                this.pos[--offset] = new Vector();
                this.layerWidth[offset] = 0;
            }
        } else {
            int offset = 0;
            for (int i = 0; i < this.numLayers; ++i) {
                NodeInfo nj;
                int j;
                int actsize;
                int psize = actsize = this.pos[i].size();
                for (j = 0; j < actsize; ++j) {
                    nj = (NodeInfo)this.pos[i].elementAt(j);
                    if (!nj.dummy) break;
                    --psize;
                }
                if (psize == 0) {
                    ++offset;
                    for (j = 0; j < actsize; ++j) {
                        nj = (NodeInfo)this.pos[i].elementAt(j);
                        nj.ignore = true;
                    }
                    continue;
                }
                if (offset <= 0) continue;
                this.layerWidth[i - offset] = this.layerWidth[i];
                for (j = 0; j < this.layerWidth[i]; ++j) {
                    nj = (NodeInfo)this.pos[i].elementAt(j);
                    nj.layer -= offset;
                }
                this.pos[i - offset] = this.pos[i];
            }
            while (offset > 0) {
                this.pos[this.numLayers - offset] = new Vector();
                this.layerWidth[this.numLayers - offset] = 0;
                --offset;
            }
        }
    }

    private void setRootCols(int layer) {
        Node n = this.roots.first;
        while (n != null) {
            NodeInfo ni = (NodeInfo)this.allinfo.elementAt(n.val);
            if (ni == null) {
                return;
            }
            if (ni.layer < layer) {
                n = n.next;
                continue;
            }
            Vector edges = ni.outEdges;
            int kmax = edges.size();
            if (kmax > 0) {
                ni.col = 0;
                for (int k = 0; k < kmax; ++k) {
                    NodeInfo to = (NodeInfo)edges.elementAt(k);
                    ni.col += to.col;
                }
                ni.col /= kmax;
            }
            n = n.next;
        }
    }

    private void alignRootCols() {
        Node n = this.roots.first;
        Vector[] arRoots = new Vector[this.numLayers];
        while (n != null) {
            NodeInfo ni = (NodeInfo)this.allinfo.elementAt(n.val);
            if (ni == null) {
                return;
            }
            if (arRoots[ni.layer] == null) {
                arRoots[ni.layer] = new Vector();
                arRoots[ni.layer].addElement(ni);
                n = n.next;
                continue;
            }
            if (((NodeInfo)arRoots[ni.layer].lastElement()).col < ni.col) {
                arRoots[ni.layer].addElement(ni);
            } else {
                int i = 0;
                while (((NodeInfo)arRoots[ni.layer].elementAt((int)i)).col < ni.col) {
                    ++i;
                }
                arRoots[ni.layer].insertElementAt(ni, i);
            }
            n = n.next;
        }
        for (int i = 0; i < this.numLayers; ++i) {
            if (arRoots[i] == null) continue;
            int max = arRoots[i].size();
            block3: for (int j = 0; j < max; ++j) {
                int col;
                NodeInfo to;
                NodeInfo nj = (NodeInfo)arRoots[i].elementAt(j);
                int index = this.pos[nj.layer].indexOf(nj);
                int oldCol = nj.col;
                Vector v = nj.outEdges;
                int kmax = v.size();
                if (kmax > 0) {
                    double colAvg = 0.0;
                    for (int k = 0; k < kmax; ++k) {
                        to = (NodeInfo)v.elementAt(k);
                        colAvg += (double)to.col + (double)(to.colsize - 1) / 2.0;
                    }
                    col = (int)((colAvg /= (double)kmax) - (double)(nj.colsize - 1) / 2.0);
                    if (nj.col > col) {
                        nj.setColumn(Math.max(col, this.getMinColPlacement(nj)));
                    } else if (nj.col < col) {
                        nj.setColumn(Math.min(col, this.getMaxColPlacement(nj)));
                    }
                }
                if (nj.col <= oldCol) continue;
                for (int l = j - 1; l >= 0; --l) {
                    NodeInfo nl = (NodeInfo)arRoots[i].elementAt(l);
                    index = this.pos[nl.layer].indexOf(nl);
                    v = nl.outEdges;
                    kmax = v.size();
                    if (kmax <= 0) continue block3;
                    double colAvg = 0.0;
                    for (int k = 0; k < kmax; ++k) {
                        to = (NodeInfo)v.elementAt(k);
                        colAvg += (double)to.col + (double)(to.colsize - 1) / 2.0;
                    }
                    col = (int)((colAvg /= (double)kmax) - (double)(nj.colsize - 1) / 2.0);
                    if (nl.col >= col) continue block3;
                    int saveCol = nl.col;
                    nl.setColumn(Math.min(col, this.getMaxColPlacement(nl)));
                    if (nl.col <= saveCol) continue block3;
                }
            }
        }
    }

    private int getMinColPlacement(NodeInfo n) {
        int index = this.pos[n.layer].indexOf(n);
        int maxNeighborIndex = Integer.MIN_VALUE;
        for (int i = 0; i < n.layersize; ++i) {
            NodeInfo ni = n.getChild(i, 0);
            index = this.pos[n.layer + i].indexOf(ni);
            if (index <= 0) continue;
            NodeInfo neighbor = (NodeInfo)this.pos[n.layer + i].elementAt(index - 1);
            maxNeighborIndex = Math.max(maxNeighborIndex, neighbor.col);
        }
        return maxNeighborIndex + 1;
    }

    private int getMaxColPlacement(NodeInfo n) {
        int index = this.pos[n.layer].indexOf(n);
        int minNeighborIndex = Integer.MAX_VALUE;
        for (int i = 0; i < n.layersize; ++i) {
            NodeInfo ni = n.getChild(i, n.colsize - 1);
            index = this.pos[n.layer + i].indexOf(ni);
            if (index >= this.pos[n.layer + i].size() - 1) continue;
            NodeInfo neighbor = (NodeInfo)this.pos[n.layer + i].elementAt(index + 1);
            minNeighborIndex = Math.min(minNeighborIndex, neighbor.col);
        }
        return minNeighborIndex - n.colsize;
    }

    private void alignFromMaxWidthLayer() {
        int i;
        for (int i2 = 0; i2 < this.ninfo.size(); ++i2) {
            NodeInfo ni = (NodeInfo)this.ninfo.elementAt(i2);
            if (ni.inEdges.size() > 1) {
                this.sortNodesBasedOnCol(ni.inEdges);
            }
            if (ni.outEdges.size() <= 1) continue;
            this.sortNodesBasedOnCol(ni.outEdges);
        }
        int start = 0;
        int end = this.numLayers;
        for (i = this.maxLayerWidthIndex + 1; i < end; ++i) {
            if (this.layerWidth[i] == 0) continue;
            this.alignALayer(0, i);
        }
        for (i = this.maxLayerWidthIndex - 1; i >= start; --i) {
            if (this.layerWidth[i] == 0) continue;
            this.alignALayer(1, i);
        }
    }

    private Vector sortNodesBasedOnCol(Vector nodeList) {
        int size = nodeList.size();
        for (int j = 1; j < size; ++j) {
            int insertAt = j;
            NodeInfo nj = (NodeInfo)nodeList.elementAt(j);
            int k = j - 1;
            while (k >= 0 && ((NodeInfo)nodeList.elementAt((int)k)).col > nj.col) {
                insertAt = k--;
            }
            if (insertAt == j) continue;
            nodeList.remove(nj);
            nodeList.insertElementAt(nj, insertAt);
        }
        return nodeList;
    }

    private int getTotalColSize(Vector nodeList, int numNodes) {
        if (nodeList == null) {
            return 0;
        }
        int total = 0;
        if (numNodes < 0 || numNodes > nodeList.size()) {
            numNodes = nodeList.size();
        }
        for (int i = 0; i < numNodes; ++i) {
            total += ((NodeInfo)nodeList.get((int)i)).colsize;
        }
        return total;
    }

    private int getPreferredCol(int type, NodeInfo nj, int moveLeaves) {
        if (this.assignNewOnly && nj.node.isNodePlaced()) {
            return nj.col;
        }
        Vector vj = type == 0 ? nj.inEdges : nj.outEdges;
        int vjsize = vj.size();
        Vector vi = type == 0 ? nj.outEdges : nj.inEdges;
        int visize = vi.size();
        int cur = nj.col;
        int val = 0;
        switch (vjsize) {
            case 0: {
                val = visize == 1 ? cur : moveLeaves + cur;
                break;
            }
            case 1: {
                NodeInfo nk = (NodeInfo)vj.elementAt(0);
                Vector vnk = type == 0 ? nk.outEdges : nk.inEdges;
                int vecColSize = this.getTotalColSize(vnk, vnk.size());
                int prevNJSize = this.getTotalColSize(vnk, vnk.indexOf(nj));
                val = (int)((double)nk.col + (double)(nk.colsize - 1) / 2.0 - (double)(vecColSize - 1) / 2.0 + (double)prevNJSize);
                break;
            }
            case 2: {
                NodeInfo n0 = (NodeInfo)vj.elementAt(0);
                NodeInfo n1 = (NodeInfo)vj.elementAt(1);
                Vector v0 = type == 0 ? n0.outEdges : n0.inEdges;
                int vecColSize = this.getTotalColSize(v0, v0.size());
                int prevNJSize = this.getTotalColSize(v0, v0.indexOf(nj));
                int n0col = (int)((double)n0.col + (double)(n0.colsize - 1) / 2.0 - (double)(vecColSize - 1) / 2.0 + (double)prevNJSize);
                Vector v1 = type == 0 ? n1.outEdges : n1.inEdges;
                vecColSize = this.getTotalColSize(v1, v1.size());
                prevNJSize = this.getTotalColSize(v1, v1.indexOf(nj));
                int n1col = (int)((double)n1.col + (double)(n1.colsize - 1) / 2.0 - (double)(vecColSize - 1) / 2.0 + (double)prevNJSize);
                if (n0.dummy != n1.dummy && v0.size() + v1.size() <= 3) {
                    val = nj.dummy == n0.dummy ? n0.col : n1.col;
                    break;
                }
                if (n0.leafAt == n1.leafAt) {
                    int n1os;
                    if (Math.abs(n0col - n1col) > 1) {
                        val = (n0col + n1col) / 2;
                        break;
                    }
                    int n0os = type == 0 ? n0.inEdges.size() : n0.outEdges.size();
                    int n = n1os = type == 0 ? n1.inEdges.size() : n1.outEdges.size();
                    if (n0os > n1os) {
                        val = (n0col + n1col) / 2;
                        break;
                    }
                    if (n0os < n1os) {
                        val = (n0col + n1col + 1) / 2;
                        break;
                    }
                    val = (n0col + n1col + (n0col <= (this.minrow + this.maxrow) / 2 ? 0 : 1)) / 2;
                    break;
                }
                if (n0.leafAt > n1.leafAt) {
                    val = n0col;
                    break;
                }
                val = n1col;
                break;
            }
            default: {
                int invisibleDummyNodes = 0;
                for (int k = 0; k < vjsize; ++k) {
                    NodeInfo nk = (NodeInfo)vj.elementAt(k);
                    if (nk.attachedTo != null) {
                        ++invisibleDummyNodes;
                        continue;
                    }
                    Vector vnk = type == 0 ? nk.outEdges : nk.inEdges;
                    int vecColSize = this.getTotalColSize(vnk, vnk.size());
                    int prevNJSize = this.getTotalColSize(vnk, vnk.indexOf(nj));
                    int nkcol = (int)((double)nk.col + (double)(nk.colsize - 1) / 2.0 - (double)(vecColSize - 1) / 2.0 + (double)prevNJSize);
                    val += nkcol;
                }
                if (vjsize == invisibleDummyNodes) {
                    System.out.println("BUG");
                }
                val += (vjsize -= invisibleDummyNodes) / 2;
                val /= vjsize;
            }
        }
        return val;
    }

    private void alignALayer(int type, int layerID) {
        int cur = ((NodeInfo)this.pos[layerID].elementAt((int)0)).col;
        int moveLeaves = 0;
        for (int j = 0; j < this.layerWidth[layerID]; ++j) {
            NodeInfo nj = (NodeInfo)this.pos[layerID].elementAt(j);
            if (nj instanceof NodeInfoExtension) continue;
            cur = ((NodeInfo)this.pos[layerID].elementAt((int)0)).col;
            if (this.assignNewOnly && nj.node.isNodePlaced()) {
                moveLeaves = 0;
                continue;
            }
            int val = this.getPreferredCol(type, nj, moveLeaves);
            if (val > nj.col) {
                val = Math.min(val, this.getMaxColPlacement(nj));
            } else if (val < nj.col) {
                val = Math.max(this.minrow, Math.max(val, this.getMinColPlacement(nj)));
            }
            nj.setColumn(val);
            if (nj.col > cur && moveLeaves > 0) {
                for (int k = j - 1; k >= 0; --k) {
                    NodeInfo nk = (NodeInfo)this.pos[layerID].elementAt(k);
                    if (nk instanceof NodeInfoExtension) continue;
                    if (this.assignNewOnly && nk.node.isNodePlaced()) {
                        moveLeaves = 0;
                        break;
                    }
                    int kval = this.getPreferredCol(type, nk, Math.min(moveLeaves, nj.col - cur));
                    if (kval <= nk.col) break;
                    kval = Math.min(kval, this.getMaxColPlacement(nk));
                    moveLeaves = kval - nk.col;
                    nk.setColumn(kval);
                    val = kval;
                }
            }
            moveLeaves = nj.col - cur;
        }
    }

    private boolean shuffleRoot() {
        int size;
        NodeInfo ni;
        NodeInfo no;
        int nn = this.ninfo.size();
        if (this.cycleNodes.size() > 0) {
            Enumeration e = this.cycleNodes.elements();
            while (e.hasMoreElements()) {
                Vector v = (Vector)e.nextElement();
                no = (NodeInfo)v.elementAt(0);
                int num = v.size();
                for (int i = 3; i < num; ++i) {
                    Object o = v.get(i);
                    if (o instanceof NodeInfo) {
                        ni = (NodeInfo)v.elementAt(i);
                        if (ni.layer >= no.layer) continue;
                        no = ni;
                        continue;
                    }
                    if (!(o instanceof NodeInfo[])) continue;
                    NodeInfo[] nodes = (NodeInfo[])v.get(i);
                    for (int j = 0; j < nodes.length; ++j) {
                        ni = nodes[j];
                        if (ni.layer >= no.layer) continue;
                        no = ni;
                    }
                }
                size = this.layerWidth[no.layer];
                if (no.shuffled || size <= 1) continue;
                int index = this.pos[no.layer].indexOf(no);
                if (index == 0) {
                    NodeInfo last = (NodeInfo)this.pos[no.layer].elementAt(size - 1);
                    this.pos[no.layer].removeElementAt(0);
                    this.pos[no.layer].addElement(no);
                    no.col = last instanceof PlaceHolder ? ((PlaceHolder)last).ni.col + 1 : last.col + 1;
                    no.shuffled = true;
                } else {
                    NodeInfo prev = (NodeInfo)this.pos[no.layer].elementAt(index - 1);
                    this.pos[no.layer].removeElementAt(index);
                    this.pos[no.layer].insertElementAt(no, index - 1);
                    no.col = prev instanceof PlaceHolder ? ((PlaceHolder)prev).ni.col - 1 : prev.col - 1;
                    no.shuffled = true;
                }
                for (int i = 0; i < nn; ++i) {
                    ni = (NodeInfo)this.ninfo.elementAt(i);
                    if (ni == null || ni.layer <= no.layer) continue;
                    ni.col = -1;
                }
                this.setRootCols(no.layer + 1);
                int min = ((NodeInfo)this.pos[no.layer].firstElement()).col;
                int max = ((NodeInfo)this.pos[no.layer].lastElement()).col;
                for (int i = no.layer + 1; i < this.numLayers; ++i) {
                    int lsize = this.pos[i].size();
                    if (lsize == 0) continue;
                    this.pos[i] = this.assignByInSplit(this.pos[i], 0);
                    this.setUniformLayerCols(i, 0, min, max);
                    min = Math.min(min, ((NodeInfo)this.pos[i].firstElement()).col);
                    max = Math.max(max, ((NodeInfo)this.pos[i].lastElement()).col);
                }
                return true;
            }
        }
        Node n = this.roots.first;
        while (n != null) {
            no = (NodeInfo)this.allinfo.elementAt(n.val);
            size = this.layerWidth[no.layer];
            if (!no.shuffled && size > 1) {
                int i;
                int index = this.pos[no.layer].indexOf(no);
                int midpoint = size / 2;
                NodeInfo mid = (NodeInfo)this.pos[no.layer].elementAt(midpoint);
                if (mid instanceof PlaceHolder) {
                    mid = ((PlaceHolder)mid).ni;
                    midpoint = this.pos[mid.layer].indexOf(mid);
                }
                if (index != midpoint) {
                    int col = mid.col;
                    no.col = mid.col = no.col;
                    this.pos[no.layer].removeElementAt(index);
                    this.pos[no.layer].add(index, mid);
                    this.pos[no.layer].removeElementAt(midpoint);
                    this.pos[no.layer].add(midpoint, no);
                    no.shuffled = true;
                    mid.shuffled = true;
                } else if (index == 0) {
                    NodeInfo last = (NodeInfo)this.pos[no.layer].lastElement();
                    this.pos[no.layer].removeElementAt(0);
                    this.pos[no.layer].addElement(no);
                    no.col = last instanceof PlaceHolder ? ((PlaceHolder)last).ni.col + 1 : last.col + 1;
                    no.shuffled = true;
                    last.shuffled = true;
                } else {
                    NodeInfo prev = (NodeInfo)this.pos[no.layer].elementAt(index - 1);
                    this.pos[no.layer].removeElementAt(index);
                    this.pos[no.layer].insertElementAt(no, index - 1);
                    no.col = prev instanceof PlaceHolder ? ((PlaceHolder)prev).ni.col - 1 : prev.col - 1;
                    no.shuffled = true;
                    prev.shuffled = true;
                }
                for (i = 0; i < nn; ++i) {
                    ni = (NodeInfo)this.ninfo.elementAt(i);
                    if (ni == null || ni.layer <= no.layer) continue;
                    ni.col = -1;
                }
                this.setRootCols(no.layer + 1);
                for (i = no.layer + 1; i < this.numLayers; ++i) {
                    size = this.pos[i].size();
                    if (size == 0) continue;
                    this.pos[i] = this.assignByInSplit(this.pos[i], 0);
                }
                return true;
            }
            n = n.next;
        }
        return false;
    }

    private void shiftLayerCols(int layer, boolean reverse) {
        if (layer < 0 || layer >= this.numLayers) {
            return;
        }
        int size = this.pos[layer].size();
        int prevLayerOffset = reverse ? -1 : 1;
        boolean colChanged = false;
        for (int i = 0; i < size; ++i) {
            NodeInfo ni = (NodeInfo)this.pos[layer].elementAt(i);
            int cOffset = 0;
            int lOffset = 0;
            NodeInfo parent = null;
            if (ni instanceof NodeInfoExtension) {
                NodeInfoExtension nie = (NodeInfoExtension)ni;
                parent = nie.parent;
                cOffset = nie.colOffset;
                lOffset = nie.layerOffset;
            } else {
                parent = ni;
                cOffset = 0;
                lOffset = 0;
            }
            NodeInfo refNode = parent.getChild(lOffset + prevLayerOffset, cOffset);
            if (refNode == null) continue;
            ni.col = refNode.col;
            colChanged = true;
        }
        if (colChanged) {
            this.reAlignLayer(layer);
            if (this.numNodes > 0 && !(((NodeInfo)this.allinfo.elementAt((int)0)).node instanceof PFDPathDiagramGroupNode)) {
                this.shiftLayerCols(layer - prevLayerOffset, reverse);
            }
        }
    }

    private void reAlignLayer(int layer) {
        Vector layerVec = this.pos[layer];
        Vector sortedLayer = new Vector();
        ArrayList<NodeInfo> spaceHolderList = new ArrayList<NodeInfo>();
        for (int i = 0; i < layerVec.size(); ++i) {
            NodeInfo ni = (NodeInfo)layerVec.get(i);
            if (ni instanceof NodeInfoExtension && ((NodeInfoExtension)ni).colOffset != 0) {
                spaceHolderList.add(ni);
                continue;
            }
            this.insertByCol(sortedLayer, ni);
        }
        this.insertSpaceHolders(sortedLayer, spaceHolderList);
        this.pos[layer] = sortedLayer;
    }

    private void insertByCol(Vector sortedList, NodeInfo node) {
        if (node.col < 0) {
            sortedList.insertElementAt(node, 0);
            return;
        }
        int i = 0;
        for (i = 0; i < sortedList.size(); ++i) {
            NodeInfo ni = (NodeInfo)sortedList.get(i);
            if (node.col < ni.col) break;
        }
        sortedList.insertElementAt(node, i);
    }

    void setUniformLayerCols(int layer, int type, int min, int max) {
        int j;
        int prevcol;
        NodeInfo ni = null;
        int ppcol = prevcol = -2147483647;
        int samenum = 0;
        int size = this.pos[layer].size();
        switch (type) {
            case 0: {
                int dx;
                NodeInfo From;
                int k1max;
                Vector v1;
                boolean isExtension;
                NodeInfo To;
                for (j = 0; j < size; ++j) {
                    To = (NodeInfo)this.pos[layer].elementAt(j);
                    isExtension = To instanceof NodeInfoExtension;
                    if (isExtension) {
                        NodeInfoExtension nie = (NodeInfoExtension)To;
                        To.col = nie.parent.col + nie.colOffset;
                    } else {
                        v1 = To.inEdges;
                        k1max = v1.size();
                        if (k1max > 0) {
                            From = (NodeInfo)v1.elementAt(0);
                            To.col = To.revDummy ? (prevcol + samenum < From.col - 1 ? From.col - 1 : From.col + 1) : From.col;
                            if (!To.dummy) {
                                if (k1max == 2) {
                                    From = (NodeInfo)v1.elementAt(1);
                                    if (!From.dummy) {
                                        To.col += From.col;
                                        To.col /= 2;
                                    }
                                } else {
                                    for (int k = 1; k < k1max; ++k) {
                                        From = (NodeInfo)v1.elementAt(k);
                                        To.col += From.col;
                                    }
                                    To.col /= k1max;
                                }
                            }
                        }
                    }
                    if (To.col == prevcol || isExtension && ((NodeInfoExtension)To).parent.col == prevcol) {
                        if (j == size - 1) {
                            dx = this.getMidIndex(this.pos[layer], j - samenum, j);
                            prevcol += j - dx - samenum;
                            for (int k = j - samenum; k < size; ++k) {
                                ni = (NodeInfo)this.pos[layer].elementAt(k);
                                ni.col = prevcol++;
                            }
                            continue;
                        }
                        ++samenum;
                        continue;
                    }
                    if (samenum > 1) {
                        dx = this.getMidIndex(this.pos[layer], j - samenum, j - 1);
                        prevcol += j - dx - samenum;
                        for (int k = j - samenum; k < j; ++k) {
                            ni = (NodeInfo)this.pos[layer].elementAt(k);
                            ni.col = prevcol++;
                        }
                        ppcol = ni.col + 1;
                    } else {
                        ppcol = prevcol < 0 ? To.col - 1 : prevcol + 1;
                    }
                    samenum = 1;
                    prevcol = Math.max(To.col, prevcol + 1);
                }
                break;
            }
            case 1: {
                int k2max;
                Vector v2;
                int dx;
                NodeInfo From;
                boolean isExtension;
                NodeInfo To;
                for (j = 0; j < size; ++j) {
                    To = (NodeInfo)this.pos[layer].elementAt(j);
                    v2 = this.getOutEdges(To);
                    isExtension = To instanceof NodeInfoExtension;
                    NodeInfo anchor = null;
                    if (isExtension) {
                        NodeInfo parent = ((NodeInfoExtension)To).parent;
                        anchor = parent.getChild(parent.layersize - 1, 0);
                    } else {
                        anchor = To.getChild(To.layersize - 1, 0);
                    }
                    if (To != anchor) {
                        if (isExtension) {
                            NodeInfoExtension nie = (NodeInfoExtension)To;
                            To.col = anchor.col + nie.colOffset;
                        } else {
                            To.col = anchor.col;
                        }
                    } else {
                        k2max = v2.size();
                        if (k2max > 0) {
                            From = (NodeInfo)v2.elementAt(0);
                            To.col = To.revDummy ? (prevcol + samenum < From.col - 1 ? From.col - 1 : From.col + 1) : From.col;
                            if (!To.dummy) {
                                if (k2max == 2) {
                                    From = (NodeInfo)v2.elementAt(1);
                                    if (!From.dummy) {
                                        To.col += From.col;
                                        To.col /= 2;
                                    }
                                } else {
                                    for (int k = 1; k < k2max; ++k) {
                                        From = (NodeInfo)v2.elementAt(k);
                                        To.col += From.col;
                                    }
                                    To.col /= k2max;
                                }
                            }
                        }
                    }
                    if (To.col == prevcol || anchor.col == prevcol) {
                        if (j == size - 1) {
                            dx = Math.max(ppcol - To.col, -samenum / 2);
                            for (int k = j - samenum; k <= j; ++k) {
                                ni = (NodeInfo)this.pos[layer].elementAt(k);
                                ni.col += dx;
                                ++dx;
                            }
                            continue;
                        }
                        ++samenum;
                        continue;
                    }
                    if (samenum > 1) {
                        dx = Math.max(ppcol - To.col, -samenum / 2);
                        for (int k = j - samenum; k < j; ++k) {
                            ni = (NodeInfo)this.pos[layer].elementAt(k);
                            ni.col += dx;
                            ++dx;
                        }
                        ppcol = ni.col + 1;
                    } else {
                        ppcol = prevcol < 0 ? To.col - 1 : prevcol + 1;
                    }
                    samenum = 1;
                    prevcol = To.col;
                }
                break;
            }
            default: {
                int k2max;
                Vector v2;
                int dx;
                NodeInfo From;
                int k1max;
                Vector v1;
                NodeInfo To;
                for (int j2 = 0; j2 < size; ++j2) {
                    To = (NodeInfo)this.pos[layer].elementAt(j2);
                    boolean isExtension = To instanceof NodeInfoExtension;
                    if (isExtension) {
                        NodeInfoExtension nie = (NodeInfoExtension)To;
                        To.col = nie.parent.col + nie.colOffset;
                    } else {
                        v1 = To.inEdges;
                        v2 = To.outEdges;
                        k1max = v1.size();
                        k2max = v2.size();
                        int incol = 0;
                        if (k1max > 0) {
                            From = (NodeInfo)v1.elementAt(0);
                            incol = To.revDummy ? (prevcol + samenum < From.col - 1 ? From.col - 1 : From.col + 1) : From.col;
                            if (!To.dummy) {
                                if (k1max == 2) {
                                    From = (NodeInfo)v1.elementAt(1);
                                    if (!From.dummy) {
                                        incol += From.col;
                                        incol /= 2;
                                    }
                                } else {
                                    for (int k = 1; k < k1max; ++k) {
                                        From = (NodeInfo)v1.elementAt(k);
                                        incol += From.col;
                                    }
                                    incol /= k1max;
                                }
                            }
                        }
                        int outcol = 0;
                        if (k2max > 0) {
                            From = (NodeInfo)v2.elementAt(0);
                            outcol = To.revDummy ? (prevcol + samenum < From.col - 1 ? From.col - 1 : (From.col <= prevcol + samenum ? prevcol + samenum : From.col + 1)) : From.col;
                            if (!To.dummy) {
                                if (k2max == 2) {
                                    From = (NodeInfo)v2.elementAt(1);
                                    if (!From.dummy) {
                                        outcol += From.col;
                                        outcol /= 2;
                                    }
                                } else {
                                    for (int k = 1; k < k2max; ++k) {
                                        From = (NodeInfo)v2.elementAt(k);
                                        outcol += From.col;
                                    }
                                    outcol /= k2max;
                                }
                            }
                        }
                        To.col = incol + outcol;
                        if (k1max > 0 && k2max > 0) {
                            To.col /= 2;
                        }
                    }
                    if (To.col == prevcol || isExtension && ((NodeInfoExtension)To).parent.col == prevcol) {
                        if (j2 == size - 1) {
                            dx = Math.max(ppcol - To.col, -samenum / 2);
                            for (int k = j2 - samenum; k <= j2; ++k) {
                                ni = (NodeInfo)this.pos[layer].elementAt(k);
                                ni.col += dx;
                                ++dx;
                            }
                            continue;
                        }
                        ++samenum;
                        continue;
                    }
                    if (samenum > 1) {
                        dx = Math.max(ppcol - To.col, -samenum / 2);
                        for (int k = j2 - samenum; k < j2; ++k) {
                            ni = (NodeInfo)this.pos[layer].elementAt(k);
                            ni.col += dx;
                            ++dx;
                        }
                        ppcol = ni.col + 1;
                    } else {
                        ppcol = prevcol < 0 ? To.col - 1 : prevcol + 1;
                    }
                    samenum = 1;
                    prevcol = To.col;
                }
            }
        }
        NodeInfo nj = (NodeInfo)this.pos[layer].elementAt(0);
        for (j = 1; j < size; ++j) {
            NodeInfo prev = nj;
            nj = (NodeInfo)this.pos[layer].elementAt(j);
            if (prev.col <= nj.col || !this.isSwappable(prev, nj)) continue;
            this.pos[layer].remove(prev);
            this.pos[layer].insertElementAt(prev, j);
            for (int jj = j; jj > 0; --jj) {
                NodeInfo njj = (NodeInfo)this.pos[layer].elementAt(jj - 1);
                if (njj.col <= nj.col || !this.isSwappable(njj, nj)) break;
                this.pos[layer].remove(njj);
                this.pos[layer].insertElementAt(njj, jj);
            }
            nj = prev;
        }
        for (j = 0; j < size; ++j) {
            nj = (NodeInfo)this.pos[layer].elementAt(j);
            if (nj.attachedTo == null) continue;
            this.pos[layer].remove(j);
            int index = this.pos[layer].indexOf(nj.attachedTo);
            if (index < j) {
                NodeInfo child = nj.attachedTo.getChild(0, nj.attachedTo.colsize - 1);
                int childIndex = this.pos[layer].indexOf(child);
                this.pos[layer].insertElementAt(nj, childIndex + 1);
                nj.setColumn(nj.attachedTo.col + nj.attachedTo.colsize);
                continue;
            }
            this.pos[layer].insertElementAt(nj, index);
            nj.setColumn(nj.attachedTo.col - nj.colsize);
        }
        int curmin = ((NodeInfo)this.pos[layer].elementAt((int)0)).col;
        int curmax = ((NodeInfo)this.pos[layer].elementAt((int)(size - 1))).col;
        int currange = curmax - curmin + 1;
        int prevrange = max - min + 1;
        int offset = prevrange - size;
        if (offset >= 0) {
            int prev;
            ((NodeInfo)this.pos[layer].elementAt((int)0)).col = prev = curmin <= min ? min : Math.min(min + offset, curmin);
            offset -= prev - min;
            for (int i = 1; i < size; ++i) {
                ni = (NodeInfo)this.pos[layer].elementAt(i);
                if (ni.col <= prev) {
                    ni.col = ++prev;
                    continue;
                }
                ni.col = Math.min(ni.col, prev + 1 + offset);
                offset -= ni.col - prev - 1;
                prev = ni.col;
            }
        } else {
            min = Math.max(curmin, min - (size - prevrange));
            for (int i = 1; i < size; ++i) {
                ni = (NodeInfo)this.pos[layer].elementAt(i);
                ni.col = min + i;
            }
            max = min + size;
        }
    }

    void alignLayerCols(int layer, int type) {
        int oldsize;
        NodeInfo From;
        int curcol;
        int nextcol;
        int kmax;
        Vector v;
        NodeInfo To;
        int size = this.pos[layer].size();
        Hashtable hash = new Hashtable();
        Stack<NodeInfo> curs = new Stack<NodeInfo>();
        int prevcol = Integer.MIN_VALUE;
        NodeInfo next = (NodeInfo)this.pos[layer].elementAt(0);
        if (type == 0) {
            To = null;
            for (int j = 0; j < size - 1; ++j) {
                To = next;
                v = To.inEdges;
                kmax = v.size();
                next = (NodeInfo)this.pos[layer].elementAt(j + 1);
                nextcol = next.col;
                if (kmax == 0 || To.revDummy) {
                    prevcol = To.col;
                    continue;
                }
                curcol = 0;
                for (int i = 0; i < kmax; ++i) {
                    From = (NodeInfo)v.elementAt(i);
                    curcol += From.col;
                }
                To.col = Math.min(nextcol - 1, Math.max(prevcol + 1, curcol /= kmax));
                if (curcol != To.col) {
                    curs.push(To);
                    Vector<Object> vv = new Vector<Object>();
                    vv.setSize(3);
                    vv.setElementAt(new Integer(curcol), 0);
                    if (j != 0) {
                        vv.setElementAt(this.pos[layer].elementAt(j - 1), 1);
                    }
                    vv.setElementAt(next, 2);
                    hash.put(To, vv);
                }
                prevcol = To.col;
            }
            v = next.inEdges;
            kmax = v.size();
            if (kmax != 0 && !next.revDummy) {
                curcol = 0;
                for (int i = 0; i < kmax; ++i) {
                    From = (NodeInfo)v.elementAt(i);
                    curcol += From.col;
                }
                next.col = Math.max(prevcol + 1, curcol /= kmax);
                if (curcol != next.col) {
                    curs.push(next);
                    Vector<Object> vv = new Vector<Object>();
                    vv.setSize(3);
                    vv.setElementAt(new Integer(curcol), 0);
                    vv.setElementAt(To, 1);
                    vv.setElementAt(null, 2);
                    hash.put(next, vv);
                }
            }
        } else {
            From = null;
            for (int j = 0; j < size - 1; ++j) {
                From = next;
                v = From.outEdges;
                kmax = v.size();
                next = (NodeInfo)this.pos[layer].elementAt(j + 1);
                nextcol = next.col;
                if (kmax == 0 || From.revDummy) {
                    prevcol = From.col;
                    continue;
                }
                curcol = 0;
                for (int i = 0; i < kmax; ++i) {
                    To = (NodeInfo)v.elementAt(i);
                    curcol += To.col;
                }
                From.col = Math.min(nextcol - 1, Math.max(prevcol + 1, curcol /= kmax));
                if (curcol != From.col) {
                    curs.push(From);
                    Vector<Object> vv = new Vector<Object>();
                    vv.setSize(3);
                    vv.setElementAt(new Integer(curcol), 0);
                    if (j != 0) {
                        vv.setElementAt(this.pos[layer].elementAt(j - 1), 1);
                    }
                    vv.setElementAt(next, 2);
                    hash.put(From, vv);
                }
                prevcol = From.col;
            }
            v = next.outEdges;
            kmax = v.size();
            if (kmax != 0 && !next.revDummy) {
                curcol = 0;
                for (int i = 0; i < kmax; ++i) {
                    To = (NodeInfo)v.elementAt(i);
                    curcol += To.col;
                }
                next.col = Math.max(prevcol + 1, curcol /= kmax);
                if (curcol != next.col) {
                    curs.push(next);
                    Vector<Object> vv = new Vector<Object>();
                    vv.setSize(3);
                    vv.setElementAt(new Integer(curcol), 0);
                    vv.setElementAt(From, 1);
                    vv.setElementAt(null, 2);
                    hash.put(next, vv);
                }
            }
        }
        int n = oldsize = curs.size() == 0 ? 0 : 100;
        while (curs.size() < oldsize) {
            oldsize = curs.size();
            Stack<NodeInfo> news = new Stack<NodeInfo>();
            while (!curs.isEmpty()) {
                To = (NodeInfo)curs.pop();
                v = (Vector)hash.get(To);
                curcol = (Integer)v.elementAt(0);
                NodeInfo prev = (NodeInfo)v.elementAt(1);
                if (prev != null) {
                    To.col = Math.max(prev.col + 1, curcol);
                }
                if ((next = (NodeInfo)v.elementAt(2)) != null) {
                    To.col = Math.min(next.col - 1, curcol);
                }
                if (curcol == To.col) continue;
                news.push(To);
            }
            curs = news;
        }
    }

    private void checkReverseLinks() {
        boolean horzflow = this.orientation == 2 || this.orientation == 3;
        for (int i = 0; i < this.numLinks; ++i) {
            LinkLayoutInterface arc = (LinkLayoutInterface)this.links.elementAt(i);
            if (!arc.isVisible()) continue;
            NodeLayoutInterface n1 = arc.getTopFromNode();
            NodeLayoutInterface n2 = arc.getTopToNode();
            if (!n1.isVisible() || !n2.isVisible()) continue;
            int from = this.nodes.indexOf(n1);
            int to = this.nodes.indexOf(n2);
            NodeInfo From = (NodeInfo)this.allinfo.elementAt(from);
            NodeInfo To = (NodeInfo)this.allinfo.elementAt(to);
            if (From.layer <= To.layer) continue;
            Point loc = n1.getCenterLocation();
            if (!arc.isCustomBreakPointsUsed() || arc.getNumBreakPoints() <= 0) continue;
            Point pt1 = arc.getBreakPoint(0);
            if (horzflow) {
                if (pt1.y > loc.y) {
                    arc.setFromNode(n1, "south");
                    arc.setToNode(n2, "south");
                    continue;
                }
                arc.setFromNode(n1, "north");
                arc.setToNode(n2, "north");
                continue;
            }
            if (pt1.x > loc.x) {
                arc.setFromNode(n1, "east");
                arc.setToNode(n2, "east");
                continue;
            }
            arc.setFromNode(n1, "west");
            arc.setToNode(n2, "west");
        }
    }

    private void assignPosition() {
        int num = this.ninfo.size();
        for (int i = 0; i < num; ++i) {
            NodeInfo ni = (NodeInfo)this.ninfo.elementAt(i);
            if (ni == null || ni instanceof NodeInfoExtension) continue;
            if (ni.layer == -1) {
                System.out.println("_DEBUG_:Column not initialized");
                continue;
            }
            for (int j = 0; j < ni.layersize; ++j) {
                for (int k = 0; k < ni.colsize; ++k) {
                    NodeInfo njk = ni.getChild(j, k);
                    this.insertNodeToPos(njk, -1);
                }
            }
        }
    }

    private void assignPositionByLocation() {
        int num = this.ninfo.size();
        for (int i = 0; i < num; ++i) {
            NodeInfo ni = (NodeInfo)this.ninfo.elementAt(i);
            if (ni == null || ni instanceof NodeInfoExtension) continue;
            if (ni.layer == -1) {
                System.out.println("_DEBUG_:Column not initialized");
                continue;
            }
            int baseCol = this.getColByLocation(ni);
            for (int j = 0; j < ni.layersize; ++j) {
                for (int k = 0; k < ni.colsize; ++k) {
                    NodeInfo njk = ni.getChild(j, k);
                    this.insertNodeToPos(njk, baseCol + k);
                }
            }
        }
    }

    private int getColByLocation(NodeInfo ni) {
        int index = -1;
        if (ni.layer == -1) {
            return index;
        }
        int x = ni.node.getX();
        int y = ni.node.getY();
        block4: for (int i = 0; i < this.pos[ni.layer].size(); ++i) {
            NodeInfo nii = (NodeInfo)this.pos[ni.layer].get(i);
            if (nii instanceof NodeInfoExtension) continue;
            switch (this.orientation) {
                case 2: 
                case 3: {
                    if (y < nii.node.getY()) {
                        return index + 1;
                    }
                    index = i + nii.colsize - 1;
                    continue block4;
                }
                case 0: 
                case 1: {
                    if (x < nii.node.getX()) {
                        return index + 1;
                    }
                    index = i + nii.colsize - 1;
                }
            }
        }
        return index + 1;
    }

    private void insertNodeToPos(NodeInfo ni, int index) {
        if (ni.layer == -1) {
            System.out.println("_DEBUG_:Column not initialized");
            return;
        }
        if (index == -1 || index > this.pos[ni.layer].size()) {
            this.pos[ni.layer].add(ni);
        } else {
            this.pos[ni.layer].add(index, ni);
        }
        int n = ni.layer;
        this.layerWidth[n] = this.layerWidth[n] + 1;
        this.maxSize = Math.max(this.maxSize, this.layerWidth[ni.layer]);
    }

    private void assignPosByColumns() {
        int unasSize;
        NodeInfo ni;
        int num = this.ninfo.size();
        Vector<NodeInfo> unassigned = new Vector<NodeInfo>();
        Point[] points = new Point[num];
        for (int i = 0; i < num; ++i) {
            int pp;
            ni = (NodeInfo)this.ninfo.elementAt(i);
            if (ni == null) continue;
            if (ni instanceof NodeInfoExtension) {
                NodeInfoExtension nie = (NodeInfoExtension)ni;
                nie.col = nie.parent.col == -1 ? -1 : nie.parent.col + nie.colOffset;
            }
            if (ni.col == -1) {
                unassigned.add(ni);
                continue;
            }
            int lsize = this.pos[ni.layer].size();
            for (pp = 0; pp < lsize && ni.col >= ((NodeInfo)this.pos[ni.layer].elementAt((int)pp)).col; ++pp) {
            }
            this.insertNodeToPos(ni, pp);
        }
        if (unassigned.size() == num) {
            this.assignPosition();
            return;
        }
        Stack<NodeInfo> almostReady = new Stack<NodeInfo>();
        while ((unasSize = unassigned.size()) > 0) {
            block3: for (int i = unasSize - 1; i >= 0; --i) {
                int j;
                ni = (NodeInfo)unassigned.elementAt(i);
                if (ni instanceof NodeInfoExtension) {
                    NodeInfoExtension nie = (NodeInfoExtension)ni;
                    if (nie.parent.col == -1) continue;
                    nie.col = nie.parent.col + nie.colOffset;
                    almostReady.push(nie);
                    unassigned.remove(i);
                    continue;
                }
                boolean found = false;
                if (ni.inEdges.size() > 0) {
                    for (j = 0; j < ni.inEdges.size(); ++j) {
                        ni.col = ((NodeInfo)ni.inEdges.elementAt((int)j)).col;
                        if (ni.col == -1) continue;
                        almostReady.push(ni);
                        unassigned.remove(i);
                        found = true;
                        break;
                    }
                }
                if (found || ni.outEdges.size() <= 0) continue;
                for (j = 0; j < ni.outEdges.size(); ++j) {
                    ni.col = ((NodeInfo)ni.outEdges.elementAt((int)j)).col;
                    if (ni.col == -1) continue;
                    almostReady.push(ni);
                    unassigned.remove(i);
                    continue block3;
                }
            }
            while (!almostReady.isEmpty()) {
                int pp;
                ni = (NodeInfo)almostReady.pop();
                int lsize = this.pos[ni.layer].size();
                block7: for (pp = 0; pp < lsize; ++pp) {
                    int pcol;
                    NodeInfo nj = (NodeInfo)this.pos[ni.layer].elementAt(pp);
                    if (ni.col < nj.col) break;
                    if (ni.col != nj.col) continue;
                    int n = pcol = pp > 0 ? ((NodeInfo)this.pos[ni.layer].elementAt((int)(pp - 1))).col : Math.max(-1, nj.col - 2);
                    if (!(ni instanceof NodeInfoExtension) && pcol + 1 < nj.col) {
                        ni.col = nj.col - 1;
                        break;
                    }
                    while (pp < lsize) {
                        nj = (NodeInfo)this.pos[ni.layer].elementAt(pp);
                        if (ni.col != nj.col) break block7;
                        if (this.isSwappable(ni, nj)) {
                            ni.col = nj.col + 1;
                            ++pp;
                            continue;
                        }
                        ++nj.col;
                        break block7;
                    }
                    break;
                }
                this.insertNodeToPos(ni, pp);
            }
        }
    }

    private void assignPosByColumns2() {
        int num = this.ninfo.size();
        Vector<NodeInfo> newnodes = new Vector<NodeInfo>();
        for (int i = 0; i < num; ++i) {
            int pp;
            NodeInfo ni = (NodeInfo)this.ninfo.elementAt(i);
            if (ni == null) continue;
            if (ni.col == -1) {
                newnodes.add(ni);
                continue;
            }
            int lsize = this.pos[ni.layer].size();
            for (pp = 0; pp < lsize && ni.col >= ((NodeInfo)this.pos[ni.layer].elementAt((int)pp)).col; ++pp) {
            }
            this.insertNodeToPos(ni, pp);
        }
        int numnn = newnodes.size();
        if (numnn == num) {
            this.assignPosition();
            return;
        }
        if (numnn == 0) {
            return;
        }
        Object[] array = newnodes.toArray();
        Vector[] possoln = new Vector[numnn];
        int singlechoices = 0;
        for (int i = 0; i < numnn; ++i) {
            possoln[i] = new Vector();
            NodeInfo ni = (NodeInfo)array[i];
            int prevcol = -1;
            for (int j = 0; j < this.pos[ni.layer].size(); ++j) {
                int curcol = ((NodeInfo)this.pos[ni.layer].elementAt((int)j)).col;
                while (curcol - prevcol > 1) {
                    possoln[i].add(new Integer(++prevcol));
                }
                prevcol = curcol;
            }
            if (possoln[i].isEmpty()) {
                int pp;
                ni.col = prevcol + 1;
                int lsize = this.pos[ni.layer].size();
                for (pp = 0; pp < lsize && ni.col >= ((NodeInfo)this.pos[ni.layer].elementAt((int)pp)).col; ++pp) {
                }
                this.insertNodeToPos(ni, pp);
                ++singlechoices;
                continue;
            }
            possoln[i].add(new Integer(prevcol + 1));
        }
        NodeInfo[] narray = new NodeInfo[numnn - singlechoices];
        Vector[] choices = new Vector[numnn - singlechoices];
        int index = 0;
        for (int i = 0; i < numnn; ++i) {
            NodeInfo ni = (NodeInfo)array[i];
            if (possoln[i].size() <= 1) continue;
            narray[index] = ni;
            choices[index] = possoln[i];
            ++index;
        }
        if (numnn - singlechoices == 0) {
            return;
        }
        int partialcross = Integer.MAX_VALUE;
        NodeInfo n0 = narray[0];
        while (!choices[0].isEmpty()) {
            int pp;
            int curcol = (Integer)choices[0].firstElement();
            int lsize = this.pos[n0.layer].size();
            for (pp = 0; pp < lsize && curcol >= ((NodeInfo)this.pos[n0.layer].elementAt((int)pp)).col; ++pp) {
            }
            int savecol = n0.col;
            n0.col = curcol;
            this.insertNodeToPos(n0, pp);
            int newcross = this.getBestSoln(narray, choices, 1, partialcross);
            if (newcross < partialcross) {
                partialcross = newcross;
            } else {
                n0.col = savecol;
            }
            this.pos[n0.layer].remove(n0);
            int n = n0.layer;
            this.layerWidth[n] = this.layerWidth[n] - 1;
            choices[0].remove(0);
        }
        for (int i = 0; i < narray.length; ++i) {
            int pp;
            NodeInfo ni = narray[i];
            int lsize = this.pos[ni.layer].size();
            for (pp = 0; pp < lsize && ni.col >= ((NodeInfo)this.pos[ni.layer].elementAt((int)pp)).col; ++pp) {
            }
            this.insertNodeToPos(ni, pp);
        }
    }

    private int getBestSoln(NodeInfo[] array, Vector[] possoln, int index, int partialcross) {
        int alen = array.length;
        if (index == alen) {
            int newcross = 0;
            for (int j = 0; j < alen; ++j) {
                NodeInfo nn;
                int n;
                NodeInfo nm;
                int m;
                NodeInfo nl;
                int l;
                NodeInfo nm2;
                int m2;
                int l2;
                int ink;
                NodeInfo nk;
                int k;
                NodeInfo nj = array[j];
                for (k = 0; k < nj.inEdges.size(); ++k) {
                    NodeInfo nl2;
                    nk = (NodeInfo)nj.inEdges.get(k);
                    ink = this.pos[nk.layer].indexOf(nk);
                    for (l2 = ink - 1; l2 >= 0; --l2) {
                        nl2 = (NodeInfo)this.pos[nk.layer].get(l2);
                        for (m2 = 0; m2 < nl2.outEdges.size(); ++m2) {
                            nm2 = (NodeInfo)nl2.outEdges.get(m2);
                            if (nm2.col <= nj.col) continue;
                            ++newcross;
                        }
                    }
                    for (l2 = ink + 1; l2 < this.pos[nk.layer].size(); ++l2) {
                        nl2 = (NodeInfo)this.pos[nk.layer].get(l2);
                        for (m2 = 0; m2 < nl2.outEdges.size(); ++m2) {
                            nm2 = (NodeInfo)nl2.outEdges.get(m2);
                            if (nm2.col >= nj.col) continue;
                            ++newcross;
                        }
                    }
                    int kosize = nk.outEdges.size();
                    int josize = nj.outEdges.size();
                    if (kosize == 1 || josize == 0) continue;
                    for (l = 0; l < kosize; ++l) {
                        nl = (NodeInfo)nk.outEdges.get(l);
                        if (nl == nj) continue;
                        for (m = 0; m < nl.outEdges.size(); ++m) {
                            nm = (NodeInfo)nl.outEdges.get(m);
                            for (n = 0; n < josize; ++n) {
                                nn = (NodeInfo)nj.outEdges.get(n);
                                if ((nl.col >= nj.col || nm.col <= nn.col) && (nl.col <= nj.col || nm.col >= nn.col)) continue;
                                ++newcross;
                            }
                        }
                    }
                }
                for (k = 0; k < nj.outEdges.size(); ++k) {
                    nk = (NodeInfo)nj.outEdges.get(k);
                    ink = this.pos[nk.layer].indexOf(nk);
                    for (l2 = ink - 1; l2 >= 0; --l2) {
                        NodeInfo nl3 = (NodeInfo)this.pos[nk.layer].get(l2);
                        for (m2 = 0; m2 < nl3.inEdges.size(); ++m2) {
                            nm2 = (NodeInfo)nl3.inEdges.get(m2);
                            if (nm2.col <= nj.col) continue;
                            ++newcross;
                        }
                    }
                    for (l2 = ink + 1; l2 < this.pos[nk.layer].size(); ++l2) {
                        NodeInfo nl4 = (NodeInfo)this.pos[nk.layer].get(l2);
                        for (m2 = 0; m2 < nl4.inEdges.size(); ++m2) {
                            nm2 = (NodeInfo)nl4.inEdges.get(m2);
                            if (nm2.col >= nj.col) continue;
                            ++newcross;
                        }
                    }
                    int kisize = nk.inEdges.size();
                    int jisize = nj.inEdges.size();
                    if (kisize == 1 || jisize == 0) continue;
                    for (l = 0; l < kisize; ++l) {
                        nl = (NodeInfo)nk.inEdges.get(l);
                        if (nl == nj) continue;
                        for (m = 0; m < nl.inEdges.size(); ++m) {
                            nm = (NodeInfo)nl.inEdges.get(m);
                            for (n = 0; n < jisize; ++n) {
                                nn = (NodeInfo)nj.inEdges.get(n);
                                if ((nl.col >= nj.col || nm.col <= nn.col) && (nl.col <= nj.col || nm.col >= nn.col)) continue;
                                ++newcross;
                            }
                        }
                    }
                }
            }
            return newcross;
        }
        NodeInfo ni = array[index];
        Vector soln = (Vector)possoln[index].clone();
        while (!soln.isEmpty()) {
            int pp;
            int curcol = (Integer)soln.firstElement();
            int savedcol = ni.col;
            ni.col = curcol;
            int lsize = this.pos[ni.layer].size();
            for (pp = 0; pp < lsize && curcol >= ((NodeInfo)this.pos[ni.layer].elementAt((int)pp)).col; ++pp) {
            }
            this.insertNodeToPos(ni, pp);
            int newcross = this.getBestSoln(array, possoln, index + 1, partialcross);
            if (newcross < partialcross) {
                partialcross = newcross;
            } else {
                ni.col = savedcol;
            }
            this.pos[ni.layer].remove(ni);
            int n = ni.layer;
            this.layerWidth[n] = this.layerWidth[n] - 1;
            soln.remove(0);
        }
        return partialcross;
    }

    private void flipTree() {
        if (this.totalNodes < 20) {
            return;
        }
        int num = 0;
        int totrow = 0;
        if (this.revtree) {
            int min = Math.max(this.numLayers - 6, this.numLayers / 2);
            for (int i = this.numLayers - 1; i > min; --i) {
                for (int j = 0; j < this.layerWidth[i]; ++j) {
                    NodeInfo To = (NodeInfo)this.pos[i].elementAt(j);
                    totrow += To.col;
                }
                num += this.layerWidth[i];
            }
            if (num > 1) {
                totrow /= num;
            }
            if ((double)totrow > 0.5 * (double)(this.minrow + this.maxrow)) {
                int rsize = this.maxrow - this.minrow;
                Vector v2 = new Vector();
                for (int i = 0; i < this.numLayers; ++i) {
                    Vector v1 = this.pos[i];
                    for (int j = 0; j < this.layerWidth[i]; ++j) {
                        NodeInfo nj = (NodeInfo)v1.elementAt(j);
                        int layerOffset = 0;
                        if (nj instanceof NodeInfoExtension) {
                            if (((NodeInfoExtension)nj).colOffset != 0) continue;
                            layerOffset = ((NodeInfoExtension)nj).layerOffset;
                            nj = ((NodeInfoExtension)nj).parent;
                        } else {
                            int newCol = this.maxrow - (nj.col + nj.colsize - 1);
                            nj.setColumn(newCol);
                        }
                        for (int k = nj.colsize - 1; k >= 0; --k) {
                            NodeInfo njk = nj.getChild(layerOffset, k);
                            v2.insertElementAt(njk, 0);
                        }
                    }
                    this.pos[i] = v2;
                    v2 = v1;
                    v2.removeAllElements();
                }
                this.maxrow -= this.minrow;
                this.minrow = 0;
            }
        } else {
            int max = Math.min(5, this.numLayers / 2);
            for (int i = 0; i < max; ++i) {
                for (int j = 0; j < this.layerWidth[i]; ++j) {
                    NodeInfo To = (NodeInfo)this.pos[i].elementAt(j);
                    totrow += To.col;
                }
                num += this.layerWidth[i];
            }
            if (num > 1) {
                totrow /= num;
            }
            if ((double)totrow > 0.5 * (double)(this.minrow + this.maxrow)) {
                int rsize = this.maxrow - this.minrow;
                Vector v2 = new Vector();
                for (int i = 0; i < this.numLayers; ++i) {
                    Vector v1 = this.pos[i];
                    for (int j = 0; j < this.layerWidth[i]; ++j) {
                        NodeInfo nj = (NodeInfo)v1.elementAt(j);
                        int layerOffset = 0;
                        if (nj instanceof NodeInfoExtension) {
                            if (((NodeInfoExtension)nj).colOffset != 0) continue;
                            layerOffset = ((NodeInfoExtension)nj).layerOffset;
                            nj = ((NodeInfoExtension)nj).parent;
                        } else {
                            int newCol = this.maxrow - (nj.col + nj.colsize - 1);
                            nj.setColumn(newCol);
                        }
                        for (int k = nj.colsize - 1; k >= 0; --k) {
                            NodeInfo njk = nj.getChild(layerOffset, k);
                            v2.insertElementAt(njk, 0);
                        }
                    }
                    this.pos[i] = v2;
                    v2 = v1;
                    v2.removeAllElements();
                }
                this.maxrow -= this.minrow;
                this.minrow = 0;
            }
        }
    }

    private void compressRows() {
        int i;
        if (this.minrow < 0) {
            this.maxrow -= this.minrow;
        }
        boolean[] used = new boolean[this.maxrow + 1];
        int[] delta = new int[this.maxrow + 1];
        for (int i2 = 0; i2 <= this.maxrow; ++i2) {
            used[i2] = false;
            delta[i2] = this.minrow;
        }
        int num = this.ninfo.size();
        for (int i3 = 0; i3 < num; ++i3) {
            NodeInfo ni = (NodeInfo)this.ninfo.elementAt(i3);
            if (ni == null) continue;
            if (this.minrow < 0) {
                ni.col -= this.minrow;
            }
            used[ni.col] = true;
        }
        if (this.minrow < 0) {
            this.minrow = 0;
        }
        int dx = this.minrow;
        for (i = this.minrow; i <= this.maxrow; ++i) {
            if (!used[i]) {
                // empty if block
            }
            delta[i] = ++dx;
        }
        for (i = 0; i < num; ++i) {
            NodeInfo ni = (NodeInfo)this.ninfo.elementAt(i);
            if (ni == null) continue;
            dx = ni.col;
            ni.col = dx - delta[ni.col];
        }
        this.minrow = 0;
        this.maxrow -= delta[this.maxrow];
        if (this.maxLayerWidth == 2 && this.maxrow - this.minrow >= this.maxLayerWidth) {
            for (i = 0; i < this.numLayers; ++i) {
                if (this.layerWidth[i] > 1) {
                    NodeInfo ni = (NodeInfo)this.pos[i].elementAt(0);
                    ni.col = this.minrow;
                    ni = (NodeInfo)this.pos[i].elementAt(1);
                    ni.col = this.minrow + 1;
                    continue;
                }
                if (this.layerWidth[i] <= 0) continue;
                NodeInfo ni = (NodeInfo)this.pos[i].elementAt(0);
                if (ni.col <= this.minrow + 1) continue;
                ni.col = this.minrow + 1;
            }
            this.maxrow = this.minrow + 1;
        }
    }

    private void removeEmptyRows() {
        int i;
        boolean[] used = new boolean[this.maxrow + 1];
        int[] delta = new int[this.maxrow + 1];
        for (int i2 = this.minrow; i2 <= this.maxrow; ++i2) {
            used[i2] = false;
            delta[i2] = 0;
        }
        for (int i3 = 0; i3 < this.ninfo.size(); ++i3) {
            NodeInfo ni = (NodeInfo)this.ninfo.elementAt(i3);
            if (ni == null) continue;
            for (int j = 0; j < ni.colsize; ++j) {
                used[ni.col + j] = true;
            }
        }
        int dx = 0;
        for (i = this.minrow; i <= this.maxrow; ++i) {
            if (!used[i]) {
                // empty if block
            }
            delta[i] = ++dx;
        }
        if (dx == 0) {
            return;
        }
        for (i = 0; i < this.ninfo.size(); ++i) {
            NodeInfo ni = (NodeInfo)this.ninfo.elementAt(i);
            if (ni == null) continue;
            dx = ni.col;
            ni.col = dx - delta[ni.col];
        }
        this.maxrow -= delta[this.maxrow];
    }

    private Vector assignByInSplit(Vector list, int anchor) {
        int i;
        int j;
        int size3;
        Vector v3;
        int j2;
        NodeInfo To;
        NodeInfo From;
        int imax = list.size();
        if (imax <= 1) {
            return list;
        }
        NodeInfo ni = (NodeInfo)list.elementAt(anchor);
        int newanchor = anchor;
        while (ni instanceof NodeInfoExtension && ((NodeInfoExtension)ni).colOffset != 0) {
            if (++newanchor < list.size()) {
                ni = (NodeInfo)list.elementAt(newanchor);
                continue;
            }
            ni = null;
        }
        if (ni == null) {
            newanchor = anchor;
            ni = (NodeInfo)list.elementAt(newanchor);
            while (ni instanceof NodeInfoExtension && ((NodeInfoExtension)ni).colOffset != 0) {
                if (--newanchor >= 0) {
                    ni = (NodeInfo)list.elementAt(newanchor);
                    continue;
                }
                return list;
            }
        }
        boolean isExtension = ni instanceof NodeInfoExtension;
        anchor = newanchor;
        list.remove(anchor);
        --imax;
        ArrayList<NodeInfo> spaceHolderList = new ArrayList<NodeInfo>();
        Vector v1 = this.getInEdges(ni);
        double[] s1 = new double[this.maxSize];
        double[] s2 = new double[this.maxSize];
        int size = v1.size();
        Stack<NodeInfo> ls = new Stack<NodeInfo>();
        Vector niOutEdges = this.getOutEdges(ni);
        if (size < 2 && (niOutEdges == null || niOutEdges.isEmpty())) {
            ls.push(ni);
        }
        for (int i2 = 0; i2 < size; ++i2) {
            int niIndex;
            From = (NodeInfo)v1.elementAt(i2);
            double value = From.col;
            From = this.getParent(From);
            if (From.outports != null && (niIndex = From.outEdges.indexOf(this.getParent(ni))) >= 0 && niIndex < From.outports.length) {
                value += From.outports[niIndex];
            }
            Sort.insert(s1, i2, value);
        }
        Vector left = new Vector();
        Vector right = new Vector();
        Vector outLeft = new Vector();
        Vector outRight = new Vector();
        Vector<NodeInfo> unResolvedNodes = new Vector<NodeInfo>();
        Vector<NodeInfo> unResolvedDummies = new Vector<NodeInfo>();
        int l1 = 0;
        int r1 = 0;
        for (int i3 = 0; i3 < imax; ++i3) {
            int k;
            int index;
            To = (NodeInfo)list.elementAt(i3);
            boolean isExt = false;
            if (To instanceof NodeInfoExtension) {
                if (((NodeInfoExtension)To).colOffset == 0) {
                    isExt = true;
                } else {
                    spaceHolderList.add(To);
                    continue;
                }
            }
            Vector v2 = this.getInEdges(To);
            int size2 = v2.size();
            int cniMulti = 0;
            int cinMulti = 0;
            for (int j3 = 0; j3 < size2; ++j3) {
                From = (NodeInfo)v2.elementAt(j3);
                double value = From.col;
                From = this.getParent(From);
                if (From.outports != null) {
                    int toIndex = From.outEdges.indexOf(this.getParent(To));
                    int niIndex = From.outEdges.indexOf(this.getParent(ni));
                    if (toIndex >= 0 && toIndex < From.outports.length) {
                        value += From.outports[toIndex];
                        if (niIndex >= 0 && niIndex < From.outports.length) {
                            if (From.outports[toIndex] < From.outports[niIndex]) {
                                ++cniMulti;
                            } else if (From.outports[toIndex] > From.outports[niIndex]) {
                                ++cinMulti;
                            }
                        }
                    }
                }
                Sort.insert(s2, j3, value);
            }
            Vector toOutEdges = this.getOutEdges(To);
            if (size2 < 2 && (toOutEdges == null || toOutEdges.isEmpty())) {
                ls.push(To);
            }
            int cin = 0;
            int cni = 0;
            for (j2 = 0; j2 < size; ++j2) {
                index = Sort.getGreaterThanIndex(s2, 0, size2, s1[j2]);
                if (index >= size2) continue;
                cin += size2 - index;
            }
            for (j2 = 0; j2 < size2; ++j2) {
                index = Sort.getGreaterThanIndex(s1, 0, size, s2[j2]);
                if (index >= size) continue;
                cni += size - index;
            }
            if (cniMulti < cinMulti) {
                right.addElement(To);
                v3 = toOutEdges;
                size3 = v3.size();
                for (k = 0; k < size3; ++k) {
                    outRight.addElement(v3.elementAt(k));
                }
                continue;
            }
            if (cniMulti > cinMulti) {
                left.addElement(To);
                v3 = toOutEdges;
                size3 = v3.size();
                for (k = 0; k < size3; ++k) {
                    outLeft.addElement(v3.elementAt(k));
                }
                continue;
            }
            if (cin == cni) {
                if (To.dummy) {
                    unResolvedDummies.addElement(To);
                    continue;
                }
                unResolvedNodes.addElement(To);
                continue;
            }
            if (cin > cni) {
                right.addElement(To);
                v3 = toOutEdges;
                size3 = v3.size();
                for (k = 0; k < size3; ++k) {
                    outRight.addElement(v3.elementAt(k));
                }
                continue;
            }
            left.addElement(To);
            v3 = toOutEdges;
            size3 = v3.size();
            for (k = 0; k < size3; ++k) {
                outLeft.addElement(v3.elementAt(k));
            }
        }
        boolean leaf = niOutEdges == null || niOutEdges.isEmpty();
        size = unResolvedNodes.size();
        v3 = niOutEdges;
        size3 = v3.size();
        int ri = 0;
        int li = 0;
        for (int k = 0; k < size3; ++k) {
            if (outRight.contains(v3.elementAt(k))) {
                ++ri;
                continue;
            }
            if (!outLeft.contains(v3.elementAt(k))) continue;
            ++li;
        }
        boolean rs = ri > li;
        int placed = 0;
        for (j = 0; j < size; ++j) {
            To = (NodeInfo)unResolvedNodes.elementAt(j - placed);
            v3 = this.getOutEdges(To);
            size3 = v3.size();
            l1 = 0;
            r1 = 0;
            for (int k = 0; k < size3; ++k) {
                if (outRight.contains(v3.elementAt(k))) {
                    ++r1;
                    continue;
                }
                if (!outLeft.contains(v3.elementAt(k))) continue;
                ++l1;
            }
            if (r1 < l1 || ni.dummy || rs) {
                left.addElement(To);
                unResolvedNodes.remove(To);
                ++placed;
                continue;
            }
            if (r1 <= l1) continue;
            right.insertElementAt(To, 0);
            unResolvedNodes.remove(To);
            ++placed;
        }
        if (placed != size) {
            size -= placed;
            for (i = 0; i < size / 2; ++i) {
                left.addElement(unResolvedNodes.elementAt(i));
            }
            for (i = size - 1; i >= size / 2; --i) {
                right.insertElementAt(unResolvedNodes.elementAt(i), 0);
            }
        }
        size = unResolvedDummies.size();
        placed = 0;
        for (j = 0; j < size; ++j) {
            To = (NodeInfo)unResolvedDummies.elementAt(j - placed);
            v3 = this.getOutEdges(To);
            size3 = v3.size();
            l1 = 0;
            r1 = 0;
            for (int k = 0; k < size3; ++k) {
                if (outRight.contains(v3.elementAt(k))) {
                    ++r1;
                    continue;
                }
                if (!outLeft.contains(v3.elementAt(k))) continue;
                ++l1;
            }
            if (r1 < l1 || leaf || rs) {
                left.addElement(To);
                unResolvedDummies.remove(To);
                ++placed;
                continue;
            }
            if (r1 <= l1) continue;
            right.insertElementAt(To, 0);
            unResolvedDummies.remove(To);
            ++placed;
        }
        if (placed != size) {
            size -= placed;
            for (i = 0; i < size / 2; ++i) {
                left.addElement(unResolvedDummies.elementAt(i));
            }
            for (i = size - 1; i >= size / 2; --i) {
                right.insertElementAt(unResolvedDummies.elementAt(i), 0);
            }
        }
        int leftSize = left.size();
        int rightSize = right.size();
        if (anchor < imax && (leftSize == 0 && rightSize > 2 || rightSize == 0 && leftSize > 2)) {
            list.insertElementAt(ni, anchor);
            return this.assignByInSplit(list, anchor + 1);
        }
        if (leftSize > 1) {
            left = this.assignByInSplit(left, 0);
        }
        if (rightSize > 1) {
            right = this.assignByInSplit(right, 0);
        }
        left.addElement(ni);
        for (j2 = 0; j2 < rightSize; ++j2) {
            left.addElement(right.elementAt(j2));
        }
        while (!ls.isEmpty()) {
            int ii;
            ni = (NodeInfo)ls.pop();
            Vector niInEdges = this.getInEdges(ni);
            From = (NodeInfo)niInEdges.elementAt(0);
            v1 = this.getOutEdges(From);
            int max = ii = left.indexOf(ni);
            int min = ii;
            for (int j4 = 0; j4 < v1.size(); ++j4) {
                int ij;
                To = (NodeInfo)v1.elementAt(j4);
                Vector toOutEdges = this.getOutEdges(To);
                if (ni == To || toOutEdges.size() == 0 || (ij = left.indexOf(To)) == -1) continue;
                if (ij < min) {
                    min = ij;
                    continue;
                }
                if (ij <= max) continue;
                max = ij;
            }
            if (ii == min || ii == max) continue;
            int distmin = ii - min;
            int distmax = max - ii;
            left.removeElementAt(ii);
            if (distmax > distmin) {
                left.insertElementAt(ni, max);
                continue;
            }
            left.insertElementAt(ni, min);
        }
        this.insertSpaceHolders(left, spaceHolderList);
        return left;
    }

    private void insertSpaceHolders(Vector list, ArrayList spaceHolderList) {
        for (int i = 0; i < spaceHolderList.size(); ++i) {
            NodeInfoExtension nie = (NodeInfoExtension)spaceHolderList.get(i);
            int insertIndex = -1;
            for (int j = 0; j < list.size() && insertIndex == -1; ++j) {
                NodeInfo ni = (NodeInfo)list.get(j);
                if (nie.parent != ni && (!(ni instanceof NodeInfoExtension) || nie.parent != ((NodeInfoExtension)ni).parent)) continue;
                insertIndex = j + 1;
            }
            if (insertIndex == -1) continue;
            boolean found = false;
            while (insertIndex < list.size() && !found) {
                NodeInfo next = (NodeInfo)list.get(insertIndex);
                if (next instanceof NodeInfoExtension && ((NodeInfoExtension)next).parent == nie.parent && ((NodeInfoExtension)next).colOffset < nie.colOffset) {
                    ++insertIndex;
                    continue;
                }
                found = true;
            }
            list.insertElementAt(nie, insertIndex);
        }
    }

    private boolean isCrossingsPresent(Vector list) {
        return this.isCrossingsPresent(list, 2);
    }

    private boolean isCrossingsPresent(Vector list, int checkDirection) {
        int imax = list.size();
        if (imax <= 1) {
            return false;
        }
        int maxInCol = Integer.MIN_VALUE;
        int maxOutCol = Integer.MIN_VALUE;
        for (int i = 0; i < imax; ++i) {
            int nkcol;
            int k;
            int ins;
            NodeInfo nj;
            int j;
            NodeInfo ni = (NodeInfo)list.elementAt(i);
            boolean isExtension = false;
            if (ni instanceof NodeInfoExtension) {
                if (((NodeInfoExtension)ni).colOffset != 0) continue;
                isExtension = true;
            }
            if (checkDirection != 1) {
                Vector niInEdges = this.getInEdges(ni);
                int inSize = niInEdges.size();
                if (inSize > 0) {
                    for (j = 0; j < inSize; ++j) {
                        maxInCol = Math.max(maxInCol, ((NodeInfo)niInEdges.elementAt((int)j)).col);
                    }
                }
                for (j = i + 1; j < imax; ++j) {
                    nj = (NodeInfo)list.elementAt(j);
                    if (nj instanceof NodeInfoExtension && ((NodeInfoExtension)nj).colOffset != 0) continue;
                    Vector njInEdges = this.getInEdges(nj);
                    ins = njInEdges.size();
                    for (k = 0; k < ins; ++k) {
                        NodeInfo nk = (NodeInfo)njInEdges.elementAt(k);
                        if (nk.col >= maxInCol) continue;
                        return true;
                    }
                }
                if (this.hasMultiPorts && inSize > 0) {
                    for (j = 0; j < inSize; ++j) {
                        int niindex;
                        int outs;
                        nj = (NodeInfo)niInEdges.get(j);
                        if (nj.outports == null || (outs = nj.outEdges.size()) < 2 || (niindex = nj.outEdges.indexOf(this.getParent(ni))) < 0) continue;
                        int nicol = ni.col;
                        for (int k2 = 0; k2 < outs; ++k2) {
                            if (k2 >= nj.outports.length || niindex >= nj.outports.length || nj.outports[k2] == nj.outports[niindex]) continue;
                            nkcol = ((NodeInfo)nj.outEdges.get((int)k2)).col;
                            if (!(nj.outports[k2] > nj.outports[niindex] && nkcol < nicol) && (!(nj.outports[k2] < nj.outports[niindex]) || nkcol <= nicol)) continue;
                            return true;
                        }
                    }
                }
            }
            if (checkDirection == 0) continue;
            Vector niOutEdges = this.getOutEdges(ni);
            int outSize = niOutEdges.size();
            if (outSize > 0) {
                for (j = 0; j < outSize; ++j) {
                    maxOutCol = Math.max(maxOutCol, ((NodeInfo)niOutEdges.elementAt((int)j)).col);
                }
            }
            for (j = i + 1; j < imax; ++j) {
                nj = (NodeInfo)list.elementAt(j);
                if (nj instanceof NodeInfoExtension && ((NodeInfoExtension)nj).colOffset != 0) continue;
                Vector njOutEdges = this.getOutEdges(nj);
                ins = njOutEdges.size();
                for (k = 0; k < ins; ++k) {
                    NodeInfo nk = (NodeInfo)njOutEdges.elementAt(k);
                    if (nk.col >= maxOutCol) continue;
                    return true;
                }
            }
            if (!this.hasMultiPorts || outSize <= 0) continue;
            for (j = 0; j < outSize; ++j) {
                int niIndex;
                int ins2;
                nj = (NodeInfo)niOutEdges.get(j);
                if (nj.inports == null || (ins2 = nj.inEdges.size()) < 2 || (niIndex = nj.inEdges.indexOf(this.getParent(ni))) < 0) continue;
                int niCol = ni.col;
                for (int k3 = 0; k3 < ins2; ++k3) {
                    if (k3 >= nj.inports.length || niIndex >= nj.inports.length || nj.inports[k3] == nj.inports[niIndex]) continue;
                    nkcol = ((NodeInfo)nj.inEdges.get((int)k3)).col;
                    if (!(nj.inports[k3] > nj.inports[niIndex] && nkcol < niCol) && (!(nj.inports[k3] < nj.inports[niIndex]) || nkcol <= niCol)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private NodeInfo getParent(NodeInfo ni) {
        if (ni instanceof NodeInfoExtension) {
            return ((NodeInfoExtension)ni).parent;
        }
        return ni;
    }

    private Vector getInEdges(NodeInfo ni) {
        if (ni instanceof NodeInfoExtension) {
            NodeInfoExtension nie = (NodeInfoExtension)ni;
            if (nie.colOffset != 0) {
                return null;
            }
            Vector<NodeInfo> inEdges = new Vector<NodeInfo>(1);
            inEdges.add(nie.parent.getChild(nie.layerOffset - 1, 0));
            return inEdges;
        }
        Vector<NodeInfo> niInEdges = new Vector<NodeInfo>(ni.inEdges.size());
        for (int i = 0; i < ni.inEdges.size(); ++i) {
            NodeInfo node = (NodeInfo)ni.inEdges.get(i);
            niInEdges.add(node.getChild(node.layersize - 1, 0));
        }
        return niInEdges;
    }

    private Vector getOutEdges(NodeInfo ni) {
        int nextLayer;
        NodeInfo parent;
        if (ni instanceof NodeInfoExtension) {
            NodeInfoExtension nie = (NodeInfoExtension)ni;
            if (nie.colOffset != 0) {
                return null;
            }
            parent = nie.parent;
            nextLayer = nie.layerOffset + 1;
        } else {
            parent = ni;
            nextLayer = 1;
        }
        NodeInfo nextNode = parent.getChild(nextLayer, 0);
        if (nextNode != null) {
            Vector<NodeInfo> outEdges = new Vector<NodeInfo>(1);
            outEdges.add(nextNode);
            return outEdges;
        }
        return parent.outEdges;
    }

    private Vector enforceColsByLocs(Vector list) {
        int size = list.size();
        if (size <= 1) {
            return list;
        }
        Vector<NodeInfo> result = new Vector<NodeInfo>();
        Stack temp = new Stack();
        boolean rsize = false;
        int index = 0;
        for (int i = 0; i < size; ++i) {
            NodeInfo ni = (NodeInfo)list.elementAt(i);
            if (ni.col == -1 || ni.dummy) {
                result.addElement(ni);
                continue;
            }
            index = i;
            for (int j = 0; j < i; ++j) {
                NodeInfo nj = (NodeInfo)result.elementAt(j);
                if (nj.col <= ni.col || nj.dummy) continue;
                index = j;
                break;
            }
            if (index == i) {
                result.addElement(ni);
                continue;
            }
            result.insertElementAt(ni, index);
        }
        return result;
    }

    private Vector assignByOutSplit(Vector list, int anchor) {
        int size3;
        Vector v3;
        NodeInfo From;
        NodeInfo To;
        int imax = list.size();
        if (imax <= 1) {
            return list;
        }
        NodeInfo ni = (NodeInfo)list.elementAt(anchor);
        int newanchor = anchor;
        while (ni instanceof NodeInfoExtension && ((NodeInfoExtension)ni).colOffset != 0) {
            if (++newanchor < list.size()) {
                ni = (NodeInfo)list.elementAt(newanchor);
                continue;
            }
            ni = null;
        }
        if (ni == null) {
            newanchor = anchor;
            ni = (NodeInfo)list.elementAt(newanchor);
            while (ni instanceof NodeInfoExtension && ((NodeInfoExtension)ni).colOffset != 0) {
                if (--newanchor >= 0) {
                    ni = (NodeInfo)list.elementAt(newanchor);
                    continue;
                }
                return list;
            }
        }
        boolean isExtension = ni instanceof NodeInfoExtension;
        anchor = newanchor;
        list.remove(anchor);
        --imax;
        Vector v1 = this.getOutEdges(ni);
        double[] s1 = new double[this.maxSize];
        double[] s2 = new double[this.maxSize];
        int size = v1.size();
        for (int i = 0; i < size; ++i) {
            int niIndex;
            To = (NodeInfo)v1.elementAt(i);
            double value = To.col;
            To = this.getParent(To);
            if (To.inports != null && (niIndex = To.inEdges.indexOf(this.getParent(ni))) >= 0 && niIndex < To.inports.length) {
                value += To.inports[niIndex];
            }
            Sort.insert(s1, i, value);
        }
        Vector left = new Vector();
        Vector right = new Vector();
        Vector inLeft = new Vector();
        Vector inRight = new Vector();
        Vector<NodeInfo> unResolved = new Vector<NodeInfo>();
        ArrayList<NodeInfo> spaceHolderList = new ArrayList<NodeInfo>();
        int l1 = 0;
        int r1 = 0;
        for (int i = 0; i < imax; ++i) {
            int k;
            int index;
            int j;
            From = (NodeInfo)list.elementAt(i);
            boolean isExt = false;
            if (From instanceof NodeInfoExtension) {
                if (((NodeInfoExtension)From).colOffset == 0) {
                    isExt = true;
                } else {
                    spaceHolderList.add(From);
                    continue;
                }
            }
            int cniMulti = 0;
            int cinMulti = 0;
            Vector v2 = this.getOutEdges(From);
            int size2 = v2.size();
            for (j = 0; j < size2; ++j) {
                To = (NodeInfo)v2.elementAt(j);
                double value = To.col;
                To = this.getParent(To);
                if (To.inports != null) {
                    int fromIndex = To.inEdges.indexOf(this.getParent(From));
                    int niIndex = To.inEdges.indexOf(this.getParent(ni));
                    if (fromIndex >= 0 && fromIndex < To.inports.length) {
                        value += To.inports[fromIndex];
                        if (niIndex >= 0 && niIndex < To.inports.length) {
                            if (To.inports[fromIndex] < To.inports[niIndex]) {
                                ++cniMulti;
                            } else if (To.inports[fromIndex] > To.inports[niIndex]) {
                                ++cinMulti;
                            }
                        }
                    }
                }
                Sort.insert(s2, j, value);
            }
            int cin = 0;
            int cni = 0;
            for (j = 0; j < size; ++j) {
                index = Sort.getGreaterThanIndex(s2, 0, size2, s1[j]);
                if (index >= size2) continue;
                cin += size2 - index;
            }
            for (j = 0; j < size2; ++j) {
                index = Sort.getGreaterThanIndex(s1, 0, size, s2[j]);
                if (index >= size) continue;
                cni += size - index;
            }
            if (cniMulti < cinMulti) {
                right.addElement(From);
                v3 = this.getInEdges(From);
                size3 = v3.size();
                for (k = 0; k < size3; ++k) {
                    inRight.addElement(v3.elementAt(k));
                }
                continue;
            }
            if (cniMulti > cinMulti) {
                left.addElement(From);
                v3 = this.getInEdges(From);
                size3 = v3.size();
                for (k = 0; k < size3; ++k) {
                    inLeft.addElement(v3.elementAt(k));
                }
                continue;
            }
            if (cin == cni) {
                unResolved.addElement(From);
                continue;
            }
            if (cin > cni) {
                right.addElement(From);
                v3 = this.getInEdges(From);
                size3 = v3.size();
                for (k = 0; k < size3; ++k) {
                    inRight.addElement(v3.elementAt(k));
                }
                continue;
            }
            left.addElement(From);
            v3 = this.getInEdges(From);
            size3 = v3.size();
            for (k = 0; k < size3; ++k) {
                inLeft.addElement(v3.elementAt(k));
            }
        }
        size = unResolved.size();
        int placed = 0;
        for (int j = 0; j < size; ++j) {
            From = (NodeInfo)unResolved.elementAt(j - placed);
            v3 = this.getInEdges(From);
            size3 = v3.size();
            l1 = 0;
            r1 = 0;
            for (int k = 0; k < size3; ++k) {
                if (inRight.contains(v3.elementAt(k))) {
                    ++r1;
                    continue;
                }
                if (!inLeft.contains(v3.elementAt(k))) continue;
                ++l1;
            }
            if (r1 < l1) {
                left.addElement(From);
                unResolved.remove(From);
                ++placed;
                continue;
            }
            if (r1 <= l1) continue;
            right.addElement(From);
            unResolved.remove(From);
            ++placed;
        }
        if (placed != size) {
            int i;
            size -= placed;
            for (i = 0; i < size / 2; ++i) {
                left.addElement(unResolved.elementAt(i));
            }
            for (i = size - 1; i >= size / 2; --i) {
                right.insertElementAt(unResolved.elementAt(i), 0);
            }
        }
        int leftSize = left.size();
        int rightSize = right.size();
        if (anchor < imax && (leftSize == 0 && rightSize > 2 || rightSize == 0 && leftSize > 2)) {
            list.insertElementAt(ni, anchor);
            return this.assignByOutSplit(list, anchor + 1);
        }
        if (leftSize > 1) {
            left = this.assignByOutSplit(left, 0);
        }
        if (rightSize > 1) {
            right = this.assignByOutSplit(right, 0);
        }
        left.addElement(ni);
        for (int j = 0; j < rightSize; ++j) {
            left.addElement(right.elementAt(j));
        }
        this.insertSpaceHolders(left, spaceHolderList);
        return left;
    }

    private Vector assignByAllSplit(Vector list, int anchor) {
        NodeInfo To;
        NodeInfo From;
        int jmax = list.size();
        if (jmax <= 1) {
            return list;
        }
        NodeInfo ni = (NodeInfo)list.elementAt(anchor);
        int newanchor = anchor;
        while (ni instanceof NodeInfoExtension && ((NodeInfoExtension)ni).colOffset != 0) {
            if (++newanchor < list.size()) {
                ni = (NodeInfo)list.elementAt(newanchor);
                continue;
            }
            ni = null;
        }
        if (ni == null) {
            newanchor = anchor;
            ni = (NodeInfo)list.elementAt(newanchor);
            while (ni instanceof NodeInfoExtension && ((NodeInfoExtension)ni).colOffset != 0) {
                if (--newanchor >= 0) {
                    ni = (NodeInfo)list.elementAt(newanchor);
                    continue;
                }
                return list;
            }
        }
        boolean isExtension = ni instanceof NodeInfoExtension;
        anchor = newanchor;
        list.remove(anchor);
        --jmax;
        double[] s1in = new double[this.maxSize];
        double[] s1out = new double[this.maxSize];
        double[] s2in = new double[this.maxSize];
        double[] s2out = new double[this.maxSize];
        Vector v1in = this.getInEdges(ni);
        int insize1 = v1in.size();
        for (int i = 0; i < insize1; ++i) {
            int niIndex;
            From = (NodeInfo)v1in.elementAt(i);
            double value = From.col;
            From = this.getParent(From);
            if (From.outports != null && (niIndex = From.outEdges.indexOf(this.getParent(ni))) >= 0 && niIndex < From.outports.length) {
                value += From.outports[niIndex];
            }
            Sort.insert(s1in, i, value);
        }
        Vector v1out = this.getOutEdges(ni);
        int outsize1 = v1out.size();
        for (int i = 0; i < outsize1; ++i) {
            int niIndex;
            To = (NodeInfo)v1out.elementAt(i);
            double value = To.col;
            To = this.getParent(To);
            if (To.inports != null && (niIndex = To.inEdges.indexOf(this.getParent(ni))) >= 0 && niIndex < To.inports.length) {
                value += To.inports[niIndex];
            }
            Sort.insert(s1out, i, value);
        }
        Vector left = new Vector();
        Vector right = new Vector();
        ArrayList<NodeInfo> spaceHolderList = new ArrayList<NodeInfo>();
        for (int j = 0; j < jmax; ++j) {
            int i;
            int index;
            int i2;
            NodeInfo nj = (NodeInfo)list.elementAt(j);
            boolean isExt = false;
            int cnjMulti = 0;
            int cjnMulti = 0;
            if (nj instanceof NodeInfoExtension) {
                if (((NodeInfoExtension)nj).colOffset == 0) {
                    isExt = true;
                } else {
                    spaceHolderList.add(nj);
                    continue;
                }
            }
            Vector v2in = this.getInEdges(nj);
            int insize2 = v2in.size();
            for (i2 = 0; i2 < insize2; ++i2) {
                From = (NodeInfo)v2in.elementAt(i2);
                double value = From.col;
                From = this.getParent(From);
                if (From.outports != null) {
                    int njIndex = From.outEdges.indexOf(this.getParent(nj));
                    int niIndex = From.outEdges.indexOf(this.getParent(ni));
                    if (njIndex >= 0 && njIndex < From.outports.length) {
                        value += From.outports[njIndex];
                        if (niIndex >= 0 && niIndex < From.outports.length) {
                            if (From.outports[njIndex] < From.outports[niIndex]) {
                                ++cnjMulti;
                            } else if (From.outports[njIndex] > From.outports[niIndex]) {
                                ++cjnMulti;
                            }
                        }
                    }
                }
                Sort.insert(s2in, i2, value);
            }
            int cjnOut = 0;
            int cjnIn = 0;
            int cjn = 0;
            int cnjOut = 0;
            int cnjIn = 0;
            int cnj = 0;
            for (i2 = 0; i2 < insize2; ++i2) {
                index = Sort.getGreaterThanIndex(s1in, 0, insize1, s2in[i2]);
                if (index >= insize1) continue;
                cnjIn += insize1 - index;
            }
            for (i2 = 0; i2 < insize1; ++i2) {
                index = Sort.getGreaterThanIndex(s2in, 0, insize2, s1in[i2]);
                if (index >= insize2) continue;
                cjnIn += insize2 - index;
            }
            Vector v2out = this.getOutEdges(nj);
            int outsize2 = v2out.size();
            for (i = 0; i < outsize2; ++i) {
                To = (NodeInfo)v2out.elementAt(i);
                double value = To.col;
                To = this.getParent(To);
                if (To.inports != null) {
                    int njIndex = To.inEdges.indexOf(this.getParent(nj));
                    int niIndex = To.inEdges.indexOf(this.getParent(ni));
                    if (njIndex >= 0 && njIndex < To.inports.length) {
                        value += To.inports[njIndex];
                        if (niIndex >= 0 && niIndex < To.inports.length) {
                            if (To.inports[njIndex] < To.inports[niIndex]) {
                                ++cnjMulti;
                            } else if (To.inports[njIndex] > To.inports[niIndex]) {
                                ++cjnMulti;
                            }
                        }
                    }
                }
                Sort.insert(s2out, i, value);
            }
            for (i = 0; i < outsize2; ++i) {
                index = Sort.getGreaterThanIndex(s1out, 0, outsize1, s2out[i]);
                if (index >= outsize1) continue;
                cnjOut += outsize1 - index;
            }
            for (i = 0; i < outsize1; ++i) {
                index = Sort.getGreaterThanIndex(s2out, 0, outsize2, s1out[i]);
                if (index >= outsize2) continue;
                cjnOut += outsize2 - index;
            }
            cnj = cnjIn + cnjOut;
            cjn = cjnIn + cjnOut;
            if (cnjMulti < cjnMulti) {
                if (outsize2 == 0) {
                    right.addElement(nj);
                } else {
                    right.insertElementAt(nj, 0);
                }
                if (!ni.countCrossings || !nj.countCrossings) continue;
                this.crossings += cnj;
                continue;
            }
            if (cnjMulti > cjnMulti) {
                if (outsize2 == 0) {
                    left.insertElementAt(nj, 0);
                } else {
                    left.addElement(nj);
                }
                if (!ni.countCrossings || !nj.countCrossings) continue;
                this.crossings += cjn;
                continue;
            }
            if (cjn >= cnj) {
                if (outsize2 == 0) {
                    right.addElement(nj);
                } else {
                    right.insertElementAt(nj, 0);
                }
                if (!ni.countCrossings || !nj.countCrossings) continue;
                this.crossings += cnj;
                continue;
            }
            if (outsize2 == 0) {
                left.insertElementAt(nj, 0);
            } else {
                left.addElement(nj);
            }
            if (!ni.countCrossings || !nj.countCrossings) continue;
            this.crossings += cjn;
        }
        int leftSize = left.size();
        int rightSize = right.size();
        if (leftSize > 1) {
            left = this.assignByAllSplit(left, 0);
        }
        if (rightSize > 1) {
            right = this.assignByAllSplit(right, 0);
        }
        left.addElement(ni);
        for (int j = 0; j < rightSize; ++j) {
            left.addElement(right.elementAt(j));
        }
        this.insertSpaceHolders(left, spaceHolderList);
        return left;
    }

    protected void assignCoords() {
        this.reassignLayers(0, 0);
        this.extractSubdiagramExternalDummyLinks(null);
        this.extractNodeInfo();
        this.reassignPos();
        if (!this.assignNewOnly || this.newLayout) {
            this.resetLinkBreakpoints();
        }
        this.swapSubdiagramDummyLinks();
        if (this.orientation > 1) {
            boolean dummyFlow = this.orientation == 3;
            this.assignHorzFlowCoords(dummyFlow);
            this.assignHorzDummyPoints(dummyFlow);
            this.assignSelfLinks();
        } else {
            boolean dummyFlow = this.orientation == 0;
            this.assignVertFlowCoords(dummyFlow);
            this.assignVertDummyPoints(dummyFlow);
            this.assignSelfLinks();
        }
        this.prevOrientation = this.orientation;
    }

    private void swapSubdiagramDummyLinks() {
        Enumeration rl = this.revlinks.elements();
        while (rl.hasMoreElements()) {
            Vector originalLinks;
            Vector rr;
            LinkLayoutInterface link = (LinkLayoutInterface)rl.nextElement();
            if (!(link instanceof DummyLink) || (rr = (Vector)this.cycleNodes.remove(String.valueOf(link.hashCode()))) == null || (originalLinks = this.getOriginalSubdiagramLinks((DummyLink)link)) == null) continue;
            for (int j = 0; j < originalLinks.size(); ++j) {
                LinkLayoutInterface curLink = (LinkLayoutInterface)originalLinks.elementAt(j);
                this.cycleNodes.put(String.valueOf(curLink.hashCode()), rr);
                this.revlinks.put(String.valueOf(curLink.hashCode()), curLink);
            }
        }
    }

    protected void assignHorzFlowCoords(boolean right) {
        int offset;
        int factor;
        int hspace = this.gridWidth;
        int vspace = this.gridHeight;
        if (right) {
            factor = 1;
            offset = 0;
        } else {
            factor = -1;
            offset = this.numLayers - 1;
        }
        int xo = this.gridWidth * this.xGridBorder;
        int yo = this.gridHeight * this.yGridBorder - this.minrow * vspace;
        if (!this.newLayout) {
            NodeInfo ni;
            int i;
            int[] nl = new int[2 * this.totalNodes];
            int xoffset = 0;
            int yoffset = 0;
            for (i = 0; i < this.totalNodes; ++i) {
                ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null) continue;
                if (right) {
                    nl[2 * i] = xo + hspace * ni.layer;
                    nl[2 * i + 1] = yo + vspace * ni.col;
                    continue;
                }
                nl[2 * i] = xo + hspace * (offset - (ni.layer + ni.layersize - 1));
                nl[2 * i + 1] = yo + vspace * ni.col;
            }
            if (this.prevOrientation == this.orientation) {
                if (this.columnOffsetNode != null) {
                    yoffset = Math.max(0, this.columnOffset % vspace);
                }
                if (this.layerOffsetNode != null) {
                    xoffset = Math.max(0, this.layerOffset % hspace);
                }
            }
            for (i = 0; i < this.totalNodes; ++i) {
                ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null || ni instanceof NodeInfoExtension || ni instanceof SubdiagramNodeInfo || this.assignNewOnly && ni.node.isNodePlaced()) continue;
                Point p = new Point(nl[2 * i] + xoffset, nl[2 * i + 1] + yoffset);
                ni.node.setLayoutLocation(1, p);
                ni.node.setNodePlaced(true);
            }
        } else {
            for (int i = 0; i < this.totalNodes; ++i) {
                NodeInfo ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null || ni instanceof NodeInfoExtension || ni instanceof SubdiagramNodeInfo || this.assignNewOnly && ni.node.isNodePlaced()) continue;
                Point p = right ? new Point(xo + hspace * ni.layer, yo + vspace * ni.col) : new Point(xo + hspace * (offset - (ni.layer + ni.layersize - 1)), yo + vspace * ni.col);
                ni.node.setLayoutLocation(1, p);
                ni.node.setNodePlaced(true);
            }
        }
    }

    private void assignVertFlowCoords(boolean up) {
        int offset;
        int factor;
        int hspace = this.gridWidth;
        int vspace = this.gridHeight;
        if (up) {
            factor = -1;
            offset = this.numLayers - 1;
        } else {
            factor = 1;
            offset = 0;
        }
        int xo = this.gridWidth * this.xGridBorder - this.minrow * hspace;
        int yo = this.gridHeight * this.yGridBorder;
        if (!this.newLayout) {
            NodeInfo ni;
            int i;
            int[] nl = new int[2 * this.totalNodes];
            int min = Math.min(this.bbox.y + vspace / 2 + 1, 10);
            int xoffset = 0;
            int yoffset = 0;
            boolean xset = false;
            boolean yset = false;
            for (i = 0; i < this.totalNodes; ++i) {
                ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null) continue;
                if (up) {
                    nl[2 * i] = xo + hspace * ni.col;
                    nl[2 * i + 1] = yo + vspace * (offset - (ni.layer + ni.layersize - 1));
                    continue;
                }
                nl[2 * i] = xo + hspace * ni.col;
                nl[2 * i + 1] = yo + vspace * ni.layer;
            }
            if (this.prevOrientation == this.orientation) {
                if (this.columnOffsetNode != null) {
                    xoffset = Math.max(0, this.columnOffset % hspace);
                }
                if (this.layerOffsetNode != null) {
                    yoffset = Math.max(0, this.layerOffset % vspace);
                }
            }
            for (i = 0; i < this.totalNodes; ++i) {
                ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null || ni instanceof NodeInfoExtension || ni instanceof SubdiagramNodeInfo || this.assignNewOnly && ni.node.isNodePlaced()) continue;
                Point p = new Point(nl[2 * i] + xoffset, nl[2 * i + 1] + yoffset);
                ni.node.setLayoutLocation(1, p);
                ni.node.setNodePlaced(true);
            }
        } else {
            for (int i = 0; i < this.totalNodes; ++i) {
                NodeInfo ni = (NodeInfo)this.allinfo.elementAt(i);
                if (ni == null || ni instanceof NodeInfoExtension || ni instanceof SubdiagramNodeInfo || this.assignNewOnly && ni.node.isNodePlaced()) continue;
                Point p = up ? new Point(xo + hspace * ni.col, yo + vspace * (offset - (ni.layer + ni.layersize - 1))) : new Point(xo + hspace * ni.col, yo + vspace * ni.layer);
                ni.node.setLayoutLocation(1, p);
                ni.node.setNodePlaced(true);
            }
        }
    }

    private void assignHorzDummyPoints(boolean rightFlow) {
        int outSpot;
        int inSpot;
        int factor;
        int breakSpot = 0;
        if (rightFlow) {
            factor = 1;
            inSpot = 8;
            outSpot = 4;
        } else {
            factor = -1;
            inSpot = 4;
            outSpot = 8;
        }
        Point pt = new Point();
        Point firstPt = new Point();
        Point lastPt = new Point();
        int endOffset = (int)Math.ceil(this.layerGridSpace);
        double endPadding = ((double)endOffset - this.layerGridSpace) * (double)this.gridWidth;
        for (int j = 0; j < this.dummyLinks.size(); ++j) {
            Vector nodeInfos;
            int end;
            int start;
            Vector v1 = (Vector)this.dummyLinks.elementAt(j);
            LinkLayoutInterface link = (LinkLayoutInterface)v1.elementAt(0);
            Vector rr = (Vector)this.cycleNodes.get(String.valueOf(link.hashCode()));
            if (rr != null) continue;
            link.setCustomBreakPointsUsed(true);
            int numDummies = v1.size() - 3 - endOffset;
            if (numDummies <= 0) {
                NodeInfo breakNode = rightFlow ? (NodeInfo)v1.get(2) : (NodeInfo)v1.get(v1.size() - 2);
                Point breakPt = breakNode.node.getLayoutLocation(breakSpot, null);
                link.addBreakPoint(breakPt);
                continue;
            }
            if (rightFlow) {
                start = 2;
                end = v1.size() - 2 - endOffset;
            } else {
                start = 2 + endOffset;
                end = v1.size() - 2;
            }
            NodeInfo first = (NodeInfo)v1.elementAt(start);
            NodeInfo last = (NodeInfo)v1.elementAt(end);
            NodeInfo from = (NodeInfo)v1.get(1);
            NodeInfo to = (NodeInfo)v1.get(v1.size() - 1);
            first.node.getLayoutLocation(inSpot, firstPt);
            if (rightFlow && this.allPos != null && this.allPos.length > 0 && this.allPos[0].length > first.layer && (nodeInfos = this.allPos[0][first.layer]) != null && nodeInfos.size() > 0) {
                for (int k = 0; k < nodeInfos.size(); ++k) {
                    NodeInfo nodeInfo = (NodeInfo)nodeInfos.get(k);
                    if (nodeInfo.dummy) continue;
                    if (nodeInfo.node.getBBox().width % this.gridWidth >= 8) break;
                    outSpot = 8;
                    break;
                }
            }
            last.node.getLayoutLocation(outSpot, lastPt);
            if (rightFlow) {
                lastPt.x = (int)((double)lastPt.x + endPadding);
            } else {
                firstPt.x = (int)((double)firstPt.x + endPadding);
            }
            link.getFromLinkPoint(firstPt, pt);
            int fromY = pt.y;
            from.node.getLayoutLocation(1, pt);
            int fromCol = from.col + (fromY - pt.y) / this.gridHeight;
            link.getToLinkPoint(lastPt, pt);
            int toY = pt.y;
            to.node.getLayoutLocation(1, pt);
            int toCol = to.col + (toY - pt.y) / this.gridHeight;
            if (first.col == fromCol) {
                firstPt.y = fromY;
            } else if (first.col == toCol) {
                firstPt.y = toY;
            }
            link.addBreakPoint(new Point(firstPt));
            for (int i = start + 1; i < end; ++i) {
                NodeInfo ni = (NodeInfo)v1.get(i);
                ni.node.getLayoutLocation(breakSpot, pt);
                if (ni.col == fromCol) {
                    pt.y = fromY;
                } else if (ni.col == toCol) {
                    pt.y = toY;
                }
                link.addBreakPoint(new Point(pt));
            }
            if (last.col == fromCol) {
                lastPt.y = fromY;
            } else if (last.col == toCol) {
                lastPt.y = toY;
            }
            link.addBreakPoint(new Point(lastPt));
        }
        Enumeration rl = this.revlinks.elements();
        while (rl.hasMoreElements()) {
            LinkLayoutInterface link = (LinkLayoutInterface)rl.nextElement();
            link.setCustomBreakPointsUsed(false);
            link.removeAllBreakPoints();
            Vector rr = (Vector)this.cycleNodes.get(String.valueOf(link.hashCode()));
            if (rr == null || rr.size() < 4) continue;
            link.setCustomBreakPointsUsed(true);
            NodeInfo toDummy = (NodeInfo)rr.get(0);
            NodeInfo to = (NodeInfo)rr.get(1);
            NodeInfo from = (NodeInfo)rr.get(2);
            NodeInfo fromDummy = (NodeInfo)rr.get(3);
            if (this.revtree) {
                NodeInfo tempNode = from;
                from = to;
                to = tempNode;
                tempNode = fromDummy;
                fromDummy = toDummy;
                toDummy = tempNode;
            }
            Point fromDummyPoint = fromDummy.node.getLayoutLocation(breakSpot, null);
            Point toDummyPoint = toDummy.node.getLayoutLocation(breakSpot, null);
            Point fromOutPoint = from.node.getLayoutLocation(outSpot, null);
            link.getFromLinkPoint(null, fromOutPoint);
            double outputDirection = from.node.getOutputLinkDirection();
            if (!Double.isNaN(outputDirection)) {
                fromOutPoint.x += (int)((double)from.node.getOutputEndSegmentLength() * Math.cos(outputDirection));
            }
            Point toInPoint = to.node.getLayoutLocation(outSpot, null);
            link.getToLinkPoint(null, toInPoint);
            double inputDirection = to.node.getInputLinkDirection();
            if (!Double.isNaN(inputDirection)) {
                toInPoint.x += (int)((double)to.node.getInputEndSegmentLength() * Math.cos(Math.PI + inputDirection));
            }
            Point toOutPoint = to.node.getLayoutLocation(outSpot, null);
            for (int i = 0; i < to.outEdges.size(); ++i) {
                NodeInfo outNode = (NodeInfo)to.outEdges.get(0);
                LinkLayoutInterface arc = (LinkLayoutInterface)this.lookup.get(to.id + "," + outNode.id);
                if (arc == null) continue;
                arc.getFromLinkPoint(null, toOutPoint);
                toOutPoint.x += factor * to.node.getOutputEndSegmentLength();
                break;
            }
            Point fromInPoint = from.node.getLayoutLocation(inSpot, null);
            for (int i = 0; i < from.inEdges.size(); ++i) {
                NodeInfo inNode = (NodeInfo)from.inEdges.get(0);
                LinkLayoutInterface arc = (LinkLayoutInterface)this.lookup.get(inNode.id + "," + from.id);
                if (arc == null) continue;
                arc.getToLinkPoint(null, fromInPoint);
                fromInPoint.x -= factor * from.node.getInputEndSegmentLength();
                break;
            }
            link.addBreakPoint(new Point(fromOutPoint.x, fromDummyPoint.y));
            link.addBreakPoint(new Point(fromInPoint.x, fromDummyPoint.y));
            if (rr.size() > 4) {
                NodeInfo[] dummies = (NodeInfo[])rr.get(4);
                for (int i = 0; i < dummies.length; ++i) {
                    int idx = this.revtree ? i : dummies.length - 1 - i;
                    NodeInfo dummy = dummies[idx];
                    Point breakPt = dummy.node.getLayoutLocation(breakSpot, null);
                    link.addBreakPoint(breakPt);
                }
            }
            link.addBreakPoint(new Point(toOutPoint.x, toDummyPoint.y));
            link.addBreakPoint(new Point(toInPoint.x, toDummyPoint.y));
        }
    }

    private void assignVertDummyPoints(boolean upFlow) {
        int outSpot;
        int inSpot;
        int factor;
        int breakSpot = 0;
        if (upFlow) {
            factor = -1;
            inSpot = 6;
            outSpot = 2;
        } else {
            factor = 1;
            inSpot = 2;
            outSpot = 6;
        }
        Point pt = new Point();
        Point firstPt = new Point();
        Point lastPt = new Point();
        int endOffset = (int)Math.ceil(this.layerGridSpace);
        double endPadding = ((double)endOffset - this.layerGridSpace) * (double)this.gridHeight;
        for (int j = 0; j < this.dummyLinks.size(); ++j) {
            int end;
            int start;
            Vector v1 = (Vector)this.dummyLinks.elementAt(j);
            LinkLayoutInterface link = (LinkLayoutInterface)v1.elementAt(0);
            Vector rr = (Vector)this.cycleNodes.get(String.valueOf(link.hashCode()));
            if (rr != null) continue;
            link.setCustomBreakPointsUsed(true);
            int numDummies = v1.size() - 3 - endOffset;
            if (numDummies <= 0) {
                NodeInfo breakNode = upFlow ? (NodeInfo)v1.get(v1.size() - 2) : (NodeInfo)v1.get(2);
                Point breakPt = breakNode.node.getLayoutLocation(breakSpot, null);
                link.addBreakPoint(breakPt);
                continue;
            }
            if (upFlow) {
                start = 2 + endOffset;
                end = v1.size() - 2;
            } else {
                start = 2;
                end = v1.size() - 2 - endOffset;
            }
            NodeInfo first = (NodeInfo)v1.elementAt(start);
            NodeInfo last = (NodeInfo)v1.elementAt(end);
            NodeInfo from = (NodeInfo)v1.get(1);
            NodeInfo to = (NodeInfo)v1.get(v1.size() - 1);
            first.node.getLayoutLocation(inSpot, firstPt);
            last.node.getLayoutLocation(outSpot, lastPt);
            if (upFlow) {
                firstPt.y = (int)((double)firstPt.y + endPadding);
            } else {
                lastPt.y = (int)((double)lastPt.y + endPadding);
            }
            link.getFromLinkPoint(firstPt, pt);
            int fromX = pt.x;
            from.node.getLayoutLocation(1, pt);
            int fromCol = from.col + (fromX - pt.x) / this.gridWidth;
            link.getToLinkPoint(lastPt, pt);
            int toX = pt.x;
            to.node.getLayoutLocation(1, pt);
            int toCol = to.col + (toX - pt.x) / this.gridWidth;
            if (first.col == fromCol) {
                firstPt.x = fromX;
            } else if (first.col == toCol) {
                firstPt.x = toX;
            }
            link.addBreakPoint(new Point(firstPt));
            for (int i = start + 1; i < end; ++i) {
                NodeInfo ni = (NodeInfo)v1.get(i);
                ni.node.getLayoutLocation(breakSpot, pt);
                if (ni.col == fromCol) {
                    pt.x = fromX;
                } else if (ni.col == toCol) {
                    pt.x = toX;
                }
                link.addBreakPoint(new Point(pt));
            }
            if (last.col == fromCol) {
                lastPt.x = fromX;
            } else if (last.col == toCol) {
                lastPt.x = toX;
            }
            link.addBreakPoint(new Point(lastPt));
        }
        Enumeration rl = this.revlinks.elements();
        while (rl.hasMoreElements()) {
            LinkLayoutInterface link = (LinkLayoutInterface)rl.nextElement();
            link.setCustomBreakPointsUsed(false);
            link.removeAllBreakPoints();
            Vector rr = (Vector)this.cycleNodes.get(String.valueOf(link.hashCode()));
            if (rr == null || rr.size() < 4) continue;
            link.setCustomBreakPointsUsed(true);
            NodeInfo toDummy = (NodeInfo)rr.get(0);
            NodeInfo to = (NodeInfo)rr.get(1);
            NodeInfo from = (NodeInfo)rr.get(2);
            NodeInfo fromDummy = (NodeInfo)rr.get(3);
            if (this.revtree) {
                NodeInfo tempNode = from;
                from = to;
                to = tempNode;
                tempNode = fromDummy;
                fromDummy = toDummy;
                toDummy = tempNode;
            }
            Point fromDummyPoint = fromDummy.node.getLayoutLocation(breakSpot, null);
            Point toDummyPoint = toDummy.node.getLayoutLocation(breakSpot, null);
            Point fromOutPoint = from.node.getLayoutLocation(outSpot, null);
            link.getFromLinkPoint(null, fromOutPoint);
            double outputDirection = from.node.getOutputLinkDirection();
            if (!Double.isNaN(outputDirection)) {
                fromOutPoint.y -= (int)((double)from.node.getOutputEndSegmentLength() * Math.sin(outputDirection));
            }
            Point toInPoint = to.node.getLayoutLocation(outSpot, null);
            link.getToLinkPoint(null, toInPoint);
            double inputDirection = to.node.getInputLinkDirection();
            if (!Double.isNaN(inputDirection)) {
                toInPoint.y -= (int)((double)to.node.getInputEndSegmentLength() * Math.sin(Math.PI + inputDirection));
            }
            Point toOutPoint = to.node.getLayoutLocation(outSpot, null);
            for (int i = 0; i < to.outEdges.size(); ++i) {
                NodeInfo outNode = (NodeInfo)to.outEdges.get(0);
                LinkLayoutInterface arc = (LinkLayoutInterface)this.lookup.get(to.id + "," + outNode.id);
                if (arc == null) continue;
                arc.getFromLinkPoint(null, toOutPoint);
                toOutPoint.y += factor * to.node.getOutputEndSegmentLength();
                break;
            }
            Point fromInPoint = from.node.getLayoutLocation(inSpot, null);
            for (int i = 0; i < from.inEdges.size(); ++i) {
                NodeInfo inNode = (NodeInfo)from.inEdges.get(0);
                LinkLayoutInterface arc = (LinkLayoutInterface)this.lookup.get(inNode.id + "," + from.id);
                if (arc == null) continue;
                arc.getToLinkPoint(null, fromInPoint);
                fromInPoint.y -= factor * from.node.getInputEndSegmentLength();
                break;
            }
            link.addBreakPoint(new Point(fromDummyPoint.x, fromOutPoint.y));
            link.addBreakPoint(new Point(fromDummyPoint.x, fromInPoint.y));
            if (rr.size() > 4) {
                NodeInfo[] dummies = (NodeInfo[])rr.get(4);
                for (int i = 0; i < dummies.length; ++i) {
                    int idx = this.revtree ? i : dummies.length - 1 - i;
                    NodeInfo dummy = dummies[idx];
                    Point breakPt = dummy.node.getLayoutLocation(breakSpot, null);
                    link.addBreakPoint(breakPt);
                }
            }
            link.addBreakPoint(new Point(toDummyPoint.x, toOutPoint.y));
            link.addBreakPoint(new Point(toDummyPoint.x, toInPoint.y));
        }
    }

    private void assignSelfLinks() {
        Vector<NodeLayoutInterface> nodes = new Vector<NodeLayoutInterface>();
        for (int i = 0; i < this.selfLinks.size(); ++i) {
            Vector v = (Vector)this.selfLinks.get(i);
            NodeInfo ni = (NodeInfo)v.get(1);
            NodeLayoutInterface node = ni.node;
            if (nodes.contains(node)) continue;
            node.layoutSelfLinks();
            nodes.add(node);
        }
    }

    private void assignHorzSelfLinks() {
        int vspace = this.gridHeight;
        Point p = new Point();
        for (int j = 0; j < this.selfLinks.size(); ++j) {
            Vector v1 = (Vector)this.selfLinks.elementAt(j);
            LinkLayoutInterface link = (LinkLayoutInterface)v1.elementAt(0);
            link.setCustomBreakPointsUsed(true);
            link.removeAllBreakPoints();
            NodeInfo ni = (NodeInfo)v1.elementAt(1);
            Point p1 = ni.node.getCenterLocation();
            Point p2 = new Point(p1.x, p1.y + (int)((double)(vspace * ni.colsize) * 0.5));
            link.getFromLinkPoint(p2, p);
            link.addBreakPoint(new Point(p.x, p2.y));
            link.getToLinkPoint(p2, p);
            link.addBreakPoint(new Point(p.x, p2.y));
        }
    }

    private void assignVertSelfLinks() {
        int hspace = this.gridWidth;
        Point p = new Point();
        for (int j = 0; j < this.selfLinks.size(); ++j) {
            Vector v1 = (Vector)this.selfLinks.elementAt(j);
            LinkLayoutInterface link = (LinkLayoutInterface)v1.elementAt(0);
            link.setCustomBreakPointsUsed(true);
            link.removeAllBreakPoints();
            NodeInfo ni = (NodeInfo)v1.elementAt(1);
            Point p1 = ni.node.getCenterLocation();
            Point p2 = new Point(p1.x + (int)((double)(hspace * ni.layersize) * 0.5), p1.y);
            link.getFromLinkPoint(p2, p);
            link.addBreakPoint(new Point(p2.x, p.y));
            link.getToLinkPoint(p2, p);
            link.addBreakPoint(new Point(p2.x, p.y));
        }
    }

    void reduceUniformCrossings() {
        int i;
        int numBends;
        int currentState;
        NodeInfo ni;
        this.prevcross = Integer.MAX_VALUE;
        int dx = 1;
        int min = 0;
        int max = min + dx * this.layerWidth[0];
        this.moveLeavesAlgo = 0;
        this.leavesAssigned = false;
        this.wideTreeAlgo = false;
        int start = 0;
        while (this.layerWidth[start] == 0) {
            ++start;
        }
        if (this.revtree && this.newLayout) {
            int index = this.numLayers - 1;
            while (this.pos[index].size() == 0) {
                --index;
            }
            ni = (NodeInfo)this.pos[index].elementAt(0);
            ni.col = 0;
            while (ni.inEdges.size() != 0) {
                ni = (NodeInfo)ni.inEdges.elementAt(0);
                this.pos[ni.layer].remove(ni);
                this.pos[ni.layer].insertElementAt(ni, 0);
                ni.col = 0;
            }
        }
        int last = this.numLayers - 1;
        while (this.layerWidth[last] == 0) {
            --last;
        }
        int incr = 1;
        int ninfoSize = this.ninfo.size();
        int minState = currentState = 0;
        this.doInitialSettings(true);
        boolean ascending = true;
        int minCrossings = Integer.MAX_VALUE;
        int minBends = Integer.MAX_VALUE;
        int[] bestNodeCols = new int[this.ninfo.size()];
        for (int z = this.numIterations - 1; z > 0; --z) {
            int j;
            int i2;
            this.crossings = 0;
            min = 0;
            max = z > this.numIterations / 2 ? this.maxLayerWidth - 1 : this.maxLayerWidth + 1;
            this.alignRootCols();
            if (currentState <= 1) {
                for (i2 = start; i2 != last + incr; i2 += incr) {
                    int size = this.pos[i2].size();
                    if (size == 0) continue;
                    if (this.isCrossingsPresent(this.pos[i2])) {
                        this.pos[i2] = this.assignByAllSplit(this.pos[i2], 0);
                        if (this.moveLeavesAlgo < 2) {
                            this.moveLeavesOut(this.pos[i2]);
                        } else {
                            this.moveLeavesTogether(this.pos[i2]);
                        }
                    }
                    this.setUniformLayerCols(i2, 0, min, max);
                    this.shiftLayerCols(i2 - incr, incr < 0);
                    min = Math.min(min, ((NodeInfo)this.pos[i2].firstElement()).col);
                    max = Math.max(max, ((NodeInfo)this.pos[i2].lastElement()).col);
                }
            } else {
                for (i2 = start; i2 != last + incr; i2 += incr) {
                    int size = this.pos[i2].size();
                    if (size == 0) continue;
                    if (this.isCrossingsPresent(this.pos[i2])) {
                        this.pos[i2] = this.assignByAllSplit(this.pos[i2], 0);
                        if (this.moveLeavesAlgo < 2) {
                            this.moveLeavesOut(this.pos[i2]);
                        } else {
                            this.moveLeavesTogether(this.pos[i2]);
                        }
                    }
                    this.setUniformLayerCols(i2, 1, min, max);
                    this.shiftLayerCols(i2 - incr, incr < 0);
                    min = Math.min(min, ((NodeInfo)this.pos[i2].firstElement()).col);
                    max = Math.max(max, ((NodeInfo)this.pos[i2].lastElement()).col);
                }
            }
            this.minrow = ((NodeInfo)this.pos[start].elementAt((int)0)).col;
            for (i2 = start + incr; i2 != last + incr; i2 += incr) {
                if (this.layerWidth[i2] == 0) continue;
                NodeInfo To = (NodeInfo)this.pos[i2].elementAt(0);
                this.minrow = Math.min(To.col, this.minrow);
            }
            if (this.minrow < 0) {
                for (i2 = 0; i2 < ninfoSize; ++i2) {
                    NodeInfo n = (NodeInfo)this.ninfo.elementAt(i2);
                    if (n == null) continue;
                    n.col -= this.minrow;
                }
            }
            if (this.crossings == 0) {
                this.optimizeBends(start, last + incr);
                this.alignRootCols();
                minBends = 0;
                for (j = 0; j < bestNodeCols.length; ++j) {
                    ni = (NodeInfo)this.ninfo.elementAt(j);
                    bestNodeCols[j] = ni.col;
                    for (int k = 0; k < ni.outEdges.size(); ++k) {
                        NodeInfo nk = (NodeInfo)ni.outEdges.elementAt(k);
                        if (ni.col == nk.col) continue;
                        ++minBends;
                    }
                }
                break;
            }
            if (this.crossings < minCrossings) {
                minCrossings = this.crossings;
                minBends = 0;
                minState = currentState;
                this.optimizeBends(start, last + incr);
                for (j = 0; j < bestNodeCols.length; ++j) {
                    ni = (NodeInfo)this.ninfo.elementAt(j);
                    bestNodeCols[j] = ni.col;
                    for (int k = 0; k < ni.outEdges.size(); ++k) {
                        NodeInfo nk = (NodeInfo)ni.outEdges.elementAt(k);
                        if (ni.col == nk.col) continue;
                        ++minBends;
                    }
                }
            } else if (this.crossings == minCrossings) {
                int j2;
                numBends = 0;
                this.optimizeBends(start, last + incr);
                for (j2 = 0; j2 < bestNodeCols.length; ++j2) {
                    ni = (NodeInfo)this.ninfo.elementAt(j2);
                    for (int k = 0; k < ni.outEdges.size(); ++k) {
                        NodeInfo nk = (NodeInfo)ni.outEdges.elementAt(k);
                        if (ni.col == nk.col) continue;
                        ++numBends;
                    }
                }
                if (numBends < minBends) {
                    for (j2 = 0; j2 < bestNodeCols.length; ++j2) {
                        bestNodeCols[j2] = ((NodeInfo)this.ninfo.elementAt((int)j2)).col;
                    }
                    minBends = numBends;
                    minState = currentState;
                }
            }
            if (z == 1 || this.prevcross == this.crossings) {
                min = 0;
                max = this.maxLayerWidth + 1;
                if (!this.newLayout) {
                    return;
                }
                boolean shuffled = false;
                if (!shuffled && this.moveLeavesAlgo == 3) {
                    boolean oneMoreTry;
                    boolean bl = oneMoreTry = !this.wideTreeAlgo && currentState == 3;
                    if (oneMoreTry) {
                        this.wideTreeAlgo = true;
                        currentState = 0;
                        this.moveLeavesAlgo = 0;
                        int swap = start;
                        start = last;
                        last = swap;
                        incr = 1;
                    } else {
                        if (currentState == 3) {
                            int numBends2 = 0;
                            if (this.crossings == minCrossings) {
                                for (int j3 = 0; j3 < bestNodeCols.length; ++j3) {
                                    ni = (NodeInfo)this.ninfo.elementAt(j3);
                                    for (int k = 0; k < ni.outEdges.size(); ++k) {
                                        NodeInfo nk = (NodeInfo)ni.outEdges.elementAt(k);
                                        if (ni.col == nk.col) continue;
                                        ++numBends2;
                                    }
                                }
                            }
                            if (this.crossings > minCrossings || this.crossings == minCrossings && numBends2 < minBends) {
                                int j4;
                                for (j4 = 0; j4 < this.numLayers; ++j4) {
                                    this.pos[j4].removeAllElements();
                                }
                                for (j4 = 0; j4 < bestNodeCols.length; ++j4) {
                                    int k;
                                    NodeInfo nj = (NodeInfo)this.ninfo.elementAt(j4);
                                    nj.col = bestNodeCols[j4];
                                    int jsize = this.pos[nj.layer].size();
                                    for (k = 0; k < jsize; ++k) {
                                        NodeInfo nk = (NodeInfo)this.pos[nj.layer].elementAt(k);
                                        if (nk.col > nj.col) break;
                                    }
                                    if (k < jsize) {
                                        this.pos[nj.layer].insertElementAt(nj, k);
                                        continue;
                                    }
                                    this.pos[nj.layer].add(nj);
                                }
                                if (currentState >= 2 && minState < 2) {
                                    int swap = start;
                                    start = last;
                                    last = swap;
                                    incr *= -1;
                                }
                            }
                            this.alignRootCols();
                            break;
                        }
                        this.moveLeavesAlgo = -1;
                        if (++currentState == 2) {
                            int swap = start;
                            start = last;
                            last = swap;
                            incr = -1;
                        }
                    }
                } else if (!shuffled) {
                    ++this.moveLeavesAlgo;
                }
                if (this.wideTreeAlgo) {
                    for (int i3 = 0; i3 < ninfoSize; ++i3) {
                        ((NodeInfo)this.ninfo.elementAt((int)i3)).col = -1;
                    }
                }
                this.doInitialSettings(currentState == 0 || currentState == 2);
                this.crossings = Integer.MAX_VALUE;
                z = this.numIterations;
            }
            this.prevcross = this.crossings;
        }
        this.alignFromMaxWidthLayer();
        this.optimizeBends(start, last + incr);
        numBends = 0;
        for (i = 0; i < bestNodeCols.length; ++i) {
            ni = (NodeInfo)this.ninfo.elementAt(i);
            for (int j = 0; j < ni.outEdges.size(); ++j) {
                NodeInfo nj = (NodeInfo)ni.outEdges.elementAt(j);
                if (ni.col == nj.col) continue;
                ++numBends;
            }
        }
        if (minBends < numBends) {
            for (i = start; i != last + incr; i += incr) {
                this.pos[i].removeAllElements();
            }
            for (i = 0; i < bestNodeCols.length; ++i) {
                int insertAt;
                ni = (NodeInfo)this.ninfo.elementAt(i);
                ni.col = bestNodeCols[i];
                int lsize = this.pos[ni.layer].size();
                for (insertAt = 0; insertAt < lsize && ((NodeInfo)this.pos[ni.layer].elementAt((int)insertAt)).col < ni.col; ++insertAt) {
                }
                if (insertAt < lsize) {
                    this.pos[ni.layer].add(insertAt, ni);
                    continue;
                }
                this.pos[ni.layer].add(ni);
            }
        } else {
            for (i = 0; i < bestNodeCols.length; ++i) {
                ni = (NodeInfo)this.ninfo.elementAt(i);
                bestNodeCols[i] = ni.col;
            }
            minBends = numBends;
        }
        this.maxrow = ((NodeInfo)this.pos[start].lastElement()).col;
        this.minrow = ((NodeInfo)this.pos[start].elementAt((int)0)).col;
        this.maxLayerWidth = this.layerWidth[0];
        this.maxLayerWidthIndex = 0;
        for (i = start + incr; i != last + incr; i += incr) {
            if (this.layerWidth[i] == 0) continue;
            if (this.maxLayerWidth < this.layerWidth[i]) {
                this.maxLayerWidth = this.layerWidth[i];
                this.maxLayerWidthIndex = i;
            }
            this.maxrow = Math.max(this.maxrow, ((NodeInfo)this.pos[i].lastElement()).col);
            this.minrow = Math.min(this.minrow, ((NodeInfo)this.pos[i].elementAt((int)0)).col);
        }
        if (this.roots.size > 1 || this.minrow != 0) {
            this.compressRows();
        }
        if (!this.hasMultiPorts) {
            this.flipTree();
        }
    }

    private void optimizeBends(int start, int end) {
        int incr = start > end ? -1 : 1;
        for (int i = start; i != end; i += incr) {
            int min = Integer.MIN_VALUE;
            for (int j = 0; j < this.layerWidth[i]; ++j) {
                int max;
                NodeInfo nj = (NodeInfo)this.pos[i].elementAt(j);
                if (nj instanceof NodeInfoExtension || (min = this.getMinColPlacement(nj)) == (max = this.getMaxColPlacement(nj))) continue;
                int savedCol = nj.col;
                int savedBend = Integer.MAX_VALUE;
                int newBend = 0;
                while (nj.col > min || nj.col < max) {
                    NodeInfo nk;
                    int k;
                    int vinsize = nj.inEdges.size();
                    int voutsize = nj.outEdges.size();
                    Vector inEdges = new Vector();
                    for (int k2 = 0; k2 < vinsize; ++k2) {
                        if (nj.inEdges.elementAt(k2) instanceof NodeInfoExtension) continue;
                        inEdges.add(nj.inEdges.elementAt(k2));
                    }
                    vinsize = inEdges.size();
                    Vector outEdges = new Vector();
                    for (int k3 = 0; k3 < voutsize; ++k3) {
                        if (nj.outEdges.elementAt(k3) instanceof NodeInfoExtension) continue;
                        outEdges.add(nj.outEdges.elementAt(k3));
                    }
                    voutsize = outEdges.size();
                    if (1 == voutsize && vinsize == 1) {
                        NodeInfo nk2 = (NodeInfo)inEdges.elementAt(0);
                        if (nk2.col == nj.col) break;
                        NodeInfo nl = (NodeInfo)outEdges.elementAt(0);
                        if (nl.col == nj.col) break;
                        int dif1 = nl.col - nj.col;
                        int dif2 = nk2.col - nj.col;
                        if (max > nj.col) {
                            if (dif2 > 0) {
                                nj.setColumn(Math.min(nj.col + dif2, max));
                                break;
                            }
                            if (dif1 > 0) {
                                nj.setColumn(Math.min(nj.col + dif1, max));
                                break;
                            }
                        }
                        if (min >= nj.col) break;
                        if (dif2 < 0) {
                            nj.setColumn(Math.max(nj.col + dif2, min));
                            break;
                        }
                        if (dif1 >= 0) break;
                        nj.setColumn(Math.max(nj.col + dif1, min));
                        break;
                    }
                    if (vinsize == 2) {
                        NodeInfo nk3 = (NodeInfo)inEdges.elementAt(0);
                        NodeInfo nl = (NodeInfo)inEdges.elementAt(1);
                        if (nj.col == (nk3.col + nl.col) / 2) break;
                    }
                    if (voutsize == 2) {
                        NodeInfo nk4 = (NodeInfo)outEdges.elementAt(0);
                        NodeInfo nl = (NodeInfo)outEdges.elementAt(1);
                        if (nj.col == (nk4.col + nl.col) / 2) break;
                    }
                    int bend0 = 0;
                    int bend1 = 0;
                    int bend2 = 0;
                    if (nj.dummy) {
                        for (k = 0; k < vinsize; ++k) {
                            nk = (NodeInfo)inEdges.elementAt(k);
                            if (!nk.dummy) continue;
                            bend0 += Math.abs(nj.col - nk.col);
                            bend1 += Math.abs(nj.col - 1 - nk.col);
                            bend2 += Math.abs(nj.col + 1 - nk.col);
                            break;
                        }
                        for (k = 0; k < voutsize; ++k) {
                            nk = (NodeInfo)outEdges.elementAt(k);
                            if (!nk.dummy) continue;
                            bend0 += Math.abs(nj.col - nk.col);
                            bend1 += Math.abs(nj.col - 1 - nk.col);
                            bend2 += Math.abs(nj.col + 1 - nk.col);
                            break;
                        }
                    } else {
                        for (k = 0; k < vinsize; ++k) {
                            nk = (NodeInfo)inEdges.elementAt(k);
                            bend0 += Math.abs(nj.col - nk.col);
                            bend1 += Math.abs(nj.col - 1 - nk.col);
                            bend2 += Math.abs(nj.col + 1 - nk.col);
                        }
                        for (k = 0; k < voutsize; ++k) {
                            nk = (NodeInfo)outEdges.elementAt(k);
                            bend0 += Math.abs(nj.col - nk.col);
                            bend1 += Math.abs(nj.col - 1 - nk.col);
                            bend2 += Math.abs(nj.col + 1 - nk.col);
                        }
                    }
                    if (nj.col == savedCol) {
                        savedBend = bend0;
                    } else {
                        newBend = bend0;
                    }
                    if (bend0 <= bend1 && bend0 <= bend2) break;
                    if (bend1 <= bend2 && nj.col > min) {
                        nj.setColumn(nj.col - 1);
                        continue;
                    }
                    if (bend2 < bend0 && nj.col < max) {
                        nj.setColumn(nj.col + 1);
                        continue;
                    }
                    if (bend1 >= bend0 || nj.col <= min) break;
                    nj.setColumn(nj.col - 1);
                }
                if (savedBend != newBend && nj.col > savedCol && j != 0) {
                    min = (j -= 2) == -1 ? Integer.MIN_VALUE : ((NodeInfo)this.pos[i].elementAt((int)j)).col + 1;
                    continue;
                }
                if (savedBend == newBend) {
                    nj.setColumn(savedCol);
                }
                min = nj.col + 1;
            }
        }
    }

    private void sortMultiportLayer(int layer) {
        block0: for (int i = 0; i < this.pos[layer].size(); ++i) {
            NodeInfo ni = (NodeInfo)this.pos[layer].get(i);
            if (ni instanceof NodeInfoExtension) continue;
            int nicol = ni.col;
            int outSize = ni.outEdges.size();
            for (int j = 0; j < outSize; ++j) {
                NodeInfo nj = (NodeInfo)ni.outEdges.elementAt(j);
                if (nj.inports == null) continue;
                int niindex = nj.inEdges.indexOf(ni);
                int inSize = nj.inEdges.size();
                boolean swap = false;
                for (int k = 0; k < inSize; ++k) {
                    if (k >= nj.inports.length || niindex >= nj.inports.length || nj.inports[k] == nj.inports[niindex] || !(nj.inports[k] < nj.inports[niindex]) || ((NodeInfo)nj.inEdges.get((int)k)).col <= nicol) continue;
                    swap = true;
                    NodeInfo nk = (NodeInfo)nj.inEdges.get(k);
                    this.moveNodeIntoPos(nk, i);
                    break;
                }
                if (swap) continue block0;
            }
        }
    }

    private void moveNodeIntoPos(NodeInfo ni, int newPos) {
        int i;
        if (ni == null) {
            return;
        }
        int layer = ni.layer;
        if (layer < 0 || layer >= this.pos.length || this.pos[layer] == null) {
            return;
        }
        Vector<NodeInfo> nodeList = new Vector<NodeInfo>();
        for (i = 0; i < ni.colsize; ++i) {
            NodeInfo child = ni.getChild(0, i);
            this.pos[layer].remove(child);
            nodeList.add(child);
        }
        if (newPos < 0) {
            newPos = 0;
        }
        if (newPos >= this.pos[layer].size()) {
            this.pos[layer].addAll(nodeList);
        } else {
            this.pos[layer].addAll(newPos, nodeList);
        }
        for (i = newPos; i < this.pos[layer].size(); ++i) {
            int newColValue = i > 0 ? ((NodeInfo)this.pos[layer].get((int)(i - 1))).col + 1 : 0;
            NodeInfo curNode = (NodeInfo)this.pos[layer].get(i);
            curNode.col = newColValue;
        }
    }

    private void doInitialSettings(boolean forward) {
        int size;
        int i;
        NodeInfo ni;
        int i2;
        NodeInfo nj;
        int j;
        int k;
        int start = 0;
        while (this.layerWidth[start] == 0) {
            ++start;
        }
        int dx = 1;
        int min = 0;
        int max = min + dx * this.layerWidth[0];
        int last = this.numLayers - 1;
        while (this.layerWidth[last] == 0) {
            --last;
        }
        if (forward) {
            if (!this.newLayout) {
                this.pos[start] = this.enforceColsByLocs(this.pos[start]);
                k = min;
                for (j = 0; j < this.layerWidth[start]; ++j) {
                    nj = (NodeInfo)this.pos[start].elementAt(j);
                    if (nj.col == -1) {
                        nj.col = k;
                    }
                    for (i2 = 0; i2 < j; ++i2) {
                        ni = (NodeInfo)this.pos[start].elementAt(i2);
                        if (ni.col <= nj.col) continue;
                        this.pos[start].remove(j);
                        this.pos[start].insertElementAt(ni, i2);
                        break;
                    }
                    nj = (NodeInfo)this.pos[start].elementAt(j);
                    k = nj.col + dx;
                }
                k = ((NodeInfo)this.pos[start].elementAt((int)0)).col;
                for (j = 1; j < this.layerWidth[start]; ++j) {
                    nj = (NodeInfo)this.pos[start].elementAt(j);
                    if (nj.col <= k) {
                        nj.col = k + dx;
                    }
                    k = nj.col;
                }
            } else {
                k = min;
                for (j = 0; j < this.layerWidth[start]; ++j) {
                    ni = (NodeInfo)this.pos[start].elementAt(j);
                    ni.col = k;
                    k += dx;
                }
            }
            min = Math.min(min, ((NodeInfo)this.pos[start].elementAt((int)0)).col);
            max = Math.max(max, ((NodeInfo)this.pos[start].elementAt((int)(this.layerWidth[start] - 1))).col);
            this.maxLayerWidth = this.pos[start].size();
            this.maxLayerWidthIndex = start;
            if (!this.leavesAssigned) {
                this.assignLeafLoc();
            }
            for (i = start + 1; i < this.numLayers; ++i) {
                size = this.pos[i].size();
                if (size == 0) continue;
                if (this.newLayout || this.isCrossingsPresent(this.pos[i], 0)) {
                    this.pos[i] = this.assignByInSplit(this.pos[i], 0);
                    this.moveLeavesOut(this.pos[i]);
                }
                this.setUniformLayerCols(i, 0, min, max);
                this.shiftLayerCols(i - 1, false);
                min = Math.min(min, ((NodeInfo)this.pos[i].elementAt((int)0)).col);
                max = Math.max(max, ((NodeInfo)this.pos[i].elementAt((int)(size - 1))).col);
                if (size <= this.maxLayerWidth) continue;
                this.maxLayerWidth = size;
                this.maxLayerWidthIndex = i;
            }
        } else {
            if (!this.newLayout) {
                this.pos[last] = this.enforceColsByLocs(this.pos[last]);
                k = min;
                for (j = 0; j < this.layerWidth[last]; ++j) {
                    nj = (NodeInfo)this.pos[last].elementAt(j);
                    if (nj.col == -1) {
                        nj.col = k;
                    }
                    for (i2 = 0; i2 < j; ++i2) {
                        ni = (NodeInfo)this.pos[last].elementAt(i2);
                        if (ni.col <= nj.col) continue;
                        this.pos[last].remove(j);
                        this.pos[last].insertElementAt(ni, i2);
                        break;
                    }
                    nj = (NodeInfo)this.pos[last].elementAt(j);
                    k = nj.col + dx;
                }
                k = ((NodeInfo)this.pos[last].elementAt((int)0)).col;
                for (j = 1; j < this.layerWidth[last]; ++j) {
                    nj = (NodeInfo)this.pos[last].elementAt(j);
                    if (nj.col <= k) {
                        nj.col = k + dx;
                    }
                    k = nj.col;
                }
            } else {
                k = min;
                for (j = 0; j < this.layerWidth[last]; ++j) {
                    ni = (NodeInfo)this.pos[last].elementAt(j);
                    ni.col = k;
                    k += dx;
                }
            }
            min = Math.min(min, ((NodeInfo)this.pos[last].firstElement()).col);
            max = Math.max(max, ((NodeInfo)this.pos[last].lastElement()).col);
            this.maxLayerWidth = this.pos[last].size();
            this.maxLayerWidthIndex = last;
            if (!this.leavesAssigned) {
                this.assignRevLeafLoc();
            }
            for (i = last - 1; i >= 0; --i) {
                size = this.pos[i].size();
                if (size == 0) continue;
                if (this.newLayout || this.isCrossingsPresent(this.pos[i], 1)) {
                    this.pos[i] = this.assignByOutSplit(this.pos[i], 0);
                    this.moveLeavesOut(this.pos[i]);
                }
                this.setUniformLayerCols(i, 1, min, max);
                this.shiftLayerCols(i + 1, true);
                min = Math.min(min, ((NodeInfo)this.pos[i].firstElement()).col);
                max = Math.max(max, ((NodeInfo)this.pos[i].lastElement()).col);
                if (size <= this.maxLayerWidth) continue;
                this.maxLayerWidth = size;
                this.maxLayerWidthIndex = i;
            }
        }
        this.minrow = ((NodeInfo)this.pos[start].elementAt((int)0)).col;
        for (i = start + 1; i < last; ++i) {
            if (this.layerWidth[i] == 0) continue;
            ni = (NodeInfo)this.pos[i].elementAt(0);
            this.minrow = Math.min(ni.col, this.minrow);
        }
        int ninfoSize = this.ninfo.size();
        if (this.minrow < 0) {
            for (int i3 = 0; i3 < ninfoSize; ++i3) {
                ni = (NodeInfo)this.ninfo.elementAt(i3);
                if (ni == null) continue;
                ni.col -= this.minrow;
            }
        }
    }

    private void arrangeInitialNodes(int start, int dir) {
        Vector v;
        Vector firstLayer = this.pos[start];
        this.pos[start] = new Vector();
        HashSet<NodeInfo> considered = new HashSet<NodeInfo>();
        Vector considering = new Vector();
        int nodeToPlace = firstLayer.size();
        Vector<Vector> furtherAway = new Vector<Vector>();
        Vector<Vector> closerTo = new Vector<Vector>();
        NodeInfo ni = (NodeInfo)firstLayer.remove(0);
        this.pos[start].add(ni);
        --nodeToPlace;
        Vector vector = v = dir == 1 ? ni.inEdges : ni.outEdges;
        if (v.size() > 0) {
            closerTo.add(v);
        }
        Vector vector2 = v = dir == 1 ? ni.outEdges : ni.inEdges;
        if (v.size() > 0) {
            furtherAway.add(v);
        }
        block0: while (!(closerTo.isEmpty() && furtherAway.isEmpty() || nodeToPlace == 0)) {
            NodeInfo nj;
            int j;
            Vector v1;
            block1: while (!closerTo.isEmpty()) {
                v1 = (Vector)closerTo.remove(0);
                for (j = 0; j < v1.size(); ++j) {
                    nj = (NodeInfo)v1.elementAt(j);
                    if (considered.contains(nj)) continue;
                    considered.add(nj);
                    if (nj.layer == start) {
                        if (this.pos[start].contains(nj)) continue;
                        this.pos[start].add(nj);
                        firstLayer.remove(nj);
                        if (--nodeToPlace != 0) continue;
                        continue block1;
                    }
                    Vector vector3 = v = dir == 1 ? nj.inEdges : nj.outEdges;
                    if (v.size() > 0) {
                        closerTo.insertElementAt(v, 0);
                    }
                    Vector vector4 = v = dir == 1 ? nj.outEdges : nj.inEdges;
                    if (v.size() <= 0) continue;
                    furtherAway.insertElementAt(v, 0);
                }
            }
            if (furtherAway.isEmpty()) continue;
            v1 = (Vector)furtherAway.remove(0);
            for (j = 0; j < v1.size(); ++j) {
                nj = (NodeInfo)v1.elementAt(j);
                if (considered.contains(nj)) continue;
                considered.add(nj);
                if (nj.layer == start) {
                    this.pos[start].add(nj);
                    firstLayer.remove(nj);
                    if (--nodeToPlace != 0) continue;
                    continue block0;
                }
                Vector vector5 = v = dir == 1 ? nj.inEdges : nj.outEdges;
                if (v.size() > 0) {
                    closerTo.insertElementAt(v, 0);
                }
                Vector vector6 = v = dir == 1 ? nj.outEdges : nj.inEdges;
                if (v.size() <= 0) continue;
                furtherAway.insertElementAt(v, 0);
            }
        }
    }

    @Override
    public void setNodePositionHonored(boolean flag) {
    }

    @Override
    public void setNodePositionForced(boolean flag) {
    }

    @Override
    public boolean isNodePositionHonored() {
        return this.reuse;
    }

    private boolean isSwappable(NodeInfo ni, NodeInfo nj) {
        if (ni instanceof NodeInfoExtension || nj instanceof NodeInfoExtension) {
            return false;
        }
        Vector v1 = ni.inEdges;
        int size1 = v1.size();
        int[] s1 = new int[size1];
        Vector v2 = nj.inEdges;
        int size2 = v2.size();
        int[] s2 = new int[size2];
        int cini = 0;
        int ciin = 0;
        if (size1 != 0 && size2 != 0) {
            int index;
            int j;
            NodeInfo From;
            int i;
            int notassigned = 0;
            for (i = 0; i < size1; ++i) {
                From = (NodeInfo)v1.elementAt(i);
                if (From.col == -1) {
                    ++notassigned;
                    continue;
                }
                Sort.insert(s1, i - notassigned, From.col);
            }
            size1 -= notassigned;
            notassigned = 0;
            for (i = 0; i < size2; ++i) {
                From = (NodeInfo)v2.elementAt(i);
                if (From.col == -1) {
                    ++notassigned;
                    continue;
                }
                Sort.insert(s2, i - notassigned, From.col);
            }
            size2 -= notassigned;
            for (j = 0; j < size1; ++j) {
                index = Sort.getGreaterThanIndex(s2, 0, size2, s1[j]);
                if (index >= size2) continue;
                ciin += size2 - index;
            }
            for (j = 0; j < size2; ++j) {
                index = Sort.getGreaterThanIndex(s1, 0, size1, s2[j]);
                if (index >= size1) continue;
                cini += size1 - index;
            }
        }
        v1 = ni.outEdges;
        size1 = v1.size();
        s1 = new int[size1];
        v2 = nj.outEdges;
        size2 = v2.size();
        s2 = new int[size2];
        int coni = 0;
        int coin = 0;
        if (size1 != 0 && size2 != 0) {
            int index;
            int j;
            int i;
            int notassigned = 0;
            for (i = 0; i < size1; ++i) {
                NodeInfo To = (NodeInfo)v1.elementAt(i);
                if (To.col == -1) {
                    ++notassigned;
                    continue;
                }
                Sort.insert(s1, i - notassigned, To.col);
            }
            size1 -= notassigned;
            notassigned = 0;
            for (i = 0; i < size2; ++i) {
                NodeInfo To = (NodeInfo)v2.elementAt(i);
                if (To.col == -1) {
                    ++notassigned;
                    continue;
                }
                Sort.insert(s2, i - notassigned, To.col);
            }
            size2 -= notassigned;
            for (j = 0; j < size1; ++j) {
                index = Sort.getGreaterThanIndex(s2, 0, size2, s1[j]);
                if (index >= size2) continue;
                coin += size2 - index;
            }
            for (j = 0; j < size2; ++j) {
                index = Sort.getGreaterThanIndex(s1, 0, size1, s2[j]);
                if (index >= size1) continue;
                coni += size1 - index;
            }
        }
        return ciin + coin <= cini + coni;
    }

    private int getMidIndex(Vector list, int start, int end) {
        double index = 0.0;
        int[] links = new int[list.size()];
        for (int k = start; k <= end; ++k) {
            NodeInfo nk = (NodeInfo)list.elementAt(k);
            if (nk.dummy) {
                index += 2.0;
            } else {
                index += (double)nk.inEdges.size();
                index += (double)nk.outEdges.size();
            }
            links[k] = (int)index;
        }
        index /= 2.0;
        int rv = start;
        while (index > (double)links[rv]) {
            ++rv;
        }
        return rv;
    }

    private void moveLeavesOut(Vector list) {
        NodeInfo nj;
        int swapWith;
        NodeInfo ni;
        int i;
        int size = list.size();
        if (size < 2) {
            return;
        }
        if (size < 4) {
            NodeInfo n0 = (NodeInfo)list.elementAt(0);
            NodeInfo n1 = (NodeInfo)list.elementAt(1);
            if (n1.leafAt < n0.leafAt && this.isSwappable(n0, n1)) {
                list.setElementAt(n1, 0);
                list.setElementAt(n0, 1);
            } else if (size == 3) {
                NodeInfo n2 = (NodeInfo)list.elementAt(2);
                if (n1.leafAt < n2.leafAt && this.isSwappable(n1, n2)) {
                    list.setElementAt(n1, 2);
                    list.setElementAt(n2, 1);
                }
            }
            return;
        }
        for (i = 1; i < size / 2; ++i) {
            ni = (NodeInfo)list.elementAt(i);
            swapWith = i;
            for (int j = i - 1; j >= 0; --j) {
                boolean swappable;
                nj = (NodeInfo)list.elementAt(j);
                boolean bl = swappable = this.wideTreeAlgo ? this.isSwappable(ni, nj) : this.isSwappable(nj, ni);
                if (!swappable) break;
                if (ni.leafAt < nj.leafAt && this.moveLeavesAlgo == 0) {
                    swapWith = j;
                    continue;
                }
                if (ni.leafAt <= nj.leafAt || this.moveLeavesAlgo != 1) break;
                swapWith = j;
            }
            if (swapWith == i) continue;
            Object swapNode = list.elementAt(swapWith);
            list.setElementAt(ni, swapWith);
            list.setElementAt(swapNode, i);
        }
        for (i = size - 2; i >= size / 2; --i) {
            ni = (NodeInfo)list.elementAt(i);
            swapWith = i;
            for (int j = i + 1; j < size && this.isSwappable(nj = (NodeInfo)list.elementAt(j), ni); ++j) {
                if (ni.leafAt < nj.leafAt && this.moveLeavesAlgo == 0) {
                    swapWith = j;
                    continue;
                }
                if (ni.leafAt <= nj.leafAt || this.moveLeavesAlgo != 1) break;
                swapWith = j;
            }
            if (swapWith == i) continue;
            Object swapNode = list.elementAt(swapWith);
            list.setElementAt(ni, swapWith);
            list.setElementAt(swapNode, i);
        }
        this.moveLeavesTogether(list);
    }

    private void moveLeavesTogether(Vector list) {
        int size = list.size();
        for (int i = 0; i < size - 2; ++i) {
            NodeInfo ni = (NodeInfo)list.elementAt(i);
            boolean swapping = false;
            NodeInfo next = (NodeInfo)list.elementAt(i + 1);
            for (int differentLeave = i + 2; ni.leafAt == next.leafAt && differentLeave < size; ++differentLeave) {
                next = (NodeInfo)list.elementAt(differentLeave);
            }
            for (int j = differentLeave; j < size; ++j) {
                NodeInfo nk;
                int k;
                NodeInfo nj = (NodeInfo)list.elementAt(j);
                if (ni.leafAt != nj.leafAt) continue;
                swapping = true;
                for (k = j - 1; k > i; --k) {
                    nk = (NodeInfo)list.elementAt(k);
                    if (this.isSwappable(nk, nj)) continue;
                    swapping = false;
                    break;
                }
                if (swapping) {
                    list.remove(nj);
                    list.insertElementAt(nj, i + 1);
                    continue;
                }
                for (k = i + 1; k < j; ++k) {
                    nk = (NodeInfo)list.elementAt(k);
                    if (this.isSwappable(nk, ni)) continue;
                    swapping = false;
                    break;
                }
                if (!swapping) continue;
                list.remove(ni);
                list.insertElementAt(ni, j - 2);
            }
        }
    }

    @Override
    public boolean isNodePositionForced() {
        return this.assignNewOnly;
    }

    protected void breakBigNodes() {
        for (int i = 0; i < this.numNodes; ++i) {
            NodeInfo ni = (NodeInfo)this.allinfo.get(i);
            if (ni.colsize == 1 && ni.layersize == 1) continue;
            ni.children = new ArrayList();
            int j = 1;
            while (j < ni.layersize) {
                NodeInfoExtension nj = new NodeInfoExtension(ni, this.allinfo.size());
                if (ni.layer != -1) {
                    nj.setLayer(ni.layer + j);
                }
                if (ni.col != -1) {
                    nj.col = ni.col;
                }
                nj.diagramId = ni.diagramId;
                nj.colOffset = 0;
                nj.layerOffset = j++;
                ni.children.add(nj);
                ((Vector)this.diagrams.elementAt(nj.diagramId)).addElement(nj);
                this.allinfo.add(nj);
            }
            for (int k = 1; k < ni.colsize; ++k) {
                int j2 = 0;
                while (j2 < ni.layersize) {
                    NodeInfoExtension nj = new NodeInfoExtension(ni, this.allinfo.size());
                    if (ni.layer != -1) {
                        nj.setLayer(ni.layer + j2);
                    }
                    if (ni.col != -1) {
                        nj.col = ni.col + k;
                    }
                    nj.diagramId = ni.diagramId;
                    nj.colOffset = k;
                    nj.layerOffset = j2++;
                    ni.children.add(nj);
                    ((Vector)this.diagrams.elementAt(nj.diagramId)).addElement(nj);
                    this.allinfo.add(nj);
                }
            }
        }
    }

    private void breakNode(NodeInfo ni) {
        if (ni.colsize == 1 && ni.layersize == 1) {
            return;
        }
        ni.children = new ArrayList();
        int j = 1;
        while (j < ni.layersize) {
            NodeInfoExtension nj = new NodeInfoExtension(ni, this.allinfo.size());
            if (ni.layer != -1) {
                nj.setLayer(ni.layer + j);
            }
            if (ni.col != -1) {
                nj.col = ni.col;
            }
            nj.diagramId = ni.diagramId;
            nj.colOffset = 0;
            nj.layerOffset = j++;
            ni.children.add(nj);
            ((Vector)this.diagrams.elementAt(nj.diagramId)).addElement(nj);
            this.allinfo.add(nj);
        }
        for (int k = 1; k < ni.colsize; ++k) {
            int j2 = 0;
            while (j2 < ni.layersize) {
                NodeInfoExtension nj = new NodeInfoExtension(ni, this.allinfo.size());
                if (ni.layer != -1) {
                    nj.setLayer(ni.layer + j2);
                }
                if (ni.col != -1) {
                    nj.col = ni.col + k;
                }
                nj.diagramId = ni.diagramId;
                nj.colOffset = k;
                nj.layerOffset = j2++;
                ni.children.add(nj);
                ((Vector)this.diagrams.elementAt(nj.diagramId)).addElement(nj);
                this.allinfo.add(nj);
            }
        }
        this.totalNodes = this.allinfo.size();
    }

    private void resetPosition(Vector list, NodeInfo node, boolean moveForward) {
        int size = list.size();
        if (size == 1) {
            return;
        }
        list.remove(node);
        int index = 0;
        --size;
        NodeInfo nj = (NodeInfo)list.elementAt(0);
        while (nj != null && nj.col < node.col) {
            if (++index < size) {
                nj = (NodeInfo)list.elementAt(index);
                continue;
            }
            nj = null;
        }
        if (nj == null) {
            list.add(node);
            return;
        }
        if (nj.col == node.col) {
            if (moveForward) {
                list.insertElementAt(node, index);
                int col = node.col;
                ++nj.col;
                ++col;
                index += 2;
                while (index < size && ((NodeInfo)list.elementAt((int)index)).col == col) {
                    ++col;
                    ++((NodeInfo)list.elementAt((int)index)).col;
                    ++index;
                }
            } else {
                list.insertElementAt(node, index + 1);
                int col = node.col;
                --nj.col;
                --col;
                --index;
                while (index >= 0 && ((NodeInfo)list.elementAt((int)index)).col == col) {
                    --col;
                    --((NodeInfo)list.elementAt((int)index)).col;
                    --index;
                }
            }
        } else {
            list.insertElementAt(node, index);
        }
    }

    private boolean isOutSwappable(NodeInfo ni, NodeInfo nj) {
        Vector v1 = ni.outEdges;
        int size1 = v1.size();
        int[] s1 = new int[size1];
        Vector v2 = nj.outEdges;
        int size2 = v2.size();
        int[] s2 = new int[size2];
        int coni = 0;
        int coin = 0;
        if (size1 != 0 && size2 != 0) {
            int index;
            int j;
            NodeInfo To;
            int i;
            int notassigned = 0;
            for (i = 0; i < size1; ++i) {
                To = (NodeInfo)v1.elementAt(i);
                if (To.col == -1) {
                    ++notassigned;
                    continue;
                }
                Sort.insert(s1, i - notassigned, To.col);
            }
            size1 -= notassigned;
            notassigned = 0;
            for (i = 0; i < size2; ++i) {
                To = (NodeInfo)v2.elementAt(i);
                if (To.col == -1) {
                    ++notassigned;
                    continue;
                }
                Sort.insert(s2, i - notassigned, To.col);
            }
            size2 -= notassigned;
            for (j = 0; j < size1; ++j) {
                index = Sort.getGreaterThanIndex(s2, 0, size2, s1[j]);
                if (index >= size2) continue;
                coin += size2 - index;
            }
            for (j = 0; j < size2; ++j) {
                index = Sort.getGreaterThanIndex(s1, 0, size1, s2[j]);
                if (index >= size1) continue;
                coni += size1 - index;
            }
        }
        return coin <= coni;
    }

    private boolean isInSwappable(NodeInfo ni, NodeInfo nj) {
        Vector v1 = ni.inEdges;
        int size1 = v1.size();
        int[] s1 = new int[size1];
        Vector v2 = nj.inEdges;
        int size2 = v2.size();
        int[] s2 = new int[size2];
        int cini = 0;
        int ciin = 0;
        if (size1 != 0 && size2 != 0) {
            int index;
            int j;
            NodeInfo From;
            int i;
            int notassigned = 0;
            for (i = 0; i < size1; ++i) {
                From = (NodeInfo)v1.elementAt(i);
                if (From.col == -1) {
                    ++notassigned;
                    continue;
                }
                Sort.insert(s1, i - notassigned, From.col);
            }
            size1 -= notassigned;
            notassigned = 0;
            for (i = 0; i < size2; ++i) {
                From = (NodeInfo)v2.elementAt(i);
                if (From.col == -1) {
                    ++notassigned;
                    continue;
                }
                Sort.insert(s2, i - notassigned, From.col);
            }
            size2 -= notassigned;
            for (j = 0; j < size1; ++j) {
                index = Sort.getGreaterThanIndex(s2, 0, size2, s1[j]);
                if (index >= size2) continue;
                ciin += size2 - index;
            }
            for (j = 0; j < size2; ++j) {
                index = Sort.getGreaterThanIndex(s1, 0, size1, s2[j]);
                if (index >= size1) continue;
                cini += size1 - index;
            }
        }
        return ciin <= cini;
    }

    @Override
    void doSetupModel() {
        this.links = this.trimLinkList(this.model.getAllLinks());
        this.nodes = this.model.getAllLayoutNodes();
        this.adjustModel();
        this.numNodes = this.nodes.size();
        this.numLinks = this.links.size();
    }

    protected Vector trimLinkList(Vector linkList) {
        if (linkList == null || linkList.isEmpty()) {
            return linkList;
        }
        Vector<LinkLayoutInterface> trimmedList = new Vector<LinkLayoutInterface>();
        ListIterator i = linkList.listIterator();
        while (i.hasNext()) {
            LinkLayoutInterface link = (LinkLayoutInterface)i.next();
            if (!link.isLayoutAffected()) continue;
            trimmedList.add(link);
        }
        return trimmedList;
    }

    protected void adjustModel() {
        this.subdiagrams.clear();
        for (int i = 0; i < this.nodes.size(); ++i) {
            NodeLayoutInterface node = (NodeLayoutInterface)this.nodes.elementAt(i);
            if (!node.isVisible()) {
                this.nodes.remove(i);
                --i;
                continue;
            }
            if (!(node instanceof SubdiagramNodeLayoutInterface)) continue;
            this.subdiagrams.add(node);
        }
        this.subdiagramDummyLinkMap = new Hashtable();
        this.createSubdiagramDummyLinks();
    }

    private void createSubdiagramDummyLinks() {
        Vector<DummyLink> linksToAdd = new Vector<DummyLink>();
        Vector<LinkLayoutInterface> linksToRemove = new Vector<LinkLayoutInterface>();
        Hashtable<String, DummyLink> existingDummys = new Hashtable<String, DummyLink>();
        for (int i = 0; i < this.links.size(); ++i) {
            LinkLayoutInterface link = (LinkLayoutInterface)this.links.elementAt(i);
            if (!link.isVisible()) {
                linksToRemove.add(link);
                continue;
            }
            NodeLayoutInterface fromNode = link.getTopFromNode();
            boolean containsFrom = this.nodes.contains(fromNode);
            NodeLayoutInterface toNode = link.getTopToNode();
            boolean containsTo = this.nodes.contains(toNode);
            if (containsFrom && containsTo) continue;
            if (!containsFrom) {
                fromNode = this.getParentSubdiagram(fromNode);
            }
            if (!containsTo) {
                toNode = this.getParentSubdiagram(toNode);
            }
            if (fromNode == null || toNode == null || fromNode == toNode) {
                linksToRemove.add(link);
                continue;
            }
            linksToRemove.add(link);
            String hashString = String.valueOf(fromNode.hashCode()) + "," + String.valueOf(toNode.hashCode());
            DummyLink dl = (DummyLink)existingDummys.get(hashString);
            if (dl == null) {
                dl = new DummyLink(fromNode, toNode);
                linksToAdd.add(dl);
                existingDummys.put(hashString, dl);
            }
            this.subdiagramDummyLinkMap.put(link, dl);
        }
        this.links.removeAll(linksToRemove);
        this.links.addAll(linksToAdd);
    }

    private SubdiagramNodeLayoutInterface getParentSubdiagram(NodeLayoutInterface node) {
        for (int i = 0; i < this.subdiagrams.size(); ++i) {
            SubdiagramNodeLayoutInterface subNode = (SubdiagramNodeLayoutInterface)this.subdiagrams.elementAt(i);
            if (!subNode.isChildNode(node)) continue;
            return subNode;
        }
        return null;
    }

    public Vector extractSubdiagramExternalDummyLinks(SubdiagramNodeInfo thisSubdiagram) {
        Hashtable<LinkLayoutInterface, Vector> tempDummyLinks = new Hashtable<LinkLayoutInterface, Vector>();
        for (int i = 0; i < this.dummyLinks.size(); ++i) {
            Vector v = (Vector)this.dummyLinks.elementAt(i);
            LinkLayoutInterface link = (LinkLayoutInterface)v.elementAt(0);
            if (!(link instanceof DummyLink)) continue;
            this.dummyLinks.remove(i);
            tempDummyLinks.put(link, v);
            --i;
        }
        Hashtable newDummyLinks = new Hashtable();
        for (int i = 0; i < this.subdiagramInfo.size(); ++i) {
            SubdiagramNodeInfo sni = (SubdiagramNodeInfo)this.subdiagramInfo.elementAt(i);
            Vector internalDummys = sni.extractDummyLinks();
            if (internalDummys != null) {
                this.dummyLinks.addAll(internalDummys);
            }
            Vector externalLinks = sni.subdiagram.getExternalLinks();
            for (int j = 0; j < externalLinks.size(); ++j) {
                Vector mySubdiagramDummy;
                Vector<Object> newDummy;
                LinkLayoutInterface originalLink = (LinkLayoutInterface)externalLinks.elementAt(j);
                DummyLink collapsedLink = (DummyLink)this.subdiagramDummyLinkMap.get(originalLink);
                if (!originalLink.isVisible() || collapsedLink == null) continue;
                NodeLayoutInterface fromNode = collapsedLink.getTopFromNode();
                NodeLayoutInterface toNode = collapsedLink.getTopToNode();
                Vector subdiagramDummy = (Vector)sni.externalDummys.get(originalLink);
                if (subdiagramDummy == null || subdiagramDummy.isEmpty()) continue;
                if (toNode == sni.subdiagram) {
                    if (this.nodes.contains(fromNode)) {
                        NodeInfo fromInfo = this.getNodeInfoFromNode(fromNode);
                        Vector oldDummy = (Vector)newDummyLinks.get(originalLink);
                        if (oldDummy == null) {
                            oldDummy = (Vector)tempDummyLinks.get(collapsedLink);
                        }
                        newDummy = new Vector<Object>();
                        if (oldDummy == null) {
                            newDummy.addAll(subdiagramDummy);
                            newDummy.insertElementAt(originalLink, 0);
                            newDummy.insertElementAt(fromInfo, 1);
                        } else {
                            newDummy.addAll(oldDummy);
                            newDummy.remove(newDummy.size() - 1);
                            newDummy.addAll(subdiagramDummy);
                            newDummy.setElementAt(originalLink, 0);
                        }
                        newDummyLinks.put(originalLink, newDummy);
                        continue;
                    }
                    if (thisSubdiagram == null) continue;
                    mySubdiagramDummy = (Vector)thisSubdiagram.externalDummys.get(originalLink);
                    if (mySubdiagramDummy == null) {
                        thisSubdiagram.externalDummys.put(originalLink, subdiagramDummy);
                        continue;
                    }
                    int lastIdx = mySubdiagramDummy.size() - 1;
                    mySubdiagramDummy.remove(lastIdx);
                    mySubdiagramDummy.addAll(lastIdx, subdiagramDummy);
                    continue;
                }
                if (this.nodes.contains(toNode)) {
                    NodeInfo toInfo = this.getNodeInfoFromNode(toNode);
                    Vector oldDummy = (Vector)newDummyLinks.get(originalLink);
                    if (oldDummy == null) {
                        oldDummy = (Vector)tempDummyLinks.get(collapsedLink);
                    }
                    newDummy = new Vector();
                    if (oldDummy == null) {
                        newDummy.addAll(subdiagramDummy);
                        newDummy.insertElementAt(originalLink, 0);
                        newDummy.addElement(toInfo);
                    } else {
                        newDummy.addAll(oldDummy);
                        newDummy.remove(1);
                        newDummy.addAll(1, subdiagramDummy);
                        newDummy.setElementAt(originalLink, 0);
                    }
                    newDummyLinks.put(originalLink, newDummy);
                    continue;
                }
                if (thisSubdiagram == null) continue;
                mySubdiagramDummy = (Vector)thisSubdiagram.externalDummys.get(originalLink);
                if (mySubdiagramDummy == null) {
                    thisSubdiagram.externalDummys.put(originalLink, subdiagramDummy);
                    continue;
                }
                mySubdiagramDummy.remove(0);
                mySubdiagramDummy.addAll(0, subdiagramDummy);
            }
        }
        Enumeration e = newDummyLinks.elements();
        while (e.hasMoreElements()) {
            Vector v = (Vector)e.nextElement();
            if (v.size() <= 3) continue;
            this.dummyLinks.add(v);
        }
        return this.dummyLinks;
    }

    public Vector extractNodeInfo() {
        for (int i = 0; i < this.subdiagramInfo.size(); ++i) {
            SubdiagramNodeInfo sni = (SubdiagramNodeInfo)this.subdiagramInfo.elementAt(i);
            Vector children = sni.extractChildInfo();
            Vector dinfo = (Vector)this.diagrams.elementAt(sni.diagramId);
            dinfo.remove(sni);
            dinfo.removeAll(sni.children);
            if (children != null) {
                dinfo.addAll(children);
            }
            this.allinfo.remove(sni);
            this.allinfo.removeAll(sni.children);
            if (children != null) {
                this.allinfo.addAll(children);
            }
            this.totalNodes = this.allinfo.size();
        }
        return this.allinfo;
    }

    protected NodeInfo getNodeInfoFromNode(NodeLayoutInterface node) {
        if (this.allinfo == null) {
            return null;
        }
        for (int i = 0; i < this.allinfo.size(); ++i) {
            NodeInfo ni = (NodeInfo)this.allinfo.elementAt(i);
            if (node == ni.node) {
                return ni;
            }
            if (!(ni instanceof SubdiagramNodeInfo) || !((SubdiagramNodeInfo)ni).subdiagram.isChildNode(node)) continue;
            return ni;
        }
        return null;
    }

    protected void layoutSubdiagrams() {
        if (this.subdiagramInfo.isEmpty()) {
            return;
        }
        Enumeration e = this.subdiagramInfo.elements();
        while (e.hasMoreElements()) {
            SubdiagramNodeInfo sni = (SubdiagramNodeInfo)e.nextElement();
            sni.arrange();
            this.maxcolsize = Math.max(sni.colsize, this.maxcolsize);
            this.maxlayersize = Math.max(sni.layersize, this.maxlayersize);
        }
    }

    @Override
    public void arrangeExpandedSubdiagram(SubdiagramNodeLayoutInterface subdiagramNode) {
        SubdiagramNodeInfo sni = new SubdiagramNodeInfo(subdiagramNode, 0, this);
        sni.arrange();
        sni.layer = 0;
        sni.col = 0;
        sni.assignCoords();
    }

    private Vector getOriginalSubdiagramLinks(DummyLink dummy) {
        if (this.subdiagramDummyLinkMap == null || !this.subdiagramDummyLinkMap.containsValue(dummy)) {
            return null;
        }
        Vector keys = new Vector();
        Enumeration en = this.subdiagramDummyLinkMap.keys();
        while (en.hasMoreElements()) {
            Object k = en.nextElement();
            Object v = this.subdiagramDummyLinkMap.get(k);
            if (v == null || v != dummy) continue;
            keys.add(k);
        }
        if (keys.size() > 0) {
            return keys;
        }
        return null;
    }

    public int getComputedBetweenLayerSpace() {
        return 0;
    }

    public void reassignLayers(int lOffset, int cOffset) {
        for (int i = 0; i < this.totalNodes; ++i) {
            NodeInfo ni = (NodeInfo)this.allinfo.elementAt(i);
            if (ni instanceof NodeInfoExtension) continue;
            if (this.revtree) {
                ni.setLayer(this.numLayers - ni.layer - ni.layersize + lOffset);
            } else {
                ni.setLayer(ni.layer + lOffset);
            }
            ni.setColumn(ni.col + cOffset);
            if (!(ni instanceof SubdiagramNodeInfo)) continue;
            ((SubdiagramNodeInfo)ni).reassignLayers();
        }
    }

    private void reassignPos() {
        int j;
        int i;
        this.allPos = new Vector[this.numDiagrams][this.numLayers];
        this.allLayerWidth = new int[this.numDiagrams][this.numLayers];
        for (i = 0; i < this.numDiagrams; ++i) {
            for (j = 0; j < this.numLayers; ++j) {
                this.allLayerWidth[i][j] = 0;
                this.allPos[i][j] = new Vector();
            }
        }
        for (i = 0; i < this.numDiagrams; ++i) {
            this.ninfo = (Vector)this.diagrams.elementAt(i);
            this.layerWidth = this.allLayerWidth[i];
            this.pos = this.allPos[i];
            for (j = 0; j < this.ninfo.size(); ++j) {
                int pp;
                NodeInfo nj = (NodeInfo)this.ninfo.elementAt(j);
                if (nj == null) continue;
                int lsize = this.pos[nj.layer].size();
                for (pp = 0; pp < lsize && nj.col >= ((NodeInfo)this.pos[nj.layer].elementAt((int)pp)).col; ++pp) {
                }
                this.insertNodeToPos(nj, pp);
            }
        }
    }

    public void resetLinkBreakpoints() {
        LinkLayoutInterface link;
        int i;
        for (i = 0; i < this.numLinks; ++i) {
            link = (LinkLayoutInterface)this.links.elementAt(i);
            link.resetBreakPoints();
        }
        if (this.subdiagramDummyLinkMap != null) {
            Enumeration e = this.subdiagramDummyLinkMap.keys();
            while (e.hasMoreElements()) {
                link = (LinkLayoutInterface)e.nextElement();
                link.resetBreakPoints();
            }
        }
        for (i = 0; i < this.subdiagramInfo.size(); ++i) {
            ((SubdiagramNodeInfo)this.subdiagramInfo.elementAt(i)).resetLinkBreakpoins();
        }
    }

    @Override
    public void setGridWidth(int width) {
        this.gridWidth = width;
    }

    @Override
    public int getGridWidth() {
        return this.gridWidth;
    }

    @Override
    public void setGridHeight(int height) {
        this.gridHeight = height;
    }

    @Override
    public int getGridHeight() {
        return this.gridHeight;
    }

    @Override
    public void setLayerGridSpace(double gridSpace) {
        this.layerGridSpace = Math.max(0.0, gridSpace);
    }

    @Override
    public double getLayerGridSpace() {
        return this.layerGridSpace;
    }

    @Override
    public void setColumnGridSpace(double gridSpace) {
        this.colGridSpace = Math.max(0.0, gridSpace);
    }

    @Override
    public double getColumnGridSpace() {
        return this.colGridSpace;
    }

    private boolean hasOverlap() {
        Vector layers = new Vector();
        for (int i = 0; i < this.allinfo.size(); ++i) {
            NodeInfo ni = (NodeInfo)this.allinfo.get(i);
            if (ni.layer < 0 || ni.col < 0) {
                return true;
            }
            if (!this.isOccupied(layers, ni.layer, ni.col, ni)) continue;
            return true;
        }
        return false;
    }

    private boolean isOccupied(Vector layers, int l, int c, NodeInfo ni) {
        Vector<NodeInfo> columns;
        if (layers.size() <= l) {
            layers.setSize(l + 1);
        }
        if ((columns = (Vector<NodeInfo>)layers.get(l)) == null) {
            columns = new Vector<NodeInfo>();
            layers.set(l, columns);
        }
        if (columns.size() <= c) {
            columns.setSize(c + 1);
        }
        if (columns.get(c) != null) {
            return true;
        }
        columns.set(c, ni);
        return false;
    }

    private boolean isPosInOrder() {
        for (int i = 0; i < this.pos.length; ++i) {
            Vector layer = this.pos[i];
            int lastCol = Integer.MIN_VALUE;
            for (int j = 0; j < layer.size(); ++j) {
                NodeInfo ni = (NodeInfo)layer.get(j);
                if (ni.col <= lastCol) {
                    return false;
                }
                lastCol = ni.col;
            }
        }
        return true;
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        boolean rc = true;
        Vector changes = this.pending.getChangesBySource(source);
        if (changes.size() > 0) {
            rc = true;
            for (int i = 0; i < changes.size(); ++i) {
                PropertyEvent event = (PropertyEvent)changes.elementAt(i);
                int key = event.id;
                Object value = event.value;
                this.applyChange(key, value);
            }
        }
        this.pending.removeChangesBySource(source);
        return rc;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        this.pending.removeChangesBySource(source);
    }

    public int getNumberPendingProperties() {
        return this.pending.getNumberPending(null);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        return this.pending.getPending(source);
    }

    public Object getPropertyValue(int id) {
        if (this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        switch (id) {
            case 101: {
                return this.getFlowDirection();
            }
            case 103: {
                return this.getGridHeight();
            }
            case 102: {
                return this.getGridWidth();
            }
            case 104: {
                return this.getColumnGridSpace();
            }
            case 105: {
                return this.getLayerGridSpace();
            }
        }
        return null;
    }

    public boolean hasUserSetValue(int id) {
        switch (id) {
            case 101: {
                if (this.orientation != 3) break;
                return false;
            }
            case 103: {
                if (this.gridHeight != 33) break;
                return false;
            }
            case 102: {
                if (this.gridWidth != 33) break;
                return false;
            }
            case 104: {
                if (this.colGridSpace != 1.0) break;
                return false;
            }
            case 105: {
                if (this.layerGridSpace != 2.0) break;
                return false;
            }
            default: {
                return true;
            }
        }
        return true;
    }

    public boolean isPropertyPending(int id) {
        return this.pending.isPending(id);
    }

    public boolean isPropertySupported(int id) {
        switch (id) {
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return true;
            }
        }
        return false;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (this.isPropertySupported(id)) {
            return this.pending.store(id, value);
        }
        return false;
    }

    protected void applyChange(int key, Object value) {
        switch (key) {
            case 101: {
                if (value instanceof String) {
                    this.setFlowDirection((String)value);
                }
                return;
            }
            case 103: {
                if (value instanceof Integer) {
                    this.setGridHeight((Integer)value);
                }
                return;
            }
            case 102: {
                if (value instanceof Integer) {
                    this.setGridWidth((Integer)value);
                }
                return;
            }
            case 104: {
                if (value instanceof Double) {
                    this.setColumnGridSpace((Double)value);
                }
                return;
            }
            case 105: {
                if (value instanceof Double) {
                    this.setLayerGridSpace((Double)value);
                }
                return;
            }
        }
    }
}

