/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.util.layout;

import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.components.util.layout.LayeredLayoutStrategy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class LayeredLayoutPropertyDialog
extends JDialog
implements ActionListener,
ItemListener,
FocusListener {
    public static final String RB_KEY = "LayeredLayoutPropertyDialog.";
    LayeredLayoutStrategy layout;
    JComboBox direction;
    JLabel betweenLayerSpacingLabel;
    JTextField betweenLayerSpacing;
    JLabel withinLayerSpacingLabel;
    JTextField withinLayerSpacing;
    TitledBorder layerSizeTitle;
    JRadioButton automatic;
    JRadioButton custom;
    JTextField columns;
    JComboBox cycle;
    JComboBox layering;
    JComboBox initializing;
    JTextField iteration;
    JButton resetButton;
    JButton okButton;
    JButton cancelButton;
    String currentDirection;
    int currentBetweenLayerSpace;
    int currentWithinLayerSpace;
    int currentLayerSize;
    String currentCycle;
    String currentInitializing;
    String currentLayering;
    int currentIteration;
    JPanel nodeSpacePanel;

    public LayeredLayoutPropertyDialog(Frame aFrame, String title, LayeredLayoutStrategy layout) {
        super(aFrame, true);
        this.setTitle(title);
        this.setResizable(false);
        this.layout = layout;
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel directionPanel = new JPanel();
        directionPanel.setLayout(new BoxLayout(directionPanel, 0));
        JLabel directionLabel = new JLabel(RB.getStringResource(RB_KEY, "flowDirectionLabel.txt"));
        directionLabel.setPreferredSize(new Dimension(200, directionLabel.getPreferredSize().height));
        String[] directions = new String[]{RB.getStringResource(RB_KEY, "flowDirectionLeftRight.txt"), RB.getStringResource(RB_KEY, "flowDirectionRightLeft.txt"), RB.getStringResource(RB_KEY, "flowDirectionTopBottom.txt"), RB.getStringResource(RB_KEY, "flowDirectionBottomTop.txt")};
        this.direction = new JComboBox<String>(directions);
        this.direction.addActionListener(this);
        directionPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        directionPanel.add((Component)directionLabel, "West");
        directionPanel.add((Component)this.direction, "Center");
        contentPane.add(directionPanel);
        contentPane.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel grid = new JPanel();
        grid.setBorder(new TitledBorder(new EtchedBorder(), RB.getStringResource(RB_KEY, "nodeSpacing.txt")));
        grid.setLayout(new BoxLayout(grid, 1));
        JPanel betweenLayerSpacingPanel = new JPanel();
        betweenLayerSpacingPanel.setLayout(new BoxLayout(betweenLayerSpacingPanel, 0));
        this.betweenLayerSpacingLabel = new JLabel(RB.getStringResource(RB_KEY, "columnSpacing.txt"));
        this.betweenLayerSpacingLabel.setPreferredSize(new Dimension(200, this.betweenLayerSpacingLabel.getPreferredSize().height));
        this.betweenLayerSpacing = new JTextField();
        this.betweenLayerSpacing.addActionListener(this);
        this.betweenLayerSpacing.addFocusListener(this);
        betweenLayerSpacingPanel.add(this.betweenLayerSpacingLabel);
        betweenLayerSpacingPanel.add(this.betweenLayerSpacing);
        betweenLayerSpacingPanel.add(Box.createRigidArea(new Dimension(120, 0)));
        grid.add(betweenLayerSpacingPanel);
        grid.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel withinLayerSpacingPanel = new JPanel();
        withinLayerSpacingPanel.setLayout(new BoxLayout(withinLayerSpacingPanel, 0));
        this.withinLayerSpacingLabel = new JLabel(RB.getStringResource(RB_KEY, "rowSpacing.txt"));
        this.withinLayerSpacingLabel.setPreferredSize(new Dimension(200, this.withinLayerSpacingLabel.getPreferredSize().height));
        this.withinLayerSpacing = new JTextField();
        this.withinLayerSpacing.addActionListener(this);
        this.withinLayerSpacing.addFocusListener(this);
        withinLayerSpacingPanel.add(this.withinLayerSpacingLabel);
        withinLayerSpacingPanel.add(this.withinLayerSpacing);
        withinLayerSpacingPanel.add(Box.createRigidArea(new Dimension(120, 0)));
        grid.add(withinLayerSpacingPanel);
        grid.add(Box.createRigidArea(new Dimension(0, 5)));
        contentPane.add(grid);
        contentPane.add(Box.createRigidArea(new Dimension(0, 5)));
        this.nodeSpacePanel = new JPanel();
        this.layerSizeTitle = new TitledBorder(new EtchedBorder(), RB.getStringResource(RB_KEY, "maxNodesColumn.txt"));
        this.nodeSpacePanel.setBorder(this.layerSizeTitle);
        this.nodeSpacePanel.setLayout(new BoxLayout(this.nodeSpacePanel, 1));
        JPanel columnsPanel = new JPanel();
        columnsPanel.setLayout(new BoxLayout(columnsPanel, 0));
        ButtonGroup bg = new ButtonGroup();
        this.automatic = new JRadioButton(RB.getStringResource(RB_KEY, "maxNodesAutomatic.txt"), true);
        this.automatic.addItemListener(this);
        bg.add(this.automatic);
        this.custom = new JRadioButton(RB.getStringResource(RB_KEY, "maxNodesCustom.txt"), false);
        this.custom.addItemListener(this);
        bg.add(this.custom);
        this.columns = new JTextField();
        this.columns.setEnabled(false);
        this.columns.addActionListener(this);
        this.columns.addFocusListener(this);
        columnsPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        columnsPanel.add(this.automatic);
        columnsPanel.add(Box.createRigidArea(new Dimension(112, 0)));
        columnsPanel.add(this.custom);
        columnsPanel.add(Box.createRigidArea(new Dimension(50, 0)));
        columnsPanel.add(this.columns);
        this.nodeSpacePanel.add(columnsPanel);
        this.nodeSpacePanel.add(Box.createRigidArea(new Dimension(0, 5)));
        contentPane.add(this.nodeSpacePanel);
        contentPane.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel advanced = new JPanel();
        advanced.setBorder(new TitledBorder(new EtchedBorder(), RB.getStringResource(RB_KEY, "advancedOptions.txt")));
        advanced.setLayout(new BoxLayout(advanced, 1));
        JPanel cyclePanel = new JPanel();
        cyclePanel.setLayout(new BoxLayout(cyclePanel, 0));
        JLabel cycleLabel = new JLabel(RB.getStringResource(RB_KEY, "cycleLabel.txt"));
        cycleLabel.setPreferredSize(new Dimension(200, cycleLabel.getPreferredSize().height));
        String[] cycles = new String[]{RB.getStringResource(RB_KEY, "cycleGreedy.txt"), RB.getStringResource(RB_KEY, "cycleDFS.txt")};
        this.cycle = new JComboBox<String>(cycles);
        this.cycle.addActionListener(this);
        cyclePanel.add((Component)cycleLabel, "West");
        cyclePanel.add((Component)this.cycle, "Center");
        advanced.add(cyclePanel);
        advanced.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel initializingPanel = new JPanel();
        initializingPanel.setLayout(new BoxLayout(initializingPanel, 0));
        JLabel initializingLabel = new JLabel(RB.getStringResource(RB_KEY, "initializationLabel.txt"));
        initializingLabel.setPreferredSize(new Dimension(200, initializingLabel.getPreferredSize().height));
        String[] initializings = new String[]{RB.getStringResource(RB_KEY, "initializeOptimal.txt"), RB.getStringResource(RB_KEY, "initializeDFSOutward.txt"), RB.getStringResource(RB_KEY, "initializeDFSInward.txt")};
        this.initializing = new JComboBox<String>(initializings);
        this.initializing.addActionListener(this);
        initializingPanel.add((Component)initializingLabel, "West");
        initializingPanel.add((Component)this.initializing, "Center");
        advanced.add(initializingPanel);
        advanced.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel layeringPanel = new JPanel();
        layeringPanel.setLayout(new BoxLayout(layeringPanel, 0));
        JLabel layeringLabel = new JLabel(RB.getStringResource(RB_KEY, "layeringLabel.txt"));
        layeringLabel.setPreferredSize(new Dimension(200, layeringLabel.getPreferredSize().height));
        String[] layerings = new String[]{RB.getStringResource(RB_KEY, "layeringLongestSink.txt"), RB.getStringResource(RB_KEY, "layeringLongestSource.txt"), RB.getStringResource(RB_KEY, "layeringOptimalLength.txt")};
        this.layering = new JComboBox<String>(layerings);
        this.layering.addActionListener(this);
        layeringPanel.add((Component)layeringLabel, "West");
        layeringPanel.add((Component)this.layering, "Center");
        advanced.add(layeringPanel);
        advanced.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel iterationPanel = new JPanel();
        iterationPanel.setLayout(new BoxLayout(iterationPanel, 0));
        JLabel iterationLabel = new JLabel(RB.getStringResource(RB_KEY, "iterationLabel.txt"));
        iterationLabel.setPreferredSize(new Dimension(200, iterationLabel.getPreferredSize().height));
        this.iteration = new JTextField();
        this.iteration.addActionListener(this);
        this.iteration.addFocusListener(this);
        iterationPanel.add(iterationLabel);
        iterationPanel.add(this.iteration);
        iterationPanel.add(Box.createRigidArea(new Dimension(120, 0)));
        advanced.add(iterationPanel);
        advanced.add(Box.createRigidArea(new Dimension(0, 5)));
        contentPane.add(advanced);
        contentPane.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.resetButton = new JButton(RB.getStringResource(RB_KEY, "defaults.txt"));
        this.resetButton.addActionListener(this);
        this.okButton = new JButton(RB.getStringResource(RB_KEY, "ok.txt"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(RB.getStringResource(RB_KEY, "cancel.txt"));
        this.cancelButton.addActionListener(this);
        this.okButton.setPreferredSize(this.resetButton.getPreferredSize());
        this.cancelButton.setPreferredSize(this.resetButton.getPreferredSize());
        buttonPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        buttonPanel.add(this.resetButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.okButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(32, 0)));
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        contentPane.add(buttonPanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(contentPane);
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        this.currentDirection = this.layout.getFlowDirection();
        this.currentBetweenLayerSpace = this.layout.getBetweenLayerSpace();
        this.currentWithinLayerSpace = this.layout.getWithinLayerSpace();
        this.currentLayerSize = this.layout.getLayerSize();
        this.currentCycle = this.layout.getCycleRemovalAlgorithm();
        this.currentInitializing = this.layout.getInitializationAlgorithm();
        this.currentLayering = this.layout.getLayeringOption();
        this.currentIteration = this.layout.getMaxIterations();
        if (this.currentDirection.equals("Right")) {
            this.direction.setSelectedIndex(0);
            this.betweenLayerSpacingLabel.setText(RB.getStringResource(RB_KEY, "columnSpacing.txt"));
            this.withinLayerSpacingLabel.setText(RB.getStringResource(RB_KEY, "rowSpacing.txt"));
            this.layerSizeTitle.setTitle(RB.getStringResource(RB_KEY, "maxNodesColumn.txt"));
        } else if (this.currentDirection.equals("Left")) {
            this.direction.setSelectedIndex(1);
            this.betweenLayerSpacingLabel.setText(RB.getStringResource(RB_KEY, "columnSpacing.txt"));
            this.withinLayerSpacingLabel.setText(RB.getStringResource(RB_KEY, "rowSpacing.txt"));
            this.layerSizeTitle.setTitle(RB.getStringResource(RB_KEY, "maxNodesColumn.txt"));
        } else if (this.currentDirection.equals("Down")) {
            this.direction.setSelectedIndex(2);
            this.betweenLayerSpacingLabel.setText(RB.getStringResource(RB_KEY, "rowSpacing.txt"));
            this.withinLayerSpacingLabel.setText(RB.getStringResource(RB_KEY, "columnSpacing.txt"));
            this.layerSizeTitle.setTitle(RB.getStringResource(RB_KEY, "maxNodesRow.txt"));
        } else {
            this.direction.setSelectedIndex(3);
            this.betweenLayerSpacingLabel.setText(RB.getStringResource(RB_KEY, "rowSpacing.txt"));
            this.withinLayerSpacingLabel.setText(RB.getStringResource(RB_KEY, "columnSpacing.txt"));
            this.layerSizeTitle.setTitle(RB.getStringResource(RB_KEY, "maxNodesRow.txt"));
        }
        this.betweenLayerSpacing.setText(String.valueOf(this.currentBetweenLayerSpace));
        this.withinLayerSpacing.setText(String.valueOf(this.currentWithinLayerSpace));
        this.cycle.setSelectedItem(this.currentCycle);
        this.layering.setSelectedItem(this.currentLayering);
        this.initializing.setSelectedItem(this.currentInitializing);
        this.iteration.setText(String.valueOf(this.currentIteration));
        if (this.currentLayerSize == -1) {
            this.automatic.setSelected(true);
            this.columns.setEnabled(false);
            this.columns.setText("5");
        } else {
            this.custom.setSelected(true);
            this.columns.setEnabled(true);
            this.columns.setText(String.valueOf(this.currentLayerSize));
        }
    }

    private void reset() {
        this.direction.setSelectedIndex(0);
        this.betweenLayerSpacing.setText("20");
        this.withinLayerSpacing.setText("40");
        this.columns.setText("5");
        this.layout.setFlowDirection("Right");
        this.layout.setBetweenLayerSpace(20);
        this.layout.setWithinLayerSpace(40);
        this.layout.setLayerSize(-1);
    }

    private void restore() {
        this.layout.setFlowDirection(this.currentDirection);
        this.layout.setBetweenLayerSpace(this.currentBetweenLayerSpace);
        this.layout.setWithinLayerSpace(this.currentWithinLayerSpace);
        this.layout.setLayerSize(this.currentLayerSize);
        this.layout.setCycleRemovalAlgorithm(this.currentCycle);
        this.layout.setInitializationAlgorithm(this.currentInitializing);
        this.layout.setLayeringOption(this.currentLayering);
        this.layout.setMaxIterations(this.currentIteration);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.cycle) {
            this.layout.setCycleRemovalAlgorithm((String)this.cycle.getSelectedItem());
        } else if (source == this.layering) {
            this.layout.setLayeringOption((String)this.layering.getSelectedItem());
        } else if (source == this.initializing) {
            this.layout.setInitializationAlgorithm((String)this.initializing.getSelectedItem());
        } else if (source == this.iteration) {
            this.layout.setMaxIterations(Integer.valueOf(this.iteration.getText()));
        } else if (source == this.betweenLayerSpacing) {
            this.layout.setBetweenLayerSpace(Integer.valueOf(this.betweenLayerSpacing.getText()));
        } else if (source == this.withinLayerSpacing) {
            this.layout.setWithinLayerSpace(Integer.valueOf(this.withinLayerSpacing.getText()));
        } else if (source == this.direction) {
            int index = this.direction.getSelectedIndex();
            if (index == 0) {
                this.layout.setFlowDirection("Right");
                this.betweenLayerSpacingLabel.setText(RB.getStringResource(RB_KEY, "columnSpacing.txt"));
                this.withinLayerSpacingLabel.setText(RB.getStringResource(RB_KEY, "rowSpacing.txt"));
                this.layerSizeTitle.setTitle(RB.getStringResource(RB_KEY, "maxNodesColumn.txt"));
            } else if (index == 1) {
                this.layout.setFlowDirection("Left");
                this.betweenLayerSpacingLabel.setText(RB.getStringResource(RB_KEY, "columnSpacing.txt"));
                this.withinLayerSpacingLabel.setText(RB.getStringResource(RB_KEY, "rowSpacing.txt"));
                this.layerSizeTitle.setTitle(RB.getStringResource(RB_KEY, "maxNodesColumn.txt"));
            } else if (index == 2) {
                this.layout.setFlowDirection("Down");
                this.betweenLayerSpacingLabel.setText(RB.getStringResource(RB_KEY, "rowSpacing.txt"));
                this.withinLayerSpacingLabel.setText(RB.getStringResource(RB_KEY, "columnSpacing.txt"));
                this.layerSizeTitle.setTitle(RB.getStringResource(RB_KEY, "maxNodesRow.txt"));
            } else {
                this.layout.setFlowDirection("Up");
                this.betweenLayerSpacingLabel.setText(RB.getStringResource(RB_KEY, "rowSpacing.txt"));
                this.withinLayerSpacingLabel.setText(RB.getStringResource(RB_KEY, "columnSpacing.txt"));
                this.layerSizeTitle.setTitle(RB.getStringResource(RB_KEY, "maxNodesRow.txt"));
            }
            this.nodeSpacePanel.repaint();
        } else if (source == this.columns) {
            this.layout.setLayerSize(Integer.valueOf(this.columns.getText()));
        } else if (source == this.resetButton) {
            this.reset();
        } else if (source == this.okButton) {
            this.dispose();
        } else if (source == this.cancelButton) {
            this.restore();
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object item = e.getItem();
        if (item == this.automatic) {
            this.layout.setLayerSize(-1);
            this.columns.setEnabled(false);
        } else if (item == this.custom) {
            this.columns.setEnabled(true);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        if (source == this.iteration) {
            this.layout.setMaxIterations(Integer.valueOf(this.iteration.getText()));
        } else if (source == this.betweenLayerSpacing) {
            this.layout.setBetweenLayerSpace(Integer.valueOf(this.betweenLayerSpacing.getText()));
        } else if (source == this.withinLayerSpacing) {
            this.layout.setWithinLayerSpace(Integer.valueOf(this.withinLayerSpacing.getText()));
        } else if (source == this.columns) {
            this.layout.setLayerSize(Integer.valueOf(this.columns.getText()));
        }
    }
}

