/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.util.layout;

import com.sas.graphics.components.pfd.PFDSelfLink;
import com.sas.graphics.components.util.layout.AdjacencyInfo;
import com.sas.graphics.components.util.layout.GraphComponent;
import com.sas.graphics.components.util.layout.GraphComponentAttrs;
import com.sas.graphics.components.util.layout.GraphComponentInterface;
import com.sas.graphics.components.util.layout.GraphDistance;
import com.sas.graphics.components.util.layout.GraphInformation;
import com.sas.graphics.components.util.layout.IntegerQueue;
import com.sas.graphics.components.util.layout.LayoutStrategy;
import com.sas.graphics.components.util.layout.MISF;
import com.sas.graphics.components.util.layout.PQueue;
import com.sas.graphics.components.util.layout.Point;
import com.sas.graphics.interfaces.LinkLayoutInterface;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.graphics.interfaces.NodeLinkDiagramLayoutInterface;
import java.awt.geom.Line2D;
import java.util.Random;
import java.util.Vector;

public class GRIPLayout
extends LayoutStrategy {
    private static boolean DEBUG_MODE = false;
    private static int LARGE_N_NODE = 300;
    private static int VERY_SMALL_N_NODE = 4;
    private int diam = 0;
    private Random random = new Random("Random".hashCode());
    private Random pointRandom = new Random("Random".hashCode());
    private GraphInformation graphInfo = null;
    private GraphComponentInterface[] components = null;
    private GraphComponentAttrs[] gca = null;
    private int compWidth;
    private int compHeight;
    private double zeroDistance = 0.01;
    private boolean nodeSizeIgnored = true;
    private int initRounds = 20;
    private int finalRounds = this.nodeSizeIgnored ? 30 : 60;
    private double repellingFactor = 0.05;
    private double preferredEdgeLength = -1.0;
    private double initTemperature = -1.0;
    private boolean fixedFinalRounds = true;
    private int finalRoundIncrement = 30;
    private int maxFinalRounds = 500;

    public GRIPLayout(int width, int height) {
        this.compWidth = width;
        this.compHeight = height;
    }

    public void setNodeSizeIgnored(boolean b) {
        this.nodeSizeIgnored = b;
    }

    public boolean isNodeSizeIgnored() {
        return this.nodeSizeIgnored;
    }

    public void setInitialRounds(int rounds) {
        this.initRounds = rounds;
    }

    public int getInitialRounds() {
        return this.initRounds;
    }

    public void setFinalRounds(int rounds) {
        this.finalRounds = rounds;
        this.fixedFinalRounds = true;
    }

    public int getFinalRounds() {
        return this.finalRounds;
    }

    public void setPreferredEdgelength(double len) {
        this.preferredEdgeLength = len;
    }

    public double getPreferredEdgeLength() {
        return this.preferredEdgeLength;
    }

    public void setInitialTemperature(double tinit) {
        this.initTemperature = tinit;
    }

    public double getInitialTemperature() {
        return this.initTemperature;
    }

    public void setRepellingFactor(double fac) {
        this.repellingFactor = fac;
        this.fixedFinalRounds = true;
    }

    public double getRepellingFactor() {
        return this.repellingFactor;
    }

    public void setFixedFinalRounds(boolean b) {
        this.fixedFinalRounds = b;
    }

    public boolean isFixedFinalRounds() {
        return this.fixedFinalRounds;
    }

    @Override
    public void setModel(NodeLinkDiagramLayoutInterface m) {
        super.setModel(m);
        this.doSetupModel();
    }

    @Override
    void doSetupModel() {
        super.doSetupModel();
        this.graphInfo = new GraphInformation(this.model);
    }

    @Override
    public boolean arrange() {
        int numOfInitVert = 3;
        double bounds = 50.0;
        this.components = this.getGraphComponents(this.graphInfo);
        int numberOfComponents = this.components.length;
        this.gca = this.initializeGraphComponents((GraphComponent[])this.components, numberOfComponents, numOfInitVert, false, false, this.initRounds, this.finalRounds, bounds);
        for (int i = 0; i < numberOfComponents; ++i) {
            this.misfEngine((GraphComponent)this.components[i], this.gca[i], bounds);
        }
        if (numberOfComponents > 1) {
            this.adjustComponentPositions((GraphComponent[])this.components, this.gca);
        }
        this.updateModelPositions();
        return true;
    }

    private GraphComponentInterface[] getGraphComponents(GraphInformation graph) {
        int numOfVert = graph.getNumberNodes();
        NodeSplitMap[] nodeMap = new NodeSplitMap[numOfVert];
        for (int i = 0; i < nodeMap.length; ++i) {
            nodeMap[i] = new NodeSplitMap();
            nodeMap[i].comp = -1;
        }
        int currentAdjacencyList = 0;
        for (int vert = 0; vert < numOfVert; ++vert) {
            if (nodeMap[vert].comp != -1) continue;
            int[] processed = this.BFS(graph, vert, numOfVert);
            int currPosition = 0;
            nodeMap[vert].comp = currentAdjacencyList;
            nodeMap[vert].vert = currPosition++;
            for (int index = vert + 1; index < numOfVert; ++index) {
                if (processed[index] != 1) continue;
                nodeMap[index].comp = currentAdjacencyList;
                nodeMap[index].vert = currPosition++;
            }
            ++currentAdjacencyList;
        }
        if (currentAdjacencyList == 1) {
            GraphComponent gc = new GraphComponent();
            gc.setNumberOfVertices(this.graphInfo.getNumberNodes());
            gc.setAdjacencyList(this.graphInfo.getAdjacencyList());
            gc.setNodeSizes(this.graphInfo.getNodeSizes());
            gc.setLinkWeights(graph.getLinkWeights());
            int[] vertexList = new int[numOfVert];
            for (int i = 0; i < numOfVert; ++i) {
                vertexList[i] = i;
            }
            gc.setVertexList(vertexList);
            return new GraphComponent[]{gc};
        }
        int[] numVertAdjList = new int[currentAdjacencyList];
        for (int i = 0; i < currentAdjacencyList; ++i) {
            numVertAdjList[i] = 0;
        }
        for (int vert = 0; vert < numOfVert; ++vert) {
            int n = nodeMap[vert].comp;
            numVertAdjList[n] = numVertAdjList[n] + 1;
        }
        int[][] vertexList = new int[currentAdjacencyList][];
        double[][] nodeSizes = new double[currentAdjacencyList][];
        for (int i = 0; i < currentAdjacencyList; ++i) {
            vertexList[i] = new int[numVertAdjList[i]];
            nodeSizes[i] = new double[numVertAdjList[i]];
        }
        for (int vert = 0; vert < numOfVert; ++vert) {
            vertexList[nodeMap[vert].comp][nodeMap[vert].vert] = vert;
            nodeSizes[nodeMap[vert].comp][nodeMap[vert].vert] = graph.getNodeSize(vert);
        }
        GraphComponentInterface[] graphComponents = new GraphComponent[currentAdjacencyList];
        for (int i = 0; i < currentAdjacencyList; ++i) {
            graphComponents[i] = new GraphComponent();
            ((GraphComponent)graphComponents[i]).setNumberOfVertices(numVertAdjList[i]);
            ((GraphComponent)graphComponents[i]).setVertexList(vertexList[i]);
            ((GraphComponent)graphComponents[i]).setNodeSizes(nodeSizes[i]);
            ((GraphComponent)graphComponents[i]).setLinkWeights(graph.getLinkWeights());
        }
        for (int vert = 0; vert < numOfVert; ++vert) {
            int adjListNum = nodeMap[vert].comp;
            if (adjListNum == -1) continue;
            int newVert = nodeMap[vert].vert;
            int numAdjVert = graph.getDegree(vert);
            Vector<AdjacencyInfo> newAdjList = new Vector<AdjacencyInfo>();
            for (int i = 0; i < numAdjVert; ++i) {
                AdjacencyInfo oldAdjInfo = graph.getAdjacencyInfo(vert, i);
                int adjVert = oldAdjInfo.getNodeIndex();
                AdjacencyInfo newAdjInfo = new AdjacencyInfo(nodeMap[adjVert].vert, oldAdjInfo.getLinkIndex());
                newAdjList.addElement(newAdjInfo);
            }
            ((GraphComponent)graphComponents[adjListNum]).setAdjacencyList(newVert, newAdjList);
        }
        return graphComponents;
    }

    private int[] createBFS(GraphComponentInterface graphComponent, int[] vertices, int numVert, int level, int[] vertDepth) {
        int count;
        int depthLim = (int)Math.pow(2.0, level);
        int numKept = 0;
        int[] marked = new int[graphComponent.getNumberNodes() + 1];
        this.diam = 0;
        for (count = 0; count <= graphComponent.getNumberNodes(); ++count) {
            marked[count] = -1;
        }
        for (count = 0; count < graphComponent.getNumberNodes(); ++count) {
            if (marked[count + 1] != -1) continue;
            int[] processed = this.BFS(graphComponent, vertices[count], depthLim);
            marked[count + 1] = 1;
            ++numKept;
            for (int index = count + 1; index < graphComponent.getNumberNodes(); ++index) {
                if (processed[vertices[index]] != 1) continue;
                marked[index + 1] = 0;
            }
        }
        marked[0] = numKept;
        return marked;
    }

    private int[] BFS(GraphComponentInterface graphComponent, int root, int depthLimit) {
        GraphComponent gc;
        int[] color = new int[graphComponent.getNumberNodes()];
        IntegerQueue vertQ = new IntegerQueue(graphComponent.getNumberNodes(), 0);
        IntegerQueue depthQ = new IntegerQueue(graphComponent.getNumberNodes(), 0);
        for (int count = 0; count < graphComponent.getNumberNodes(); ++count) {
            color[count] = 0;
        }
        int currentDepth = 1;
        int vert = root;
        while (currentDepth <= depthLimit + 1) {
            color[vert] = 1;
            int deg = graphComponent.getDegree(vert);
            for (int count = 0; count < deg; ++count) {
                int adjVert = graphComponent.getAdjacentVertex(vert, count);
                if (adjVert < 0 || color[adjVert] != 0) continue;
                color[adjVert] = -1;
                vertQ.enqueue(adjVert);
                depthQ.enqueue(currentDepth);
            }
            if (vertQ.size() <= 0) break;
            vert = vertQ.dequeue();
            currentDepth = depthQ.dequeue() + 1;
        }
        if (this.diam < currentDepth) {
            this.diam = currentDepth;
        }
        if (graphComponent instanceof GraphComponent && (gc = (GraphComponent)graphComponent).getDiameter() < currentDepth) {
            gc.setDiameter(this.diam);
        }
        vertQ.freeQueue();
        depthQ.freeQueue();
        return color;
    }

    private int[] randomBFS(int[] vertices, int numVert) {
        int[] marked = new int[numVert + 1];
        int numKept = numVert;
        Random random = new Random(System.currentTimeMillis());
        while (numKept == numVert) {
            numKept = 0;
            for (int count = 1; count <= numVert; ++count) {
                int randNum = random.nextInt() % 5;
                if (randNum % 2 == 0) {
                    marked[count] = 1;
                    ++numKept;
                    continue;
                }
                marked[count] = 0;
            }
        }
        marked[0] = numKept;
        return marked;
    }

    private GraphDistance[] nbr_bfs(GraphComponentInterface graphComponent, int root, GraphDistance[][][] nbrs, int[] nbr, int[] vertDepth) {
        int count;
        int i;
        int[] color = new int[graphComponent.getNumberNodes()];
        IntegerQueue vertQ = new IntegerQueue(2 * graphComponent.getNumberNodes(), 10);
        int bottomNbrsLayer = 0;
        int[] nbrCounter = new int[vertDepth[root] + 1];
        int numOfCloseVert = 3;
        int closeVertItr = 0;
        boolean closeVertDone = false;
        GraphDistance[] closeVert = new GraphDistance[numOfCloseVert];
        nbrs[root] = new GraphDistance[vertDepth[root] + 2][];
        for (i = 0; i <= vertDepth[root]; ++i) {
            nbrs[root][i] = new GraphDistance[nbr[i]];
            nbrCounter[i] = 0;
        }
        for (count = 0; count < graphComponent.getNumberNodes(); ++count) {
            color[count] = 0;
        }
        int currDist = 1;
        int vert = root;
        do {
            color[vert] = 1;
            int deg = graphComponent.getDegree(vert);
            for (count = 0; count < deg; ++count) {
                int adjVert = graphComponent.getAdjacentVertex(vert, count);
                if (adjVert < 0 || color[adjVert] != 0) continue;
                color[adjVert] = -1;
                vertQ.enqueue(adjVert);
                vertQ.enqueue(currDist);
                for (i = bottomNbrsLayer; i <= Math.min(vertDepth[adjVert], vertDepth[root]); ++i) {
                    if (nbrCounter[i] < nbr[i]) {
                        if (nbrs[root][i][nbrCounter[i]] == null) {
                            nbrs[root][i][nbrCounter[i]] = new GraphDistance();
                        }
                        nbrs[root][i][nbrCounter[i]].setVertex(adjVert);
                        nbrs[root][i][nbrCounter[i]].setDistance(currDist);
                        int n = i;
                        nbrCounter[n] = nbrCounter[n] + 1;
                        continue;
                    }
                    bottomNbrsLayer = i + 1;
                }
                if (closeVertDone || closeVertItr >= numOfCloseVert || vertDepth[adjVert] <= vertDepth[root]) continue;
                if (closeVert[closeVertItr] == null) {
                    closeVert[closeVertItr] = new GraphDistance();
                }
                closeVert[closeVertItr].setDistance(currDist);
                closeVert[closeVertItr].setVertex(adjVert);
                if (++closeVertItr != numOfCloseVert) continue;
                closeVertDone = true;
            }
            if (vertQ.size() <= 0) break;
            vert = vertQ.dequeue();
            currDist = vertQ.dequeue() + 1;
        } while ((!closeVertDone || bottomNbrsLayer <= vertDepth[root]) && vertQ.size() >= 0);
        vertQ.freeQueue();
        return closeVert;
    }

    private static void DEBUG(String s) {
        if (DEBUG_MODE) {
            System.out.println(s);
        }
    }

    public GraphDistance[] nbr_dijkstra(GraphComponentInterface graphComponent, int root, GraphDistance[][][] nbrs, int[] nbr, int[] vertDepth) {
        int[] color = new int[graphComponent.getNumberNodes()];
        PQueue vertQ = new PQueue(graphComponent.getNumberNodes());
        int bottomNbrsLayer = 0;
        int[] nbrCounter = new int[vertDepth[root] + 1];
        int numOfCloseVert = 3;
        int closeVertItr = 0;
        boolean closeVertDone = false;
        GraphDistance[] closeVert = new GraphDistance[numOfCloseVert];
        nbrs[root] = new GraphDistance[vertDepth[root] + 2][];
        for (int i = 0; i <= vertDepth[root]; ++i) {
            nbrs[root][i] = new GraphDistance[nbr[i]];
            nbrCounter[i] = 0;
        }
        for (int count = 0; count < graphComponent.getNumberNodes(); ++count) {
            color[count] = 0;
        }
        vertQ.enqueue(root, 0.0);
        GraphDistance gd = new GraphDistance();
        while (!(vertQ.getCount() <= 0 || closeVertDone && bottomNbrsLayer > vertDepth[root])) {
            int vert = vertQ.dequeueMin(gd);
            if (color[vert] == 1) continue;
            if (vert != root) {
                for (int i = bottomNbrsLayer; i <= Math.min(vertDepth[vert], vertDepth[root]); ++i) {
                    if (nbrCounter[i] < nbr[i]) {
                        if (nbrs[root][i][nbrCounter[i]] == null) {
                            nbrs[root][i][nbrCounter[i]] = new GraphDistance();
                        }
                        nbrs[root][i][nbrCounter[i]].setVertex(vert);
                        nbrs[root][i][nbrCounter[i]].setDistance(gd.getDistance());
                        int n = i;
                        nbrCounter[n] = nbrCounter[n] + 1;
                        continue;
                    }
                    bottomNbrsLayer = i + 1;
                }
                if (!closeVertDone && vertDepth[vert] > vertDepth[root]) {
                    if (closeVert[closeVertItr] == null) {
                        closeVert[closeVertItr] = new GraphDistance();
                    }
                    closeVert[closeVertItr].setDistance(gd.getDistance());
                    closeVert[closeVertItr].setVertex(vert);
                    if (++closeVertItr == numOfCloseVert) {
                        closeVertDone = true;
                    }
                }
            }
            color[vert] = 1;
            int deg = graphComponent.getDegree(vert);
            for (int count = 0; count < deg; ++count) {
                int adjVert = graphComponent.getAdjacentVertex(vert, count);
                if (adjVert < 0 || color[adjVert] == 1) continue;
                double distVertToNbr = graphComponent.getLinkWeight(vert, count);
                vertQ.enqueue(adjVert, distVertToNbr + gd.getDistance());
            }
        }
        vertQ.freeQueue();
        return closeVert;
    }

    public MISF createMISF(GraphComponentInterface graphComponent, boolean useRandom, int numOfInitialVertices, boolean skipFiltration, int[] vertDepth) {
        int numOfVert = graphComponent.getNumberNodes();
        int log2n = (int)(Math.log(numOfVert) / Math.log(2.0)) + 2;
        int[] misf = new int[numOfVert];
        MISF result = new MISF();
        for (int count = 0; count < numOfVert; ++count) {
            misf[count] = count;
            vertDepth[count] = 0;
        }
        this.diam = (int)Math.sqrt(numOfVert);
        if (skipFiltration) {
            result.setDepth(1);
            result.setSize(new int[]{numOfVert});
            result.setFilterList(misf);
            return result;
        }
        this.orderByDegree(graphComponent, misf, numOfVert);
        int[] misfSize = new int[log2n];
        misfSize[0] = graphComponent.getNumberNodes();
        for (int level = 1; level < log2n; ++level) {
            int prev_misfSize = misfSize[level - 1];
            int[] marked = null;
            marked = useRandom ? this.randomBFS(misf, prev_misfSize) : this.createBFS(graphComponent, misf, prev_misfSize, level, vertDepth);
            misfSize[level] = marked[0];
            int misfIndex = 0;
            for (int markedIndex = 1; misfIndex <= misfSize[level - 1] && markedIndex < marked.length; ++markedIndex) {
                if (marked[markedIndex] != 1) continue;
                vertDepth[misf[markedIndex - 1]] = level;
                int temp = misf[misfIndex];
                misf[misfIndex] = misf[markedIndex - 1];
                misf[markedIndex - 1] = temp;
                ++misfIndex;
            }
            if (misfSize[level] >= numOfInitialVertices + 1) continue;
            for (int count = misfSize[level]; count < numOfInitialVertices; ++count) {
                vertDepth[misf[count]] = level;
            }
            misfSize[level] = numOfInitialVertices;
            log2n = level + 1;
        }
        if (misfSize[log2n - 1] > numOfInitialVertices) {
            for (int count = numOfInitialVertices; count < misfSize[log2n - 1]; ++count) {
                vertDepth[misf[count]] = log2n - 2;
                int n = log2n - 2;
                misfSize[n] = misfSize[n] + 1;
            }
            misfSize[log2n - 1] = numOfInitialVertices;
        }
        result.setDepth(log2n);
        result.setSize(misfSize);
        result.setFilterList(misf);
        return result;
    }

    private void orderByDegree(GraphComponentInterface graphComponent, int[] misf, int numOfVert) {
        int position;
        int degree;
        int vert;
        int index;
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (int vert2 = 0; vert2 < numOfVert; ++vert2) {
            int d = graphComponent.getDegree(vert2);
            min = Math.min(min, d);
            max = Math.max(max, d);
        }
        int[] offset = new int[max + 1];
        int[] degreeProcessed = new int[max + 1];
        int[] numDegree = new int[max + 1];
        for (index = 0; index <= max; ++index) {
            numDegree[index] = 0;
            degreeProcessed[index] = 0;
        }
        for (vert = 0; vert < numOfVert; ++vert) {
            int n = graphComponent.getDegree(vert);
            numDegree[n] = numDegree[n] + 1;
        }
        offset[0] = 0;
        offset[1] = 0;
        for (index = 2; index <= max; ++index) {
            offset[index] = offset[index - 1] + numDegree[index - 1];
        }
        offset[0] = offset[max] + numDegree[max];
        vert = 0;
        while (vert < numOfVert) {
            degree = graphComponent.getDegree(vert);
            position = offset[degree] + degreeProcessed[degree];
            misf[position] = vert++;
            int n = degree;
            degreeProcessed[n] = degreeProcessed[n] + 1;
        }
        int i = 0;
        while (i < numOfVert) {
            degree = graphComponent.getDegree(i);
            position = numOfVert - offset[degree] - degreeProcessed[degree];
            misf[position] = i++;
            int n = degree;
            degreeProcessed[n] = degreeProcessed[n] - 1;
        }
    }

    private GraphComponentAttrs[] initializeGraphComponents(GraphComponent[] graphComponents, int numComponents, int _numOfInitVert, boolean displayPar, boolean randBFS, int initRounds, int finalRounds, double bounds) {
        double edge = this.getEdgeLength();
        GraphComponentAttrs[] result = new GraphComponentAttrs[numComponents];
        int numOfInitVert = 3;
        for (int currComponent = 0; currComponent < numComponents; ++currComponent) {
            GraphComponent graph = graphComponents[currComponent];
            int numOfVert = graph.getNumberNodes();
            double tInit = this.initTemperature > 0.0 ? this.initTemperature : edge / 6.0;
            numOfInitVert = Math.min(numOfInitVert, _numOfInitVert);
            int[] vertDepth = new int[numOfVert];
            boolean skipFilteration = false;
            if (numOfVert < 3) {
                skipFilteration = true;
            }
            MISF misf = this.createMISF(graph, randBFS, numOfInitVert, skipFilteration, vertDepth);
            GRIPLayout.DEBUG("MISF for graph " + currComponent + " = " + misf);
            int d = graph.getDiameter() == 0 ? this.diam : graph.getDiameter();
            Point[] pos = new Point[numOfVert];
            for (int i = 0; i < numOfVert; ++i) {
                pos[i] = this.getRandomPoint(bounds);
            }
            if (numOfVert == 1 || numOfVert == 2) {
                pos[0].setValue(0.0, 0.0);
                if (numOfVert == 2) {
                    pos[1].setX(pos[0].getX() + edge);
                }
            }
            GraphComponentAttrs gca = new GraphComponentAttrs(misf, d, edge, misf.getDepth() - 1, numOfInitVert, displayPar, false, true, 0, initRounds, finalRounds, true, numOfVert, tInit, pos);
            gca.setVertDepth(vertDepth);
            gca.setFRLevels(1);
            gca.setFullFR(numOfVert < LARGE_N_NODE);
            int[] nbr = this.setNBRSize(numOfVert, graph, misf.getDepth(), misf.getSize(), numOfInitVert);
            gca.setNbr(nbr);
            result[currComponent] = gca;
        }
        return result;
    }

    private double getEdgeLength() {
        if (this.preferredEdgeLength > 0.0) {
            return this.preferredEdgeLength;
        }
        int totalNNodes = this.graphInfo.getNumberNodes();
        if (this.graphInfo.getErrorNodeCount() == 0) {
            return Math.ceil(this.graphInfo.getMaximumNodeSize() * 2.0) * 1.2;
        }
        return Math.ceil(this.graphInfo.getMaximumNodeSize() * 2.0);
    }

    private int[] setNBRSize(int numOfVert, GraphComponent graph, int misfDepth, int[] misfSize, int numOfInitVert) {
        int itr;
        double avgDeg = 0.0;
        int maxCxty = 0;
        int initCxty = 10000;
        int smallLevel = 0;
        for (int vert = 0; vert < numOfVert; ++vert) {
            avgDeg += (double)graph.getDegree(vert);
        }
        maxCxty = (int)avgDeg;
        if (maxCxty < initCxty) {
            maxCxty = initCxty;
        }
        avgDeg /= (double)numOfVert;
        for (itr = 0; itr < misfDepth && misfSize[itr] > 0; ++itr) {
            if (!((double)misfSize[itr] * (double)misfSize[itr] - (double)initCxty <= 0.0)) continue;
            smallLevel = itr;
            break;
        }
        int[] nbr = new int[misfDepth];
        for (itr = 0; itr < misfDepth && misfSize[itr] > 0; ++itr) {
            nbr[itr] = itr >= smallLevel ? Math.max(misfSize[itr] - 1, numOfInitVert - 1) : (int)Math.min(this.sched(itr, 0, 2, 10000, 1) * (double)maxCxty / (double)misfSize[itr], (double)(misfSize[itr] - 1));
        }
        nbr[0] = Math.min(2 * nbr[0], numOfVert - 1);
        return nbr;
    }

    double sched(int x, int max, int maxVal, int min, int minVal) {
        if (x <= max) {
            return maxVal;
        }
        if (max <= x && x <= min) {
            return (double)(minVal - maxVal) / (double)(min - max) * (double)(x - max) + (double)maxVal;
        }
        return minVal;
    }

    int sched3(int x, int max, int maxVal, int min, int minVal) {
        if (x <= max) {
            return maxVal;
        }
        if (max <= x && x <= min) {
            double k = -Math.log((double)minVal / (double)maxVal) / (double)min;
            return (int)Math.ceil((double)maxVal * Math.exp(-k * (double)x));
        }
        return minVal;
    }

    private void misfEngine(GraphComponent gc, GraphComponentAttrs gca, double bounds) {
        if (gc.getNumberNodes() < 3) {
            return;
        }
        boolean loop = true;
        GRIPLayout.DEBUG("misfEngine(): roundsCtr=" + gca.getRoundsCtr() + " rounds=" + gca.getRounds());
        int numOfVert = gc.getNumberNodes();
        int[] misf = gca.getMisf().getFilterList();
        double tInit = gca.getInitialTemperature();
        int roundsCtr = gca.getRoundsCtr();
        int currLevel = gca.getCurrLevel();
        int rounds = gca.getRounds();
        int finalRounds = gca.getFinalRounds();
        boolean displayPar = gca.isDisplayPar();
        int FRLevels = gca.getFRLevels();
        boolean FRFull = gca.isFullFR();
        int[] misfSize = gca.getMisf().getSize();
        int misfDepth = gca.getMisf().getDepth();
        int numOfInitVert = gca.getNumOfInitVert();
        long dTime = 0L;
        long reInitTime = 0L;
        long refineTime = 0L;
        long springKKTime = 0L;
        while (currLevel >= 0) {
            int currVert;
            GRIPLayout.DEBUG("DrawGraph: current level is " + currLevel + " with size " + misfSize[currLevel]);
            if (displayPar) {
                loop = false;
            }
            GraphDistance[] closeVert = null;
            int itr = misfSize[currLevel];
            if (currLevel == misfDepth - 1 && gca.getFirstRound()) {
                int i;
                Point baricenter = new Point(0.0, 0.0);
                gca.setFirstRound(false);
                for (i = 0; i < numOfInitVert; ++i) {
                    currVert = misf[i];
                    gca.getPosition()[currVert].setValue(this.getRandomPoint(bounds));
                    long t1 = System.currentTimeMillis();
                    closeVert = this.nbr_dijkstra(gc, currVert, gca.getNbrs(), gca.getNbr(), gca.getVertDepth());
                    long t2 = System.currentTimeMillis();
                    dTime += t2 - t1;
                }
                for (i = 0; i < itr; ++i) {
                    baricenter.add(gca.getPosition()[misf[i]], baricenter);
                }
                baricenter.divide(3.0, baricenter);
                for (i = 0; i < itr; ++i) {
                    gca.getPosition()[misf[i]].subtract(baricenter, gca.getPosition()[misf[i]]);
                }
            }
            long t1 = System.currentTimeMillis();
            if (roundsCtr == rounds) {
                for (int i = 0; i < itr; ++i) {
                    gca.getNbrs()[misf[i]][currLevel] = null;
                }
                --currLevel;
                if (itr == numOfVert) break;
                roundsCtr = 0;
                rounds = this.sched3(misfSize[currLevel], 0, gca.getRounds(), numOfVert, finalRounds);
                for (int vert = 0; vert < itr; ++vert) {
                    gca.getHeat()[misf[vert]] = tInit;
                }
                while (itr < misfSize[currLevel]) {
                    currVert = misf[itr];
                    closeVert = this.nbr_dijkstra(gc, currVert, gca.getNbrs(), gca.getNbr(), gca.getVertDepth());
                    gca.getPosition()[currVert].setValue(gca.getPosition()[closeVert[0].getVertex()]);
                    gca.getPosition()[currVert].add(gca.getPosition()[closeVert[1].getVertex()], gca.getPosition()[currVert]);
                    gca.getPosition()[currVert].add(gca.getPosition()[closeVert[2].getVertex()], gca.getPosition()[currVert]);
                    gca.getPosition()[currVert].divide(3.0, gca.getPosition()[currVert]);
                    gca.getOldDisplacement()[currVert].add(gca.getOldDisplacement()[closeVert[0].getVertex()], gca.getOldDisplacement()[currVert]);
                    gca.getOldDisplacement()[currVert].add(gca.getOldDisplacement()[closeVert[1].getVertex()], gca.getOldDisplacement()[currVert]);
                    gca.getOldDisplacement()[currVert].add(gca.getOldDisplacement()[closeVert[2].getVertex()], gca.getOldDisplacement()[currVert]);
                    gca.getOldDisplacement()[currVert].divide(3.0, gca.getOldDisplacement()[currVert]);
                    gca.getOldDisplacementNorm()[currVert] = gca.getOldDisplacement()[currVert].distance(null);
                    int count = 0;
                    while (count++ < 3) {
                        this.springKKLocal(currVert, gca, closeVert, 3);
                        this.updateLocalTemp(currVert, gca);
                        gca.getOldDisplacement()[currVert].setValue(gca.getDisplacement()[currVert]);
                        gca.getOldDisplacementNorm()[currVert] = gca.getDisplacementNorm()[currVert];
                        gca.getDisplacement()[currVert].multiply(gca.getHeat()[currVert], gca.getDisplacement()[currVert]);
                        if (gca.getDisplacementNorm()[currVert] != 0.0) {
                            gca.getDisplacement()[currVert].divide(gca.getDisplacementNorm()[currVert], gca.getDisplacement()[currVert]);
                        }
                        gca.getPosition()[currVert].add(gca.getDisplacement()[currVert], gca.getPosition()[currVert]);
                    }
                    ++itr;
                }
            }
            long t2 = System.currentTimeMillis();
            reInitTime += t2 - t1;
            t1 = System.currentTimeMillis();
            if (roundsCtr++ < rounds) {
                int i;
                for (i = 0; i < itr; ++i) {
                    long ta = System.currentTimeMillis();
                    if (currLevel < FRLevels) {
                        if (this.nodeSizeIgnored) {
                            if (FRFull) {
                                this.springFullFR(misf[i], gc, gca);
                            } else {
                                this.springFR(misf[i], gca.getNbrs()[misf[i]][currLevel], currLevel, gc, gca);
                            }
                        } else if (FRFull) {
                            this.springFullFRWithNodeSize(misf[i], gc, gca);
                        } else {
                            this.springFR(misf[i], gca.getNbrs()[misf[i]][currLevel], currLevel, gc, gca);
                        }
                    } else {
                        this.springKK(misf[i], gca.getNbrs()[misf[i]][currLevel], currLevel, gca);
                    }
                    long tb = System.currentTimeMillis();
                    springKKTime += tb - ta;
                    this.updateLocalTemp(misf[i], gca);
                    gca.getOldDisplacement()[misf[i]].setValue(gca.getDisplacement()[misf[i]]);
                    gca.getOldDisplacementNorm()[misf[i]] = gca.getDisplacementNorm()[misf[i]];
                    gca.getDisplacement()[misf[i]].multiply(gca.getHeat()[misf[i]], gca.getDisplacement()[misf[i]]);
                    if (gca.getDisplacementNorm()[misf[i]] == 0.0) continue;
                    gca.getDisplacement()[misf[i]].divide(gca.getDisplacementNorm()[misf[i]], gca.getDisplacement()[misf[i]]);
                }
                for (i = 0; i < itr; ++i) {
                    gca.getPosition()[misf[i]].add(gca.getDisplacement()[misf[i]], gca.getPosition()[misf[i]]);
                }
                if (!this.fixedFinalRounds && currLevel < FRLevels && roundsCtr == rounds && this.getNumberOfOverlaps(gc, gca) >= 1 && (rounds += this.finalRoundIncrement) > this.maxFinalRounds) {
                    this.repellingFactor *= 2.0;
                    rounds = finalRounds;
                    roundsCtr = 0;
                    if (this.repellingFactor > 1.0) break;
                }
            }
            t2 = System.currentTimeMillis();
            refineTime += t2 - t1;
        }
        boolean createList = false;
        if (loop && gca.isCreateListSwitch()) {
            createList = true;
            gca.setCreateListSwitch(false);
        }
        gca.setCurrLevel(currLevel);
        gca.setCreateList(gca.isCreateList() || createList);
        gca.setRoundsCtr(roundsCtr);
        gca.setRounds(rounds);
    }

    private void updateLocalTemp(int vert, float r, float s, GraphComponentAttrs gca) {
        double temp = gca.getHeat()[vert];
        double normOldDisp = gca.getOldDisplacementNorm()[vert];
        double normNewDisp = gca.getDisplacementNorm()[vert];
        if (normOldDisp != 0.0 && normNewDisp != 0.0) {
            double scalProd = gca.getDisplacement()[vert].scalarProduct(gca.getOldDisplacement()[vert]);
            double cos = scalProd / (normOldDisp * normNewDisp);
            temp = gca.getOldCos()[vert] * cos > 0.0 ? (temp += temp * (double)s * cos * (double)r) : (temp += temp * cos * (double)r);
            gca.getOldCos()[vert] = cos;
            gca.getHeat()[vert] = temp;
        }
        GRIPLayout.DEBUG("Heat[" + vert + "]=" + temp);
    }

    private void updateLocalTemp(int vert, GraphComponentAttrs gca) {
        double temp = gca.getHeat()[vert];
        double normOldDisp = gca.getOldDisplacementNorm()[vert];
        double normNewDisp = gca.getDisplacementNorm()[vert];
        if (normOldDisp != 0.0 && normNewDisp != 0.0) {
            double scalProd = gca.getDisplacement()[vert].scalarProduct(gca.getOldDisplacement()[vert]);
            double cos = scalProd / (normOldDisp * normNewDisp);
            double r = 0.15;
            double s = 3.0;
            temp = gca.getOldCos()[vert] * cos > 0.0 ? (temp += temp * s * cos * r) : (temp += temp * cos * r);
            gca.getOldCos()[vert] = cos;
            gca.getHeat()[vert] = temp;
        }
        GRIPLayout.DEBUG("Heat[" + vert + "]=" + temp);
    }

    private void springFullFR(int vert, GraphComponent graph, GraphComponentAttrs gca) {
        double norm2;
        int otherVertex;
        Point[] disp = gca.getDisplacement();
        disp[vert].setValue(0.0, 0.0);
        Point vect = new Point(0.0, 0.0);
        double edge = gca.getEdgeLength();
        double fedge2 = this.repellingFactor * edge * edge;
        Point displacement = gca.getDisplacement()[vert];
        int degree = graph.getDegree(vert);
        for (int adjVert = 0; adjVert < degree; ++adjVert) {
            otherVertex = graph.getAdjacentVertex(vert, adjVert);
            if (otherVertex < 0) continue;
            vect.setValue(0.0, 0.0);
            vect.add(gca.getPosition()[otherVertex], vect);
            vect.subtract(gca.getPosition()[vert], vect);
            double weight = graph.getLinkWeight(vert, adjVert);
            norm2 = vect.distanceSq(0.0, 0.0);
            vect.multiply(norm2 / (edge * edge * weight * weight), vect);
            displacement.add(vect, displacement);
        }
        int numOfVert = graph.getNumberNodes();
        for (int i = 0; i < numOfVert; ++i) {
            if (i == vert) continue;
            otherVertex = i;
            vect.setValue(0.0, 0.0);
            vect.add(gca.getPosition()[vert], vect);
            vect.subtract(gca.getPosition()[otherVertex], vect);
            double weight = this.isAdjacentVertex(graph, vert, otherVertex) ? graph.getLinkWeight(vert, otherVertex) : 1.0;
            norm2 = vect.distanceSq(0.0, 0.0);
            if (norm2 == 0.0) {
                int x = this.random.nextInt() % 2;
                int y = this.random.nextInt() % 2;
                norm2 = this.zeroDistance;
                vect.setValue(x, y);
            }
            double deg = (graph.getDegree(vert) + 1) * (graph.getDegree(otherVertex) + 1);
            vect.multiply(deg * fedge2 * weight * weight / norm2, vect);
            displacement.add(vect, displacement);
        }
        double norm = displacement.distance(0.0, 0.0);
        int intNorm = 0;
        intNorm = norm > 0.0 ? (int)Math.floor(norm + 0.5) : -((int)Math.floor(0.5 - norm));
        gca.getDisplacementNorm()[vert] = intNorm;
        if (gca.getDisplacementNorm()[vert] != 0.0) {
            displacement.multiply(edge / norm, displacement);
            gca.getDisplacementNorm()[vert] = displacement.distance(0.0, 0.0);
        }
    }

    private void springFR(int vert, GraphDistance[] vertNbrs, int misfLayer, GraphComponent graph, GraphComponentAttrs gca) {
        double _norm2;
        int overt;
        double edge = gca.getEdgeLength();
        double fedge2 = 0.03 * edge * edge;
        Point vect = new Point();
        gca.getDisplacement()[vert].setValue(0.0, 0.0);
        int deg = graph.getDegree(vert);
        for (int adjVert = 0; adjVert < deg; ++adjVert) {
            overt = graph.getAdjacentVertex(vert, adjVert);
            if (overt >= 0 && gca.getNbrs()[overt] == null) continue;
            vect.setValue(0.0, 0.0);
            vect.add(gca.getPosition()[overt], vect);
            vect.subtract(gca.getPosition()[vert], vect);
            _norm2 = vect.distanceSq(0.0, 0.0);
            vect.multiply(_norm2 / (edge * edge), vect);
            gca.getDisplacement()[vert].add(vect, gca.getDisplacement()[vert]);
        }
        int[] nbr = gca.getNbr();
        for (int i = 0; i < nbr[misfLayer]; ++i) {
            overt = vertNbrs[i].getVertex();
            vect.setValue(0.0, 0.0);
            vect.add(gca.getPosition()[vert], vect);
            vect.subtract(gca.getPosition()[overt], vect);
            _norm2 = vect.distanceSq(0.0, 0.0);
            if (_norm2 == 0.0) {
                int x = this.random.nextInt() % 2;
                int y = this.random.nextInt() % 2;
                _norm2 = 0.01;
                vect.setValue(x, y);
            }
            vect.multiply(fedge2 / _norm2, vect);
            gca.getDisplacement()[vert].add(vect, gca.getDisplacement()[vert]);
        }
        double _norm = gca.getDisplacement()[vert].distance(0.0, 0.0);
        int intNorm = 0;
        intNorm = _norm > 0.0 ? (int)Math.floor(_norm + 0.5) : -((int)Math.floor(0.5 - _norm));
        gca.getDisplacementNorm()[vert] = intNorm;
        GRIPLayout.DEBUG("dispNorm[" + vert + "]=" + gca.getDisplacementNorm()[vert]);
        if (gca.getDisplacementNorm()[vert] != 0.0) {
            gca.getDisplacement()[vert].multiply(edge / _norm, gca.getDisplacement()[vert]);
            gca.getDisplacementNorm()[vert] = gca.getDisplacement()[vert].distance(0.0, 0.0);
        }
        GRIPLayout.DEBUG("dispNorm[" + vert + "]=" + gca.getDisplacementNorm()[vert]);
        GRIPLayout.DEBUG("Leaving FR_spring()");
    }

    private void springFullFRWithNodeSize(int vert, GraphComponent graph, GraphComponentAttrs gca) {
        int otherVertex;
        Point[] disp = gca.getDisplacement();
        disp[vert].setValue(0.0, 0.0);
        Point vect = new Point(0.0, 0.0);
        double edge = gca.getEdgeLength();
        double fedge2 = this.repellingFactor * edge * edge;
        Point displacement = gca.getDisplacement()[vert];
        int degree = graph.getDegree(vert);
        for (int adjVert = 0; adjVert < degree; ++adjVert) {
            double fa;
            otherVertex = graph.getAdjacentVertex(vert, adjVert);
            if (otherVertex < 0) continue;
            vect.setValue(0.0, 0.0);
            vect.add(gca.getPosition()[otherVertex], vect);
            vect.subtract(gca.getPosition()[vert], vect);
            double weight = graph.getLinkWeight(vert, adjVert);
            double distCnt = vect.distance(0.0, 0.0);
            double nodeSize = graph.getNodeSize(vert) + graph.getNodeSize(otherVertex);
            double dist = distCnt - nodeSize;
            if (dist <= 0.0) {
                fa = 0.0;
            } else {
                vect.divide(distCnt, vect);
                fa = dist * dist * dist / (edge * edge * weight * weight);
            }
            vect.multiply(fa, vect);
            displacement.add(vect, displacement);
        }
        int numOfVert = graph.getNumberNodes();
        for (int i = 0; i < numOfVert; ++i) {
            if (i == vert) continue;
            otherVertex = i;
            vect.setValue(0.0, 0.0);
            vect.add(gca.getPosition()[vert], vect);
            vect.subtract(gca.getPosition()[otherVertex], vect);
            double weight = this.isAdjacentVertex(graph, vert, otherVertex) ? graph.getLinkWeight(vert, otherVertex) : 1.0;
            double distCnt = vect.distance(0.0, 0.0);
            if (distCnt == 0.0) {
                int x = this.random.nextInt() % 2;
                int y = this.random.nextInt() % 2;
                vect.setValue(x, y);
            } else {
                vect.divide(distCnt, vect);
            }
            double deg = (graph.getDegree(vert) + 1) * (graph.getDegree(otherVertex) + 1);
            double nodeSize = graph.getNodeSize(vert) + graph.getNodeSize(otherVertex);
            double dist = distCnt - nodeSize;
            if (dist <= 0.0) {
                dist = this.zeroDistance;
                if (distCnt < nodeSize * 0.5) {
                    dist *= 0.1;
                }
            }
            double fr = deg * fedge2 * weight * weight / dist;
            vect.multiply(fr, vect);
            displacement.add(vect, displacement);
        }
        double norm = displacement.distance(0.0, 0.0);
        int intNorm = 0;
        intNorm = norm > 0.0 ? (int)Math.floor(norm + 0.5) : -((int)Math.floor(0.5 - norm));
        gca.getDisplacementNorm()[vert] = intNorm;
        if (gca.getDisplacementNorm()[vert] != 0.0) {
            displacement.multiply(edge / norm, displacement);
            gca.getDisplacementNorm()[vert] = displacement.distance(0.0, 0.0);
        }
    }

    private void springForceAtlas(int vert, GraphComponent graph, GraphComponentAttrs gca) {
        int otherVertex;
        Point[] disp = gca.getDisplacement();
        disp[vert].setValue(0.0, 0.0);
        Point vect = new Point(0.0, 0.0);
        double edge = gca.getEdgeLength();
        Point displacement = gca.getDisplacement()[vert];
        int degree = graph.getDegree(vert);
        for (int adjVert = 0; adjVert < degree; ++adjVert) {
            double fa;
            otherVertex = graph.getAdjacentVertex(vert, adjVert);
            if (otherVertex < 0) continue;
            vect.setValue(0.0, 0.0);
            vect.add(gca.getPosition()[otherVertex], vect);
            vect.subtract(gca.getPosition()[vert], vect);
            double distCnt = vect.distance(0.0, 0.0);
            double dist = distCnt - graph.getNodeSize(vert) - graph.getNodeSize(otherVertex);
            if (dist <= 0.0) {
                fa = 0.0;
            } else {
                vect.divide(distCnt, vect);
                fa = dist;
            }
            vect.multiply(fa, vect);
            displacement.add(vect, displacement);
        }
        int numOfVert = graph.getNumberNodes();
        for (int i = 0; i < numOfVert; ++i) {
            double fr;
            if (i == vert) continue;
            otherVertex = i;
            vect.setValue(0.0, 0.0);
            vect.add(gca.getPosition()[vert], vect);
            vect.subtract(gca.getPosition()[otherVertex], vect);
            double distCnt = vect.distance(0.0, 0.0);
            if (distCnt == 0.0) {
                int x = this.random.nextInt() % 2;
                int y = this.random.nextInt() % 2;
                vect.setValue(x, y);
            } else {
                vect.divide(distCnt, vect);
            }
            double deg = (graph.getDegree(vert) + 1) * (graph.getDegree(otherVertex) + 1);
            double nodeSize = graph.getNodeSize(vert) + graph.getNodeSize(otherVertex);
            double dist = distCnt - nodeSize;
            if (dist <= 0.0) {
                dist = this.zeroDistance * 0.01;
                if (distCnt < nodeSize * 0.5) {
                    dist *= 0.1;
                }
                fr = 100.0 * deg;
            } else {
                fr = 100.0 * deg / dist;
            }
            vect.multiply(fr, vect);
            displacement.add(vect, displacement);
        }
        double norm = displacement.distance(0.0, 0.0);
        int intNorm = 0;
        intNorm = norm > 0.0 ? (int)Math.floor(norm + 0.5) : -((int)Math.floor(0.5 - norm));
        gca.getDisplacementNorm()[vert] = norm;
        if (gca.getDisplacementNorm()[vert] != 0.0) {
            displacement.multiply(edge / norm, displacement);
            gca.getDisplacementNorm()[vert] = displacement.distance(0.0, 0.0);
        }
    }

    void springKK(int vert, GraphDistance[] vertNbrs, int misfLayer, GraphComponentAttrs gca) {
        GRIPLayout.DEBUG("Entering KK_spring()\n");
        gca.getDisplacement()[vert].setValue(0.0, 0.0);
        double edge = gca.getEdgeLength();
        for (int i = 0; i < gca.getNbr()[misfLayer]; ++i) {
            if (vertNbrs == null || vertNbrs[i] == null) continue;
            int overt = vertNbrs[i].getVertex();
            double dist2 = vertNbrs[i].getDistance() * vertNbrs[i].getDistance();
            if (dist2 == 0.0) continue;
            Point vect = new Point();
            vect.add(gca.getPosition()[overt], vect);
            vect.subtract(gca.getPosition()[vert], vect);
            double _norm2 = vect.distanceSq(0.0, 0.0);
            vect.multiply(_norm2 / (dist2 * edge * edge) - 1.0, vect);
            gca.getDisplacement()[vert].add(vect, gca.getDisplacement()[vert]);
        }
        double _norm = gca.getDisplacement()[vert].distance(0.0, 0.0);
        int intNorm = 0;
        intNorm = _norm > 0.0 ? (int)Math.floor(_norm + 0.5) : -((int)Math.floor(0.5 - _norm));
        gca.getDisplacementNorm()[vert] = intNorm;
        if (intNorm != 0) {
            gca.getDisplacement()[vert].multiply(gca.getEdgeLength() / _norm, gca.getDisplacement()[vert]);
            gca.getDisplacementNorm()[vert] = gca.getDisplacement()[vert].distance(0.0, 0.0);
        }
        GRIPLayout.DEBUG("Leaving KK_spring()");
    }

    void springKKLocal(int vert, GraphComponentAttrs gca, GraphDistance[] closeVert, int size) {
        GRIPLayout.DEBUG("Entering KK_spring_local()");
        gca.getDisplacement()[vert].setValue(0.0, 0.0);
        double edge = gca.getEdgeLength();
        Point vect = new Point();
        for (int i = 0; i < size; ++i) {
            vect.setValue(0.0, 0.0);
            GRIPLayout.DEBUG("looking at close vert " + closeVert[i].getVertex() + " with dist " + closeVert[i].getDistance());
            gca.getPosition()[closeVert[i].getVertex()].subtract(gca.getPosition()[vert], vect);
            double _norm2 = vect.distanceSq(0.0, 0.0);
            vect.multiply(_norm2 / (closeVert[i].getDistance() * closeVert[i].getDistance() * edge * edge) - 1.0, vect);
            gca.getDisplacement()[vert].add(vect, gca.getDisplacement()[vert]);
        }
        gca.getDisplacementNorm()[vert] = gca.getDisplacement()[vert].distance(0.0, 0.0);
        GRIPLayout.DEBUG("Leaving KK_spring_local()");
    }

    public GraphComponentInterface[] getComponents() {
        return this.components;
    }

    public void setComponents(GraphComponentInterface[] components) {
        this.components = components;
    }

    public GraphComponentAttrs[] getGca() {
        return this.gca;
    }

    public void setGca(GraphComponentAttrs[] gca) {
        this.gca = gca;
    }

    private void adjustComponentPositions(GraphComponent[] gc, GraphComponentAttrs[] gca) {
        int nComponents = gca.length;
        int[] sortedComponentIndex = this.sortComponentsByDiameter(gca);
        Point[] componentOffset = new Point[nComponents];
        for (int i = 0; i < nComponents; ++i) {
            componentOffset[i] = new Point();
        }
        int centerRadius = (int)Math.round((double)(gca[sortedComponentIndex[0]].getDiameter() + 1) / 2.0);
        boolean axis = true;
        boolean posDir = true;
        int lastMax = 0;
        double lastCoord = 0.0;
        for (int counter = 1; counter < nComponents; ++counter) {
            GraphComponentAttrs oneGCA = gca[sortedComponentIndex[counter]];
            int diam = oneGCA.getDiameter();
            if (diam > lastMax) {
                lastMax = diam;
            }
            lastCoord = posDir ? (lastCoord += (double)Math.round((double)(diam + 1) / 2.0)) : (lastCoord -= (double)Math.round((double)(diam + 1) / 2.0));
            double edge = oneGCA.getEdgeLength();
            if (!axis) {
                componentOffset[sortedComponentIndex[counter]].setValue(lastCoord * edge, (double)centerRadius * edge);
            } else if (axis) {
                componentOffset[sortedComponentIndex[counter]].setValue((double)centerRadius * edge, lastCoord * edge);
            }
            if (posDir) {
                if ((double)centerRadius > 0.0) {
                    axis = false;
                    posDir = false;
                    lastCoord = 0.0;
                    continue;
                }
                centerRadius *= -1;
                axis = true;
                posDir = true;
                lastCoord = 0.0;
                centerRadius += lastMax > 1 ? lastMax + 2 : lastMax;
                lastMax = 0;
                continue;
            }
            if (centerRadius > 0) {
                centerRadius *= -1;
                axis = false;
                posDir = false;
                lastCoord = 0.0;
                continue;
            }
            axis = false;
            posDir = true;
            lastCoord = 0.0;
        }
        for (int i = 1; i < nComponents; ++i) {
            Point[] pos = gca[sortedComponentIndex[i]].getPosition();
            for (int j = 0; j < pos.length; ++j) {
                pos[j].add(componentOffset[sortedComponentIndex[i]], pos[j]);
            }
        }
    }

    private int[] sortComponentsByDiameter(GraphComponentAttrs[] gc) {
        int i;
        int nComponents = gc.length;
        int maxDiameter = 0;
        for (int i2 = 0; i2 < gc.length; ++i2) {
            maxDiameter = Math.max(maxDiameter, gc[i2].getDiameter());
        }
        int[] sortedComponents = new int[nComponents];
        int[] diameterCount = new int[maxDiameter + 1];
        int[] componentProcessed = new int[maxDiameter + 1];
        int[] offset = new int[maxDiameter + 1];
        for (i = 1; i <= maxDiameter; ++i) {
            diameterCount[i] = 0;
            componentProcessed[i] = 0;
        }
        for (i = 0; i < nComponents; ++i) {
            int n = gc[i].getDiameter();
            diameterCount[n] = diameterCount[n] + 1;
        }
        offset[maxDiameter] = 0;
        for (i = maxDiameter - 1; i >= 1; --i) {
            offset[i] = offset[i + 1] + diameterCount[i + 1];
        }
        i = 0;
        while (i < nComponents) {
            int diameter = gc[i].getDiameter();
            sortedComponents[offset[diameter] + componentProcessed[diameter]] = i++;
            int n = diameter;
            componentProcessed[n] = componentProcessed[n] + 1;
        }
        return sortedComponents;
    }

    public void updateModelPositions() {
        for (int i = 0; i < this.gca.length; ++i) {
            Point[] pos = this.gca[i].getPosition();
            int[] vertexList = ((GraphComponent)this.components[i]).getVertexList();
            for (int j = 0; j < pos.length; ++j) {
                NodeLayoutInterface n = (NodeLayoutInterface)this.model.getAllLayoutNodes().get(vertexList[j]);
                int x = (int)pos[j].getX();
                int y = (int)pos[j].getY();
                n.setCenterLocation(new java.awt.Point(x, y));
            }
        }
        this.postProcessModel();
    }

    protected void postProcessModel() {
        for (int i = 0; i < this.model.getAllLinks().size(); ++i) {
            LinkLayoutInterface link = (LinkLayoutInterface)this.model.getAllLinks().get(i);
            if (!(link instanceof PFDSelfLink)) continue;
            ((PFDSelfLink)link).setRelativeLocation(2, true);
        }
    }

    private int getNumberOfOverlaps() {
        int nLinks = this.model.getAllLinks().size();
        int nNodes = this.model.getAllLayoutNodes().size();
        int overlaps = 0;
        for (int i = 0; i < nLinks; ++i) {
            LinkLayoutInterface link = (LinkLayoutInterface)this.model.getAllLinks().get(i);
            NodeLayoutInterface from = link.getFromNode();
            NodeLayoutInterface to = link.getToNode();
            Line2D.Double line = new Line2D.Double(from.getCenterLocation(), to.getCenterLocation());
            for (int j = 0; j < nNodes; ++j) {
                NodeLayoutInterface n = (NodeLayoutInterface)this.model.getAllLayoutNodes().elementAt(i);
                if (n == from || n == to || !n.getBBox().intersectsLine(line)) continue;
                ++overlaps;
            }
        }
        return overlaps;
    }

    private int getNumberOfOverlaps(GraphComponent graph, GraphComponentAttrs gca) {
        int overlaps = 0;
        Point[] pos = gca.getPosition();
        int[] vertexList = graph.getVertexList();
        for (int j = 0; j < pos.length; ++j) {
            NodeLayoutInterface n = (NodeLayoutInterface)this.model.getAllLayoutNodes().get(vertexList[j]);
            int x = (int)pos[j].getX();
            int y = (int)pos[j].getY();
            n.setCenterLocation(new java.awt.Point(x, y));
        }
        int nLinks = this.model.getAllLinks().size();
        int nNodes = graph.getNumberNodes();
        for (int i = 0; i < nLinks; ++i) {
            LinkLayoutInterface link = (LinkLayoutInterface)this.model.getAllLinks().get(i);
            if (link instanceof PFDSelfLink) continue;
            NodeLayoutInterface from = link.getFromNode();
            NodeLayoutInterface to = link.getToNode();
            Line2D.Double line = new Line2D.Double(from.getCenterLocation(), to.getCenterLocation());
            for (int j = 0; j < nNodes; ++j) {
                NodeLayoutInterface n = (NodeLayoutInterface)this.model.getAllLayoutNodes().get(vertexList[j]);
                if (n == from || n == to || !n.getBBox().intersectsLine(line)) continue;
                ++overlaps;
            }
        }
        return overlaps;
    }

    private Point getRandomPoint(double spaceBounds) {
        double x = this.pointRandom.nextDouble() * spaceBounds;
        double y = this.pointRandom.nextDouble() * spaceBounds;
        return new Point(x, y);
    }

    private boolean isAdjacentVertex(GraphComponent graph, int theVertex, int otherVertex) {
        int degree = graph.getDegree(theVertex);
        for (int adjVert = 0; adjVert < degree; ++adjVert) {
            int vertIndex = graph.getAdjacentVertex(theVertex, adjVert);
            if (otherVertex != vertIndex) continue;
            return true;
        }
        return false;
    }

    private class NodeSplitMap {
        int comp;
        int vert;

        private NodeSplitMap() {
        }
    }
}

