/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.util.layout;

import com.sas.graphics.components.util.layout.LayoutStrategy;
import com.sas.graphics.interfaces.ForceLayoutStrategyInterface;
import com.sas.graphics.interfaces.LinkLayoutInterface;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import java.awt.Dimension;
import java.awt.Point;

public class ForceLayoutStrategy
extends LayoutStrategy
implements ForceLayoutStrategyInterface {
    private double[] ndx;
    private double[] ndy;
    double[] xpos;
    double[] ypos;
    private int xgravity;
    private int ygravity;
    private int gmass;
    private int echarge;
    private int springlength;
    private int springconst;

    public ForceLayoutStrategy() {
        this.numIterations = 1000;
    }

    @Override
    public void setGravitationalForce(int xval, int yval) {
        System.out.println("setGravitationalForce()");
        this.xgravity = xval;
        this.ygravity = yval;
    }

    @Override
    public int getGravitationalForceY() {
        return this.xgravity;
    }

    @Override
    public int getGravitationalForceX() {
        return this.ygravity;
    }

    @Override
    public void setGravitationalMass(int val) {
        System.out.println("setGravitationalMass()");
        this.gmass = val;
    }

    @Override
    public int getGravitationalMass() {
        return this.gmass;
    }

    @Override
    public void setElectricCharge(int val) {
        System.out.println("setElectricCharge()");
        this.echarge = val;
    }

    @Override
    public int getElectricCharge() {
        return this.echarge;
    }

    @Override
    public void setSpringLength(int val) {
        System.out.println("setSpringLength()");
        this.springlength = val;
    }

    @Override
    public int getSpringLength() {
        return this.springlength;
    }

    @Override
    public void setSpringConstant(int val) {
        System.out.println("setSpringConstant()");
        this.springconst = val;
    }

    @Override
    public int getSpringConstant() {
        return this.springconst;
    }

    @Override
    public boolean arrange() {
        this.doSetupModel();
        int num = this.numNodes;
        this.xpos = new double[num];
        this.ypos = new double[num];
        int tmax = 1000;
        boolean moving = true;
        double side = 1.6;
        double grid = Math.sqrt(num) / side;
        double tiny = 1.0E-4 * grid;
        double[] x1 = new double[num];
        double[] y1 = new double[num];
        double[] xp = new double[num];
        double[] yp = new double[num];
        this.ndx = new double[num];
        this.ndy = new double[num];
        for (int i = 0; i < num; ++i) {
            this.ndx[i] = 0.0;
            this.ndy[i] = 0.0;
        }
        int totdeg = this.links.size();
        double avedeg = (double)totdeg / 2.0 / (double)num;
        double fac = 1.5 * avedeg / (double)num;
        for (int time = 1; time < tmax && moving; ++time) {
            double[] pos;
            NodeLayoutInterface f;
            int from;
            if (time % 50 == 0) {
                System.out.println("time=" + time);
            }
            for (from = 0; from < num; ++from) {
                f = (NodeLayoutInterface)this.nodes.elementAt(from);
                pos = this.getNormalizedCoord(f.getCenterLocation());
                x1[from] = this.xpos[from] = pos[0];
                y1[from] = this.ypos[from] = pos[1];
            }
            double maxten = this.relax((0.1 + fac) * grid);
            double maxmag = 0.0;
            double maxdiff = 0.0;
            for (from = 0; from < num; ++from) {
                f = (NodeLayoutInterface)this.nodes.elementAt(from);
                pos = this.getNormalizedCoord(f.getCenterLocation());
                double xd = pos[0] - x1[from];
                double yd = pos[1] - y1[from];
                double mag = xd * xd + yd * yd;
                maxmag = Math.max(mag, maxmag);
                xd = pos[0] - xp[from];
                yd = pos[1] - yp[from];
                double diff = xd * xd + yd * yd;
                maxdiff = Math.max(diff, maxdiff);
                xp[from] = x1[from];
                yp[from] = y1[from];
            }
            moving = maxmag > tiny && maxdiff > tiny;
        }
        return this.center();
    }

    double relax(double deslen) {
        double[] fpos;
        double[] tpos;
        for (int i = 0; i < this.numLinks; ++i) {
            double vy;
            LinkLayoutInterface e = (LinkLayoutInterface)this.links.elementAt(i);
            NodeLayoutInterface fnode = e.getFromNode();
            NodeLayoutInterface tnode = e.getToNode();
            tpos = this.getNormalizedCoord(tnode.getCenterLocation());
            double vx = tpos[0] - (fpos = this.getNormalizedCoord(fnode.getCenterLocation()))[0];
            double len = Math.sqrt(vx * vx + (vy = tpos[1] - fpos[1]) * vy);
            double f = len == 0.0 ? 0.0 : (deslen - len) / (len * 3.0);
            double dx = f * vx;
            double dy = f * vy;
            int to = this.nodes.indexOf(tnode);
            int from = this.nodes.indexOf(fnode);
            int n = to;
            this.ndx[n] = this.ndx[n] + dx;
            int n2 = to;
            this.ndy[n2] = this.ndy[n2] + dy;
            int n3 = from;
            this.ndx[n3] = this.ndx[n3] + -dx;
            int n4 = from;
            this.ndy[n4] = this.ndy[n4] + -dy;
        }
        double maxtension = 0.0;
        for (int i = 0; i < this.numNodes; ++i) {
            double tension = this.ndx[i] * this.ndx[i] + this.ndy[i] * this.ndy[i];
            maxtension = Math.max(tension, maxtension);
            NodeLayoutInterface n1 = (NodeLayoutInterface)this.nodes.elementAt(i);
            fpos = this.getNormalizedCoord(n1.getCenterLocation());
            double dx = 0.0;
            double dy = 0.0;
            for (int j = 0; j < this.numNodes; ++j) {
                double vy;
                if (i == j) continue;
                NodeLayoutInterface n2 = (NodeLayoutInterface)this.nodes.elementAt(j);
                tpos = this.getNormalizedCoord(n2.getCenterLocation());
                double vx = fpos[0] - tpos[0];
                double len = vx * vx + (vy = fpos[1] - tpos[1]) * vy;
                if (len == 0.0) {
                    dx += 0.01 * Math.random();
                    dy += 0.01 * Math.random();
                    continue;
                }
                if (!(len < 2.0 * deslen * (2.0 * deslen))) continue;
                dx += 0.01 * vx / len;
                dy += 0.01 * vy / len;
            }
            double dlen = dx * dx + dy * dy;
            if (!(dlen > 0.0)) continue;
            dlen = Math.sqrt(dlen) / 2.0;
            int n = i;
            this.ndx[n] = this.ndx[n] + 0.01 * dx / dlen;
            int n5 = i;
            this.ndy[n5] = this.ndy[n5] + 0.01 * dy / dlen;
        }
        Dimension d = new Dimension(2, 2);
        double[] pos = new double[]{-0.9, -0.9};
        Point border1 = this.getScreenCoord(pos);
        pos[0] = 0.9;
        pos[1] = 0.9;
        Point border2 = this.getScreenCoord(pos);
        int i = 0;
        while (i < this.numNodes) {
            NodeLayoutInterface n = (NodeLayoutInterface)this.nodes.elementAt(i);
            pos = this.getNormalizedCoord(n.getCenterLocation());
            pos[0] = pos[0] + Math.max(-0.05, Math.min(0.05, this.ndx[i]));
            pos[1] = pos[1] + Math.max(-0.05, Math.min(0.05, this.ndy[i]));
            Point screen = this.getScreenCoord(pos);
            if (screen.x < 20) {
                screen.x = 20;
            } else if (screen.x > 620) {
                screen.x = 620;
            }
            if (screen.y < 20) {
                screen.y = 22;
            } else if (screen.y > 460) {
                screen.y = 460;
            }
            int n6 = i;
            this.ndx[n6] = this.ndx[n6] / 2.0;
            int n7 = i++;
            this.ndy[n7] = this.ndy[n7] / 2.0;
            n.setCenterLocation(screen);
        }
        return maxtension;
    }

    private boolean center() {
        double[] pos;
        NodeLayoutInterface n;
        int i;
        double oldxmin = 0.0;
        double oldxmax = 0.0;
        double oldymin = 0.0;
        double oldymax = 0.0;
        for (i = 0; i < this.numNodes; ++i) {
            n = (NodeLayoutInterface)this.nodes.elementAt(i);
            pos = this.getNormalizedCoord(n.getCenterLocation());
            if (i == 0) {
                oldxmin = oldxmax = pos[0];
                oldymin = oldymax = pos[1];
                continue;
            }
            oldxmin = Math.min(pos[0], oldxmin);
            oldxmax = Math.max(pos[0], oldxmax);
            oldymin = Math.min(pos[1], oldymin);
            oldymax = Math.max(pos[1], oldymax);
        }
        double oldxm = (oldxmin + oldxmax) / 2.0;
        double oldym = (oldymin + oldymax) / 2.0;
        double oldxd = oldxmax - oldxmin;
        double oldyd = oldymax - oldymin;
        double newxmin = -0.9;
        double newxmax = 0.7;
        double newymin = -0.9;
        double newymax = 0.9;
        double newxm = (newxmin + newxmax) / 2.0;
        double newym = (newymin + newymax) / 2.0;
        double newxd = newxmax - newxmin;
        double newyd = newymax - newymin;
        double xshift = newxm - oldxm;
        double yshift = newym - oldym;
        double xexp = 1.0 + (newxd - oldxd) / newxd;
        double yexp = 1.0 + (newyd - oldyd) / newyd;
        double expand = Math.min(xexp, yexp);
        for (i = 0; i < this.numNodes; ++i) {
            n = (NodeLayoutInterface)this.nodes.elementAt(i);
            pos = this.getNormalizedCoord(n.getCenterLocation());
            double x = pos[0] + xshift;
            double y = pos[1] + yshift;
            x = newxm + (x - newxm) * expand;
            y = newym + (y - newym) * expand;
            n.setCenterLocation(this.getScreenCoord(x, y));
        }
        return true;
    }
}

