/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.util.layout;

import java.util.Hashtable;
import java.util.NoSuchElementException;

public class CustomLinkedList<E> {
    Hashtable<E, ListNode<E>> nodeMap = new Hashtable();
    ListNode<E> first;
    ListNode<E> last;
    int size = 0;

    public E getFirst() {
        return this.first == null ? null : (E)this.first.item;
    }

    public E getLast() {
        return this.last == null ? null : (E)this.last.item;
    }

    public void linkFirst(E e) {
        ListNode<E> f = this.first;
        ListNode<E> newNode = new ListNode<E>(null, e, f);
        this.first = newNode;
        if (f == null) {
            this.last = newNode;
        } else {
            f.prev = newNode;
        }
        this.nodeMap.put(e, newNode);
        ++this.size;
    }

    public void linkLast(E e) {
        ListNode<E> l = this.last;
        ListNode<E> newNode = new ListNode<E>(l, e, null);
        this.last = newNode;
        if (l == null) {
            this.first = newNode;
        } else {
            l.next = newNode;
        }
        this.nodeMap.put(e, newNode);
        ++this.size;
    }

    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            ListNode<E> x = this.first;
            while (x != null) {
                if (x.item == null) {
                    return index;
                }
                ++index;
                x = x.next;
            }
        } else {
            ListNode<E> x = this.first;
            while (x != null) {
                if (o.equals(x.item)) {
                    return index;
                }
                ++index;
                x = x.next;
            }
        }
        return -1;
    }

    public E unlinkFirst(ListNode<E> f) {
        Object element = f.item;
        ListNode next = f.next;
        f.item = null;
        f.next = null;
        this.first = next;
        if (next == null) {
            this.last = null;
        } else {
            next.prev = null;
        }
        --this.size;
        this.nodeMap.remove(element);
        return element;
    }

    public E unlinkLast(ListNode<E> l) {
        Object element = l.item;
        ListNode prev = l.prev;
        l.item = null;
        l.prev = null;
        this.last = prev;
        if (prev == null) {
            this.first = null;
        } else {
            prev.next = null;
        }
        --this.size;
        this.nodeMap.remove(element);
        return element;
    }

    public E removeFirst() {
        ListNode<E> f = this.first;
        if (f == null) {
            throw new NoSuchElementException();
        }
        return this.unlinkFirst(f);
    }

    public E remove(int index) {
        this.checkElementIndex(index);
        return this.unlink(this.node(index));
    }

    public E unlink(ListNode<E> x) {
        Object element = x.item;
        ListNode next = x.next;
        ListNode prev = x.prev;
        if (prev == null) {
            this.first = next;
        } else {
            prev.next = next;
            x.prev = null;
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.prev = prev;
            x.next = null;
        }
        x.item = null;
        --this.size;
        this.nodeMap.remove(element);
        return element;
    }

    private ListNode<E> node(int index) {
        if (index < this.size >> 1) {
            ListNode<E> x = this.first;
            for (int i = 0; i < index; ++i) {
                x = x.next;
            }
            return x;
        }
        ListNode<E> x = this.last;
        for (int i = this.size - 1; i > index; --i) {
            x = x.prev;
        }
        return x;
    }

    public E get(int index) {
        this.checkElementIndex(index);
        return this.node((int)index).item;
    }

    public E getPrevious(E element) {
        ListNode<E> node = this.nodeMap.get(element);
        return node == null ? null : (node.prev == null ? null : node.prev.item);
    }

    public E getNext(E element) {
        ListNode<E> node = this.nodeMap.get(element);
        return node == null ? null : (node.next == null ? null : node.next.item);
    }

    public boolean hasPrevious(E element) {
        ListNode<E> node = this.nodeMap.get(element);
        return node == null ? false : node.prev != null;
    }

    public boolean hasNext(E element) {
        ListNode<E> node = this.nodeMap.get(element);
        return node == null ? false : node.next != null;
    }

    public void linkBefore(E e, E succ) {
        this.linkBefore(e, this.nodeMap.get(succ));
    }

    public void linkBefore(E e, ListNode<E> succ) {
        ListNode pred = succ.prev;
        ListNode newNode = new ListNode(pred, e, succ);
        succ.prev = newNode;
        if (pred == null) {
            this.first = newNode;
        } else {
            pred.next = newNode;
        }
        this.nodeMap.put(e, newNode);
        ++this.size;
    }

    public void linkAfter(E e, E pred) {
        this.linkAfter(e, this.nodeMap.get(pred));
    }

    public void linkAfter(E e, ListNode<E> pred) {
        ListNode succ = pred.next;
        ListNode<E> newNode = new ListNode<E>(pred, e, succ);
        pred.next = newNode;
        if (succ == null) {
            this.last = newNode;
        } else {
            succ.prev = newNode;
        }
        this.nodeMap.put(e, newNode);
        ++this.size;
    }

    public void linkLast(CustomLinkedList<E> list) {
        if (list == null) {
            return;
        }
        E element = list.getFirst();
        while (element != null) {
            this.linkLast(element);
            element = list.getNext(element);
        }
    }

    public boolean isAfter(E pred, E element) {
        if (pred == null) {
            return false;
        }
        E e = this.getNext(pred);
        while (e != null && e != element) {
            e = this.getNext(e);
        }
        return e == element;
    }

    public boolean isBefore(E succ, E element) {
        if (succ == null) {
            return false;
        }
        E e = this.getPrevious(succ);
        while (e != null && e != element) {
            e = this.getPrevious(e);
        }
        return e == element;
    }

    public boolean isBetween(E start, E end, E element) {
        if (start == null || end == null) {
            return false;
        }
        E e = this.getNext(start);
        while (e != end && e != element) {
            e = this.getNext(e);
        }
        return e == element;
    }

    public boolean contains(E e) {
        return this.nodeMap.containsKey(e);
    }

    private boolean isElementIndex(int index) {
        return index >= 0 && index < this.size;
    }

    private void checkElementIndex(int index) {
        if (!this.isElementIndex(index)) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    public int getSize() {
        return this.size;
    }

    private class ListNode<E> {
        E item;
        ListNode<E> next;
        ListNode<E> prev;

        ListNode(ListNode<E> prev, E element, ListNode<E> next) {
            this.item = element;
            this.next = next;
            this.prev = prev;
        }
    }
}

