/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.xml.parsers;

import com.sas.graphics.components.pfd.PFDStatus;
import com.sas.graphics.components.pfd.xml.parsers.PFDElementInfoReader;
import com.sas.graphics.components.pfd.xml.parsers.PFDParserUtils;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class StatusParser
implements ElementParserInterface {
    public static final String TAG_NAME = "Status";
    public final String CONFIG = "com/sas/graphics/components/pfd/xml/parsers/config/status.config";
    protected PFDElementInfoReader statusInfoReader = new PFDElementInfoReader("com/sas/graphics/components/pfd/xml/parsers/config/status.config");

    public StatusParser() {
        this(null);
    }

    public StatusParser(PropertyInterface pi) {
        this.statusInfoReader.setInstance(pi);
    }

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        String tooltip;
        PFDStatus status = this.createFromType(element.getAttribute("type"));
        if (status == null) {
            return null;
        }
        Element detailsElement = PFDParserUtils.getChildWithTagName((String)"StatusDetails", (Element)element);
        if (detailsElement != null) {
            String titleText = detailsElement.getAttribute("title");
            String detailsText = PFDParserUtils.getElementText((Element)detailsElement);
            if (!titleText.equalsIgnoreCase("") && !detailsText.equalsIgnoreCase("")) {
                status.setPropertyValue(706, titleText);
                status.setPropertyValue(707, detailsText);
                status.setPropertyValue(709, Boolean.valueOf(detailsElement.getAttribute("isVisible")));
            } else {
                return null;
            }
        }
        if ((tooltip = element.getAttribute("tooltip")) != null) {
            status.setPropertyValue(705, tooltip);
        }
        status.applyPropertyChanges();
        return status;
    }

    public Element putToXML(Hashtable context, Object instance) {
        if (!(instance instanceof PFDStatus)) {
            return null;
        }
        PFDStatus status = (PFDStatus)instance;
        Element statusElement = PFDParserUtils.newElement((Hashtable)context, (String)TAG_NAME);
        Integer statusID = (Integer)status.getValue("ID");
        String typeName = this.getStatusNameFromStatusId(statusID);
        if (statusID == null || typeName == null) {
            return null;
        }
        statusElement.setAttribute("type", typeName);
        String tooltip = (String)status.getPropertyValue(705);
        if (tooltip != null) {
            statusElement.setAttribute("tooltip", tooltip);
        }
        String detailsText = (String)status.getPropertyValue(707);
        String titleText = (String)status.getPropertyValue(706);
        Boolean isVisible = (Boolean)status.getPropertyValue(709);
        if (detailsText != null && titleText != null) {
            Element statusDetailsElement = PFDParserUtils.newElement((Hashtable)context, (String)"StatusDetails");
            statusDetailsElement.setAttribute("title", titleText);
            if (isVisible != null) {
                statusDetailsElement.setAttribute("isVisible", isVisible.toString());
            }
            statusDetailsElement.setTextContent(detailsText);
            statusElement.appendChild(statusDetailsElement);
        }
        return statusElement;
    }

    private PFDStatus createFromType(String typeString) {
        int statusID = this.getStatusIdFromStatusName(typeString);
        if (statusID < 0) {
            return null;
        }
        return PFDStatus.getInstance(statusID);
    }

    private int getStatusIdFromStatusName(String name) {
        if (name.equalsIgnoreCase("warning")) {
            return 1;
        }
        if (name.equalsIgnoreCase("error")) {
            return 2;
        }
        if (name.equalsIgnoreCase("processing")) {
            return 3;
        }
        if (name.equalsIgnoreCase("complete")) {
            return 5;
        }
        if (name.equalsIgnoreCase("incomplete")) {
            return 4;
        }
        if (name.equalsIgnoreCase("invalid")) {
            return 6;
        }
        return -1;
    }

    private String getStatusNameFromStatusId(int id) {
        switch (id) {
            case 1: {
                return "warning";
            }
            case 2: {
                return "error";
            }
            case 3: {
                return "processing";
            }
            case 5: {
                return "complete";
            }
            case 4: {
                return "incomplete";
            }
            case 6: {
                return "invalid";
            }
        }
        return null;
    }

    public Object getObject() {
        return null;
    }

    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof PropertyInterface)) {
            return false;
        }
        if (this.statusInfoReader != null) {
            this.statusInfoReader.setInstance(instance);
        }
        return true;
    }
}

