/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.xml.parsers;

import com.sas.graphics.components.pfd.PFDCompositeNode;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDStatus;
import com.sas.graphics.components.pfd.xml.parsers.ButtonParser;
import com.sas.graphics.components.pfd.xml.parsers.PFDElementInfoReader;
import com.sas.graphics.components.pfd.xml.parsers.PFDParserUtils;
import com.sas.graphics.components.pfd.xml.parsers.PortParser;
import com.sas.graphics.components.pfd.xml.parsers.StatusParser;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.xml.GraphParserUtils;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NodeParser
implements ElementParserInterface {
    public static final String TAG_NAME = "PFDNode";
    public final String CONFIG = "com/sas/graphics/components/pfd/xml/parsers/config/node.config";
    protected PFDElementInfoReader nodeInfoReader = new PFDElementInfoReader("com/sas/graphics/components/pfd/xml/parsers/config/node.config");

    public NodeParser() {
        this(null);
    }

    public NodeParser(PropertyInterface pi) {
        this.nodeInfoReader.setInstance(pi);
    }

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        this.setObject(instance);
        String id = element.getAttribute("id");
        if (element == null || id.equals("") || context == null || context.contains(id)) {
            return null;
        }
        if (this.getObject() != null) {
            context.put(id, this.getObject());
        }
        PFDParserUtils.parseElement(context, element, this.nodeInfoReader);
        Element childElement = null;
        PropertyInterface pi = (PropertyInterface)this.getObject();
        this.getCommentsFromXML(pi, element, childElement);
        this.getDetailsFromXML(pi, element, childElement);
        this.getStatusFromXML(pi, element, childElement, context);
        pi.applyPropertyChanges();
        if (!element.getAttribute("portType").equalsIgnoreCase("omnidirectional")) {
            this.getPortsFromXML(context, element, childElement);
        }
        this.getButtonsFromXML(context, element, childElement);
        return this.getObject();
    }

    protected void getCommentsFromXML(PropertyInterface pi, Element parentElement, Element childElement) {
        childElement = PFDParserUtils.getChildWithTagName((String)"Comment", (Element)parentElement);
        if (childElement != null) {
            String commentText;
            String isVisibleAttr = childElement.getAttribute("isVisible");
            if (!isVisibleAttr.equalsIgnoreCase("") && isVisibleAttr.equalsIgnoreCase("true")) {
                pi.setPropertyValue(407, (Object)Boolean.TRUE);
            }
            if ((commentText = PFDParserUtils.getElementText((Element)childElement)) != null) {
                pi.setPropertyValue(406, (Object)commentText);
            }
        }
    }

    protected void getDetailsFromXML(PropertyInterface pi, Element parentElement, Element childElement) {
        childElement = PFDParserUtils.getChildWithTagName((String)"Details", (Element)parentElement);
        if (childElement != null) {
            pi.setPropertyValue(405, (Object)PFDParserUtils.getElementText((Element)childElement));
        }
    }

    protected void getStatusFromXML(PropertyInterface pi, Element parentElement, Element childElement, Hashtable context) {
        PFDStatus status;
        childElement = PFDParserUtils.getChildWithTagName((String)"Status", (Element)parentElement);
        if (childElement != null && (status = (PFDStatus)new StatusParser().getFromXML(context, childElement, null)) != null) {
            pi.setPropertyValue(411, (Object)status);
        }
    }

    protected void getButtonsFromXML(Hashtable context, Element parentElement, Element childElement) {
        childElement = PFDParserUtils.getChildWithTagName((String)"Buttons", (Element)parentElement);
        if (childElement != null) {
            ButtonParser.initButtonsFromXML(context, childElement, this.getObject());
        }
    }

    protected boolean getPortsFromXML(Hashtable context, Element parentElement, Element childElement) {
        childElement = PFDParserUtils.getChildWithTagName((String)"Ports", (Element)parentElement);
        if (childElement != null && this.getObject() instanceof PFDCompositeNode) {
            Element outputPortsElement;
            PFDCompositeNode node = (PFDCompositeNode)this.getObject();
            Element inputPortsElement = PFDParserUtils.getChildWithTagName((String)"InputPorts", (Element)childElement);
            if (inputPortsElement != null) {
                this.getInputPortsFromXML(context, inputPortsElement, node);
            }
            if ((outputPortsElement = PFDParserUtils.getChildWithTagName((String)"OutputPorts", (Element)childElement)) != null) {
                this.getOutputPortsFromXML(context, outputPortsElement, node);
            }
            return true;
        }
        return false;
    }

    protected void getInputPortsFromXML(Hashtable context, Element inputPortsElement, PFDCompositeNode node) {
        node.removeAllInputPorts();
        List portList = PFDParserUtils.getListFromXML(context, inputPortsElement, new PortParser());
        if (portList == null || portList.isEmpty()) {
            return;
        }
        if (node.getPortStyle() == 0) {
            for (PFDPort port : portList) {
                node.addInputPort(port);
                port.setParent(node);
            }
        } else {
            PFDPort port = (PFDPort)portList.get(0);
            node.setInputPort(port);
            port.setParent(node);
        }
    }

    protected void getOutputPortsFromXML(Hashtable context, Element outputPortsElement, PFDCompositeNode node) {
        node.removeAllOutputPorts();
        List portList = PFDParserUtils.getListFromXML(context, outputPortsElement, new PortParser());
        if (portList == null || portList.isEmpty()) {
            return;
        }
        if (node.getPortStyle() == 0) {
            for (PFDPort port : portList) {
                node.addOutputPort(port);
                port.setParent(node);
            }
        } else {
            PFDPort port = (PFDPort)portList.get(0);
            node.setOutputPort(port);
            port.setParent(node);
        }
    }

    public Element putToXML(Hashtable context, Object instance) {
        if (!(instance instanceof PFDCompositeNode) || context == null) {
            return null;
        }
        PFDCompositeNode node = (PFDCompositeNode)instance;
        String id = node.getPFDItemId();
        if (id == null || context.containsKey(id) || context.containsValue(id)) {
            node.setPFDItemId(PFDParserUtils.getUniqueID(context));
        }
        context.put(node.getPFDItemId(), node);
        Element e = PFDParserUtils.toXML(TAG_NAME, context, instance, this.nodeInfoReader);
        Element childElement = this.putPortsToXML(context, node);
        if (childElement != null) {
            e.appendChild(childElement);
        }
        if ((childElement = this.putCommentsToXML(context, node)) != null) {
            e.appendChild(childElement);
        }
        if ((childElement = this.putDetailsToXML(context, node)) != null) {
            e.appendChild(childElement);
        }
        if ((childElement = this.putStatusToXML(context, node)) != null) {
            e.appendChild(childElement);
        }
        if ((childElement = this.putButtonsToXML(context, node)) != null) {
            e.appendChild(childElement);
        }
        if ((childElement = this.putCustomTagsToXML(context, node)) != null) {
            e.appendChild(childElement);
        }
        context.remove(node.getPFDItemId());
        context.put(node.getPFDItemId(), GraphParserUtils.toString((Node)e).trim());
        return e;
    }

    protected Element putCommentsToXML(Hashtable context, PFDCompositeNode node) {
        String commentText = node.getNoteText();
        if (commentText != null && commentText.trim().length() > 0) {
            Element commentElement = PFDParserUtils.newElement((Hashtable)context, (String)"Comment");
            if (node.hasUserSetValue(407)) {
                commentElement.setAttribute("isVisible", "true");
            }
            commentElement.setTextContent(commentText);
            return commentElement;
        }
        return null;
    }

    protected Element putDetailsToXML(Hashtable context, PFDCompositeNode node) {
        String detailsText = node.getContentText();
        if (detailsText != null && detailsText.trim().length() > 0) {
            Element detailsElement = PFDParserUtils.newElement((Hashtable)context, (String)"Details");
            detailsElement.setTextContent(detailsText);
            return detailsElement;
        }
        return null;
    }

    protected Element putStatusToXML(Hashtable context, PFDCompositeNode node) {
        if (node.getStatus() != 0) {
            Element statusElement = new StatusParser().putToXML(context, node.getStatusObject());
            return statusElement;
        }
        return null;
    }

    protected Element putButtonsToXML(Hashtable context, PFDCompositeNode node) {
        if (node.getIndicatorButtons().getNumButtons() > 0) {
            return ButtonParser.getButtonsElement(context, node);
        }
        return null;
    }

    protected Element putCustomTagsToXML(Hashtable context, PFDCompositeNode node) {
        return null;
    }

    protected Element putPortsToXML(Hashtable context, PFDCompositeNode node) {
        Element inputPortsElement = this.putInputPortsToXML(context, node);
        Element outputPortsElement = this.putOutputPortsToXML(context, node);
        if (inputPortsElement == null && outputPortsElement == null) {
            return null;
        }
        Element portsElement = PFDParserUtils.newElement((Hashtable)context, (String)"Ports");
        if (inputPortsElement != null) {
            portsElement.appendChild(inputPortsElement);
        }
        if (outputPortsElement != null) {
            portsElement.appendChild(outputPortsElement);
        }
        return portsElement;
    }

    protected Element putInputPortsToXML(Hashtable context, PFDCompositeNode node) {
        if (node.getNumInputPorts() == 1 && this.isPortDefault(node.getInputPort())) {
            return null;
        }
        Element e = PFDParserUtils.newElement((Hashtable)context, (String)"InputPorts");
        PortParser parser = new PortParser();
        for (int i = 0; i < node.getNumInputPorts(); ++i) {
            Element portElement = parser.putToXML(context, node.getInputPort(i));
            if (portElement == null) continue;
            e.appendChild(portElement);
        }
        return e;
    }

    protected Element putOutputPortsToXML(Hashtable context, PFDCompositeNode node) {
        if (node.getNumOutputPorts() == 1 && this.isPortDefault(node.getOutputPort())) {
            return null;
        }
        Element e = PFDParserUtils.newElement((Hashtable)context, (String)"OutputPorts");
        PortParser parser = new PortParser();
        for (int i = 0; i < node.getNumOutputPorts(); ++i) {
            Element portElement = parser.putToXML(context, node.getOutputPort(i));
            if (portElement == null) continue;
            e.appendChild(portElement);
        }
        return e;
    }

    protected boolean isPortDefault(PFDPort port) {
        if (port == null) {
            return false;
        }
        return !port.isControl();
    }

    public Object getObject() {
        return this.nodeInfoReader.getXmlTarget();
    }

    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof PropertyInterface)) {
            return false;
        }
        if (this.nodeInfoReader != null) {
            this.nodeInfoReader.setInstance(instance);
        }
        return true;
    }
}

