/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.ui.menu;

import com.sas.graphics.components.pfd.PFDCollapsableNodeGroup;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PFDPopupMenu
extends JPopupMenu {
    private PFDView view;

    public PFDPopupMenu(PFDView v) {
        this.view = v;
    }

    public void updateMenu(PFDPrimitive[] primitives) {
        List menuItems;
        this.removeAll();
        if (primitives == null || primitives.length == 0) {
            menuItems = this.view.getMenuItems();
        } else if (primitives.length == 1 || this.isAllLinks(primitives)) {
            menuItems = primitives[0].getMenuItems();
        } else {
            List<PFDPrimitive> pList = Arrays.asList(primitives);
            boolean groupEnabled = PFDCollapsableNodeGroup.canGroup(pList);
            menuItems = this.getGroupMenuItems(groupEnabled);
        }
        this.buildMenu(menuItems);
    }

    private boolean isAllLinks(PFDPrimitive[] primitives) {
        for (int i = 0; i < primitives.length; ++i) {
            if (primitives[i] instanceof PFDLink) continue;
            return false;
        }
        return true;
    }

    private void buildMenu(List items) {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            Object o = items.get(i);
            if (!(o instanceof Component)) continue;
            this.add((Component)o);
        }
    }

    private List getGroupMenuItems(boolean groupEnabled) {
        Vector<JComponent> items = new Vector<JComponent>();
        Action a = this.view.getAction("ACTION_CUT");
        items.add(new JMenuItem(a));
        a = this.view.getAction("ACTION_COPY");
        items.add(new JMenuItem(a));
        a = this.view.getAction("ACTION_DELETE");
        items.add(new JMenuItem(a));
        items.add(new JPopupMenu.Separator());
        a = this.view.getAction("ACTION_CREATE_GROUP");
        a.setEnabled(groupEnabled);
        items.add(new JMenuItem(a));
        return items;
    }
}

