/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.ui.menu;

import com.sas.graphics.components.pfd.PFDIconManager;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.ui.PFDPlaceholderIcon;
import com.sas.graphics.components.pfd.ui.actions.PFDAbstractAction;
import com.sas.graphics.components.pfd.ui.menu.RB;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class PFDMenuUtil {
    private static final String RB_KEY = "PFDMenuUtil.";

    public static JMenuItem createMenuItem(Action a) {
        JMenuItem menuItem = new JMenuItem(a);
        return menuItem;
    }

    public static JCheckBoxMenuItem createCheckBoxMenuItem(Action a) {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(a);
        if (a instanceof PFDAbstractAction) {
            ((PFDAbstractAction)a).addButton(menuItem);
        }
        return menuItem;
    }

    public static JRadioButtonMenuItem createRadioButtonMenuItem(Action a) {
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(a);
        if (a instanceof PFDAbstractAction) {
            ((PFDAbstractAction)a).addButton(menuItem);
        }
        return menuItem;
    }

    public static JMenu createLayoutMenu(PFDView v) {
        JMenu layoutMenu = new JMenu(RB.getStringResource(RB_KEY, "layoutMenu.name.txt"));
        layoutMenu.setIcon(new PFDPlaceholderIcon());
        Action action = v.getAction("ACTION_RUN_LAYOUT");
        JMenuItem runLayout = PFDMenuUtil.createMenuItem(action);
        runLayout.setIcon(null);
        layoutMenu.add(runLayout);
        layoutMenu.setEnabled(action.isEnabled());
        layoutMenu.addSeparator();
        action = v.getAction("ACTION_LAYOUT_RIGHT");
        layoutMenu.add(PFDMenuUtil.createRadioButtonMenuItem(action));
        action = v.getAction("ACTION_LAYOUT_DOWN");
        layoutMenu.add(PFDMenuUtil.createRadioButtonMenuItem(action));
        return layoutMenu;
    }

    public static JMenu createZoomMenu(PFDView v) {
        JMenu zoomMenu = new JMenu(RB.getStringResource(RB_KEY, "zoomMenu.name.txt"));
        Icon zoomIcon = PFDIconManager.getIcon("Zoom.gif");
        zoomMenu.setIcon(zoomIcon);
        Action action = v.getAction("ACTION_ZOOM_200");
        zoomMenu.add(PFDMenuUtil.createRadioButtonMenuItem(action));
        action = v.getAction("ACTION_ZOOM_150");
        zoomMenu.add(PFDMenuUtil.createRadioButtonMenuItem(action));
        action = v.getAction("ACTION_ZOOM_100");
        zoomMenu.add(PFDMenuUtil.createRadioButtonMenuItem(action));
        action = v.getAction("ACTION_ZOOM_75");
        zoomMenu.add(PFDMenuUtil.createRadioButtonMenuItem(action));
        action = v.getAction("ACTION_ZOOM_50");
        zoomMenu.add(PFDMenuUtil.createRadioButtonMenuItem(action));
        action = v.getAction("ACTION_ZOOM_25");
        zoomMenu.add(PFDMenuUtil.createRadioButtonMenuItem(action));
        action = v.getAction("ACTION_ZOOM_10");
        zoomMenu.add(PFDMenuUtil.createRadioButtonMenuItem(action));
        zoomMenu.addSeparator();
        action = v.getAction("ACTION_ZOOM_FIT");
        zoomMenu.add(PFDMenuUtil.createMenuItem(action));
        action = v.getAction("ACTION_ZOOM_FIT_WIDTH");
        zoomMenu.add(PFDMenuUtil.createMenuItem(action));
        action = v.getAction("ACTION_ZOOM_FIT_HEIGHT");
        zoomMenu.add(PFDMenuUtil.createMenuItem(action));
        return zoomMenu;
    }

    public static JMenu createGridMenu(PFDView v) {
        JMenu gridMenu = new JMenu(RB.getStringResource(RB_KEY, "gridMenu.name.txt"));
        Icon gridIcon = PFDIconManager.getIcon("ShowGrid.gif");
        gridMenu.setIcon(gridIcon);
        Action action = v.getAction("ACTION_TOGGLE_GRID");
        gridMenu.add(PFDMenuUtil.createRadioButtonMenuItem(action));
        action = v.getAction("ACTION_TOGGLE_SNAP_TO_GRID");
        gridMenu.add(PFDMenuUtil.createRadioButtonMenuItem(action));
        gridMenu.addSeparator();
        gridMenu.add(PFDMenuUtil.createGridStyleMenu(v));
        return gridMenu;
    }

    public static JMenu createGridStyleMenu(PFDView v) {
        JMenu gridStyleMenu = new JMenu(RB.getStringResource(RB_KEY, "gridStyleMenu.name.txt"));
        Action action = v.getAction("ACTION_GRID_STYLE_SOLID");
        gridStyleMenu.add(PFDMenuUtil.createRadioButtonMenuItem(action));
        action = v.getAction("ACTION_GRID_STYLE_DOT");
        gridStyleMenu.add(PFDMenuUtil.createRadioButtonMenuItem(action));
        return gridStyleMenu;
    }

    public static JMenu createPrintMenu(PFDView v) {
        JMenu printMenu = new JMenu(RB.getStringResource(RB_KEY, "printMenu.name.txt"));
        printMenu.setIcon(new PFDPlaceholderIcon());
        Action action = v.getAction("ACTION_PAGE_SETUP");
        printMenu.add(PFDMenuUtil.createMenuItem(action));
        action = v.getAction("ACTION_PRINT");
        printMenu.add(PFDMenuUtil.createMenuItem(action));
        printMenu.addSeparator();
        action = v.getAction("ACTION_TOGGLE_PAGE_BOUNDARIES");
        printMenu.add(PFDMenuUtil.createCheckBoxMenuItem(action));
        return printMenu;
    }
}

