/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.ui;

import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.PFDViewEvent;
import com.sas.graphics.components.pfd.PFDViewListener;
import com.sas.graphics.components.pfd.ui.RB;
import java.awt.Dimension;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PFDZoomSlider
extends JSlider
implements PFDViewListener {
    private static final long serialVersionUID = 3733305008993564573L;
    private static final String RB_KEY = "PFDZoomSlider.";
    private boolean update = true;
    protected PFDView view = null;

    public PFDZoomSlider(PFDView v) {
        Dimension size = this.getPreferredSize();
        size.width = 60;
        this.setPreferredSize(size);
        this.attachView(v);
        this.setToolTipText(RB.getStringResource(RB_KEY, "tip"));
        this.addChangeListener(this.createSliderChangeListener());
    }

    protected ChangeListener createSliderChangeListener() {
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PFDZoomSlider.this.updateView();
            }
        };
        return listener;
    }

    @Override
    public void viewChanged(PFDViewEvent e) {
        if (e.getType() == 0) {
            this.updateFromView();
        }
    }

    private void updateFromView() {
        if (this.update && this.view != null) {
            this.update = false;
            this.setValue((int)(this.view.getScale() * 100.0));
            this.update = true;
        }
    }

    private void updateView() {
        if (this.update && this.view != null) {
            this.update = false;
            int scaleInt = this.getValue();
            this.view.setScale((double)scaleInt / 100.0);
            this.update = true;
        }
    }

    public void attachView(PFDView v) {
        this.detachView();
        if (v == null) {
            return;
        }
        this.view = v;
        this.setMinimum((int)(this.view.getMinScale() * 100.0));
        this.setMaximum((int)(this.view.getMaxScale() * 100.0));
        this.setValue((int)(this.view.getScale() * 100.0));
        this.view.addPFDViewListener(this);
    }

    public void detachView() {
        if (this.view == null) {
            return;
        }
        this.view.removePFDViewListener(this);
        this.view = null;
    }
}

