/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.ui;

import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.PFDViewEvent;
import com.sas.graphics.components.pfd.PFDViewListener;
import com.sas.graphics.components.pfd.ui.RB;
import java.awt.Dimension;
import java.text.MessageFormat;
import javax.swing.JLabel;

public class PFDZoomLabel
extends JLabel
implements PFDViewListener {
    private static final String RB_KEY = "PFDZoomLabel.";
    private boolean update = true;
    private String customScalePattern = RB.getStringResource("PFDZoomLabel.", "customScale.fmt");
    private PFDView view = null;

    public PFDZoomLabel(PFDView v) {
        this.setHorizontalAlignment(4);
        this.attachView(v);
    }

    @Override
    public void viewChanged(PFDViewEvent e) {
        if (e.getType() == 0) {
            this.updateFromView();
        }
    }

    private void updateFromView() {
        if (this.view != null) {
            int newScale = (int)(this.view.getScale() * 100.0);
            String customScale = MessageFormat.format(this.customScalePattern, new Integer(newScale));
            this.setText(customScale);
        }
    }

    private void initSize() {
        if (this.view != null) {
            int newScale = (int)(this.view.getMaxScale() * 100.0);
            String maxScale = MessageFormat.format(this.customScalePattern, new Integer(newScale));
            this.setText(maxScale);
            Dimension d = this.getPreferredSize();
            this.setPreferredSize(d);
        }
    }

    public void attachView(PFDView v) {
        this.detachView();
        if (v == null) {
            return;
        }
        this.view = v;
        this.initSize();
        this.updateFromView();
        this.view.addPFDViewListener(this);
    }

    public void detachView() {
        if (this.view == null) {
            return;
        }
        this.view.removePFDViewListener(this);
        this.view = null;
    }
}

