/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.ui;

import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.PFDViewEvent;
import com.sas.graphics.components.pfd.PFDViewListener;
import com.sas.graphics.components.pfd.ui.RB;
import com.sas.graphics.components.pfd.ui.actions.PFDAbstractAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class PFDZoomComboBox
extends JComboBox
implements PFDViewListener {
    private static final long serialVersionUID = -6863477435722416552L;
    private static final String RB_KEY = "PFDZoomComboBox.";
    private boolean update = true;
    private String customScalePattern = null;
    protected PFDView view = null;

    public PFDZoomComboBox(PFDView v) {
        this.setEditable(true);
        this.setToolTipText(RB.getStringResource(RB_KEY, "tip"));
        this.customScalePattern = RB.getStringResource(RB_KEY, "customScale.fmt");
        this.attachView(v);
        this.addActionListener(this.createActionListener());
    }

    @Override
    public void viewChanged(PFDViewEvent e) {
        if (e.getType() == 0) {
            this.updateFromView();
        }
    }

    private void updateFromView() {
        if (this.update && this.view != null) {
            this.update = false;
            int newScale = (int)(this.view.getScale() * 100.0);
            String customeScale = MessageFormat.format(this.customScalePattern, new Integer(newScale));
            this.setSelectedItem(customeScale);
            this.update = true;
        }
    }

    private void updateView(ActionEvent e) {
        if (this.update && this.view != null) {
            this.update = false;
            Object selection = this.getSelectedItem();
            if (selection instanceof PFDAbstractAction) {
                ((PFDAbstractAction)selection).actionPerformed(e);
                ((PFDAbstractAction)selection).setSelected(true);
            } else {
                int oldValue;
                int min = (int)(this.view.getMinScale() * 100.0);
                int max = (int)(this.view.getMaxScale() * 100.0);
                int newValue = oldValue = (int)(this.view.getScale() * 100.0);
                boolean error = false;
                String customValue = (String)selection;
                NumberFormat format = NumberFormat.getIntegerInstance();
                try {
                    Number n = format.parse(customValue);
                    newValue = n.intValue();
                    if (newValue < min || newValue > max) {
                        error = true;
                    }
                }
                catch (ParseException pe) {
                    error = true;
                }
                if (error) {
                    String pattern = RB.getStringResource(RB_KEY, "error.fmt");
                    String errorMessage = MessageFormat.format(pattern, new Integer(min), new Integer(max));
                    JOptionPane.showMessageDialog(this.view, errorMessage, null, 0);
                    String customeScale = MessageFormat.format(this.customScalePattern, new Integer(oldValue));
                    this.setSelectedItem(customeScale);
                } else {
                    this.view.setScale((double)newValue / 100.0);
                    String customeScale = MessageFormat.format(this.customScalePattern, new Integer(newValue));
                    this.setSelectedItem(customeScale);
                }
            }
            this.update = true;
        }
    }

    protected ActionListener createActionListener() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PFDZoomComboBox.this.updateView(e);
            }
        };
        return listener;
    }

    public void attachView(PFDView v) {
        this.detachView();
        if (v == null) {
            return;
        }
        this.view = v;
        this.addItem(this.view.getAction("ACTION_ZOOM_200"));
        this.addItem(this.view.getAction("ACTION_ZOOM_150"));
        this.addItem(this.view.getAction("ACTION_ZOOM_100"));
        this.addItem(this.view.getAction("ACTION_ZOOM_75"));
        this.addItem(this.view.getAction("ACTION_ZOOM_50"));
        this.addItem(this.view.getAction("ACTION_ZOOM_25"));
        this.addItem(this.view.getAction("ACTION_ZOOM_10"));
        this.addItem(this.view.getAction("ACTION_ZOOM_FIT"));
        this.addItem(this.view.getAction("ACTION_ZOOM_FIT_WIDTH"));
        this.addItem(this.view.getAction("ACTION_ZOOM_FIT_HEIGHT"));
        this.setMaximumRowCount(this.getItemCount());
        this.updateFromView();
        this.view.addPFDViewListener(this);
    }

    public void detachView() {
        if (this.view == null) {
            return;
        }
        this.view.removePFDViewListener(this);
        this.view = null;
        this.removeAllItems();
    }
}

