/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;

public class PFDTable
extends JTable {
    private static final String ACTION_KEY_TAB = "PFDTable.actionKeyTab";
    private Color[] columnColors = null;

    public PFDTable() {
        this.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), ACTION_KEY_TAB);
        this.getActionMap().put(ACTION_KEY_TAB, new TabKeyAction());
    }

    @Override
    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        int numColumns = this.getColumnCount();
        this.columnColors = numColumns > 0 ? new Color[numColumns] : null;
    }

    public void setColumnBackground(Color color, int columnIndex) {
        if (color == null || columnIndex < 0 || columnIndex >= this.columnColors.length) {
            throw new IllegalArgumentException();
        }
        this.columnColors[columnIndex] = color;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container viewport = this.getParent();
        if (!(viewport instanceof JViewport)) {
            return false;
        }
        return this.getPreferredSize().height < viewport.getHeight();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintEmptyRows(g);
    }

    protected void paintEmptyRows(Graphics g) {
        int rowCount = this.getRowCount();
        Rectangle clip = g.getClipBounds();
        Rectangle bounds = this.getBounds();
        int startY = rowCount * this.rowHeight;
        int endY = bounds.y + bounds.height;
        if (startY < (endY = Math.min(endY, clip.y + clip.height))) {
            int i;
            int colXValue = bounds.x;
            for (i = 0; i < this.getColumnCount() && i < this.columnColors.length; ++i) {
                Color columnColor = this.columnColors[i];
                int colWidth = this.getColumnModel().getColumn(i).getWidth();
                if (columnColor != null) {
                    g.setColor(columnColor);
                    g.fillRect(colXValue, startY, colWidth - 1, endY - startY - 1);
                }
                colXValue += colWidth;
            }
            g.setColor(this.getGridColor());
            if (this.showVerticalLines) {
                for (i = 0; i < this.getColumnCount(); ++i) {
                    Rectangle cellBounds = this.getCellRect(0, i, true);
                    g.drawLine(cellBounds.x + cellBounds.width - 1, startY, cellBounds.x + cellBounds.width - 1, endY);
                }
            }
            if (this.showHorizontalLines) {
                for (int y = startY + this.rowHeight - 1; y < endY; y += this.rowHeight) {
                    g.drawLine(clip.x, y, clip.x + clip.width, y);
                }
            }
        }
    }

    private class TabKeyAction
    extends AbstractAction {
        private TabKeyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component nextComponent;
            FocusTraversalPolicy policy;
            JTable table = (JTable)e.getSource();
            Container container = table.getFocusCycleRootAncestor();
            if (container != null && (policy = container.getFocusTraversalPolicy()) != null && (nextComponent = policy.getComponentAfter(container, table)) != null) {
                nextComponent.requestFocusInWindow();
            }
        }
    }
}

