/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.ui;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.interfaces.PFDMultipleInputInterface;
import com.sas.graphics.components.pfd.interfaces.PFDMultipleOutputInterface;
import com.sas.graphics.components.pfd.ui.PFDDialogUtil;
import com.sas.graphics.components.pfd.ui.PFDTable;
import com.sas.graphics.components.pfd.ui.RB;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class PFDNodeSelectorPanel
extends JPanel
implements ListSelectionListener {
    private static final String RB_KEY = "PFDNodeSelectorDialog.";
    public static final int TYPE_INPUT = 0;
    public static final int TYPE_OUTPUT = 1;
    public static final PFDPort EMPTY_PORT = new PFDPort();
    private PFDView view;
    private JTable nodeTable;
    private JComboBox portComboBox;
    private JPanel portSelectionPanel;
    private NodeSelectorModel tableModel;
    private JButton okButton;
    private JButton cancelButton;
    private PFDPort connectPort = null;
    private PFDLink connectLink = null;
    private PFDPort connectLinkPort = null;
    private String inputTitleFormat;
    private String outputTitleFormat;
    private static final Color gridColor = new Color(211, 211, 185);
    private static final int rowHeight = 21;
    private static final int defaultNumRowsVisible = 8;
    private static final int maxTypeColumnWidth = 100;
    private static final int defaultTableWidth = 250;
    private static final int cellPadding = 2;
    private int type = 0;
    public static final String CLOSE_VALUE_PROPERTY = "closeValue";
    public static final String UNINITIALIZED_VALUE = "valueUninitialized";
    public static final String OK_VALUE = "valueOK";
    public static final String CANCEL_VALUE = "valueCancel";
    private String closeValue = "valueUninitialized";
    private static final String ACTION_KEY_ENTER = "PFDNodeSelectorPanel.actionKeyEnter";

    public PFDNodeSelectorPanel(PFDView view, int type) {
        this.view = view;
        this.setType(type);
        this.init();
    }

    public void setConnectPort(PFDPort connectPort) {
        this.connectPort = connectPort;
    }

    public PFDPort getConnectPort() {
        return this.connectPort;
    }

    public void setConnectLink(PFDLink connectLink) {
        this.connectLink = connectLink;
    }

    public PFDLink getConnectLink() {
        return this.connectLink;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public String getCloseValue() {
        return this.closeValue;
    }

    public void setCloseValue(String closeValue) {
        String oldValue = this.closeValue;
        this.closeValue = closeValue;
        this.firePropertyChange(CLOSE_VALUE_PROPERTY, oldValue, closeValue);
    }

    private void init() {
        this.inputTitleFormat = RB.getStringResource(RB_KEY, "inputTitle.fmt");
        this.outputTitleFormat = RB.getStringResource(RB_KEY, "outputTitle.fmt");
        this.createGui();
        this.initKeyBindings();
    }

    private void initKeyBindings() {
        this.nodeTable.getInputMap().put(KeyStroke.getKeyStroke(10, 0), ACTION_KEY_ENTER);
        this.nodeTable.getActionMap().put(ACTION_KEY_ENTER, new EnterKeyAction());
        this.portComboBox.getInputMap().put(KeyStroke.getKeyStroke(10, 0), ACTION_KEY_ENTER);
        this.portComboBox.getActionMap().put(ACTION_KEY_ENTER, new EnterKeyAction());
    }

    private void initFromSource() {
        if (this.connectPort == null) {
            return;
        }
        this.connectLinkPort = this.connectLink == null ? null : (this.type == 0 ? this.connectLink.getFromPort() : this.connectLink.getToPort());
        this.initTableFromSource();
        this.initSizes();
        this.initSelections();
    }

    private void initSelections() {
        this.nodeTable.clearSelection();
        if (this.nodeTable.getRowCount() <= 0) {
            return;
        }
        if (this.connectLinkPort == null) {
            this.nodeTable.setRowSelectionInterval(0, 0);
        } else {
            PFDAbstractNode parentNode = this.connectLinkPort.getParentNode();
            if (parentNode == null) {
                this.nodeTable.setRowSelectionInterval(0, 0);
            } else {
                int row = this.getNodeIndex(parentNode);
                this.nodeTable.setRowSelectionInterval(row, row);
                List ports = this.tableModel.getNodePorts(parentNode);
                int portIndex = ports.indexOf(this.connectLinkPort);
                if (portIndex >= 0 && portIndex < this.portComboBox.getItemCount()) {
                    this.portComboBox.setSelectedIndex(portIndex);
                }
            }
        }
    }

    private int getNodeIndex(PFDAbstractNode node) {
        if (node == null) {
            return -1;
        }
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            Object n = this.tableModel.getValueAt(i, 0);
            if (n != node) continue;
            return i;
        }
        return -1;
    }

    private String getTitle() {
        String titleFormat = null;
        titleFormat = this.type == 0 ? this.inputTitleFormat : this.outputTitleFormat;
        MessageFormat message = new MessageFormat(titleFormat);
        String title = message.format(new Object[]{PFDDialogUtil.getPortName(this.connectPort)});
        return title;
    }

    private void initTableFromSource() {
        this.tableModel.updateData();
    }

    private void initSizes() {
        TableColumnModel colModel = this.nodeTable.getColumnModel();
        TableColumn typeColumn = colModel.getColumn(1);
        int typeColumnWidth = this.getTypeColumnWidth(this.nodeTable);
        typeColumnWidth = Math.min(typeColumnWidth, 100);
        typeColumn.setMinWidth(typeColumnWidth);
        this.nodeTable.setPreferredScrollableViewportSize(new Dimension(250, 168));
        Dimension prefSize = this.portComboBox.getPreferredSize();
        prefSize.width = 250;
        this.portComboBox.setPreferredSize(prefSize);
    }

    private int getTypeColumnWidth(JTable table) {
        TableModel model = table.getModel();
        TableCellRenderer renderer = table.getDefaultRenderer(model.getColumnClass(1));
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        TableColumn column = table.getColumnModel().getColumn(1);
        Component comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
        int headerWidth = comp.getPreferredSize().width;
        int cellWidth = 0;
        for (int j = 0; j < table.getRowCount(); ++j) {
            comp = renderer.getTableCellRendererComponent(table, model.getValueAt(j, 1), false, false, j, 1);
            cellWidth = Math.max(cellWidth, comp.getPreferredSize().width + 2);
        }
        return Math.max(headerWidth, cellWidth);
    }

    private void createGui() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getSelectionPanel(), "Center");
        this.add((Component)this.getButtonsPanel(), "South");
    }

    private JPanel getButtonsPanel() {
        JPanel panel = new JPanel();
        FlowLayout layout = new FlowLayout();
        layout.setHgap(6);
        layout.setVgap(0);
        panel.setLayout(layout);
        AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PFDNodeSelectorPanel.this.setCloseValue(PFDNodeSelectorPanel.OK_VALUE);
            }
        };
        okAction.putValue("Name", PFDDialogUtil.getOKButtonText());
        this.okButton = new JButton(okAction);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PFDNodeSelectorPanel.this.setCloseValue(PFDNodeSelectorPanel.CANCEL_VALUE);
            }
        };
        cancelAction.putValue("Name", PFDDialogUtil.getCancelButtonText());
        this.cancelButton = new JButton(cancelAction);
        panel.add(this.okButton);
        panel.add(this.cancelButton);
        panel.setBorder(new EmptyBorder(11, 0, 11, 5));
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        buttonsPanel.add((Component)new JPanel(), "Center");
        buttonsPanel.add((Component)panel, "East");
        return buttonsPanel;
    }

    private JPanel getSelectionPanel() {
        JPanel selectionPanel = new JPanel();
        BorderLayout layout = new BorderLayout();
        layout.setVgap(6);
        selectionPanel.setLayout(layout);
        selectionPanel.setBorder(new EmptyBorder(11, 11, 11, 11));
        selectionPanel.add((Component)this.getNodeSelectionPanel(), "Center");
        selectionPanel.add((Component)this.getPortSelectionPanel(), "South");
        return selectionPanel;
    }

    private JPanel getNodeSelectionPanel() {
        JPanel nodeSelectionPanel = new JPanel(new BorderLayout());
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder(new EmptyBorder(0, 0, 2, 0));
        JLabel title = new JLabel(RB.getStringResource(RB_KEY, "nodeTableTitle.txt"));
        titlePanel.add((Component)title, "West");
        titlePanel.add((Component)new JPanel(), "Center");
        nodeSelectionPanel.add((Component)titlePanel, "North");
        nodeSelectionPanel.add((Component)this.getNodeSelectionScrollPane(), "Center");
        return nodeSelectionPanel;
    }

    private JScrollPane getNodeSelectionScrollPane() {
        return new JScrollPane(this.createNewTable());
    }

    private JTable createNewTable() {
        this.nodeTable = new PFDTable();
        this.tableModel = new NodeSelectorModel();
        this.nodeTable.setModel(this.tableModel);
        this.nodeTable.getColumnModel().getColumn(0).setCellRenderer(new PFDNodeCellRenderer());
        this.nodeTable.setSelectionMode(0);
        this.nodeTable.setAutoResizeMode(2);
        this.nodeTable.setGridColor(gridColor);
        this.nodeTable.setRowHeight(21);
        this.nodeTable.setShowGrid(false);
        JTableHeader header = this.nodeTable.getTableHeader();
        header.setReorderingAllowed(false);
        this.nodeTable.getSelectionModel().addListSelectionListener(this);
        return this.nodeTable;
    }

    private JPanel getPortSelectionPanel() {
        this.portSelectionPanel = new JPanel(new BorderLayout());
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder(new EmptyBorder(0, 0, 2, 0));
        JLabel title = new JLabel(RB.getStringResource(RB_KEY, "portComboTitle.txt"));
        titlePanel.add((Component)title, "West");
        titlePanel.add((Component)new JPanel(), "Center");
        this.portSelectionPanel.add((Component)titlePanel, "North");
        this.portSelectionPanel.add((Component)this.getPortSelectionComboBox(), "Center");
        return this.portSelectionPanel;
    }

    private JComboBox getPortSelectionComboBox() {
        this.portComboBox = new JComboBox();
        return this.portComboBox;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int selectedRow = this.nodeTable.getSelectedRow();
        this.portComboBox.removeAllItems();
        if (selectedRow < 0) {
            this.portComboBox.setEnabled(false);
        } else {
            Object node = this.tableModel.getValueAt(selectedRow, 0);
            if (node instanceof PFDAbstractNode) {
                this.initPortsFromNode((PFDAbstractNode)node);
            } else {
                this.portComboBox.setEnabled(false);
            }
        }
    }

    private void initPortsFromNode(PFDAbstractNode node) {
        List ports = this.tableModel.getNodePorts(node);
        if (ports == null || ports.isEmpty()) {
            this.portComboBox.setEnabled(false);
        } else {
            this.portComboBox.setEnabled(true);
            for (int i = 0; i < ports.size(); ++i) {
                this.portComboBox.addItem(this.getPortName((PFDPort)ports.get(i)));
            }
        }
    }

    private String getPortName(PFDPort port) {
        if (this.type == 0) {
            return PFDDialogUtil.getOutputPortName(port);
        }
        return PFDDialogUtil.getInputPortName(port);
    }

    public PFDPort getSelectedPort() {
        if (this.getCloseValue() != OK_VALUE) {
            return null;
        }
        if (this.nodeTable.getSelectedRowCount() == 0) {
            return null;
        }
        Object selectedValue = this.tableModel.getValueAt(this.nodeTable.getSelectedRow(), 0);
        if (selectedValue instanceof PFDAbstractNode) {
            List portList;
            PFDAbstractNode selectedNode = (PFDAbstractNode)selectedValue;
            int portIndex = this.portComboBox.getSelectedIndex();
            if (portIndex >= 0 && (portList = this.tableModel.getNodePorts(selectedNode)) != null && portIndex < portList.size()) {
                return (PFDPort)portList.get(portIndex);
            }
        } else {
            return EMPTY_PORT;
        }
        return null;
    }

    public static PFDPort showNodeSelectorDialog(Component parentComponent, PFDView view, PFDPort connectPort, PFDLink connectLink, int type) {
        if (view == null || connectPort == null) {
            return null;
        }
        PFDNodeSelectorPanel selectorPanel = new PFDNodeSelectorPanel(view, type);
        selectorPanel.setConnectPort(connectPort);
        selectorPanel.setConnectLink(connectLink);
        selectorPanel.initFromSource();
        String title = selectorPanel.getTitle();
        JDialog dialog = selectorPanel.createDialog(parentComponent, title);
        dialog.setVisible(true);
        dialog.dispose();
        return selectorPanel.getSelectedPort();
    }

    private JDialog createDialog(Component parentComponent, String title) {
        boolean supportsWindowDecorations;
        Window window = PFDDialogUtil.getWindowForComponent(parentComponent);
        final JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, true) : (window instanceof Dialog ? new JDialog((Dialog)window, title, true) : new JDialog((Frame)null, title, true));
        dialog.setComponentOrientation(this.getComponentOrientation());
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        dialog.setResizable(false);
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            dialog.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(0);
        }
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowClosing(WindowEvent we) {
                PFDNodeSelectorPanel.this.setCloseValue(PFDNodeSelectorPanel.UNINITIALIZED_VALUE);
            }
        };
        dialog.addWindowListener(adapter);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (dialog.isVisible() && event.getSource() == PFDNodeSelectorPanel.this && event.getPropertyName().equals(PFDNodeSelectorPanel.CLOSE_VALUE_PROPERTY) && event.getNewValue() != null && event.getNewValue() != PFDNodeSelectorPanel.UNINITIALIZED_VALUE) {
                    dialog.setVisible(false);
                }
            }
        });
        return dialog;
    }

    private class EnterKeyAction
    extends AbstractAction {
        private EnterKeyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Action action = PFDNodeSelectorPanel.this.okButton.getAction();
            if (action != null) {
                action.actionPerformed(e);
            }
        }
    }

    private class NodeSelectorModel
    extends AbstractTableModel {
        public static final int NODE_COLUMN = 0;
        public static final int TYPE_COLUMN = 1;
        private List nodes = new Vector();
        private List nodeTypes = new Vector();
        private List[] data = new List[]{this.nodes, this.nodeTypes};
        private Hashtable nodePortTable = new Hashtable();
        private String nodeHeader;
        private String nodeTypeHeader;

        public NodeSelectorModel() {
            this.nodeHeader = this.getNodeHeader(PFDNodeSelectorPanel.this.type);
            this.nodeTypeHeader = RB.getStringResource(PFDNodeSelectorPanel.RB_KEY, "nodeTypeHeader.txt");
        }

        private String getNodeHeader(int type) {
            if (type == 0) {
                return RB.getStringResource(PFDNodeSelectorPanel.RB_KEY, "inputNodeHeader.txt");
            }
            return RB.getStringResource(PFDNodeSelectorPanel.RB_KEY, "outputNodeHeader.txt");
        }

        public List getNodePorts(PFDAbstractNode node) {
            if (this.nodePortTable == null || node == null) {
                return null;
            }
            return (List)this.nodePortTable.get(node);
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return this.nodeHeader;
            }
            return this.nodeTypeHeader;
        }

        @Override
        public int getColumnCount() {
            return this.data.length;
        }

        @Override
        public int getRowCount() {
            return this.nodes.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            List columnData;
            if (rowIndex < 0 || columnIndex < 0) {
                return null;
            }
            if (columnIndex < this.data.length && rowIndex < (columnData = this.data[columnIndex]).size()) {
                return columnData.get(rowIndex);
            }
            return null;
        }

        public void updateData() {
            this.nodes.clear();
            this.nodeTypes.clear();
            this.nodePortTable.clear();
            if (PFDNodeSelectorPanel.this.connectPort != null) {
                if (PFDNodeSelectorPanel.this.type == 0) {
                    this.updateDataInput();
                } else {
                    this.updateDataOutput();
                }
            }
            this.fireTableDataChanged();
        }

        private void updateDataInput() {
            if (PFDNodeSelectorPanel.this.view == null) {
                return;
            }
            PFDModel model = PFDNodeSelectorPanel.this.view.getModel();
            if (model == null) {
                return;
            }
            this.addData(this.getNodeEntry(null));
            Vector modelNodes = model.getAllNodes();
            for (int i = 0; i < modelNodes.size(); ++i) {
                PFDAbstractNode n = (PFDAbstractNode)modelNodes.get(i);
                List ports = this.getValidOutputPorts(n);
                if (ports == null || ports.isEmpty()) continue;
                this.nodePortTable.put(n, ports);
                this.addData(this.getNodeEntry(n));
            }
        }

        private void updateDataOutput() {
            if (PFDNodeSelectorPanel.this.view == null) {
                return;
            }
            PFDModel model = PFDNodeSelectorPanel.this.view.getModel();
            if (model == null) {
                return;
            }
            this.addData(this.getNodeEntry(null));
            Vector modelNodes = model.getAllNodes();
            for (int i = 0; i < modelNodes.size(); ++i) {
                PFDAbstractNode n = (PFDAbstractNode)modelNodes.get(i);
                List ports = this.getValidInputPorts(n);
                if (ports == null || ports.isEmpty()) continue;
                this.nodePortTable.put(n, ports);
                this.addData(this.getNodeEntry(n));
            }
        }

        private void addData(Object[] entry) {
            if (entry == null) {
                return;
            }
            for (int k = 0; k < entry.length && k < this.data.length; ++k) {
                this.data[k].add(entry[k]);
            }
        }

        private Object[] getNodeEntry(PFDAbstractNode node) {
            Object[] entry = node == null ? new Object[]{PFDDialogUtil.getEmptyNodeName(), null} : new Object[]{node, PFDDialogUtil.getNodeTypeDescription(node)};
            return entry;
        }

        private List getValidOutputPorts(PFDAbstractNode node) {
            if (node == null) {
                return null;
            }
            Vector<PFDPort> validPorts = new Vector<PFDPort>();
            if (node instanceof PFDMultipleOutputInterface) {
                PFDMultipleOutputInterface moi = (PFDMultipleOutputInterface)((Object)node);
                for (int i = 0; i < moi.getNumOutputPorts(); ++i) {
                    PFDPort port = moi.getOutputPort(i);
                    if (port != PFDNodeSelectorPanel.this.connectLinkPort && (port == null || !this.canPortsConnect(port, PFDNodeSelectorPanel.this.connectPort))) continue;
                    validPorts.add(port);
                }
            } else {
                PFDPort port = node.getOutputPort();
                if (port == PFDNodeSelectorPanel.this.connectLinkPort || port != null && this.canPortsConnect(port, PFDNodeSelectorPanel.this.connectPort)) {
                    validPorts.add(port);
                }
            }
            return validPorts;
        }

        private List getValidInputPorts(PFDAbstractNode node) {
            if (node == null) {
                return null;
            }
            Vector<PFDPort> validPorts = new Vector<PFDPort>();
            if (node instanceof PFDMultipleInputInterface) {
                PFDMultipleInputInterface mii = (PFDMultipleInputInterface)((Object)node);
                for (int i = 0; i < mii.getNumInputPorts(); ++i) {
                    PFDPort port = mii.getInputPort(i);
                    if (port != PFDNodeSelectorPanel.this.connectLinkPort && (port == null || !this.canPortsConnect(PFDNodeSelectorPanel.this.connectPort, port))) continue;
                    validPorts.add(port);
                }
            } else {
                PFDPort port = node.getInputPort();
                if (port == PFDNodeSelectorPanel.this.connectLinkPort || port != null && this.canPortsConnect(PFDNodeSelectorPanel.this.connectPort, port)) {
                    validPorts.add(port);
                }
            }
            return validPorts;
        }

        private boolean canPortsConnect(PFDPort fromPort, PFDPort toPort) {
            if (fromPort == null || toPort == null) {
                return false;
            }
            if (PFDNodeSelectorPanel.this.connectLink != null) {
                if (PFDNodeSelectorPanel.this.connectPort == fromPort) {
                    return toPort.canDropToLink(PFDNodeSelectorPanel.this.connectLink);
                }
                return fromPort.canDropFromLink(PFDNodeSelectorPanel.this.connectLink);
            }
            if (fromPort.canDragNewLink() && toPort.canAcceptNewLink()) {
                PFDLink link = fromPort.createDragLink();
                return link != null && link.isLinkSupported(fromPort, toPort);
            }
            return false;
        }
    }

    private class PFDNodeCellRenderer
    extends DefaultTableCellRenderer {
        private PFDNodeCellRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            if (value instanceof PFDAbstractNode) {
                PFDAbstractNode node = (PFDAbstractNode)value;
                this.setIcon(PFDDialogUtil.getNodeTypeIcon(node));
                this.setText(PFDDialogUtil.getNodeName(node));
            } else {
                super.setValue(value);
                this.setIcon(null);
            }
        }
    }
}

